#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 pandoc-types
version:              1.22
visibility:           public
id:                   pandoc-types-1.22-K1U3otiVNjpE9PSImfewvu
key:                  pandoc-types-1.22-K1U3otiVNjpE9PSImfewvu
license:              BSD-3-Clause
copyright:            (c) 2006-2019 John MacFarlane
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
homepage:             https://pandoc.org/
synopsis:             Types for representing a structured document
description:
    @Text.Pandoc.Definition@ defines the '\''Pandoc'\'' data
    structure, which is used by pandoc to represent
    structured documents.  This module used to live
    in the pandoc package, but starting with pandoc 1.7, it
    has been split off, so that other packages can use it
    without drawing in all of pandoc'\''s dependencies, and
    pandoc itself can depend on packages (like citeproc-hs)
    that use them.

    @Text.Pandoc.Builder@ provides functions for building
    up @Pandoc@ structures programmatically.

    @Text.Pandoc.Generic@ provides generic functions for
    manipulating Pandoc documents.

    @Text.Pandoc.Walk@ provides faster, nongeneric functions
    for manipulating Pandoc documents.

    @Text.Pandoc.JSON@ provides functions for serializing
    and deserializing a @Pandoc@ structure to and from JSON.

category:             Text
abi:                  cc5d8503b8f6ae92078f2cf992b14161
exposed:              True
exposed-modules:
    Text.Pandoc.Arbitrary Text.Pandoc.Builder Text.Pandoc.Definition
    Text.Pandoc.Generic Text.Pandoc.JSON Text.Pandoc.Walk

hidden-modules:       Paths_pandoc_types
import-dirs:          /usr/lib/ghc-8.10.5/site-local/pandoc-types-1.22
library-dirs:         /usr/lib/ghc-8.10.5/site-local/pandoc-types-1.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/pandoc-types-1.22
hs-libraries:         HSpandoc-types-1.22-K1U3otiVNjpE9PSImfewvu
depends:
    QuickCheck-2.14.2-AlBcjlnVb6HBYuJ8lOviFD
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ base-4.14.2.0
    bytestring-0.10.12.0 containers-0.6.4.1 deepseq-1.4.4.0
    ghc-prim-0.6.1 syb-0.7.2.1-5ZaH2aS3V5s5i5LSCPBZnH text-1.2.4.1
    transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-pandoc-types/html/pandoc-types.haddock

haddock-html:         /usr/share/doc/haskell-pandoc-types/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

