#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 non-negative
version:              0.1.2
visibility:           public
id:                   non-negative-0.1.2-1AfSGYjJ6wn7c1yCD58ENy
key:                  non-negative-0.1.2-1AfSGYjJ6wn7c1yCD58ENy
license:              LicenseRef-GPL
maintainer:           Henning Thielemann <haskell@henning-thielemann.de>
author:               Henning Thielemann <haskell@henning-thielemann.de>
homepage:             http://code.haskell.org/~thielema/non-negative/
synopsis:             Non-negative numbers
description:
    Provides a class for non-negative numbers,
    a wrapper which can turn any ordered numeric type into a member of that class,
    and a lazy number type for non-negative numbers
    (a generalization of Peano numbers).
    This library is used by the @event-list@ package.

category:             Math
abi:                  c3c2e24522a21985e0e8bf7e7f7e6220
exposed:              True
exposed-modules:
    Numeric.NonNegative.Chunky Numeric.NonNegative.Class
    Numeric.NonNegative.Wrapper

hidden-modules:       Numeric.NonNegative.ChunkyPrivate
import-dirs:          /usr/lib/ghc-8.10.5/site-local/non-negative-0.1.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/non-negative-0.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/non-negative-0.1.2
hs-libraries:         HSnon-negative-0.1.2-1AfSGYjJ6wn7c1yCD58ENy
depends:
    QuickCheck-2.14.2-AlBcjlnVb6HBYuJ8lOviFD base-4.14.2.0
    utility-ht-0.0.16-24GowJ9ezK6J2J6n2aO3mj

haddock-interfaces:
    /usr/share/doc/haskell-non-negative/html/non-negative.haddock

haddock-html:         /usr/share/doc/haskell-non-negative/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

