#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 network-bsd
version:              2.8.1.0
visibility:           public
id:                   network-bsd-2.8.1.0-J6bIyDlFsUOASjxht9nXWx
key:                  network-bsd-2.8.1.0-J6bIyDlFsUOASjxht9nXWx
license:              BSD-3-Clause
maintainer:           Kazu Yamamoto, Herbert Valerio Riedel
homepage:             https://github.com/haskell/network-bsd
synopsis:             POSIX network database (<netdb.h>) API
description:
    This package provides Haskell bindings to the
    the [POSIX network database (<netdb.h>) API](http://pubs.opengroup.org/onlinepubs/009696699/basedefs/netdb.h.html).

    === Relationship to the @network@ package

    The @network@ package version 2.* series provides "Network.BSD" but
    it is removed starting with @network@ version 3.0.

    This package provides the "Network.BSD" module split off from the
    <https://hackage.haskell.org/package/network network package>.

    If in addition to the @network@'\''s modules also "Network.BSD" is
    necessary, add @network-bsd@ to your dependencies like so:

    > library
    >     build-depends: network     >= 2.7 && < 3.1
    >                  , network-bsd >= 2.7 && < 2.9

    I.e. you can control the version of the @network@ package
    independently.

    __NOTE__: Starting with @network-bsd-2.8.1.0@ the APIs of @network@
    and @network-bsd@ evolve differently, and consequently the
    versioning doesn'\''t match up anymore! Moreover, also starting with
    version @network-bsd-2.8.1.0@ this package requires @network >= 3@
    in order to avoid module name clashes with @network < 3@'\''s
    "Network.BSD" module.

    However, @network-bsd-2.7.0.0@ and @network-bsd-2.8.0.0@ passes thru
    the "Network.BSD" module from @network-2.7.*@ and @network-2.8.*@
    respectively in a non-clashing way via Cabal'\''s
    <https://www.haskell.org/cabal/users-guide/developing-packages.html#pkg-field-library-reexported-modules reexported-modules>
    feature while ensuring a well-defined
    <https://pvp.haskell.org/ API versioning> of the observable API of
    @network-bsd@. This is why the example above supporting a wide range
    of @network@ versions works by including version 2.7.0.0 in the
    required version range of @network-bsd@.

category:             Network
abi:                  359ac4c5e92c9430d20b51be0d393e5f
exposed:              True
exposed-modules:      Network.BSD
import-dirs:          /usr/lib/ghc-8.10.5/site-local/network-bsd-2.8.1.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/network-bsd-2.8.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/network-bsd-2.8.1.0
hs-libraries:         HSnetwork-bsd-2.8.1.0-J6bIyDlFsUOASjxht9nXWx
depends:
    base-4.14.2.0 deepseq-1.4.4.0
    network-3.1.2.2-5EE9GqQpTmvH0oBl8byO4M

haddock-interfaces:   /usr/share/doc/haskell-network-bsd/html/network-bsd.haddock
haddock-html:         /usr/share/doc/haskell-network-bsd/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

