#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp-test
version:              0.14.0.0
visibility:           public
id:                   lsp-test-0.14.0.0-K1AczpjIdc3Huhg0TxsAPb
key:                  lsp-test-0.14.0.0-K1AczpjIdc3Huhg0TxsAPb
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire, and @Language.LSP.Test@ can replay captured sessions from
    <haskell-lsp https://hackage.haskell.org/package/haskell-lsp>.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  6d2068be3739a73f92483e45ca86fb7a
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-I56cvBuZMEG2VbjtPZAqZY:Control.Applicative.Combinators,
    Language.LSP.Test,
    Language.LSP.Types from lsp-types-1.2.0.0-926l9WtteBxBKACgKH5KZf:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.2.0.0-926l9WtteBxBKACgKH5KZf:Language.LSP.Types.Capabilities

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-8.10.5/site-local/lsp-test-0.14.0.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/lsp-test-0.14.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/lsp-test-0.14.0.0
hs-libraries:         HSlsp-test-0.14.0.0-K1AczpjIdc3Huhg0TxsAPb
depends:
    Diff-0.4.0-13VXofqCMLyHuBACVASIzF
    Glob-0.10.1-1oUfOxlY2AX2MEz9S8cGUZ
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ
    aeson-pretty-0.8.8-3aCNsqOVx5w7giic7jdZv7
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i
    async-2.2.3-EEZ7ScAbhsHIRG0TBpna8H base-4.14.2.0
    bytestring-0.10.12.0 conduit-1.3.4.1-GHgRKpknFuqDscwzVojbiE
    conduit-parse-0.2.1.0-Dbr8EnBbkDbJ3E5IIgVBtP containers-0.6.4.1
    data-default-0.7.1.1-5u8NwVJ9HGT30K0bkKsBOX directory-1.3.6.0
    filepath-1.4.2.1 lens-5.0.1-9j09gzxg2dR5Wmd3U39g28
    lsp-types-1.2.0.0-926l9WtteBxBKACgKH5KZf mtl-2.2.2
    parser-combinators-1.3.0-I56cvBuZMEG2VbjtPZAqZY process-1.6.9.0
    some-1.0.3-1KmRXE4Js6K5qWAWmRn59k text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2 unix-2.7.2.2
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

