#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp
version:              1.2.0.0
visibility:           public
id:                   lsp-1.2.0.0-JYjHpvPu1SW4k7gGYBb5ES
key:                  lsp-1.2.0.0-JYjHpvPu1SW4k7gGYBb5ES
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell IDE
    Engine, at https://github.com/haskell/haskell-ide-engine

category:             Development
abi:                  3182624f269274794a63c3fa6f25cb94
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.2.0.0-926l9WtteBxBKACgKH5KZf:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.2.0.0-926l9WtteBxBKACgKH5KZf:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.2.0.0-926l9WtteBxBKACgKH5KZf:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.2.0.0-926l9WtteBxBKACgKH5KZf:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-8.10.5/site-local/lsp-1.2.0.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/lsp-1.2.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/lsp-1.2.0.0
hs-libraries:         HSlsp-1.2.0.0-JYjHpvPu1SW4k7gGYBb5ES
depends:
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ
    async-2.2.3-EEZ7ScAbhsHIRG0TBpna8H
    attoparsec-0.14.1-CDW2c9fsk3y4jVQKNBcpib base-4.14.2.0
    bytestring-0.10.12.0 containers-0.6.4.1
    data-default-0.7.1.1-5u8NwVJ9HGT30K0bkKsBOX
    dependent-map-0.4.0.0-9Q1JxGe6XZWLCg27tVKkjD directory-1.3.6.0
    filepath-1.4.2.1 hashable-1.3.2.0-GpzwVyCMdDv8NwdC61S1EE
    hslogger-1.3.1.0-4ZvjEIYEuqKInhLQNg26B3
    lens-5.0.1-9j09gzxg2dR5Wmd3U39g28
    lsp-types-1.2.0.0-926l9WtteBxBKACgKH5KZf mtl-2.2.2
    network-uri-2.6.4.1-4m8gp52oIfHLdE9VhQrWxs
    random-1.2.0-GZbCBA9NAlUBaVRSIi1HYu
    scientific-0.3.7.0-Fi0gRGhsiJ35wgbCjOXuHX
    sorted-list-0.2.1.0-9nmT4tHEEdz1Ro1gJtKttX stm-2.5.0.1 text-1.2.4.1
    time-1.9.3 transformers-0.5.6.2
    unliftio-core-0.2.0.1-1ibY1oF6Hkc5ZYjZ4yW3Lp
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya
    uuid-1.3.15-AKTgcL3LOBPLKcWo3t3zYb

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

