#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 language-javascript
version:              0.7.1.0
visibility:           public
id:                   language-javascript-0.7.1.0-8AmGWtz9iKl1RM19Kf18XU
key:                  language-javascript-0.7.1.0-8AmGWtz9iKl1RM19Kf18XU
license:              BSD-3-Clause
copyright:
    (c) 2010-2015 Alan Zimmerman
    (c) 2015-2019 Erik de Castro Lopo
    (c) 2018      Daniel Gasienica

maintainer:           Erik de Castro Lopo <erikd@mega-nerd.com>
author:               Alan Zimmerman
homepage:             https://github.com/erikd/language-javascript
synopsis:             Parser for JavaScript
description:
    Parses Javascript into an Abstract Syntax Tree (AST).  Initially intended as frontend to hjsmin.

    Note: Version 0.5.0 breaks compatibility with prior versions, the AST has been reworked to allow
    round trip processing of JavaScript.

category:             Language
abi:                  bffe1601757661dcc2ee8b1c9735806e
exposed:              True
exposed-modules:
    Language.JavaScript.Parser Language.JavaScript.Parser.AST
    Language.JavaScript.Parser.Grammar7
    Language.JavaScript.Parser.Lexer Language.JavaScript.Parser.Parser
    Language.JavaScript.Parser.SrcLocation
    Language.JavaScript.Pretty.Printer
    Language.JavaScript.Process.Minify

hidden-modules:
    Language.JavaScript.Parser.LexerUtils
    Language.JavaScript.Parser.ParseError
    Language.JavaScript.Parser.ParserMonad
    Language.JavaScript.Parser.Token

import-dirs:          /usr/lib/ghc-8.10.5/site-local/language-javascript-0.7.1.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/language-javascript-0.7.1.0
dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/i386-linux-ghc-8.10.5/language-javascript-0.7.1.0

hs-libraries:         HSlanguage-javascript-0.7.1.0-8AmGWtz9iKl1RM19Kf18XU
depends:
    array-0.5.4.0 base-4.14.2.0
    blaze-builder-0.4.2.1-CvyaA91rGJh3LGq34EOJVB bytestring-0.10.12.0
    containers-0.6.4.1 mtl-2.2.2 text-1.2.4.1
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du

haddock-interfaces:
    /usr/share/doc/haskell-language-javascript/html/language-javascript.haddock

haddock-html:         /usr/share/doc/haskell-language-javascript/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

