#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 iproute
version:              1.7.11
visibility:           public
id:                   iproute-1.7.11-d5s0fig5u67LjOGRvUkdk
key:                  iproute-1.7.11-d5s0fig5u67LjOGRvUkdk
license:              BSD-3-Clause
maintainer:           Kazu Yamamoto <kazu@iij.ad.jp>
author:               Kazu Yamamoto <kazu@iij.ad.jp>
homepage:             http://www.mew.org/~kazu/proj/iproute/
synopsis:             IP Routing Table
description:
    IP Routing Table is a tree of IP ranges
    to search one of them on the longest
    match base. It is a kind of TRIE with one
    way branching removed. Both IPv4 and IPv6
    are supported.

category:             Algorithms, Network
abi:                  b1dd15b3780ae42b39f44f16a6daf87f
exposed:              True
exposed-modules:
    Data.IP Data.IP.Builder Data.IP.Internal Data.IP.RouteTable
    Data.IP.RouteTable.Internal

hidden-modules:       Data.IP.Addr Data.IP.Mask Data.IP.Op Data.IP.Range
import-dirs:          /usr/lib/ghc-8.10.5/site-local/iproute-1.7.11
library-dirs:         /usr/lib/ghc-8.10.5/site-local/iproute-1.7.11
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/iproute-1.7.11
hs-libraries:         HSiproute-1.7.11-d5s0fig5u67LjOGRvUkdk
depends:
    appar-0.1.8-AJpyf6kw4BC7M1w0DNi1Qs base-4.14.2.0
    byteorder-1.0.4-HnaHkJFNp8iDlUJGtdnY0n bytestring-0.10.12.0
    containers-0.6.4.1 network-3.1.2.2-5EE9GqQpTmvH0oBl8byO4M

haddock-interfaces:   /usr/share/doc/haskell-iproute/html/iproute.haddock
haddock-html:         /usr/share/doc/haskell-iproute/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

