#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hourglass
version:              0.2.12
visibility:           public
id:                   hourglass-0.2.12-9iZsbaT4CVFLnJ2S83W47g
key:                  hourglass-0.2.12-9iZsbaT4CVFLnJ2S83W47g
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           vincent@snarc.org
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/vincenthz/hs-hourglass
synopsis:             simple performant time related library
description:
    Simple time library focusing on simple but powerful and performant API

    The backbone of the library are the Timeable and Time type classes.

    Each Timeable instances can be converted to type that has a Time instances,
    and thus are different representations of current time.

category:             Time
abi:                  04e66508a8ce997cc13cc3488f472cfa
exposed:              True
exposed-modules:
    Data.Hourglass Data.Hourglass.Compat Data.Hourglass.Epoch
    Data.Hourglass.Types System.Hourglass Time.Compat Time.System
    Time.Types

hidden-modules:
    Data.Hourglass.Time Data.Hourglass.Format Data.Hourglass.Diff
    Data.Hourglass.Local Data.Hourglass.Calendar Data.Hourglass.Zone
    Data.Hourglass.Internal Data.Hourglass.Utils
    Data.Hourglass.Internal.Unix

import-dirs:          /usr/lib/ghc-8.10.5/site-local/hourglass-0.2.12
library-dirs:         /usr/lib/ghc-8.10.5/site-local/hourglass-0.2.12
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/hourglass-0.2.12
hs-libraries:         HShourglass-0.2.12-9iZsbaT4CVFLnJ2S83W47g
depends:              base-4.14.2.0 deepseq-1.4.4.0
haddock-interfaces:   /usr/share/doc/haskell-hourglass/html/hourglass.haddock
haddock-html:         /usr/share/doc/haskell-hourglass/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

