#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 hedgehog
version:              1.0.5
visibility:           public
id:                   hedgehog-1.0.5-Gzn4nuAuPDKGW9aRRASyVT
key:                  hedgehog-1.0.5-Gzn4nuAuPDKGW9aRRASyVT
license:              BSD-3-Clause
maintainer:           Jacob Stanley <jacob@stanley.io>
author:               Jacob Stanley
homepage:             https://hedgehog.qa
synopsis:             Release with confidence.
description:
    <http://hedgehog.qa/ Hedgehog> automatically generates a comprehensive array
    of test cases, exercising your software in ways human testers would never
    imagine.

    Generate hundreds of test cases automatically, exposing even the
    most insidious of corner cases. Failures are automatically simplified, giving
    developers coherent, intelligible error messages.

    To get started quickly, see the <https://github.com/hedgehogqa/haskell-hedgehog/tree/master/hedgehog-example examples>.

category:             Testing
abi:                  4dc691dfbf642bf45ac03c0b4e3c7c0a
exposed:              True
exposed-modules:
    Hedgehog Hedgehog.Gen Hedgehog.Internal.Config
    Hedgehog.Internal.Discovery Hedgehog.Internal.Distributive
    Hedgehog.Internal.Exception Hedgehog.Internal.Gen
    Hedgehog.Internal.HTraversable Hedgehog.Internal.Opaque
    Hedgehog.Internal.Prelude Hedgehog.Internal.Property
    Hedgehog.Internal.Queue Hedgehog.Internal.Range
    Hedgehog.Internal.Region Hedgehog.Internal.Report
    Hedgehog.Internal.Runner Hedgehog.Internal.Seed
    Hedgehog.Internal.Show Hedgehog.Internal.Shrink
    Hedgehog.Internal.Source Hedgehog.Internal.State
    Hedgehog.Internal.TH Hedgehog.Internal.Tree
    Hedgehog.Internal.Tripping Hedgehog.Main Hedgehog.Range

import-dirs:          /usr/lib/ghc-8.10.5/site-local/hedgehog-1.0.5
library-dirs:         /usr/lib/ghc-8.10.5/site-local/hedgehog-1.0.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/hedgehog-1.0.5
hs-libraries:         HShedgehog-1.0.5-Gzn4nuAuPDKGW9aRRASyVT
depends:
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i
    async-2.2.3-EEZ7ScAbhsHIRG0TBpna8H base-4.14.2.0
    bytestring-0.10.12.0
    concurrent-output-1.10.12-CgHJDdB5KnTEq5zfdNYAWT containers-0.6.4.1
    deepseq-1.4.4.0 directory-1.3.6.0
    erf-2.0.0.0-BAjfrhskuQTIFU6BgB8zca exceptions-0.10.4
    lifted-async-0.10.2-6xtC11ZmRn79QTvIIdcDMa
    mmorph-1.1.5-HQ5yL7dTs6W12JIMoRbUvr
    monad-control-1.0.2.3-Bi4GOATU8bxGtDgK1rR68J mtl-2.2.2
    pretty-show-1.10-jI5AqYpLoz98dMARTaePi
    primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh
    random-1.2.0-GZbCBA9NAlUBaVRSIi1HYu
    resourcet-1.2.4.2-7etOfd8fePh2l91avxjTIe stm-2.5.0.1
    template-haskell-2.16.0.0 text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2
    transformers-base-0.4.5.2-KzHjyAKDkdpHt6juu1Rjxn
    wl-pprint-annotated-0.1.0.1-XMj0oY6NWaCzbUZcjW0Ec

haddock-interfaces:   /usr/share/doc/haskell-hedgehog/html/hedgehog.haddock
haddock-html:         /usr/share/doc/haskell-hedgehog/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

