#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 graphviz
version:              2999.20.1.0
visibility:           public
id:                   graphviz-2999.20.1.0-96iLVdZRyTNAvCgdcoPpbW
key:                  graphviz-2999.20.1.0-96iLVdZRyTNAvCgdcoPpbW
license:              BSD-3-Clause
copyright:            Matthew Sackman, Ivan Lazar Miljenovic
maintainer:           Ivan.Miljenovic@gmail.com
author:               Matthew Sackman, Ivan Lazar Miljenovic
stability:            Beta
homepage:             https://github.com/ivan-m/graphviz
synopsis:             Bindings to Graphviz for graph visualisation.
description:
    This library provides bindings for the Dot language used by the
    Graphviz (<http://graphviz.org/>) suite of programs for visualising
    graphs, as well as functions to call those programs.

    Main features of the graphviz library include:

    * Almost complete coverage of all Graphviz attributes and syntax.

    * Support for specifying clusters.

    * The ability to use a custom node type.

    * Functions for running a Graphviz layout tool with all specified
    output types.

    * The ability to not only generate but also parse Dot code with two
    options: strict and liberal (in terms of ordering of statements).

    * Functions to convert FGL graphs and other graph-like data structures
    to Dot code - including support to group them into clusters - with a
    high degree of customisation by specifying which attributes to use
    and limited support for the inverse operation.

    * Round-trip support for passing an FGL graph through Graphviz to
    augment node and edge labels with positional information, etc.

category:             Graphs, Graphics
abi:                  6bae4f74a5a74f31a6a0cefcf4625b49
exposed:              True
exposed-modules:
    Data.GraphViz Data.GraphViz.Algorithms Data.GraphViz.Attributes
    Data.GraphViz.Attributes.Colors
    Data.GraphViz.Attributes.Colors.Brewer
    Data.GraphViz.Attributes.Colors.SVG
    Data.GraphViz.Attributes.Colors.X11
    Data.GraphViz.Attributes.Complete Data.GraphViz.Attributes.HTML
    Data.GraphViz.Attributes.Internal Data.GraphViz.Commands
    Data.GraphViz.Commands.IO Data.GraphViz.Exception
    Data.GraphViz.Internal.State Data.GraphViz.Internal.Util
    Data.GraphViz.Parsing Data.GraphViz.PreProcessing
    Data.GraphViz.Printing Data.GraphViz.Types
    Data.GraphViz.Types.Canonical Data.GraphViz.Types.Generalised
    Data.GraphViz.Types.Graph Data.GraphViz.Types.Internal.Common
    Data.GraphViz.Types.Monadic

hidden-modules:
    Data.GraphViz.Algorithms.Clustering Data.GraphViz.Attributes.Arrows
    Data.GraphViz.Attributes.ColorScheme Data.GraphViz.Attributes.Same
    Data.GraphViz.Attributes.Values Data.GraphViz.Commands.Available
    Data.GraphViz.Types.State

import-dirs:          /usr/lib/ghc-8.10.5/site-local/graphviz-2999.20.1.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/graphviz-2999.20.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/graphviz-2999.20.1.0
hs-libraries:         HSgraphviz-2999.20.1.0-96iLVdZRyTNAvCgdcoPpbW
depends:
    base-4.14.2.0 bytestring-0.10.12.0
    colour-2.3.5-Kcgb8k1EndZEaiZNG4e3mM containers-0.6.4.1
    directory-1.3.6.0 dlist-1.0-2pxhAw6JY91eMk6tw7lC2
    fgl-5.7.0.3-7QcjBlSkxRGItOSJY6uAQt filepath-1.4.2.1 mtl-2.2.2
    polyparse-1.13-4Tks6P3TcZl5fGSKCByHwM process-1.6.9.0
    temporary-1.3-8GcUVXeVeMb6fVcXKNialU text-1.2.4.1
    wl-pprint-text-1.2.0.1-EluLDWNsmVp2uUAh1N4fAU

haddock-interfaces:   /usr/share/doc/haskell-graphviz/html/graphviz.haddock
haddock-html:         /usr/share/doc/haskell-graphviz/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

