#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 ghc-typelits-extra
version:              0.4.2
visibility:           public
id:                   ghc-typelits-extra-0.4.2-7e93znmnvIh7Oh6zsV4OH8
key:                  ghc-typelits-extra-0.4.2-7e93znmnvIh7Oh6zsV4OH8
license:              BSD-2-Clause
copyright:
    Copyright © 2015-2016, University of Twente,
    2017-2018, QBayLogic B.V.

maintainer:           christiaan.baaij@gmail.com
author:               Christiaan Baaij
homepage:             http://www.clash-lang.org/
synopsis:             Additional type-level operations on GHC.TypeLits.Nat
description:
    Additional type-level operations on @GHC.TypeLits.Nat@:

    * @Max@: type-level <http://hackage.haskell.org/package/base-4.8.2.0/docs/Prelude.html#v:max max>

    * @Min@: type-level <http://hackage.haskell.org/package/base-4.8.2.0/docs/Prelude.html#v:min min>

    * @Div@: type-level <http://hackage.haskell.org/package/base-4.8.2.0/docs/Prelude.html#v:div div>

    * @Mod@: type-level <http://hackage.haskell.org/package/base-4.8.2.0/docs/Prelude.html#v:mod mod>

    * @FLog@: type-level equivalent of <https://hackage.haskell.org/package/integer-gmp/docs/GHC-Integer-Logarithms.html#v:integerLogBase-35- integerLogBase#>
    i.e. the exact integer equivalent to @floor (logBase x y)@

    * @CLog@: type-level equivalent of /the ceiling of/ <https://hackage.haskell.org/package/integer-gmp/docs/GHC-Integer-Logarithms.html#v:integerLogBase-35- integerLogBase#>
    i.e. the exact integer equivalent to @ceiling (logBase x y)@

    * @Log@: type-level equivalent of <https://hackage.haskell.org/package/integer-gmp/docs/GHC-Integer-Logarithms.html#v:integerLogBase-35- integerLogBase#>
    where the operation only reduces when @floor (logBase b x) ~ ceiling (logBase b x)@

    * @GCD@: a type-level <http://hackage.haskell.org/package/base-4.8.2.0/docs/Prelude.html#v:gcd gcd>

    * @LCM@: a type-level <http://hackage.haskell.org/package/base-4.8.2.0/docs/Prelude.html#v:lcm lcm>

    And a custom solver for the above operations defined in
    @GHC.TypeLits.Extra.Solver@ as a GHC type-checker plugin. To use the plugin,
    add the

    @
    OPTIONS_GHC -fplugin GHC.TypeLits.Extra.Solver
    @

    pragma to the header of your file.

category:             Type System
abi:                  fc2d8cd4f42b4e84d448b7310628ea67
exposed:              True
exposed-modules:      GHC.TypeLits.Extra GHC.TypeLits.Extra.Solver
hidden-modules:
    GHC.TypeLits.Extra.Solver.Unify
    GHC.TypeLits.Extra.Solver.Operations

import-dirs:          /usr/lib/ghc-8.10.5/site-local/ghc-typelits-extra-0.4.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/ghc-typelits-extra-0.4.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/ghc-typelits-extra-0.4.2
hs-libraries:         HSghc-typelits-extra-0.4.2-7e93znmnvIh7Oh6zsV4OH8
depends:
    base-4.14.2.0 containers-0.6.4.1 ghc-8.10.5 ghc-prim-0.6.1
    ghc-tcplugins-extra-0.4.1-KV2ZXQAweA56zK5GfNIVIB
    ghc-typelits-knownnat-0.7.5-9Ga0JrBRSdN6ebgUugqwje
    ghc-typelits-natnormalise-0.7.4-7kKL9CcMIW3FgT0pYk0LWI
    integer-gmp-1.0.3.0 transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-ghc-typelits-extra/html/ghc-typelits-extra.haddock

haddock-html:         /usr/share/doc/haskell-ghc-typelits-extra/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

