#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 filepath-bytestring
version:              1.4.2.1.7
visibility:           public
id:                   filepath-bytestring-1.4.2.1.7-Br0LVMlCKMG5kfqbudRwlT
key:                  filepath-bytestring-1.4.2.1.7-Br0LVMlCKMG5kfqbudRwlT
license:              BSD-3-Clause
copyright:
    Neil Mitchell 2005-2019
    Joey Hess 2019

maintainer:           Joey Hess <id@joeyh.name>
author:               Neil Mitchell <ndmitchell@gmail.com>
synopsis:
    Library for manipulating RawFilePaths in a cross platform way.

description:
    This package provides functionality for manipulating @RawFilePath@
    values. It can be used as a drop in replacement for the filepath library
    to get the benefits of using ByteStrings. It provides three modules:

    * "System.FilePath.Posix.ByteString" manipulates POSIX\/Linux style @RawFilePath@ values (with @\/@ as the path separator).

    * "System.FilePath.Windows.ByteString" manipulates Windows style @RawFilePath@ values (with either @\\@ or @\/@ as the path separator, and deals with drives).

    * "System.FilePath.ByteString" is an alias for the module appropriate to your platform.

    All three modules provide the same API, and the same documentation (calling out differences in the different variants).

category:             System
abi:                  ec21e20c436ecb4711b3e7db2b5e3aa9
exposed:              True
exposed-modules:
    System.FilePath.ByteString System.FilePath.Posix.ByteString
    System.FilePath.Windows.ByteString

import-dirs:
    /usr/lib/ghc-8.10.5/site-local/filepath-bytestring-1.4.2.1.7

library-dirs:
    /usr/lib/ghc-8.10.5/site-local/filepath-bytestring-1.4.2.1.7

dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/i386-linux-ghc-8.10.5/filepath-bytestring-1.4.2.1.7

hs-libraries:         HSfilepath-bytestring-1.4.2.1.7-Br0LVMlCKMG5kfqbudRwlT
depends:              base-4.14.2.0 bytestring-0.10.12.0 unix-2.7.2.2
haddock-interfaces:
    /usr/share/doc/haskell-filepath-bytestring/html/filepath-bytestring.haddock

haddock-html:         /usr/share/doc/haskell-filepath-bytestring/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

