#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 direct-sqlite
version:              2.3.26
visibility:           public
id:                   direct-sqlite-2.3.26-JZBjUsrA31vIIPpaf4XEFQ
key:                  direct-sqlite-2.3.26-JZBjUsrA31vIIPpaf4XEFQ
license:              BSD-3-Clause
copyright:
    Copyright (c) 2012 - 2014 Irene Knapp,
    2014 - 2018 Janne Hellsten,
    2018 - 2020 Sergey Bushnyak

maintainer:           Sergey Bushnyak <sergey.bushnyak@sigrlami.eu>
author:               Irene Knapp <irene.knapp@icloud.com>
homepage:             https://github.com/IreneKnapp/direct-sqlite
synopsis:
    Low-level binding to SQLite3.  Includes UTF8 and BLOB support.

description:
    This package is not very different from the other SQLite3 bindings out
    there, but it fixes a few deficiencies I was finding.  As compared to
    bindings-sqlite3, it is slightly higher-level, in that it supports
    marshalling of data values to and from the database.  In particular,
    it supports strings encoded as UTF8, and BLOBs represented as
    ByteStrings.

category:             Database
abi:                  e37f03bbb7f2345c9d9ee20a402ccbae
exposed:              True
exposed-modules:
    Database.SQLite3 Database.SQLite3.Bindings
    Database.SQLite3.Bindings.Types Database.SQLite3.Direct

import-dirs:          /usr/lib/ghc-8.10.5/site-local/direct-sqlite-2.3.26
library-dirs:         /usr/lib/ghc-8.10.5/site-local/direct-sqlite-2.3.26
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/direct-sqlite-2.3.26
hs-libraries:         HSdirect-sqlite-2.3.26-JZBjUsrA31vIIPpaf4XEFQ
extra-libraries:      sqlite3
depends:
    base-4.14.2.0 bytestring-0.10.12.0
    semigroups-0.19.1-CZajNmE3x4tGZtRwSHDk5O text-1.2.4.1

haddock-interfaces:
    /usr/share/doc/haskell-direct-sqlite/html/direct-sqlite.haddock

haddock-html:         /usr/share/doc/haskell-direct-sqlite/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

