#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-lib
version:              1.4.2
visibility:           public
id:                   clash-lib-1.4.2-EV1xAUEjHpOHym6xTApmx7
key:                  clash-lib-1.4.2-EV1xAUEjHpOHym6xTApmx7
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2019, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - As a library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * The CoreHW internal language: SystemF + Letrec + Case-decomposition

    * The normalisation process that brings CoreHW in a normal form that can be
    converted to a netlist

    * Blackbox/Primitive Handling


    Front-ends (for: parsing, typecheck, etc.) are provided by separate packages:

    * <https://hackage.haskell.org/package/clash-ghc GHC/Haskell Frontend>

    * <https://github.com/christiaanb/Idris-dev Idris Frontend>


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  bb52f51910185d0793721671091783bf
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation.ClashLib Clash.Backend
    Clash.Backend.SystemVerilog Clash.Backend.VHDL
    Clash.Backend.Verilog Clash.Core.DataCon Clash.Core.EqSolver
    Clash.Core.Evaluator.Types Clash.Core.FreeVars Clash.Core.Literal
    Clash.Core.Name Clash.Core.PartialEval
    Clash.Core.PartialEval.AsTerm Clash.Core.PartialEval.Monad
    Clash.Core.PartialEval.NormalForm Clash.Core.Pretty
    Clash.Core.Subst Clash.Core.Term Clash.Core.TermInfo
    Clash.Core.TermLiteral Clash.Core.TermLiteral.TH
    Clash.Core.Termination Clash.Core.TyCon Clash.Core.Type
    Clash.Core.TysPrim Clash.Core.Util Clash.Core.Var Clash.Core.VarEnv
    Clash.Debug Clash.Driver Clash.Driver.Manifest Clash.Driver.Types
    Clash.Edalize.Edam Clash.Netlist Clash.Netlist.BlackBox
    Clash.Netlist.BlackBox.Parser Clash.Netlist.BlackBox.Types
    Clash.Netlist.BlackBox.Util Clash.Netlist.Id
    Clash.Netlist.Id.Common Clash.Netlist.Id.Internal
    Clash.Netlist.Id.SystemVerilog Clash.Netlist.Id.VHDL
    Clash.Netlist.Id.Verilog Clash.Netlist.Types Clash.Netlist.Util
    Clash.Normalize Clash.Normalize.DEC
    Clash.Normalize.PrimitiveReductions Clash.Normalize.Strategy
    Clash.Normalize.Transformations Clash.Normalize.Types
    Clash.Normalize.Util Clash.Pretty Clash.Primitives.DSL
    Clash.Primitives.GHC.Int Clash.Primitives.GHC.Literal
    Clash.Primitives.GHC.Word Clash.Primitives.Intel.ClockGen
    Clash.Primitives.Sized.ToInteger Clash.Primitives.Sized.Vector
    Clash.Primitives.Types Clash.Primitives.Util
    Clash.Primitives.Verification Clash.Rewrite.Combinators
    Clash.Rewrite.Types Clash.Rewrite.Util Clash.Rewrite.WorkFree
    Clash.Unique Clash.Util Clash.Util.Graph Clash.Util.Interpolate
    Data.Text.Prettyprint.Doc.Extra

hidden-modules:
    Clash.Annotations.TopEntity.Extra Control.Applicative.Extra
    Data.Aeson.Extra Data.List.Extra Data.Map.Ordered.Extra
    Data.Primitive.ByteArray.Extra Data.Semigroup.Monad.Extra
    Data.Set.Ordered.Extra GHC.BasicTypes.Extra GHC.SrcLoc.Extra
    Paths_clash_lib

import-dirs:          /usr/lib/ghc-8.10.5/site-local/clash-lib-1.4.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/clash-lib-1.4.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/clash-lib-1.4.2
hs-libraries:         HSclash-lib-1.4.2-EV1xAUEjHpOHym6xTApmx7
depends:
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ
    aeson-pretty-0.8.8-3aCNsqOVx5w7giic7jdZv7
    ansi-terminal-0.11-366lZebL4UKAFopo4Q1x1i array-0.5.4.0
    attoparsec-0.14.1-CDW2c9fsk3y4jVQKNBcpib base-4.14.2.0
    base16-bytestring-1.0.1.0-HvKbW9RCiAQ5xlJPICEukR binary-0.8.8.0
    bytestring-0.10.12.0 clash-prelude-1.4.2-E2UwAKCOSzTI2wACpNoK8p
    concurrent-supply-0.1.8-6JZZa09jJFLH7rRErjVHpD containers-0.6.4.1
    cryptohash-sha256-0.11.102.0-GeiT4PSdo4ZH5E1cWZ6znE
    data-binary-ieee754-0.4.4-BBofvLKootn8l57SJnz736
    data-default-0.7.1.1-5u8NwVJ9HGT30K0bkKsBOX deepseq-1.4.4.0
    directory-1.3.6.0 dlist-1.0-2pxhAw6JY91eMk6tw7lC2
    errors-2.3.0-L2PYtE6sWhcKjNVUy63IeC exceptions-0.10.4
    extra-1.7.9-4atxCqewDRnKsFBrL9ak4x filepath-1.4.2.1 ghc-8.10.5
    ghc-boot-th-8.10.5 hashable-1.3.2.0-GpzwVyCMdDv8NwdC61S1EE
    haskell-src-meta-0.8.7-G05LCOS2t7o5qMJRkyaooz
    hint-0.9.0.4-LK4O9xhZAogDQ988RpN1lj integer-gmp-1.0.3.0
    interpolate-0.2.1-KHuR4MgF6BR3kkE5Ro2R7H
    lens-5.0.1-9j09gzxg2dR5Wmd3U39g28 mtl-2.2.2
    ordered-containers-0.2.2-4hDEgxfiDLqBjZHb5VUNDJ
    parsers-0.12.10-BMaDGU0UZ32IYwApQumZx4
    pretty-show-1.10-jI5AqYpLoz98dMARTaePi
    prettyprinter-1.7.0-D28lGbKBr8A22zyggdsd0d
    primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh process-1.6.9.0
    reducers-3.12.3-9xE6j0xIYVbBQgO8nghmVb template-haskell-2.16.0.0
    temporary-1.3-8GcUVXeVeMb6fVcXKNialU
    terminal-size-0.3.2.1-8LMlp57ywuCIM7VIh4tqn1 text-1.2.4.1
    text-show-3.9-IU6rO8cci5SLsE2pr9Ujqy time-1.9.3
    transformers-0.5.6.2 trifecta-2.1.1-FcyWD2aUBQJ6k1c1C3rZuo
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
    vector-binary-instances-0.2.5.2-5fEBRlLrHbJIGSRNZhKDtf

haddock-interfaces:   /usr/share/doc/haskell-clash-lib/html/clash-lib.haddock
haddock-html:         /usr/share/doc/haskell-clash-lib/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

