#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 aws
version:              0.22
visibility:           public
id:                   aws-0.22-1f72u9DiyfN3Ns0TW9HMoP
key:                  aws-0.22-1f72u9DiyfN3Ns0TW9HMoP
license:              BSD-3-Clause
copyright:            See contributors list in README and LICENSE file
maintainer:           aristidb@gmail.com
author:               Aristid Breitkreuz, contributors see README
homepage:             http://github.com/aristidb/aws
synopsis:             Amazon Web Services (AWS) for Haskell
description:
    Bindings for Amazon Web Services (AWS), with the aim of supporting all AWS services. To see a high level overview of the library, see the README at <https://github.com/aristidb/aws/blob/master/README.md>.

category:             Network, Web, AWS, Cloud, Distributed Computing
abi:                  fd1770833c03e66c944668f9fa474707
exposed:              True
exposed-modules:
    Aws Aws.Aws Aws.Core Aws.DynamoDb Aws.DynamoDb.Commands
    Aws.DynamoDb.Commands.BatchGetItem
    Aws.DynamoDb.Commands.BatchWriteItem
    Aws.DynamoDb.Commands.DeleteItem Aws.DynamoDb.Commands.GetItem
    Aws.DynamoDb.Commands.PutItem Aws.DynamoDb.Commands.Query
    Aws.DynamoDb.Commands.Scan Aws.DynamoDb.Commands.Table
    Aws.DynamoDb.Commands.UpdateItem Aws.DynamoDb.Core
    Aws.Ec2.InstanceMetadata Aws.Iam Aws.Iam.Commands
    Aws.Iam.Commands.AddUserToGroup Aws.Iam.Commands.CreateAccessKey
    Aws.Iam.Commands.CreateGroup Aws.Iam.Commands.CreateUser
    Aws.Iam.Commands.DeleteAccessKey Aws.Iam.Commands.DeleteGroup
    Aws.Iam.Commands.DeleteGroupPolicy Aws.Iam.Commands.DeleteUser
    Aws.Iam.Commands.DeleteUserPolicy Aws.Iam.Commands.GetGroupPolicy
    Aws.Iam.Commands.GetUser Aws.Iam.Commands.GetUserPolicy
    Aws.Iam.Commands.ListAccessKeys Aws.Iam.Commands.ListGroupPolicies
    Aws.Iam.Commands.ListGroups Aws.Iam.Commands.ListMfaDevices
    Aws.Iam.Commands.ListUserPolicies Aws.Iam.Commands.ListUsers
    Aws.Iam.Commands.PutGroupPolicy Aws.Iam.Commands.PutUserPolicy
    Aws.Iam.Commands.RemoveUserFromGroup
    Aws.Iam.Commands.UpdateAccessKey Aws.Iam.Commands.UpdateGroup
    Aws.Iam.Commands.UpdateUser Aws.Iam.Core Aws.Iam.Internal
    Aws.Network Aws.S3 Aws.S3.Commands Aws.S3.Commands.CopyObject
    Aws.S3.Commands.DeleteBucket Aws.S3.Commands.DeleteObject
    Aws.S3.Commands.DeleteObjectVersion Aws.S3.Commands.DeleteObjects
    Aws.S3.Commands.GetBucket Aws.S3.Commands.GetBucketLocation
    Aws.S3.Commands.GetBucketObjectVersions Aws.S3.Commands.GetObject
    Aws.S3.Commands.GetService Aws.S3.Commands.HeadObject
    Aws.S3.Commands.Multipart Aws.S3.Commands.PutBucket
    Aws.S3.Commands.PutBucketVersioning Aws.S3.Commands.PutObject
    Aws.S3.Core Aws.Ses Aws.Ses.Commands
    Aws.Ses.Commands.DeleteIdentity
    Aws.Ses.Commands.GetIdentityDkimAttributes
    Aws.Ses.Commands.GetIdentityNotificationAttributes
    Aws.Ses.Commands.GetIdentityVerificationAttributes
    Aws.Ses.Commands.ListIdentities Aws.Ses.Commands.SendRawEmail
    Aws.Ses.Commands.SetIdentityDkimEnabled
    Aws.Ses.Commands.SetIdentityFeedbackForwardingEnabled
    Aws.Ses.Commands.SetIdentityNotificationTopic
    Aws.Ses.Commands.VerifyDomainDkim
    Aws.Ses.Commands.VerifyDomainIdentity
    Aws.Ses.Commands.VerifyEmailIdentity Aws.Ses.Core Aws.SimpleDb
    Aws.SimpleDb.Commands Aws.SimpleDb.Commands.Attributes
    Aws.SimpleDb.Commands.Domain Aws.SimpleDb.Commands.Select
    Aws.SimpleDb.Core Aws.Sqs Aws.Sqs.Commands Aws.Sqs.Commands.Message
    Aws.Sqs.Commands.Permission Aws.Sqs.Commands.Queue
    Aws.Sqs.Commands.QueueAttributes Aws.Sqs.Core

import-dirs:          /usr/lib/ghc-8.10.5/site-local/aws-0.22
library-dirs:         /usr/lib/ghc-8.10.5/site-local/aws-0.22
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/aws-0.22
hs-libraries:         HSaws-0.22-1f72u9DiyfN3Ns0TW9HMoP
depends:
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ
    attoparsec-0.14.1-CDW2c9fsk3y4jVQKNBcpib base-4.14.2.0
    base16-bytestring-1.0.1.0-HvKbW9RCiAQ5xlJPICEukR
    base64-bytestring-1.2.0.1-9folcSD81CwJ7ibR6pZE7R
    blaze-builder-0.4.2.1-CvyaA91rGJh3LGq34EOJVB
    byteable-0.1.1-Gf4TH6XbSdI4yHpNVK8xgD bytestring-0.10.12.0
    case-insensitive-1.2.1.0-G5jOpOHgp1lAnadtJPMHHB
    cereal-0.5.8.1-4r85zOZIbEW4fo8WFnBuTl
    conduit-1.3.4.1-GHgRKpknFuqDscwzVojbiE
    conduit-extra-1.3.5-6wbdzvOjyuAGkpGhMnpbur containers-0.6.4.1
    cryptonite-0.29-KSQcZnQaH5M3lIm9Vzc7YS
    data-default-0.7.1.1-5u8NwVJ9HGT30K0bkKsBOX directory-1.3.6.0
    exceptions-0.10.4 filepath-1.4.2.1
    http-client-tls-0.3.5.3-1EuJcCGFPgBHafkDNjffQC
    http-conduit-2.3.8-EHVj4SxGcYE5sNggtZCndH
    http-types-0.12.3-JSCBEGU6f6MIPS3hXwEPIB
    lifted-base-0.2.3.12-HsHHuUVdYcr6iiSvL0hwyv
    memory-0.16.0-E1gXzMJzgEcJ8QhI9dLs6S
    monad-control-1.0.2.3-Bi4GOATU8bxGtDgK1rR68J mtl-2.2.2
    network-3.1.2.2-5EE9GqQpTmvH0oBl8byO4M
    network-bsd-2.8.1.0-J6bIyDlFsUOASjxht9nXWx
    old-locale-1.0.0.7-L6Wsx5CTYHFJNpULKIS1yv
    resourcet-1.2.4.2-7etOfd8fePh2l91avxjTIe
    safe-0.3.19-DlKvqLTtraZKItu5PR3KBM
    scientific-0.3.7.0-Fi0gRGhsiJ35wgbCjOXuHX
    tagged-0.8.6.1-F25vmSN4H5fEaMJYsLgYMV text-1.2.4.1 time-1.9.3
    transformers-0.5.6.2
    unordered-containers-0.2.14.0-JpdjDmlqBJN4PAu3jIj4Ya
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp
    xml-conduit-1.9.1.1-5pCpotf51DzBhLZtCry6QK

haddock-interfaces:   /usr/share/doc/haskell-aws/html/aws.haddock
haddock-html:         /usr/share/doc/haskell-aws/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

