#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 abstract-deque
version:              0.3
visibility:           public
id:                   abstract-deque-0.3-2HPl6PiF3J2CEi80oUuAC8
key:                  abstract-deque-0.3-2HPl6PiF3J2CEi80oUuAC8
license:              BSD-3-Clause
maintainer:           rrnewton@gmail.com
author:               Ryan R. Newton
homepage:             https://github.com/rrnewton/haskell-lockfree/wiki
synopsis:             Abstract, parameterized interface to mutable Deques.
description:
    An abstract interface to highly-parameterizable queues/deques.

    Background: There exists a feature space for queues that extends between:

    * simple, single-ended, non-concurrent, bounded queues

    * double-ended, threadsafe, growable queues

    ... with important points inbetween (such as
    the queues used for work-stealing).

    This package includes an interface for Deques that allows the
    programmer to use a single API for all of the above, while using the
    type-system to select an efficient implementation given the
    requirements (using type families).

    This package also includes a simple reference implementation based
    on '\''IORef'\'' and "Data.Sequence".

category:             Data 
abi:                  905463c841411fdb97ef8121407fdef0
exposed:              True
exposed-modules:
    Data.Concurrent.Deque.Class Data.Concurrent.Deque.Debugger
    Data.Concurrent.Deque.Reference
    Data.Concurrent.Deque.Reference.DequeInstance

import-dirs:          /usr/lib/ghc-8.10.5/site-local/abstract-deque-0.3
library-dirs:         /usr/lib/ghc-8.10.5/site-local/abstract-deque-0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/abstract-deque-0.3
hs-libraries:         HSabstract-deque-0.3-2HPl6PiF3J2CEi80oUuAC8
depends:
    array-0.5.4.0 base-4.14.2.0 containers-0.6.4.1
    random-1.2.0-GZbCBA9NAlUBaVRSIi1HYu time-1.9.3

haddock-interfaces:
    /usr/share/doc/haskell-abstract-deque/html/abstract-deque.haddock

haddock-html:         /usr/share/doc/haskell-abstract-deque/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

