/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfile;
import org.apache.ivy.util.Message;

public class ExecutionEnvironmentProfileProvider {
    private static final String DEFAULT_PROFILES_FILE = "jvm-packages.properties";
    private static final String PACKAGE_PREFIX = "org/apache/ivy/osgi/core/";
    private Map profileList = ExecutionEnvironmentProfileProvider.loadDefaultProfileList();
    private static final ExecutionEnvironmentProfileProvider INSTANCE;

    public static ExecutionEnvironmentProfileProvider getInstance() {
        return INSTANCE;
    }

    public ExecutionEnvironmentProfile getProfile(String profile) {
        return (ExecutionEnvironmentProfile)this.profileList.get(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map loadDefaultProfileList() throws IOException {
        ClassLoader loader = ExecutionEnvironmentProfileProvider.class.getClassLoader();
        InputStream defaultProfilesFile = loader.getResourceAsStream("org/apache/ivy/osgi/core/jvm-packages.properties");
        if (defaultProfilesFile == null) {
            throw new FileNotFoundException("org/apache/ivy/osgi/core/jvm-packages.properties not found in the classpath");
        }
        Properties props = new Properties();
        try {
            props.load(defaultProfilesFile);
        }
        finally {
            defaultProfilesFile.close();
        }
        HashMap profiles = new HashMap();
        Iterator<Map.Entry<Object, Object>> itProp = props.entrySet().iterator();
        while (itProp.hasNext()) {
            String profileName;
            Map.Entry<Object, Object> prop = itProp.next();
            String propName = (String)prop.getKey();
            if (!propName.endsWith(".pkglist") || profiles.containsKey(profileName = propName.substring(0, propName.length() - 8))) continue;
            ExecutionEnvironmentProfileProvider.loadProfile(props, profiles, profileName);
        }
        return profiles;
    }

    private static ExecutionEnvironmentProfile loadProfile(Properties props, Map profiles, String name) {
        ExecutionEnvironmentProfile profile = new ExecutionEnvironmentProfile(name);
        String extendedProfileName = props.getProperty(name + ".extends");
        if (extendedProfileName != null) {
            ExecutionEnvironmentProfile extendedProfile = (ExecutionEnvironmentProfile)profiles.get(extendedProfileName);
            if (extendedProfile == null) {
                extendedProfile = ExecutionEnvironmentProfileProvider.loadProfile(props, profiles, extendedProfileName);
            }
            Iterator itExtended = extendedProfile.getPkgNames().iterator();
            while (itExtended.hasNext()) {
                profile.addPkgName((String)itExtended.next());
            }
        }
        String pkgList = props.getProperty(name + ".pkglist");
        String[] packages = pkgList.split(",");
        for (int i = 0; i < packages.length; ++i) {
            String pkg = packages[i].trim();
            if (pkg.length() == 0) continue;
            profile.addPkgName(pkg);
        }
        profiles.put(name, profile);
        Message.verbose("Execution environment profile " + profile.getName() + " loaded");
        return profile;
    }

    static {
        try {
            INSTANCE = new ExecutionEnvironmentProfileProvider();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

