#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 clash-ghc
version:              1.4.2
visibility:           public
id:                   clash-ghc-1.4.2-H8JcmWWLEMU8YqqE8U8OuW
key:                  clash-ghc-1.4.2-H8JcmWWLEMU8YqqE8U8OuW
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2017, Myrtle Software Ltd,
    2017-2019, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - GHC frontend

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * Clash Compiler binary using GHC/Haskell as a frontend


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  06a29475807491d65edc70c42c2a1bca
exposed:              True
exposed-modules:
    Clash.GHC.Evaluator Clash.GHC.Evaluator.Primitive
    Clash.GHC.GenerateBindings Clash.GHC.LoadModules
    Clash.GHC.NetlistTypes Clash.GHC.PartialEval
    Clash.GHC.PartialEval.Eval Clash.GHC.PartialEval.Primitive
    Clash.GHC.PartialEval.Quote Clash.GHCi.Common Clash.Main

hidden-modules:
    Clash.GHCi.UI Clash.GHCi.UI.Info Clash.GHCi.UI.Monad
    Clash.GHCi.UI.Tags Clash.GHC.ClashFlags Clash.GHC.GHC2Core
    Clash.GHC.LoadInterfaceFiles Clash.GHC.Util Paths_clash_ghc
    Clash.GHCi.Leak Clash.GHCi.Util

import-dirs:          /usr/lib/ghc-8.10.5/site-local/clash-ghc-1.4.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/clash-ghc-1.4.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/clash-ghc-1.4.2
hs-libraries:         HSclash-ghc-1.4.2-H8JcmWWLEMU8YqqE8U8OuW
depends:
    Cabal-3.2.1.0 array-0.5.4.0 base-4.14.2.0
    bifunctors-5.5.11-62Q02Tz1l88F1V0eOPlGhU bytestring-0.10.12.0
    clash-lib-1.4.2-5565hFg1ok8E9YWegx8F8y
    clash-prelude-1.4.2-LaOopvtmWAmFFCxaQqs9gG
    concurrent-supply-0.1.8-7NN1OxB0HmP8AlnFB3GVid containers-0.6.4.1
    deepseq-1.4.4.0 directory-1.3.6.0 exceptions-0.10.4
    extra-1.7.9-I2EBCNs9k096Tr6TS7Hr6q filepath-1.4.2.1 ghc-8.10.5
    ghc-boot-8.10.5 ghc-prim-0.6.1
    ghc-typelits-extra-0.4.2-35TsNSINDzo1NWKj7Si1ZZ
    ghc-typelits-knownnat-0.7.5-KVAZkbaVRsxFzqD6LXhqt8
    ghc-typelits-natnormalise-0.7.4-9uwNlpgwoidEuKrtkPIvf6 ghci-8.10.5
    hashable-1.3.2.0-3hvuAxdSjzxDW0RNnAXdYP haskeline-0.8.0.1
    integer-gmp-1.0.3.0 lens-5.0.1-IbvU1bVPfUJ4fN12HblCTX mtl-2.2.2
    primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh process-1.6.9.0
    reflection-2.1.6-HzgLH8hVgZPCjNofm3HjVv
    split-0.2.3.4-B2kmGe26Sk0AtE9bO993ec template-haskell-2.16.0.0
    text-1.2.4.1 time-1.9.3 transformers-0.5.6.2
    uniplate-1.6.13-If9GSszYBfw3FE5qrfMeD9 unix-2.7.2.2
    unordered-containers-0.2.14.0-8aHRrFmFeW5FoD6sXDqCak
    utf8-string-1.0.2-DMovLmOdbFr3ZT2kNNb9Du
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:   /usr/share/doc/clash-ghc/html/clash-ghc.haddock
haddock-html:         /usr/share/doc/clash-ghc/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

