#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cabal-plan
version:              0.7.2.0
visibility:           public
id:                   cabal-plan-0.7.2.0-EJBJVx38HnyLUBRhnNB15f
key:                  cabal-plan-0.7.2.0-EJBJVx38HnyLUBRhnNB15f
license:              GPL-2.0-or-later
copyright:            2016 Herbert Valerio Riedel
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel
synopsis:             Library and utility for processing cabal'\''s plan.json file
description:
    This package provides a library (see "Cabal.Plan") for decoding @plan.json@ files as
    well as the simple tool @cabal-plan@ for extracting and pretty printing
    the information contained in the @plan.json@ file.

    @plan.json@ files are generated by [cabal](https://hackage.haskell.org/package/cabal-install)'\''s [Nix-style local builds](http://cabal.readthedocs.io/en/latest/nix-local-build.html) and contain detailed information about the build/install plan computed by the cabal solver.

    == @cabal-plan@ utility

    The @cabal-plan@ executable (enabled via the @exe@ cabal flag) provides various operations:

    [info] Show basic report of dependency tree
    [show] Dump '\''PlanJson'\'' data-structure via '\''Show'\'' instance
    [tred] Show dependency tree as a graph
    [diff] Diff two install plans
    [list-bins] List all binaries
    [list-bin] List single binary (useful for scripting, e.g. @cabal list-bin exe:cabal-plan@)
    [fingerprint] Print SHA256 sums of dependencies'\'' source tarballs and cabal files
    [dot] Generate graph of dependencies in @.dot@ format
    [topo] Print plan topologically sorted
    [license-report] Generate license report for a component (only available when built with @license-report@ flag enabled); see <src/example/cabal-plan.md report example for cabal-plan> (<src/example/cabal-plan.html Pandoc rendered HTML>)

    See also ["New things in Haskell package QA" Blogpost](http://oleg.fi/gists/posts/2018-01-08-haskell-package-qa.html) for a description of the @topo@ and @dot@ operations as well as how to enable tab-completion.

category:             Development
abi:                  74f9abf56186d2a5d778979afc7c7c12
exposed:              True
exposed-modules:      Cabal.Plan
import-dirs:          /usr/lib/ghc-8.10.5/site-local/cabal-plan-0.7.2.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/cabal-plan-0.7.2.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/cabal-plan-0.7.2.0
hs-libraries:         HScabal-plan-0.7.2.0-EJBJVx38HnyLUBRhnNB15f
depends:
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ base-4.14.2.0
    base16-bytestring-1.0.1.0-HvKbW9RCiAQ5xlJPICEukR
    bytestring-0.10.12.0 containers-0.6.4.1 directory-1.3.6.0
    filepath-1.4.2.1 text-1.2.4.1

haddock-interfaces:   /usr/share/doc/cabal-plan/html/cabal-plan.haddock
haddock-html:         /usr/share/doc/cabal-plan/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

