#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 arch-hs
version:              0.9.1.0
visibility:           public
id:                   arch-hs-0.9.1.0-1TFmJ2KpSH94GPGwirdwaK
key:                  arch-hs-0.9.1.0-1TFmJ2KpSH94GPGwirdwaK
license:              MIT
copyright:            (c) 2020-2021 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  44e257592b4e4c0cc75dff79d731ed3f
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.CommunityDB
    Distribution.ArchHs.Compat Distribution.ArchHs.Core
    Distribution.ArchHs.Exception Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-8.10.5/site-local/arch-hs-0.9.1.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/arch-hs-0.9.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/arch-hs-0.9.1.0
hs-libraries:         HSarch-hs-0.9.1.0-1TFmJ2KpSH94GPGwirdwaK
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-8.10.5/site-local/arch-hs-0.9.1.0/include
depends:
    Cabal-3.2.1.0 Diff-0.4.0-13VXofqCMLyHuBACVASIzF
    aeson-1.5.6.0-CVfeYccFVpdCde0UrZZZdZ
    algebraic-graphs-0.5-6Mitx71bn696mws0hSew9y
    arch-web-0.1.0-5jG2Nry7DfQ9FNnSlsi9OH base-4.14.2.0
    bytestring-0.10.12.0 conduit-1.3.4.1-GHgRKpknFuqDscwzVojbiE
    conduit-extra-1.3.5-6wbdzvOjyuAGkpGhMnpbur containers-0.6.4.1
    deepseq-1.4.4.0 directory-1.3.6.0 filepath-1.4.2.1
    hackage-db-2.1.1-LK8FDtjaENpBfPviG3zpLM
    http-client-0.7.8-C6JWYZrbeBCPAdb6EpQD6
    http-client-tls-0.3.5.3-1EuJcCGFPgBHafkDNjffQC
    megaparsec-9.0.1-CgNxKp13Re58VqY3iga6b3
    microlens-0.4.12.0-7mbtYeVEJj9DE2AV66WaoK
    microlens-th-0.4.3.10-L22hJd4Bpy6EfILCAvCrvo
    neat-interpolation-0.5.1.2-JnP70tAK7gc9ekAYp3VaAX
    optparse-simple-0.1.1.3-FOz3MnvZGS35as3It23VmF
    polysemy-1.5.0.0-33hK6tV6KOVI09ObP4vO2c
    prettyprinter-1.7.0-D28lGbKBr8A22zyggdsd0d
    prettyprinter-ansi-terminal-1.1.2-B0FzwVcIaD83YtSeA0ehf
    servant-client-0.18.2-I9C0Cy2YGbR2G9HxaeOyxu
    split-0.2.3.4-Fv3j3BhtJgT8PrdAoYtOLl
    tar-conduit-0.3.2-IatGl7EIOMh68FCdScy5xH template-haskell-2.16.0.0
    text-1.2.4.1

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

