# keyboard

everything on this list can be configured in the "Keyboard" tab of the Settings dialog:
- click on a keybind then enter a key or key combination to change it.
- right-click to clear the keybind.

the keys in the "Global hotkeys" section can be used in any window, though not within text boxes.

| action                                                 | default keybind  |
|--------------------------------------------------------|------------------|
| **Global hotkeys**                                     |                  |
| New                                                    | `Ctrl-N`         |
| Clear song data                                        | —                |
| Open file                                              | `Ctrl-O`         |
| Restore backup                                         | —                |
| Save file                                              | `Ctrl-S`         |
| Save as                                                | `Ctrl-Shift-S`   |
| Undo                                                   | `Ctrl-Z`         |
| Redo                                                   | `Ctrl-Y`         |
| Play/Stop (toggle)                                     | `Return`         |
| Play                                                   | —                |
| Stop                                                   | —                |
| Play (from beginning)                                  | `F5`             |
| Play (repeat pattern)                                  | —                |
| Play from cursor                                       | `Shift-Return`   |
| Step row                                               | `Ctrl-Return`    |
| Octave up                                              | `Keypad *`       |
| Octave down                                            | `Keypad /`       |
| Previous instrument                                    | `Shift-Keypad /` |
| Next instrument                                        | `Shift-Keypad *` |
| Increase edit step                                     | `Ctrl-Keypad *`  |
| Decrease edit step                                     | `Ctrl-Keypad /`  |
| Toggle edit mode                                       | `Space`          |
| Metronome                                              | `Ctrl-M`         |
| Toggle repeat pattern                                  | —                |
| Follow orders                                          | —                |
| Follow pattern                                         | —                |
| Toggle full-screen                                     | `F11`            |
| Request voice from TX81Z                               | —                |
| Panic                                                  | `F12`            |
|                                                        |                  |
| **Window activation**                                  |                  |
| Find/Replace                                           | Ctrl-F           |
| Settings                                               | —                |
| Song Information                                       | —                |
| Subsongs                                               | —                |
| Speed                                                  | —                |
| Instrument List                                        | —                |
| Wavetable List                                         | —                |
| Sample List                                            | —                |
| Orders                                                 | —                |
| Pattern                                                | —                |
| Mixer                                                  | —                |
| Grooves                                                | —                |
| Channels                                               | —                |
| Pattern Manager                                        | —                |
| Chip Manager                                           | —                |
| Compatibility Flags                                    | —                |
| Song Comments                                          | —                |
| Instrument Editor                                      | —                |
| Wavetable Editor                                       | —                |
| Sample Editor                                          | —                |
| Edit Controls                                          | —                |
| Piano                                                  | —                |
| Oscilloscope (master)                                  | —                |
| Oscilloscope (per-channel)                             | —                |
| Volume Meter                                           | —                |
| Clock                                                  | —                |
| Register View                                          | —                |
| Log Viewer                                             | —                |
| Statistics                                             | —                |
| Effect List                                            | —                |
| Debug Menu                                             | `Ctrl-Shift-D`   |
| About                                                  | —                |
| Collapse/expand current window                         | —                |
| Close current window                                   | `Shift-Escape`   |
|                                                        |                  |
| **Note input**                                         |                  |
| _see "note input" section after table_                 |                  |
|                                                        |                  |
| **Pattern**                                            |                  |
| Transpose (+1)                                         | `Ctrl-F2`        |
| Transpose (-1)                                         | `Ctrl-F1`        |
| Transpose (+1 octave)                                  | `Ctrl-F4`        |
| Transpose (-1 octave)                                  | `Ctrl-F3`        |
| Increase values (+1)                                   | `Ctrl-Shift-F2`  |
| Increase values (-1)                                   | `Ctrl-Shift-F1`  |
| Increase values (+16)                                  | `Ctrl-Shift-F4`  |
| Increase values (-16)                                  | `Ctrl-Shift-F3`  |
| Select all                                             | `Ctrl-A`         |
| Cut                                                    | `Ctrl-X`         |
| Copy                                                   | `Ctrl-C`         |
| Paste                                                  | `Ctrl-V`         |
| Paste Mix (foreground)                                 | `Ctrl-Shift-V`   |
| Paste Mix (background)                                 | —                |
| Paste Flood                                            | —                |
| Paste Overflow                                         | —                |
| Move cursor up                                         | `Up`             |
| Move cursor down                                       | `Down`           |
| Move cursor left                                       | `Left`           |
| Move cursor right                                      | `Right`          |
| Move cursor up by one (override Edit Step)             | `Shift-Home`     |
| Move cursor down by one (override Edit Step)           | `Shift-End`      |
| Move cursor to previous channel                        | —                |
| Move cursor to next channel                            | —                |
| Move cursor to next channel (overflow)                 | —                |
| Move cursor to previous channel (overflow)             | —                |
| Move cursor to beginning of pattern                    | `Home`           |
| Move cursor to end of pattern                          | `End`            |
| Move cursor up (coarse)                                | `PageUp`         |
| Move cursor down (coarse)                              | `PageDown`       |
| Expand selection upwards                               | `Shift-Up`       |
| Expand selection downwards                             | `Shift-Down`     |
| Expand selection to the left                           | `Shift-Left`     |
| Expand selection to the right                          | `Shift-Right`    |
| Expand selection upwards by one (override Edit Step)   | —                |
| Expand selection downwards by one (override Edit Step) | —                |
| Expand selection to beginning of pattern               | —                |
| Expand selection to end of pattern                     | —                |
| Expand selection upwards (coarse)                      | `Shift-PageUp`   |
| Expand selection downwards (coarse)                    | `Shift-PageDown` |
| Delete                                                 | `Delete`         |
| Pull delete                                            | `Backspace`      |
| Insert                                                 | `Insert`         |
| Mute channel at cursor                                 | `Alt-F9`         |
| Solo channel at cursor                                 | `Alt-F10`        |
| Unmute all channels                                    | `Alt-Shift-F9`   |
| Go to next order                                       | —                |
| Go to previous order                                   | —                |
| Collapse channel at cursor                             | —                |
| Increase effect columns                                | —                |
| Decrease effect columns                                | —                |
| Interpolate                                            | —                |
| Fade                                                   | —                |
| Invert values                                          | —                |
| Flip selection                                         | —                |
| Collapse rows                                          | —                |
| Expand rows                                            | —                |
| Collapse pattern                                       | —                |
| Expand pattern                                         | —                |
| Collapse song                                          | —                |
| Expand song                                            | —                |
| Set note input latch                                   | —                |
| Clear note input latch                                 | —                |
|                                                        |                  |
| **Instrument list**                                    |                  |
| Add                                                    | `Insert`         |
| Duplicate                                              | `Ctrl-D`         |
| Open                                                   | —                |
| Open (replace current)                                 | —                |
| Save                                                   | —                |
| Save (.dmp)                                            | —                |
| Move up                                                | `Shift-Up`       |
| Move down                                              | `Shift-Down`     |
| Delete                                                 | —                |
| Edit                                                   | `Shift-Return`   |
| Cursor up                                              | `Up`             |
| Cursor down                                            | `Down`           |
| Toggle folders/standard view                           | `Ctrl-V`         |
|                                                        |                  |
| **Wavetable list**                                     |                  |
| Add                                                    | `Insert`         |
| Duplicate                                              | `Ctrl-D`         |
| Open                                                   | —                |
| Open (replace current)                                 | —                |
| Save                                                   | —                |
| Save (.dmw)                                            | —                |
| Save (raw)                                             | —                |
| Move up                                                | `Shift-Up`       |
| Move down                                              | `Shift-Down`     |
| Delete                                                 | —                |
| Edit                                                   | `Shift-Return`   |
| Cursor up                                              | `Up`             |
| Cursor down                                            | `Down`           |
| Toggle folders/standard view                           | `Ctrl-V`         |
|                                                        |                  |
| **Sample list**                                        |                  |
| Add                                                    | `Insert`         |
| Duplicate                                              | `Ctrl-D`         |
| Create wavetable from selection                        | `Ctrl-W`         |
| Open                                                   | —                |
| Open (replace current)                                 | —                |
| Import raw data                                        | —                |
| Import raw data (replace current)                      | —                |
| Save                                                   | —                |
| Save (raw)                                             | —                |
| Move up                                                | `Shift-Up`       |
| Move down                                              | `Shift-Down`     |
| Delete                                                 | —                |
| Edit                                                   | `Shift-Return`   |
| Cursor up                                              | `Up`             |
| Cursor down                                            | `Down`           |
| Preview                                                | —                |
| Stop preview                                           | —                |
| Toggle folders/standard view                           | `Ctrl-V`         |
|                                                        |                  |
| **Orders**                                             |                  |
| Previous order                                         | `Up`             |
| Next order                                             | `Down`           |
| Cursor left                                            | `Left`           |
| Cursor right                                           | `Right`          |
| Increase value                                         | —                |
| Decrease value                                         | —                |
| Switch edit mode                                       | —                |
| Toggle alter entire row                                | `Ctrl-L`         |
| Add                                                    | `Insert`         |
| Duplicate                                              | `Ctrl-D`         |
| Deep clone                                             | `Ctrl-Shift-D`   |
| Duplicate to end of song                               | `Ctrl-E`         |
| Deep clone to end of song                              | `Ctrl-Shift-E`   |
| Remove                                                 | `Delete`         |
| Move up                                                | `Shift-Up`       |
| Move down                                              | `Shift-Down`     |
| Replay                                                 | —                |
|                                                        |                  |
| **Sample editor**                                      |                  |
| Edit mode: Select                                      | `Shift-I`        |
| Edit mode: Draw                                        | `Shift-D`        |
| Cut                                                    | `Ctrl-X`         |
| Copy                                                   | `Ctrl-C`         |
| Paste                                                  | `Ctrl-V`         |
| Paste replace                                          | `Ctrl-Shift-V`   |
| Paste mix                                              | `Ctrl-Alt-V`     |
| Select all                                             | `Ctrl-A`         |
| Resize                                                 | `Ctrl-R`         |
| Resample                                               | `Ctrl-E`         |
| Amplify                                                | `Ctrl-B`         |
| Normalize                                              | `Ctrl-N`         |
| Fade in                                                | `Ctrl-I`         |
| Fade out                                               | `Ctrl-O`         |
| Insert silence                                         | `Insert`         |
| Apply silence                                          | `Shift-Delete`   |
| Delete                                                 | `Delete`         |
| Trim                                                   | `Ctrl-Delete`    |
| Reverse                                                | `Ctrl-T`         |
| Invert                                                 | `Ctrl-Shift-T`   |
| Signed/unsigned exchange                               | `Ctrl-U`         |
| Apply filter                                           | `Ctrl-F`         |
| Preview sample                                         | —                |
| Stop sample preview                                    | —                |
| Zoom in                                                | `Ctrl-=`         |
| Zoom out                                               | `Ctrl--`         |
| Toggle auto-zoom                                       | `Ctrl-0`         |
| Create instrument from sample                          | —                |
| Set loop to selection                                  | `Ctrl-L`         |

## note input

the settings for note input keybinds operate differently. each entry in the list of keybinds is made of the following:
- **Key**: key assignment.
- **Type**: type of note input. left-click cycles through "Note", "Note off", "Note release", and "Macro release".
  - _note:_ the list is sorted by type. on changing a key's type, it will instantly move to its new sorting position!
- **Value**: number of semitones above C at the current octave. only appears for note type binds.
- **Remove**: removes the keybind from the list.

below all the binds, select a key from the dropdown list to add it. it will appear at or near the top of the list as a note with value 0.
