<?php

/*
 * This file is part of the FOSUserBundle package.
 *
 * (c) FriendsOfSymfony <http://friendsofsymfony.github.com/>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace FOS\UserBundle\Security;

use Symfony\Component\Security\Core\Exception\DisabledException;
use Symfony\Component\Security\Core\User\UserCheckerInterface;
use Symfony\Component\Security\Core\User\UserInterface as BaseUserInterface;

/**
 * UserChecker checks the user account flags.
 *
 * @author Julian Finkler (Devtronic) <julian@developer-heaven.de>
 */
class UserChecker implements UserCheckerInterface
{
    /**
     * @return void
     */
    public function checkPreAuth(BaseUserInterface $user)
    {
        if (!$user->isEnabled()) {
            $ex = new DisabledException('User account is disabled.');
            $ex->setUser($user);
            throw $ex;
        }
    }

    /**
     * @return void
     */
    public function checkPostAuth(BaseUserInterface $user)
    {
    }
}
