"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getElementNames = getElementNames;
exports._getElementNames = _getElementNames;
const language_core_1 = require("@vue/language-core");
const utils_1 = require("./utils");
function getElementNames(fileName) {
    const { typescript: ts, language, languageService, getFileId } = this;
    const volarFile = language.scripts.get(getFileId(fileName));
    if (!(volarFile?.generated?.root instanceof language_core_1.VueVirtualCode)) {
        return;
    }
    const vueCode = volarFile.generated.root;
    return _getElementNames(ts, languageService, vueCode);
}
function _getElementNames(ts, tsLs, vueCode) {
    return (0, utils_1.getVariableType)(ts, tsLs, vueCode, '__VLS_elements')
        ?.type
        ?.getProperties()
        .map(c => c.name)
        ?? [];
}
//# sourceMappingURL=getElementNames.js.map