/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.WebResource;
import org.apache.catalina.connector.RequestFacade;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.IOTools;
import org.apache.catalina.util.XMLWriter;
import org.apache.tomcat.PeriodicEventListener;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.http.ConcurrentDateFormat;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.http.WebdavIfHeader;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebdavServlet
extends DefaultServlet
implements PeriodicEventListener {
    private static final long serialVersionUID = 1L;
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    private static final int MAX_DEPTH = 3;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    protected static final String SUPPORTED_LOCKS = "\n  <D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>\n  <D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>\n";
    protected static final ConcurrentDateFormat creationDateFormat = new ConcurrentDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US, TimeZone.getTimeZone("GMT"));
    protected static final String LOCK_SCHEME = "urn:uuid:";
    private final ConcurrentHashMap<String, LockInfo> resourceLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LockInfo> sharedLocks = new ConcurrentHashMap();
    private int maxDepth = 3;
    private boolean allowSpecialPaths = false;
    private boolean strictIfProcessing = true;
    private boolean serveSubpathOnly = false;
    private PropertyStore store = null;

    @Override
    public void init() throws ServletException {
        Object object;
        super.init();
        String string = this.getServletConfig().getServletName();
        ServletRegistration servletRegistration = this.getServletConfig().getServletContext().getServletRegistration(string);
        Collection collection = servletRegistration.getMappings();
        Object object2 = collection.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (((String)object).endsWith("/*")) continue;
            this.log(sm.getString("webdavservlet.nonWildcardMapping", new Object[]{object}));
        }
        if (this.getServletConfig().getInitParameter("maxDepth") != null) {
            this.maxDepth = Integer.parseInt(this.getServletConfig().getInitParameter("maxDepth"));
        }
        if (this.getServletConfig().getInitParameter("allowSpecialPaths") != null) {
            this.allowSpecialPaths = Boolean.parseBoolean(this.getServletConfig().getInitParameter("allowSpecialPaths"));
        }
        if (this.getServletConfig().getInitParameter("strictIfProcessing") != null) {
            this.strictIfProcessing = Boolean.parseBoolean(this.getServletConfig().getInitParameter("strictIfProcessing"));
        }
        if (this.getServletConfig().getInitParameter("serveSubpathOnly") != null) {
            this.serveSubpathOnly = Boolean.parseBoolean(this.getServletConfig().getInitParameter("serveSubpathOnly"));
        }
        if ((object2 = this.getServletConfig().getInitParameter("propertyStore")) != null) {
            try {
                object = Thread.currentThread().getContextClassLoader().loadClass((String)object2);
                this.store = (PropertyStore)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
                Enumeration enumeration = this.getServletConfig().getInitParameterNames();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    if (!string2.startsWith("store.")) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    String string3 = this.getServletConfig().getInitParameter(string2);
                    if (IntrospectionUtils.setProperty((Object)this.store, (String)(string2 = string2.substring("store.".length())), (String)string3, (boolean)true, (StringBuilder)stringBuilder)) continue;
                    this.log(sm.getString("webdavservlet.noStoreParameter", new Object[]{string2, string3}));
                }
            }
            catch (Exception exception) {
                this.log(sm.getString("webdavservlet.storeError"), exception);
            }
        }
        if (this.store == null) {
            this.log(sm.getString("webdavservlet.memorystore"));
            this.store = new MemoryPropertyStore();
        }
        this.store.init();
    }

    @Override
    public void destroy() {
        this.store.destroy();
    }

    public void periodicEvent() {
        for (LockInfo lockInfo : this.sharedLocks.values()) {
            if (!lockInfo.hasExpired()) continue;
            this.sharedLocks.remove(lockInfo.path);
        }
        for (LockInfo lockInfo : this.resourceLocks.values()) {
            if (lockInfo.isExclusive()) {
                if (!lockInfo.hasExpired()) continue;
                this.resourceLocks.remove(lockInfo.path);
                continue;
            }
            for (String string : lockInfo.sharedTokens) {
                if (this.sharedLocks.get(string) != null) continue;
                lockInfo.sharedTokens.remove(string);
            }
            if (!lockInfo.sharedTokens.isEmpty()) continue;
            this.resourceLocks.remove(lockInfo.path);
        }
        this.store.periodicEvent();
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(new WebdavResolver(this.getServletContext()));
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ServletException(sm.getString("webdavservlet.jaxpfailed"));
        }
        return documentBuilder;
    }

    @Override
    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        if (httpServletRequest.getDispatcherType() == DispatcherType.ERROR) {
            this.doGet(httpServletRequest, httpServletResponse);
            return;
        }
        if (this.isSpecialPath(string)) {
            httpServletResponse.sendError(404);
            return;
        }
        String string2 = httpServletRequest.getMethod();
        if (this.debug > 0) {
            this.log("[" + string2 + "] " + string);
        }
        if (string2.equals(METHOD_PROPFIND)) {
            this.doPropfind(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_PROPPATCH)) {
            this.doProppatch(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_MKCOL)) {
            this.doMkcol(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_COPY)) {
            this.doCopy(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_MOVE)) {
            this.doMove(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_LOCK)) {
            this.doLock(httpServletRequest, httpServletResponse);
        } else if (string2.equals(METHOD_UNLOCK)) {
            this.doUnlock(httpServletRequest, httpServletResponse);
        } else {
            super.service(httpServletRequest, httpServletResponse);
        }
    }

    @Override
    protected boolean checkIfHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, WebResource webResource) throws IOException {
        if (webResource != null && !super.checkIfHeaders(httpServletRequest, httpServletResponse, webResource)) {
            return false;
        }
        String string = httpServletRequest.getHeader("If");
        if (string != null) {
            WebdavIfHeader webdavIfHeader = new WebdavIfHeader(this.getUriPrefix(httpServletRequest), string);
            if (!webdavIfHeader.hasValue()) {
                return !this.strictIfProcessing;
            }
            String string2 = this.getRelativePath(httpServletRequest);
            Iterator iterator = webdavIfHeader.getResources();
            String string3 = null;
            String string4 = null;
            WebResource webResource2 = null;
            if (iterator.hasNext()) {
                string4 = (String)iterator.next();
                string3 = this.getPathFromHref(string4, httpServletRequest);
                if (string3 == null) {
                    return false;
                }
                webResource2 = this.resources.getResource(string3);
            } else {
                string3 = string2;
                string4 = this.getEncodedPath(string2, webResource, httpServletRequest);
                webResource2 = webResource;
            }
            while (true) {
                boolean bl = webResource2 != null && webResource2.exists();
                String string5 = bl ? this.generateETag(webResource2) : "";
                ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                if (!this.strictIfProcessing || bl) {
                    String string6 = string3;
                    while (true) {
                        int n;
                        LockInfo lockInfo;
                        if ((lockInfo = this.resourceLocks.get(string6)) != null) {
                            if (lockInfo.hasExpired()) {
                                this.resourceLocks.remove(string6);
                            } else if (string6 != string3 && lockInfo.depth > 0 || string6 == string3) {
                                if (lockInfo.isExclusive()) {
                                    arrayList.add((CallSite)((Object)(LOCK_SCHEME + lockInfo.token)));
                                } else {
                                    for (String string7 : lockInfo.sharedTokens) {
                                        if (this.sharedLocks.get(string7) != null) continue;
                                        lockInfo.sharedTokens.remove(string7);
                                    }
                                    if (lockInfo.sharedTokens.isEmpty()) {
                                        this.resourceLocks.remove(lockInfo.path);
                                    }
                                    for (String string7 : lockInfo.sharedTokens) {
                                        LockInfo lockInfo2 = this.sharedLocks.get(string7);
                                        if (lockInfo2 == null || (string6 == string3 || lockInfo2.depth <= 0) && string6 != string3) continue;
                                        arrayList.add((CallSite)((Object)(LOCK_SCHEME + string7)));
                                    }
                                }
                            }
                        }
                        if ((n = string6.lastIndexOf(47)) < 0) break;
                        string6 = string6.substring(0, n);
                    }
                }
                if (webdavIfHeader.matches(string4, arrayList, string5)) {
                    return true;
                }
                if (!iterator.hasNext()) break;
                string4 = (String)iterator.next();
                string3 = this.getPathFromHref(string4, httpServletRequest);
                webResource2 = this.resources.getResource(string3);
            }
            return false;
        }
        return true;
    }

    @Override
    protected String getRelativePath(HttpServletRequest httpServletRequest, boolean bl) {
        if (this.serveSubpathOnly) {
            return super.getRelativePath(httpServletRequest, bl);
        }
        String string = httpServletRequest.getAttribute("jakarta.servlet.include.request_uri") != null ? (String)httpServletRequest.getAttribute("jakarta.servlet.include.path_info") : httpServletRequest.getPathInfo();
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append('/');
        }
        String string2 = stringBuilder.toString();
        if (!bl && string2.length() > 1 && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    @Override
    protected String getPathPrefix(HttpServletRequest httpServletRequest) {
        if (this.serveSubpathOnly) {
            return super.getPathPrefix(httpServletRequest);
        }
        Object object = httpServletRequest.getContextPath();
        if (httpServletRequest.getServletPath() != null) {
            object = (String)object + httpServletRequest.getServletPath();
        }
        return object;
    }

    @Override
    protected String determineMethodsAllowed(HttpServletRequest httpServletRequest) {
        WebResource webResource = this.resources.getResource(this.getRelativePath(httpServletRequest));
        StringBuilder stringBuilder = new StringBuilder("OPTIONS, GET, POST, HEAD");
        if (!this.isReadOnly()) {
            stringBuilder.append(", DELETE");
            if (!webResource.isDirectory()) {
                stringBuilder.append(", PUT");
            }
        }
        if (httpServletRequest instanceof RequestFacade && ((RequestFacade)httpServletRequest).getAllowTrace()) {
            stringBuilder.append(", TRACE");
        }
        stringBuilder.append(", LOCK, UNLOCK, PROPPATCH, COPY, MOVE");
        if (this.isListings()) {
            stringBuilder.append(", PROPFIND");
        }
        if (!webResource.exists()) {
            stringBuilder.append(", MKCOL");
        }
        return stringBuilder.toString();
    }

    @Override
    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.addHeader("DAV", "1,2,3");
        httpServletResponse.addHeader("Allow", this.determineMethodsAllowed(httpServletRequest));
        httpServletResponse.addHeader("MS-Author-Via", "DAV");
    }

    protected void doPropfind(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String[] stringArray;
        ArrayDeque<Object> arrayDeque;
        Object object;
        Object object2;
        Object object3;
        if (!this.isListings()) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = this.maxDepth;
        PropfindType propfindType = null;
        String string2 = httpServletRequest.getHeader("Depth");
        if (string2 == null) {
            n = this.maxDepth;
        } else if (string2.equals("0")) {
            n = 0;
        } else if (string2.equals("1")) {
            n = 1;
        } else if (string2.equals("infinity")) {
            n = this.maxDepth;
        } else {
            httpServletResponse.sendError(400);
            return;
        }
        byte[] byArray = null;
        try {
            object3 = httpServletRequest.getInputStream();
            try {
                object2 = new ByteArrayOutputStream();
                try {
                    IOTools.flow((InputStream)object3, (OutputStream)object2);
                    byArray = ((ByteArrayOutputStream)object2).toByteArray();
                }
                finally {
                    ((ByteArrayOutputStream)object2).close();
                }
            }
            finally {
                if (object3 != null) {
                    ((InputStream)object3).close();
                }
            }
        }
        catch (IOException iOException) {
            httpServletResponse.sendError(400);
            return;
        }
        if (byArray.length > 0) {
            object3 = this.getDocumentBuilder();
            try {
                object2 = ((DocumentBuilder)object3).parse(new InputSource(new ByteArrayInputStream(byArray)));
                object = object2.getDocumentElement();
                if (!"propfind".equals(WebdavServlet.getDAVNode((Node)object))) {
                    httpServletResponse.sendError(400);
                    return;
                }
                arrayDeque = object.getChildNodes();
                block22: for (int i = 0; i < arrayDeque.getLength(); ++i) {
                    stringArray = arrayDeque.item(i);
                    switch (stringArray.getNodeType()) {
                        case 3: {
                            continue block22;
                        }
                        case 1: {
                            String[] stringArray2 = WebdavServlet.getDAVNode((Node)stringArray);
                            if ("prop".equals(stringArray2)) {
                                if (propfindType != null) {
                                    httpServletResponse.sendError(400);
                                    return;
                                }
                                propfindType = PropfindType.FIND_BY_PROPERTY;
                                NodeList nodeList = stringArray.getChildNodes();
                                block23: for (int j = 0; j < nodeList.getLength(); ++j) {
                                    Node object4 = nodeList.item(j);
                                    switch (object4.getNodeType()) {
                                        case 3: {
                                            continue block23;
                                        }
                                        case 1: {
                                            arrayList.add(object4);
                                        }
                                    }
                                }
                            }
                            if ("propname".equals(stringArray2)) {
                                if (propfindType != null) {
                                    httpServletResponse.sendError(400);
                                    return;
                                }
                                propfindType = PropfindType.FIND_PROPERTY_NAMES;
                            }
                            if (!"allprop".equals(stringArray2)) continue block22;
                            if (propfindType != null) {
                                httpServletResponse.sendError(400);
                                return;
                            }
                            propfindType = PropfindType.FIND_ALL_PROP;
                        }
                    }
                }
            }
            catch (IOException | SAXException exception) {
                httpServletResponse.sendError(400);
                return;
            }
            if (propfindType == null) {
                httpServletResponse.sendError(400);
                return;
            }
        } else {
            propfindType = PropfindType.FIND_ALL_PROP;
        }
        if (!this.checkIfHeaders(httpServletRequest, httpServletResponse, (WebResource)(object3 = this.resources.getResource(string)))) {
            httpServletResponse.setStatus(412);
            return;
        }
        if (!object3.exists()) {
            httpServletResponse.sendError(404);
            return;
        }
        httpServletResponse.setStatus(207);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        object2 = new XMLWriter(httpServletResponse.getWriter());
        ((XMLWriter)object2).writeXMLHeader();
        ((XMLWriter)object2).writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        if (n == 0) {
            this.propfindResource((XMLWriter)object2, this.getEncodedPath(string, (WebResource)object3, httpServletRequest), string, propfindType, arrayList, object3.isFile(), object3.getCreation(), object3.getLastModified(), object3.getContentLength(), this.getServletContext().getMimeType(object3.getName()), this.generateETag((WebResource)object3));
        } else {
            object = new ArrayDeque();
            object.addFirst(string);
            arrayDeque = new ArrayDeque();
            while (!object.isEmpty() && n >= 0) {
                String string3 = (String)object.remove();
                if (this.isSpecialPath(string3)) continue;
                object3 = this.resources.getResource(string3);
                if (object3.exists()) {
                    this.propfindResource((XMLWriter)object2, this.getEncodedPath(string3, (WebResource)object3, httpServletRequest), string3, propfindType, arrayList, object3.isFile(), object3.getCreation(), object3.getLastModified(), object3.getContentLength(), this.getServletContext().getMimeType(object3.getName()), this.generateETag((WebResource)object3));
                }
                if (object3.isDirectory() && n > 0) {
                    for (String string4 : stringArray = this.resources.list(string3)) {
                        Object object4 = string3;
                        if (!((String)object4).endsWith("/")) {
                            object4 = (String)object4 + "/";
                        }
                        object4 = (String)object4 + string4;
                        arrayDeque.addFirst(object4);
                    }
                }
                if (object.isEmpty()) {
                    --n;
                    object = arrayDeque;
                    arrayDeque = new ArrayDeque<Object>();
                }
                ((XMLWriter)object2).sendData();
            }
        }
        ((XMLWriter)object2).writeElement("D", "multistatus", 1);
        ((XMLWriter)object2).sendData();
    }

    protected void doProppatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Iterator<ProppatchOperation> iterator;
        Object object;
        String string = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string);
        if (!this.checkIfHeaders(httpServletRequest, httpServletResponse, webResource)) {
            httpServletResponse.setStatus(412);
            return;
        }
        if (!webResource.exists()) {
            httpServletResponse.sendError(404);
            return;
        }
        if (this.isReadOnly()) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(string, httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        ArrayList<ProppatchOperation> arrayList = new ArrayList<ProppatchOperation>();
        byte[] byArray = null;
        try {
            object = httpServletRequest.getInputStream();
            try {
                iterator = new ByteArrayOutputStream();
                try {
                    IOTools.flow((InputStream)object, (OutputStream)((Object)iterator));
                    byArray = ((ByteArrayOutputStream)((Object)iterator)).toByteArray();
                }
                finally {
                    ((ByteArrayOutputStream)((Object)iterator)).close();
                }
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
            }
        }
        catch (IOException iOException) {
            httpServletResponse.sendError(400);
            return;
        }
        if (byArray.length <= 0) {
            httpServletResponse.sendError(400);
            return;
        }
        try {
            object = documentBuilder.parse(new InputSource(new ByteArrayInputStream(byArray)));
            iterator = object.getDocumentElement();
            if (!"propertyupdate".equals(WebdavServlet.getDAVNode((Node)((Object)iterator)))) {
                httpServletResponse.sendError(400);
                return;
            }
            NodeList object2 = iterator.getChildNodes();
            block34: for (int i = 0; i < object2.getLength(); ++i) {
                Node node = object2.item(i);
                switch (node.getNodeType()) {
                    case 3: {
                        continue block34;
                    }
                    case 1: {
                        Node node2;
                        int n;
                        Node node3;
                        NodeList nodeList;
                        Node node4;
                        int n2;
                        NodeList nodeList2;
                        String string2 = WebdavServlet.getDAVNode(node);
                        if ("set".equals(string2)) {
                            nodeList2 = node.getChildNodes();
                            block35: for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
                                node4 = nodeList2.item(n2);
                                switch (node4.getNodeType()) {
                                    case 3: {
                                        continue block35;
                                    }
                                    case 1: {
                                        if (!"prop".equals(WebdavServlet.getDAVNode(node4))) continue block35;
                                        nodeList = node4.getChildNodes();
                                        node3 = null;
                                        block36: for (n = 0; n < nodeList.getLength(); ++n) {
                                            node2 = nodeList.item(n);
                                            switch (node2.getNodeType()) {
                                                case 3: {
                                                    continue block36;
                                                }
                                                case 1: {
                                                    node3 = node2;
                                                }
                                            }
                                        }
                                        if (node3 != null) {
                                            arrayList.add(new ProppatchOperation(PropertyUpdateType.SET, node3));
                                            continue block35;
                                        }
                                        httpServletResponse.sendError(400);
                                        return;
                                    }
                                }
                            }
                        }
                        if (!"remove".equals(string2)) continue block34;
                        nodeList2 = node.getChildNodes();
                        block37: for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
                            node4 = nodeList2.item(n2);
                            switch (node4.getNodeType()) {
                                case 3: {
                                    continue block37;
                                }
                                case 1: {
                                    if (!"prop".equals(WebdavServlet.getDAVNode(node4))) continue block37;
                                    nodeList = node4.getChildNodes();
                                    node3 = null;
                                    block38: for (n = 0; n < nodeList.getLength(); ++n) {
                                        node2 = nodeList.item(n);
                                        switch (node2.getNodeType()) {
                                            case 3: {
                                                continue block38;
                                            }
                                            case 1: {
                                                node3 = node2;
                                            }
                                        }
                                    }
                                    if (node3 != null) {
                                        arrayList.add(new ProppatchOperation(PropertyUpdateType.REMOVE, node3));
                                        continue block37;
                                    }
                                    httpServletResponse.sendError(400);
                                    return;
                                }
                            }
                        }
                        continue block34;
                    }
                }
            }
        }
        catch (IOException | SAXException exception) {
            httpServletResponse.sendError(400);
            return;
        }
        this.store.proppatch(string, arrayList);
        httpServletResponse.setStatus(207);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        object = new XMLWriter(httpServletResponse.getWriter());
        ((XMLWriter)object).writeXMLHeader();
        ((XMLWriter)object).writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        ((XMLWriter)object).writeElement("D", "response", 0);
        ((XMLWriter)object).writeElement("D", "href", 0);
        ((XMLWriter)object).writeText(this.getEncodedPath(string, webResource, httpServletRequest));
        ((XMLWriter)object).writeElement("D", "href", 1);
        for (ProppatchOperation proppatchOperation : arrayList) {
            ((XMLWriter)object).writeElement("D", "propstat", 0);
            ((XMLWriter)object).writeElement("D", "prop", 0);
            ((XMLWriter)object).writeElement(proppatchOperation.propertyNode.getPrefix(), proppatchOperation.propertyNode.getNamespaceURI(), proppatchOperation.propertyNode.getLocalName(), 2);
            ((XMLWriter)object).writeElement("D", "prop", 1);
            ((XMLWriter)object).writeElement("D", "status", 0);
            ((XMLWriter)object).writeText("HTTP/1.1 " + String.valueOf(proppatchOperation.getStatusCode()) + " ");
            ((XMLWriter)object).writeElement("D", "status", 1);
            if (proppatchOperation.getProtectedProperty() && proppatchOperation.getStatusCode() == 403) {
                ((XMLWriter)object).writeElement("D", "error", 0);
                ((XMLWriter)object).writeElement("D", "cannot-modify-protected-property", 2);
                ((XMLWriter)object).writeElement("D", "error", 1);
            }
            ((XMLWriter)object).writeElement("D", "propstat", 1);
        }
        ((XMLWriter)object).writeElement("D", "response", 1);
        ((XMLWriter)object).writeElement("D", "multistatus", 1);
        ((XMLWriter)object).sendData();
    }

    protected void doMkcol(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string);
        if (!this.checkIfHeaders(httpServletRequest, httpServletResponse, webResource)) {
            httpServletResponse.setStatus(412);
            return;
        }
        if (webResource.exists()) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        if (this.isReadOnly()) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(string, httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        if (httpServletRequest.getContentLengthLong() > 0L || "chunked".equalsIgnoreCase(httpServletRequest.getHeader("Transfer-Encoding"))) {
            httpServletResponse.sendError(415);
            return;
        }
        if (this.resources.mkdir(string)) {
            httpServletResponse.setStatus(201);
        } else {
            httpServletResponse.sendError(409);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.isReadOnly()) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        this.deleteResource(string, httpServletRequest, httpServletResponse);
    }

    @Override
    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string);
        if (!this.checkIfHeaders(httpServletRequest, httpServletResponse, webResource)) {
            httpServletResponse.setStatus(412);
            return;
        }
        if (this.isLocked(string, httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        if (webResource.isDirectory()) {
            this.sendNotAllowed(httpServletRequest, httpServletResponse);
            return;
        }
        super.doPut(httpServletRequest, httpServletResponse);
    }

    protected void doCopy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.isReadOnly()) {
            httpServletResponse.sendError(403);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        this.copyResource(string, httpServletRequest, httpServletResponse);
    }

    protected void doMove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.isReadOnly()) {
            httpServletResponse.sendError(403);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        if (this.isLocked(string, httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        if (this.copyResource(string, httpServletRequest, httpServletResponse)) {
            this.deleteResource(string, httpServletRequest, httpServletResponse, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doLock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object3;
        Object object4;
        Object object5;
        if (this.isReadOnly()) {
            httpServletResponse.sendError(403);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string);
        if (!this.checkIfHeaders(httpServletRequest, httpServletResponse, webResource)) {
            httpServletResponse.setStatus(412);
            return;
        }
        Object object6 = new LockInfo(this.maxDepth);
        ((LockInfo)object6).principal = httpServletRequest.getRemoteUser();
        String string2 = httpServletRequest.getHeader("Depth");
        if (string2 == null) {
            ((LockInfo)object6).depth = this.maxDepth;
        } else if (string2.equals("0")) {
            ((LockInfo)object6).depth = 0;
        } else if (string2.equals("infinity")) {
            ((LockInfo)object6).depth = this.maxDepth;
        } else {
            httpServletResponse.sendError(400);
            return;
        }
        int n = 3600;
        String string3 = httpServletRequest.getHeader("Timeout");
        if (string3 != null) {
            if (string3.startsWith("Second-")) {
                try {
                    n = Integer.parseInt(string3.substring("Second-".length()));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (string3.equals("Infinite")) {
                n = 604800;
            }
            if (n == 0) {
                n = 3600;
            }
            if (n > 604800) {
                n = 604800;
            }
        }
        ((LockInfo)object6).expiresAt = System.currentTimeMillis() + (long)(n * 1000);
        boolean bl = false;
        Node node = null;
        byte[] byArray = null;
        try {
            object5 = httpServletRequest.getInputStream();
            try {
                object4 = new ByteArrayOutputStream();
                try {
                    IOTools.flow((InputStream)object5, (OutputStream)object4);
                    byArray = ((ByteArrayOutputStream)object4).toByteArray();
                }
                finally {
                    ((ByteArrayOutputStream)object4).close();
                }
            }
            finally {
                if (object5 != null) {
                    ((InputStream)object5).close();
                }
            }
        }
        catch (IOException iOException) {
            httpServletResponse.sendError(400);
            return;
        }
        if (byArray.length > 0) {
            object5 = this.getDocumentBuilder();
            try {
                object4 = ((DocumentBuilder)object5).parse(new InputSource(new ByteArrayInputStream(byArray)));
                object3 = object4.getDocumentElement();
                if (!"lockinfo".equals(WebdavServlet.getDAVNode((Node)object3))) {
                    httpServletResponse.sendError(400);
                    return;
                }
                node = object3;
                bl = true;
            }
            catch (IOException | SAXException exception) {
                httpServletResponse.sendError(400);
                return;
            }
        }
        if (node != null) {
            void var17_37;
            void var15_26;
            Node node2;
            int n2;
            object5 = node.getChildNodes();
            object4 = null;
            object3 = null;
            Object object22 = null;
            object = null;
            Object var17_36 = null;
            block32: for (n2 = 0; n2 < object5.getLength(); ++n2) {
                node2 = object5.item(n2);
                switch (node2.getNodeType()) {
                    case 3: {
                        continue block32;
                    }
                    case 1: {
                        if ("lockscope".equals(WebdavServlet.getDAVNode(node2))) {
                            Node node3 = node2;
                        }
                        if ("locktype".equals(WebdavServlet.getDAVNode(node2))) {
                            object = node2;
                        }
                        if (!"owner".equals(WebdavServlet.getDAVNode(node2))) continue block32;
                        Node node4 = node2;
                    }
                }
            }
            if (var15_26 != null) {
                object5 = var15_26.getChildNodes();
                block33: for (n2 = 0; n2 < object5.getLength(); ++n2) {
                    node2 = object5.item(n2);
                    switch (node2.getNodeType()) {
                        case 3: {
                            continue block33;
                        }
                        case 1: {
                            ((LockInfo)object6).scope = WebdavServlet.getDAVNode(node2);
                        }
                    }
                }
                if (((LockInfo)object6).scope == null) {
                    httpServletResponse.sendError(400);
                    return;
                }
            } else {
                httpServletResponse.sendError(400);
                return;
            }
            if (object != null) {
                object5 = object.getChildNodes();
                block34: for (n2 = 0; n2 < object5.getLength(); ++n2) {
                    node2 = object5.item(n2);
                    switch (node2.getNodeType()) {
                        case 3: {
                            continue block34;
                        }
                        case 1: {
                            ((LockInfo)object6).type = WebdavServlet.getDAVNode(node2);
                        }
                    }
                }
                if (((LockInfo)object6).type == null) {
                    httpServletResponse.sendError(400);
                    return;
                }
            } else {
                httpServletResponse.sendError(400);
                return;
            }
            if (var17_37 != null) {
                object5 = var17_37.getChildNodes();
                block35: for (n2 = 0; n2 < object5.getLength(); ++n2) {
                    node2 = object5.item(n2);
                    switch (node2.getNodeType()) {
                        case 3: {
                            ((LockInfo)object6).owner = ((LockInfo)object6).owner + node2.getNodeValue();
                            continue block35;
                        }
                        case 1: {
                            object4 = new StringWriter();
                            object3 = new DOMWriter((Writer)object4);
                            ((DOMWriter)object3).print(node2);
                            ((LockInfo)object6).owner = ((LockInfo)object6).owner + ((StringWriter)object4).toString();
                        }
                    }
                }
                if (((LockInfo)object6).owner == null) {
                    httpServletResponse.sendError(400);
                    return;
                }
            } else {
                ((LockInfo)object6).owner = "";
            }
        }
        ((LockInfo)object6).path = string;
        if (bl) {
            object5 = string;
            while (true) {
                int n3;
                if ((object4 = this.resourceLocks.get(object5)) != null) {
                    if (((LockInfo)object4).hasExpired()) {
                        this.resourceLocks.remove(object5);
                    } else if (((LockInfo)object4).isExclusive() || ((LockInfo)object6).isExclusive()) {
                        httpServletResponse.setStatus(423);
                        return;
                    }
                }
                if ((n3 = ((String)object5).lastIndexOf(47)) < 0) break;
                object5 = ((String)object5).substring(0, n3);
            }
            ((LockInfo)object6).token = UUID.randomUUID().toString();
            if (webResource.isDirectory() && ((LockInfo)object6).depth == this.maxDepth) {
                object4 = new ArrayList();
                for (LockInfo lockInfo : this.resourceLocks.values()) {
                    if (lockInfo.hasExpired()) {
                        this.resourceLocks.remove(lockInfo.path);
                        continue;
                    }
                    if (!lockInfo.isExclusive() && !((LockInfo)object6).isExclusive() || !lockInfo.path.startsWith(((LockInfo)object6).path + "/")) continue;
                    object4.add(lockInfo.lockroot);
                }
                if (!object4.isEmpty()) {
                    httpServletResponse.setStatus(207);
                    XMLWriter xMLWriter = new XMLWriter();
                    xMLWriter.writeXMLHeader();
                    xMLWriter.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
                    xMLWriter.writeElement("D", "response", 0);
                    xMLWriter.writeElement("D", "href", 0);
                    xMLWriter.writeText(this.getEncodedPath(string, webResource, httpServletRequest));
                    xMLWriter.writeElement("D", "href", 1);
                    xMLWriter.writeElement("D", "status", 0);
                    xMLWriter.writeText("HTTP/1.1 424 ");
                    xMLWriter.writeElement("D", "status", 1);
                    xMLWriter.writeElement("D", "response", 1);
                    Iterator iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        object = (String)iterator.next();
                        xMLWriter.writeElement("D", "response", 0);
                        xMLWriter.writeElement("D", "href", 0);
                        xMLWriter.writeText((String)object);
                        xMLWriter.writeElement("D", "href", 1);
                        xMLWriter.writeElement("D", "status", 0);
                        xMLWriter.writeText("HTTP/1.1 423 ");
                        xMLWriter.writeElement("D", "status", 1);
                        xMLWriter.writeElement("D", "response", 1);
                    }
                    xMLWriter.writeElement("D", "multistatus", 1);
                    PrintWriter printWriter = httpServletResponse.getWriter();
                    ((Writer)printWriter).write(xMLWriter.toString());
                    ((Writer)printWriter).close();
                    return;
                }
            } else if (!webResource.exists()) {
                if (!this.resources.write(string, new ByteArrayInputStream(new byte[0]), false)) {
                    httpServletResponse.sendError(409);
                    return;
                }
                httpServletResponse.setStatus(201);
            }
            ((LockInfo)object6).lockroot = this.getEncodedPath(((LockInfo)object6).path, webResource, httpServletRequest);
            if (((LockInfo)object6).isExclusive()) {
                this.resourceLocks.put(string, (LockInfo)object6);
            } else {
                object4 = this.resourceLocks.get(string);
                if (object4 == null) {
                    object4 = new LockInfo(this.maxDepth);
                    ((LockInfo)object4).scope = "shared";
                    ((LockInfo)object4).path = string;
                    ((LockInfo)object4).lockroot = ((LockInfo)object6).lockroot;
                    ((LockInfo)object4).depth = this.maxDepth;
                    this.resourceLocks.put(string, (LockInfo)object4);
                }
                ((LockInfo)object4).sharedTokens.add(((LockInfo)object6).token);
                this.sharedLocks.put(((LockInfo)object6).token, (LockInfo)object6);
            }
            httpServletResponse.addHeader("Lock-Token", "<urn:uuid:" + ((LockInfo)object6).token + ">");
        }
        if (!bl) {
            object5 = httpServletRequest.getHeader("If");
            if (object5 == null) {
                httpServletResponse.sendError(400);
                return;
            }
            object4 = null;
            String string4 = string;
            while (true) {
                int n3;
                LockInfo lockInfo;
                if ((lockInfo = this.resourceLocks.get(string4)) != null) {
                    if (lockInfo.hasExpired()) {
                        this.resourceLocks.remove(string4);
                    } else if (string4 != string && lockInfo.depth > 0 || string4 == string) {
                        if (lockInfo.isExclusive()) {
                            if (((String)object5).contains(":" + lockInfo.token + ">") && (lockInfo.principal == null || lockInfo.principal.equals(httpServletRequest.getRemoteUser()))) {
                                object4 = lockInfo;
                                break;
                            }
                        } else {
                            for (String string5 : lockInfo.sharedTokens) {
                                LockInfo lockInfo2;
                                if (!((String)object5).contains(":" + string5 + ">") || (lockInfo2 = this.sharedLocks.get(string5)) == null || lockInfo2.principal != null && !lockInfo2.principal.equals(httpServletRequest.getRemoteUser()) || (string4 == string || lockInfo2.depth <= 0) && string4 != string) continue;
                                object4 = lockInfo2;
                                break;
                            }
                        }
                    }
                }
                if ((n3 = string4.lastIndexOf(47)) < 0) break;
                string4 = string4.substring(0, n3);
            }
            if (object4 != null) {
                if (!((LockInfo)object4).hasExpired()) {
                    ((LockInfo)object4).expiresAt = ((LockInfo)object6).expiresAt;
                } else {
                    object4 = null;
                }
            }
            object6 = object4;
        }
        object5 = new XMLWriter();
        ((XMLWriter)object5).writeXMLHeader();
        ((XMLWriter)object5).writeElement("D", DEFAULT_NAMESPACE, "prop", 0);
        ((XMLWriter)object5).writeElement("D", "lockdiscovery", 0);
        if (object6 != null) {
            ((LockInfo)object6).toXML((XMLWriter)object5);
        }
        ((XMLWriter)object5).writeElement("D", "lockdiscovery", 1);
        ((XMLWriter)object5).writeElement("D", "prop", 1);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        object4 = httpServletResponse.getWriter();
        ((Writer)object4).write(((XMLWriter)object5).toString());
        ((Writer)object4).close();
    }

    protected void doUnlock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (this.isReadOnly()) {
            httpServletResponse.sendError(403);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        WebResource webResource = this.resources.getResource(string);
        if (!this.checkIfHeaders(httpServletRequest, httpServletResponse, webResource)) {
            httpServletResponse.setStatus(412);
            return;
        }
        String string2 = httpServletRequest.getHeader("Lock-Token");
        if (string2 == null) {
            httpServletResponse.sendError(400);
            return;
        }
        boolean bl = false;
        String string3 = string;
        while (true) {
            int n;
            LockInfo lockInfo;
            if ((lockInfo = this.resourceLocks.get(string3)) != null) {
                if (lockInfo.hasExpired()) {
                    this.resourceLocks.remove(string3);
                } else if (string3 != string && lockInfo.depth > 0 || string3 == string) {
                    if (lockInfo.isExclusive()) {
                        if (string2.contains(":" + lockInfo.token + ">") && (lockInfo.principal == null || lockInfo.principal.equals(httpServletRequest.getRemoteUser()))) {
                            this.resourceLocks.remove(string3);
                            bl = true;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    for (String string4 : lockInfo.sharedTokens) {
                        if (!string2.contains(":" + string4 + ">")) continue;
                        LockInfo lockInfo2 = this.sharedLocks.get(string4);
                        if (lockInfo2 == null) {
                            lockInfo.sharedTokens.remove(string4);
                            break;
                        }
                        if (lockInfo2.principal != null && !lockInfo2.principal.equals(httpServletRequest.getRemoteUser()) || (string3 == string || lockInfo2.depth <= 0) && string3 != string) break;
                        lockInfo.sharedTokens.remove(string4);
                        this.sharedLocks.remove(string4);
                        bl = true;
                        break;
                    }
                    if (lockInfo.sharedTokens.isEmpty()) {
                        this.resourceLocks.remove(string3);
                    }
                }
            }
            if ((n = string3.lastIndexOf(47)) < 0) break;
            string3 = string3.substring(0, n);
        }
        if (bl) {
            httpServletResponse.setStatus(204);
        } else {
            this.sendReport(httpServletRequest, httpServletResponse, string3, 409, "lock-token-matches-request-uri");
        }
    }

    private boolean isSpecialPath(String string) {
        String string2;
        return !this.allowSpecialPaths && ((string2 = string.toUpperCase(Locale.ENGLISH)).startsWith("/WEB-INF/") || string2.startsWith("/META-INF/") || string2.equals("/WEB-INF") || string2.equals("/META-INF"));
    }

    private String getEncodedPath(String string, WebResource webResource, HttpServletRequest httpServletRequest) {
        Object object = this.getPathPrefix(httpServletRequest);
        object = ((String)object).endsWith("/") && string.startsWith("/") ? (String)object + string.substring(1) : (String)object + string;
        if (webResource != null && webResource.isDirectory() && !((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        return this.rewriteUrl((String)object);
    }

    private String getUriPrefix(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getScheme() + "://" + httpServletRequest.getServerName();
    }

    private String getPathFromHref(String string, HttpServletRequest httpServletRequest) {
        String string2;
        URI uRI;
        if (string == null || string.isEmpty()) {
            return null;
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        String string3 = uRI.getPath();
        if (!string3.equals(RequestUtil.normalize((String)string3))) {
            return null;
        }
        if (uRI.isAbsolute() && !httpServletRequest.getServerName().equals(uRI.getHost())) {
            return null;
        }
        if (string3.length() > 1 && string3.endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (!string3.startsWith((string2 = this.getPathPrefix(httpServletRequest)) + "/")) {
            return null;
        }
        string3 = string3.substring(string2.length());
        if (this.debug > 0) {
            this.log(string + " Href path: " + string3);
        }
        if (this.isSpecialPath(string3)) {
            return null;
        }
        return string3;
    }

    private boolean isLocked(String string, HttpServletRequest httpServletRequest) {
        String string2;
        if (string == null) {
            string = this.getRelativePath(httpServletRequest);
        }
        if ((string2 = httpServletRequest.getHeader("If")) == null) {
            string2 = "";
        }
        return this.isLocked(string, httpServletRequest.getRemoteUser(), string2);
    }

    private boolean isLocked(String string, String string2, String string3) {
        boolean bl = false;
        String string4 = string;
        while (true) {
            int n;
            LockInfo lockInfo;
            if ((lockInfo = this.resourceLocks.get(string4)) != null) {
                if (lockInfo.hasExpired()) {
                    this.resourceLocks.remove(string4);
                } else if (string4 != string && lockInfo.depth > 0 || string4 == string) {
                    if (lockInfo.isExclusive()) {
                        return !string3.contains(":" + lockInfo.token + ">") || lockInfo.principal != null && !lockInfo.principal.equals(string2);
                    }
                    for (String string5 : lockInfo.sharedTokens) {
                        LockInfo lockInfo2 = this.sharedLocks.get(string5);
                        if (lockInfo2 == null || (string4 == string || lockInfo2.depth <= 0) && string4 != string) continue;
                        if (string3.contains(":" + string5 + ">") && (lockInfo2.principal == null || lockInfo2.principal.equals(string2))) {
                            return false;
                        }
                        bl = true;
                    }
                }
            }
            if ((n = string4.lastIndexOf(47)) < 0) break;
            string4 = string4.substring(0, n);
        }
        return bl;
    }

    private boolean copyResource(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        boolean bl;
        URI uRI;
        WebResource webResource = this.resources.getResource(string);
        if (!webResource.exists()) {
            httpServletResponse.sendError(404);
            return false;
        }
        if (!this.checkIfHeaders(httpServletRequest, httpServletResponse, webResource)) {
            httpServletResponse.setStatus(412);
            return false;
        }
        String string2 = httpServletRequest.getHeader("Destination");
        if (string2 == null || string2.isEmpty()) {
            httpServletResponse.sendError(400);
            return false;
        }
        try {
            uRI = new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            httpServletResponse.sendError(400);
            return false;
        }
        String string3 = uRI.getPath();
        if (!string3.equals(RequestUtil.normalize((String)string3))) {
            httpServletResponse.sendError(400);
            return false;
        }
        if (uRI.isAbsolute()) {
            if (!httpServletRequest.getScheme().equals(uRI.getScheme()) || !httpServletRequest.getServerName().equals(uRI.getHost())) {
                httpServletResponse.sendError(403);
                return false;
            }
            if (!(httpServletRequest.getServerPort() == uRI.getPort() || uRI.getPort() == -1 && ("http".equals(httpServletRequest.getScheme()) && httpServletRequest.getServerPort() == 80 || "https".equals(httpServletRequest.getScheme()) && httpServletRequest.getServerPort() == 443))) {
                httpServletResponse.sendError(403);
                return false;
            }
        }
        if (string3.length() > 1 && string3.endsWith("/")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        String string4 = this.getPathPrefix(httpServletRequest);
        Object object = string4;
        if (this.serveSubpathOnly && httpServletRequest.getServletPath() != null) {
            object = (String)object + httpServletRequest.getServletPath();
        }
        if (!string3.startsWith((String)object + "/")) {
            httpServletResponse.sendError(403);
            return false;
        }
        string3 = string3.substring(string4.length());
        if (this.debug > 0) {
            this.log("Dest path: " + string3);
        }
        if (this.isSpecialPath(string3)) {
            httpServletResponse.sendError(403);
            return false;
        }
        if (string3.equals(string)) {
            httpServletResponse.sendError(403);
            return false;
        }
        if (string3.startsWith(string) && string3.charAt(string.length()) == '/' || string.startsWith(string3) && string.charAt(string3.length()) == '/') {
            httpServletResponse.sendError(403);
            return false;
        }
        if (this.isLocked(string3, httpServletRequest)) {
            httpServletResponse.sendError(423);
            return false;
        }
        boolean bl2 = true;
        String string5 = httpServletRequest.getHeader("Overwrite");
        if (string5 != null) {
            bl2 = string5.equalsIgnoreCase("T");
        }
        WebResource webResource2 = this.resources.getResource(string3);
        if (bl2) {
            if (webResource2.exists()) {
                if (!this.deleteResource(string3, httpServletRequest, httpServletResponse, true)) {
                    return false;
                }
            } else {
                httpServletResponse.setStatus(201);
            }
        } else if (webResource2.exists()) {
            httpServletResponse.sendError(412);
            return false;
        }
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        boolean bl3 = true;
        String string6 = httpServletRequest.getHeader("Depth");
        if (string6 != null && !string6.equals("infinity")) {
            if (string6.equals("0")) {
                bl3 = false;
            } else {
                httpServletResponse.sendError(400);
                return false;
            }
        }
        if (!(bl = this.copyResource(linkedHashMap, string, string3, bl3)) || !linkedHashMap.isEmpty()) {
            if (linkedHashMap.size() == 1) {
                httpServletResponse.sendError(((Integer)linkedHashMap.values().iterator().next()).intValue());
            } else {
                this.sendReport(httpServletRequest, httpServletResponse, linkedHashMap);
            }
            return false;
        }
        if (webResource2.exists()) {
            httpServletResponse.setStatus(204);
        } else {
            httpServletResponse.setStatus(201);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyResource(Map<String, Integer> map, String string, String string2, boolean bl) {
        String string4;
        WebResource webResource2;
        int n;
        WebResource webResource;
        if (this.debug > 1) {
            this.log("Copy: " + string + " To: " + string2 + " Infinite: " + bl);
        }
        if ((webResource = this.resources.getResource(string)).isDirectory()) {
            String[] stringArray;
            if (!this.resources.mkdir(string2)) {
                stringArray = this.resources.getResource(string2);
                if (!stringArray.isDirectory()) {
                    map.put(string2, 409);
                    return false;
                }
            } else {
                this.store.copy(string, string2);
            }
            if (!bl) return true;
            String[] stringArray2 = stringArray = this.resources.list(string);
            int n2 = stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                Object object = string2;
                if (!((String)object).equals("/")) {
                    object = (String)object + "/";
                }
                object = (String)object + string3;
                Object object2 = string;
                if (!((String)object2).equals("/")) {
                    object2 = (String)object2 + "/";
                }
                object2 = (String)object2 + string3;
                this.copyResource(map, (String)object2, (String)object, true);
                ++n3;
            }
            return true;
        }
        if (!webResource.isFile()) {
            map.put(string, 500);
            return false;
        }
        WebResource webResource3 = this.resources.getResource(string2);
        if (!(webResource3.exists() || webResource3.getWebappPath().endsWith("/") || (n = webResource3.getWebappPath().lastIndexOf(47)) <= 0 || (webResource2 = this.resources.getResource(string4 = webResource3.getWebappPath().substring(0, n))).isDirectory())) {
            map.put(string, 409);
            return false;
        }
        if (!webResource3.exists() && string2.endsWith("/") && string2.length() > 1) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        try (InputStream inputStream = webResource.getInputStream();){
            if (!this.resources.write(string2, inputStream, false)) {
                map.put(string, 500);
                boolean bl2 = false;
                return bl2;
            }
            this.store.copy(string, string2);
            return true;
        }
        catch (IOException iOException) {
            this.log(sm.getString("webdavservlet.inputstreamclosefail", new Object[]{string}), iOException);
            return true;
        }
    }

    private boolean deleteResource(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        WebResource webResource = this.resources.getResource(string);
        if (!this.checkIfHeaders(httpServletRequest, httpServletResponse, webResource)) {
            httpServletResponse.setStatus(412);
            return false;
        }
        return this.deleteResource(string, httpServletRequest, httpServletResponse, true);
    }

    private boolean deleteResource(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean bl) throws IOException {
        if (this.isLocked(string, httpServletRequest)) {
            httpServletResponse.sendError(423);
            return false;
        }
        WebResource webResource = this.resources.getResource(string);
        if (!webResource.exists()) {
            httpServletResponse.sendError(404);
            return false;
        }
        if (!webResource.isDirectory()) {
            if (!webResource.delete()) {
                this.sendNotAllowed(httpServletRequest, httpServletResponse);
                return false;
            }
            this.deletedResource(string);
        } else {
            LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
            this.deleteCollection(httpServletRequest, string, linkedHashMap);
            if (!webResource.delete()) {
                if (this.resources.list(string).length == 0) {
                    linkedHashMap.put(string, 405);
                }
            } else {
                this.deletedResource(string);
            }
            if (!linkedHashMap.isEmpty()) {
                this.sendReport(httpServletRequest, httpServletResponse, linkedHashMap);
                return false;
            }
        }
        if (bl) {
            httpServletResponse.setStatus(204);
        }
        return true;
    }

    private void deleteCollection(HttpServletRequest httpServletRequest, String string, Map<String, Integer> map) {
        String[] stringArray;
        if (this.debug > 1) {
            this.log("Delete collection: " + string);
        }
        if (this.isSpecialPath(string)) {
            map.put(string, 403);
            return;
        }
        String string2 = httpServletRequest.getHeader("If");
        if (string2 == null) {
            string2 = "";
        }
        for (String string3 : stringArray = this.resources.list(string)) {
            Object object = string;
            if (!((String)object).equals("/")) {
                object = (String)object + "/";
            }
            if (this.isLocked((String)(object = (String)object + string3), httpServletRequest.getRemoteUser(), string2)) {
                map.put((String)object, 423);
                continue;
            }
            WebResource webResource = this.resources.getResource((String)object);
            if (webResource.isDirectory()) {
                this.deleteCollection(httpServletRequest, (String)object, map);
            }
            if (!webResource.delete()) {
                if (webResource.isDirectory() && this.resources.list((String)object).length != 0) continue;
                map.put((String)object, 405);
                continue;
            }
            this.deletedResource((String)object);
        }
    }

    private void deletedResource(String string) {
        LockInfo lockInfo = this.resourceLocks.remove(string);
        if (lockInfo != null && !lockInfo.isExclusive()) {
            for (String string2 : lockInfo.sharedTokens) {
                this.sharedLocks.remove(string2);
            }
        }
        this.store.delete(string);
    }

    private void sendReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map<String, Integer> map) throws IOException {
        httpServletResponse.setStatus(207);
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.writeXMLHeader();
        xMLWriter.writeElement("D", DEFAULT_NAMESPACE, "multistatus", 0);
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String string = entry.getKey();
            int n = entry.getValue();
            xMLWriter.writeElement("D", "response", 0);
            xMLWriter.writeElement("D", "href", 0);
            xMLWriter.writeText(this.getEncodedPath(string, null, httpServletRequest));
            xMLWriter.writeElement("D", "href", 1);
            xMLWriter.writeElement("D", "status", 0);
            xMLWriter.writeText("HTTP/1.1 " + n + " ");
            xMLWriter.writeElement("D", "status", 1);
            xMLWriter.writeElement("D", "response", 1);
        }
        xMLWriter.writeElement("D", "multistatus", 1);
        PrintWriter printWriter = httpServletResponse.getWriter();
        ((Writer)printWriter).write(xMLWriter.toString());
        ((Writer)printWriter).close();
    }

    private void sendReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, int n, String string2) throws IOException {
        httpServletResponse.setStatus(n);
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.writeXMLHeader();
        xMLWriter.writeElement("D", DEFAULT_NAMESPACE, "error", 0);
        if (string != null && string.length() > 0) {
            xMLWriter.writeElement("D", string2, 0);
            xMLWriter.writeElement("D", "href", 0);
            xMLWriter.writeText(this.getEncodedPath(string, null, httpServletRequest));
            xMLWriter.writeElement("D", "href", 1);
            xMLWriter.writeElement("D", string2, 1);
        } else {
            xMLWriter.writeElement("D", string2, 2);
        }
        xMLWriter.writeElement("D", "error", 1);
        PrintWriter printWriter = httpServletResponse.getWriter();
        ((Writer)printWriter).write(xMLWriter.toString());
        ((Writer)printWriter).close();
    }

    private void propfindResource(XMLWriter xMLWriter, String string, String string2, PropfindType propfindType, List<Node> list, boolean bl, long l, long l2, long l3, String string3, String string4) {
        xMLWriter.writeElement("D", "response", 0);
        String string5 = "HTTP/1.1 200 ";
        xMLWriter.writeElement("D", "href", 0);
        xMLWriter.writeText(string);
        xMLWriter.writeElement("D", "href", 1);
        String string6 = string2;
        int n = string2.lastIndexOf(47);
        if (n != -1) {
            string6 = string6.substring(n + 1);
        }
        switch (propfindType) {
            case FIND_ALL_PROP: {
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                xMLWriter.writeProperty("D", "creationdate", WebdavServlet.getISOCreationDate(l));
                xMLWriter.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)l2));
                if (bl) {
                    xMLWriter.writeProperty("D", "getcontentlength", Long.toString(l3));
                    if (string3 != null) {
                        xMLWriter.writeProperty("D", "getcontenttype", string3);
                    }
                    xMLWriter.writeProperty("D", "getetag", string4);
                    xMLWriter.writeElement("D", "resourcetype", 2);
                } else {
                    xMLWriter.writeElement("D", "resourcetype", 0);
                    xMLWriter.writeElement("D", "collection", 2);
                    xMLWriter.writeElement("D", "resourcetype", 1);
                }
                this.store.propfind(string2, null, false, xMLWriter);
                xMLWriter.writeElement("D", "supportedlock", 0);
                xMLWriter.writeRaw(SUPPORTED_LOCKS);
                xMLWriter.writeElement("D", "supportedlock", 1);
                this.generateLockDiscovery(string2, xMLWriter);
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
                break;
            }
            case FIND_PROPERTY_NAMES: {
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                xMLWriter.writeElement("D", "creationdate", 2);
                if (bl) {
                    xMLWriter.writeElement("D", "getcontentlength", 2);
                    if (string3 != null) {
                        xMLWriter.writeElement("D", "getcontenttype", 2);
                    }
                    xMLWriter.writeElement("D", "getetag", 2);
                }
                xMLWriter.writeElement("D", "getlastmodified", 2);
                xMLWriter.writeElement("D", "resourcetype", 2);
                xMLWriter.writeElement("D", "lockdiscovery", 2);
                xMLWriter.writeElement("D", "supportedlock", 2);
                this.store.propfind(string2, null, true, xMLWriter);
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
                break;
            }
            case FIND_BY_PROPERTY: {
                String string7;
                ArrayList<Node> arrayList = new ArrayList<Node>();
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                for (Node node : list) {
                    boolean bl2;
                    string7 = WebdavServlet.getDAVNode(node);
                    boolean bl3 = bl2 = string7 != null && !string7.equals("displayname") && !string7.equals("getcontentlanguage");
                    if (string7 == null || !bl2) {
                        if (this.store.propfind(string2, node, false, xMLWriter)) continue;
                        arrayList.add(node);
                        continue;
                    }
                    if (string7.equals("creationdate")) {
                        xMLWriter.writeProperty("D", "creationdate", WebdavServlet.getISOCreationDate(l));
                        continue;
                    }
                    if (string7.equals("getcontentlength")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getcontentlength", Long.toString(l3));
                            continue;
                        }
                        arrayList.add(node);
                        continue;
                    }
                    if (string7.equals("getcontenttype")) {
                        if (bl && string3 != null) {
                            xMLWriter.writeProperty("D", "getcontenttype", string3);
                            continue;
                        }
                        arrayList.add(node);
                        continue;
                    }
                    if (string7.equals("getetag")) {
                        if (bl) {
                            xMLWriter.writeProperty("D", "getetag", string4);
                            continue;
                        }
                        arrayList.add(node);
                        continue;
                    }
                    if (string7.equals("getlastmodified")) {
                        xMLWriter.writeProperty("D", "getlastmodified", FastHttpDateFormat.formatDate((long)l2));
                        continue;
                    }
                    if (string7.equals("resourcetype")) {
                        if (bl) {
                            xMLWriter.writeElement("D", "resourcetype", 2);
                            continue;
                        }
                        xMLWriter.writeElement("D", "resourcetype", 0);
                        xMLWriter.writeElement("D", "collection", 2);
                        xMLWriter.writeElement("D", "resourcetype", 1);
                        continue;
                    }
                    if (string7.equals("supportedlock")) {
                        xMLWriter.writeElement("D", "supportedlock", 0);
                        xMLWriter.writeRaw(SUPPORTED_LOCKS);
                        xMLWriter.writeElement("D", "supportedlock", 1);
                        continue;
                    }
                    if (string7.equals("lockdiscovery")) {
                        this.generateLockDiscovery(string2, xMLWriter);
                        continue;
                    }
                    arrayList.add(node);
                }
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
                if (arrayList.isEmpty()) break;
                string5 = "HTTP/1.1 404 ";
                xMLWriter.writeElement("D", "propstat", 0);
                xMLWriter.writeElement("D", "prop", 0);
                for (Node node : arrayList) {
                    string7 = WebdavServlet.getDAVNode(node);
                    if (string7 != null) {
                        xMLWriter.writeElement("D", string7, 2);
                        continue;
                    }
                    xMLWriter.writeElement(null, node.getNamespaceURI(), node.getLocalName(), 2);
                }
                xMLWriter.writeElement("D", "prop", 1);
                xMLWriter.writeElement("D", "status", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement("D", "status", 1);
                xMLWriter.writeElement("D", "propstat", 1);
            }
        }
        xMLWriter.writeElement("D", "response", 1);
    }

    private void generateLockDiscovery(String string, XMLWriter xMLWriter) {
        xMLWriter.writeElement("D", "lockdiscovery", 0);
        String string2 = string;
        while (true) {
            int n;
            LockInfo lockInfo;
            if ((lockInfo = this.resourceLocks.get(string2)) != null) {
                if (lockInfo.hasExpired()) {
                    this.resourceLocks.remove(string2);
                } else if (string2 != string && lockInfo.depth > 0 || string2 == string) {
                    if (lockInfo.isExclusive()) {
                        lockInfo.toXML(xMLWriter);
                    } else {
                        for (String string3 : lockInfo.sharedTokens) {
                            LockInfo lockInfo2 = this.sharedLocks.get(string3);
                            if (lockInfo2 == null) continue;
                            if (lockInfo2.hasExpired()) {
                                this.sharedLocks.remove(string3);
                                continue;
                            }
                            if ((string2 == string || lockInfo2.depth <= 0) && string2 != string) continue;
                            lockInfo2.toXML(xMLWriter);
                        }
                    }
                }
            }
            if ((n = string2.lastIndexOf(47)) < 0) break;
            string2 = string2.substring(0, n);
        }
        xMLWriter.writeElement("D", "lockdiscovery", 1);
    }

    private static String getISOCreationDate(long l) {
        return creationDateFormat.format(new Date(l));
    }

    private static String getDAVNode(Node node) {
        if (DEFAULT_NAMESPACE.equals(node.getNamespaceURI())) {
            return node.getLocalName();
        }
        return null;
    }

    private static boolean propertyEquals(Node node, Node node2) {
        return node.getLocalName().equals(node2.getLocalName()) && (node.getNamespaceURI() == null && node2.getNamespaceURI() == null || node.getNamespaceURI() != null && node.getNamespaceURI().equals(node2.getNamespaceURI()));
    }

    public static interface PropertyStore {
        public void init();

        public void destroy();

        public void periodicEvent();

        public void copy(String var1, String var2);

        public void delete(String var1);

        public boolean propfind(String var1, Node var2, boolean var3, XMLWriter var4);

        public void proppatch(String var1, ArrayList<ProppatchOperation> var2);
    }

    public static class MemoryPropertyStore
    implements PropertyStore {
        private final ConcurrentHashMap<String, ArrayList<Node>> deadProperties = new ConcurrentHashMap();

        @Override
        public void init() {
        }

        @Override
        public void destroy() {
        }

        @Override
        public void periodicEvent() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copy(String string, String string2) {
            ArrayList<Node> arrayList = this.deadProperties.get(string);
            ArrayList<Node> arrayList2 = this.deadProperties.get(string2);
            if (arrayList != null) {
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList();
                    this.deadProperties.put(string2, arrayList2);
                }
                ArrayList<Node> arrayList3 = arrayList;
                synchronized (arrayList3) {
                    ArrayList<Node> arrayList4 = arrayList2;
                    synchronized (arrayList4) {
                        for (Node node : arrayList) {
                            node = node.cloneNode(true);
                            boolean bl = false;
                            for (int i = 0; i < arrayList2.size(); ++i) {
                                Node node2 = arrayList2.get(i);
                                if (!WebdavServlet.propertyEquals(node, node2)) continue;
                                bl = true;
                                arrayList2.set(i, node);
                                break;
                            }
                            if (bl) continue;
                            arrayList2.add(node);
                        }
                    }
                }
            }
        }

        @Override
        public void delete(String string) {
            this.deadProperties.remove(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean propfind(String string, Node node, boolean bl, XMLWriter xMLWriter) {
            ArrayList<Node> arrayList = this.deadProperties.get(string);
            if (arrayList != null) {
                ArrayList<Node> arrayList2 = arrayList;
                synchronized (arrayList2) {
                    if (bl) {
                        for (Node node2 : arrayList) {
                            xMLWriter.writeElement(null, node2.getNamespaceURI(), node2.getLocalName(), 2);
                        }
                    } else if (node != null) {
                        Node node3 = null;
                        for (Node object : arrayList) {
                            if (!WebdavServlet.propertyEquals(object, node)) continue;
                            node3 = object;
                        }
                        if (node3 != null) {
                            StringWriter stringWriter = new StringWriter();
                            DOMWriter dOMWriter = new DOMWriter(stringWriter);
                            dOMWriter.print(node3);
                            xMLWriter.writeRaw(stringWriter.toString());
                            return true;
                        }
                    } else {
                        StringWriter stringWriter = new StringWriter();
                        DOMWriter dOMWriter = new DOMWriter(stringWriter);
                        for (Node node2 : arrayList) {
                            dOMWriter.print(node2);
                        }
                        xMLWriter.writeRaw(stringWriter.toString());
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void proppatch(String string, ArrayList<ProppatchOperation> arrayList) {
            boolean bl = false;
            for (ProppatchOperation object : arrayList) {
                if (!object.getProtectedProperty()) continue;
                bl = true;
                object.setStatusCode(403);
            }
            if (bl) {
                for (ProppatchOperation proppatchOperation : arrayList) {
                    if (proppatchOperation.getProtectedProperty()) continue;
                    proppatchOperation.setStatusCode(424);
                }
            } else {
                ArrayList<Node> arrayList2 = this.deadProperties.get(string);
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Node>();
                    this.deadProperties.put(string, arrayList2);
                }
                ArrayList<Node> arrayList3 = arrayList2;
                synchronized (arrayList3) {
                    block5: for (ProppatchOperation proppatchOperation : arrayList) {
                        int n;
                        Node node;
                        if (proppatchOperation.getUpdateType() == PropertyUpdateType.SET) {
                            node = proppatchOperation.getPropertyNode().cloneNode(true);
                            n = 0;
                            for (int i = 0; i < arrayList2.size(); ++i) {
                                Node node2 = (Node)arrayList2.get(i);
                                if (!WebdavServlet.propertyEquals(node, node2)) continue;
                                n = 1;
                                arrayList2.set(i, node);
                                break;
                            }
                            if (n == 0) {
                                arrayList2.add(node);
                            }
                        }
                        if (proppatchOperation.getUpdateType() != PropertyUpdateType.REMOVE) continue;
                        node = proppatchOperation.getPropertyNode();
                        for (n = 0; n < arrayList2.size(); ++n) {
                            Node node3 = (Node)arrayList2.get(n);
                            if (!WebdavServlet.propertyEquals(node, node3)) continue;
                            arrayList2.remove(n);
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    private static class LockInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int maxDepth;
        String path = "/";
        String lockroot = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        String token = "";
        List<String> sharedTokens = new CopyOnWriteArrayList<String>();
        long expiresAt = 0L;
        String principal = null;

        LockInfo(int n) {
            this.maxDepth = n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Type:");
            stringBuilder.append(this.type);
            stringBuilder.append("\nScope:");
            stringBuilder.append(this.scope);
            stringBuilder.append("\nDepth:");
            stringBuilder.append(this.depth);
            stringBuilder.append("\nOwner:");
            stringBuilder.append(this.owner);
            stringBuilder.append("\nExpiration:");
            stringBuilder.append(FastHttpDateFormat.formatDate((long)this.expiresAt));
            stringBuilder.append("\nToken:");
            stringBuilder.append(this.token);
            stringBuilder.append("\n");
            return stringBuilder.toString();
        }

        public boolean hasExpired() {
            return this.sharedTokens.size() == 0 && System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return this.scope.equals("exclusive");
        }

        public void toXML(XMLWriter xMLWriter) {
            xMLWriter.writeElement("D", "activelock", 0);
            xMLWriter.writeElement("D", "locktype", 0);
            xMLWriter.writeElement("D", this.type, 2);
            xMLWriter.writeElement("D", "locktype", 1);
            xMLWriter.writeElement("D", "lockscope", 0);
            xMLWriter.writeElement("D", this.scope, 2);
            xMLWriter.writeElement("D", "lockscope", 1);
            xMLWriter.writeElement("D", "depth", 0);
            if (this.depth == this.maxDepth) {
                xMLWriter.writeText("Infinity");
            } else {
                xMLWriter.writeText("0");
            }
            xMLWriter.writeElement("D", "depth", 1);
            xMLWriter.writeElement("D", "owner", 0);
            xMLWriter.writeText(this.owner);
            xMLWriter.writeElement("D", "owner", 1);
            xMLWriter.writeElement("D", "timeout", 0);
            long l = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            xMLWriter.writeText("Second-" + l);
            xMLWriter.writeElement("D", "timeout", 1);
            xMLWriter.writeElement("D", "lockroot", 0);
            xMLWriter.writeElement("D", "href", 0);
            xMLWriter.writeText(this.lockroot);
            xMLWriter.writeElement("D", "href", 1);
            xMLWriter.writeElement("D", "lockroot", 1);
            xMLWriter.writeElement("D", "locktoken", 0);
            xMLWriter.writeElement("D", "href", 0);
            xMLWriter.writeText(WebdavServlet.LOCK_SCHEME + this.token);
            xMLWriter.writeElement("D", "href", 1);
            xMLWriter.writeElement("D", "locktoken", 1);
            xMLWriter.writeElement("D", "activelock", 1);
        }
    }

    private static class WebdavResolver
    implements EntityResolver {
        private ServletContext context;

        WebdavResolver(ServletContext servletContext) {
            this.context = servletContext;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            this.context.log(DefaultServlet.sm.getString("webdavservlet.externalEntityIgnored", new Object[]{string, string2}));
            return new InputSource(new StringReader("Ignored external entity"));
        }
    }

    static enum PropfindType {
        FIND_BY_PROPERTY,
        FIND_ALL_PROP,
        FIND_PROPERTY_NAMES;

    }

    public static class ProppatchOperation {
        private final PropertyUpdateType updateType;
        private final Node propertyNode;
        private final boolean protectedProperty;
        private int statusCode = 200;

        public ProppatchOperation(PropertyUpdateType propertyUpdateType, Node node) {
            this.updateType = propertyUpdateType;
            this.propertyNode = node;
            String string = WebdavServlet.getDAVNode(node);
            this.protectedProperty = string != null && !string.equals("displayname") && !string.equals("getcontentlanguage");
        }

        public PropertyUpdateType getUpdateType() {
            return this.updateType;
        }

        public Node getPropertyNode() {
            return this.propertyNode;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(int n) {
            this.statusCode = n;
        }

        public boolean getProtectedProperty() {
            return this.protectedProperty;
        }
    }

    static enum PropertyUpdateType {
        SET,
        REMOVE;

    }
}

