/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeEvent;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.ServletSecurityElement;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.descriptor.JspConfigDescriptor;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Globals;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Service;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.ApplicationContextFacade;
import org.apache.catalina.core.ApplicationDispatcher;
import org.apache.catalina.core.ApplicationFilterRegistration;
import org.apache.catalina.core.ApplicationMapping;
import org.apache.catalina.core.ApplicationServletRegistration;
import org.apache.catalina.core.ApplicationSessionCookieConfig;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.mapper.MappingData;
import org.apache.catalina.util.Introspection;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.util.URLEncoder;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.EncodedSolidusHandling;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.buf.UDecoder;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.http.RequestUtil;
import org.apache.tomcat.util.res.StringManager;

public class ApplicationContext
implements ServletContext {
    protected Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
    private final Map<String, String> readOnlyAttributes = new ConcurrentHashMap<String, String>();
    private final StandardContext context;
    private final Service service;
    private final ServletContext facade = new ApplicationContextFacade(this);
    private final Map<String, String> parameters = new ConcurrentHashMap<String, String>();
    private static final StringManager sm = StringManager.getManager(ApplicationContext.class);
    private final ThreadLocal<DispatchData> dispatchData = new ThreadLocal();
    private SessionCookieConfig sessionCookieConfig;
    private Set<SessionTrackingMode> sessionTrackingModes = null;
    private Set<SessionTrackingMode> defaultSessionTrackingModes = null;
    private Set<SessionTrackingMode> supportedSessionTrackingModes = null;
    private boolean newServletContextListenerAllowed = true;

    public ApplicationContext(StandardContext standardContext) {
        this.context = standardContext;
        this.service = ((Engine)standardContext.getParent().getParent()).getService();
        this.sessionCookieConfig = new ApplicationSessionCookieConfig(standardContext);
        this.populateSessionTrackingModes();
    }

    public Object getAttribute(String string) {
        return this.attributes.get(string);
    }

    public Enumeration<String> getAttributeNames() {
        HashSet<String> hashSet = new HashSet<String>(this.attributes.keySet());
        return Collections.enumeration(hashSet);
    }

    public ServletContext getContext(String string) {
        if (string == null || !string.startsWith("/")) {
            return null;
        }
        Context context = null;
        try {
            Container container = this.context.getParent();
            context = (Context)container.findChild(string);
            if (context != null && !context.getState().isAvailable()) {
                context = null;
            }
            if (context == null) {
                int n = string.indexOf("##");
                if (n > -1) {
                    string = string.substring(0, n);
                }
                MessageBytes messageBytes = MessageBytes.newInstance();
                messageBytes.setString(container.getName());
                MessageBytes messageBytes2 = MessageBytes.newInstance();
                messageBytes2.setString(string);
                MappingData mappingData = new MappingData();
                this.service.getMapper().map(messageBytes, messageBytes2, null, mappingData);
                context = mappingData.context;
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            return null;
        }
        if (context == null) {
            return null;
        }
        if (this.context.getCrossContext()) {
            return context.getServletContext();
        }
        if (context == this.context) {
            return this.context.getServletContext();
        }
        return null;
    }

    public String getContextPath() {
        return this.context.getPath();
    }

    public String getInitParameter(String string) {
        if ("org.apache.jasper.XML_VALIDATE_TLD".equals(string) && this.context.getTldValidation()) {
            return "true";
        }
        if ("org.apache.jasper.XML_BLOCK_EXTERNAL".equals(string) && !this.context.getXmlBlockExternal()) {
            return "false";
        }
        return this.parameters.get(string);
    }

    public Enumeration<String> getInitParameterNames() {
        HashSet<String> hashSet = new HashSet<String>(this.parameters.keySet());
        if (this.context.getTldValidation()) {
            hashSet.add("org.apache.jasper.XML_VALIDATE_TLD");
        }
        if (!this.context.getXmlBlockExternal()) {
            hashSet.add("org.apache.jasper.XML_BLOCK_EXTERNAL");
        }
        return Collections.enumeration(hashSet);
    }

    public int getMajorVersion() {
        return 6;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getMimeType(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(n + 1);
        if (string2.length() < 1) {
            return null;
        }
        return this.context.findMimeMapping(string2);
    }

    public RequestDispatcher getNamedDispatcher(String string) {
        if (string == null) {
            return null;
        }
        Wrapper wrapper = (Wrapper)this.context.findChild(string);
        if (wrapper == null) {
            return null;
        }
        return new ApplicationDispatcher(wrapper, null, null, null, null, null, string);
    }

    public String getRealPath(String string) {
        String string2 = this.validateResourcePath(string, true);
        return this.context.getRealPath(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestDispatcher getRequestDispatcher(String string) {
        String string2;
        Object object;
        if (string == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.requestDispatcher.iae", new Object[]{string}));
        }
        int n = string.indexOf(63);
        if (n >= 0) {
            object = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            object = string;
            string2 = null;
        }
        String string3 = ApplicationContext.stripPathParams((String)object);
        if (this.getContext().getDispatchersUseEncodedPaths()) {
            string3 = UDecoder.URLDecode((String)string3, (Charset)StandardCharsets.UTF_8, (EncodedSolidusHandling)this.context.getEncodedSolidusHandlingEnum(), (EncodedSolidusHandling)this.context.getEncodedReverseSolidusHandlingEnum());
        }
        if ((string3 = RequestUtil.normalize((String)string3)) == null) {
            this.getContext().getLogger().warn((Object)sm.getString("applicationContext.illegalDispatchPath", new Object[]{string}), (Throwable)new IllegalArgumentException());
            return null;
        }
        object = this.getContext().getDispatchersUseEncodedPaths() ? URLEncoder.DEFAULT.encode(this.getContextPath(), StandardCharsets.UTF_8) + (String)object : URLEncoder.DEFAULT.encode(this.getContextPath() + (String)object, StandardCharsets.UTF_8);
        DispatchData dispatchData = this.dispatchData.get();
        if (dispatchData == null) {
            dispatchData = new DispatchData();
            this.dispatchData.set(dispatchData);
        }
        MessageBytes messageBytes = dispatchData.uriMB;
        MappingData mappingData = dispatchData.mappingData;
        try {
            messageBytes.setChars(MessageBytes.EMPTY_CHAR_ARRAY, 0, 0);
            CharChunk charChunk = messageBytes.getCharChunk();
            try {
                charChunk.append(this.context.getPath());
                charChunk.append(string3);
                this.service.getMapper().map(this.context, messageBytes, mappingData);
                if (mappingData.wrapper == null) {
                    RequestDispatcher requestDispatcher = null;
                    return requestDispatcher;
                }
            }
            catch (Exception exception) {
                this.log(sm.getString("applicationContext.mapping.error"), exception);
                RequestDispatcher requestDispatcher = null;
                return requestDispatcher;
            }
            Wrapper wrapper = mappingData.wrapper;
            String string4 = mappingData.wrapperPath.toString();
            String string5 = mappingData.pathInfo.toString();
            HttpServletMapping httpServletMapping = new ApplicationMapping(mappingData).getHttpServletMapping();
            ApplicationDispatcher applicationDispatcher = new ApplicationDispatcher(wrapper, (String)object, string4, string5, string2, httpServletMapping, null);
            return applicationDispatcher;
        }
        finally {
            messageBytes.recycle();
            mappingData.recycle();
        }
    }

    static String stripPathParams(String string) {
        if (string.indexOf(59) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = string.indexOf(59, n);
            if (n3 < 0) {
                n3 = n2;
            }
            stringBuilder.append(string.substring(n, n3));
            int n4 = string.indexOf(47, n3);
            if (n4 < 0) {
                n = n2;
                continue;
            }
            n = n4;
        }
        return stringBuilder.toString();
    }

    public URL getResource(String string) throws MalformedURLException {
        String string2 = this.validateResourcePath(string, !this.context.getContextGetResourceRequiresSlash());
        if (string2 == null) {
            throw new MalformedURLException(sm.getString("applicationContext.requestDispatcher.iae", new Object[]{string}));
        }
        WebResourceRoot webResourceRoot = this.context.getResources();
        if (webResourceRoot != null) {
            return webResourceRoot.getResource(string2).getURL();
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        String string2 = this.validateResourcePath(string, !this.context.getContextGetResourceRequiresSlash());
        if (string2 == null) {
            return null;
        }
        WebResourceRoot webResourceRoot = this.context.getResources();
        if (webResourceRoot != null) {
            return webResourceRoot.getResource(string2).getInputStream();
        }
        return null;
    }

    private String validateResourcePath(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            if (bl) {
                return "/" + string;
            }
            return null;
        }
        return string;
    }

    public Set<String> getResourcePaths(String string) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.resourcePaths.iae", new Object[]{string}));
        }
        WebResourceRoot webResourceRoot = this.context.getResources();
        if (webResourceRoot != null) {
            return webResourceRoot.listWebAppPaths(string);
        }
        return null;
    }

    public String getServerInfo() {
        return ServerInfo.getServerInfo();
    }

    public String getServletContextName() {
        return this.context.getDisplayName();
    }

    public void log(String string) {
        this.context.getLogger().info((Object)string);
    }

    public void log(String string, Throwable throwable) {
        this.context.getLogger().error((Object)string, throwable);
    }

    public void removeAttribute(String string) {
        Object object = null;
        if (this.readOnlyAttributes.containsKey(string)) {
            return;
        }
        object = this.attributes.remove(string);
        if (object == null) {
            return;
        }
        Object[] objectArray = this.context.getApplicationEventListeners();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        ServletContextAttributeEvent servletContextAttributeEvent = new ServletContextAttributeEvent(this.context.getServletContext(), string, object);
        for (Object object2 : objectArray) {
            if (!(object2 instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener servletContextAttributeListener = (ServletContextAttributeListener)object2;
            try {
                this.context.fireContainerEvent("beforeContextAttributeRemoved", servletContextAttributeListener);
                servletContextAttributeListener.attributeRemoved(servletContextAttributeEvent);
                this.context.fireContainerEvent("afterContextAttributeRemoved", servletContextAttributeListener);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                this.context.fireContainerEvent("afterContextAttributeRemoved", servletContextAttributeListener);
                this.log(sm.getString("applicationContext.attributeEvent"), throwable);
            }
        }
    }

    public void setAttribute(String string, Object object) {
        if (string == null) {
            throw new NullPointerException(sm.getString("applicationContext.setAttribute.namenull"));
        }
        if (object == null) {
            this.removeAttribute(string);
            return;
        }
        if (this.readOnlyAttributes.containsKey(string)) {
            return;
        }
        Object object2 = this.attributes.put(string, object);
        boolean bl = object2 != null;
        Object[] objectArray = this.context.getApplicationEventListeners();
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        ServletContextAttributeEvent servletContextAttributeEvent = null;
        servletContextAttributeEvent = bl ? new ServletContextAttributeEvent(this.context.getServletContext(), string, object2) : new ServletContextAttributeEvent(this.context.getServletContext(), string, object);
        for (Object object3 : objectArray) {
            if (!(object3 instanceof ServletContextAttributeListener)) continue;
            ServletContextAttributeListener servletContextAttributeListener = (ServletContextAttributeListener)object3;
            try {
                if (bl) {
                    this.context.fireContainerEvent("beforeContextAttributeReplaced", servletContextAttributeListener);
                    servletContextAttributeListener.attributeReplaced(servletContextAttributeEvent);
                    this.context.fireContainerEvent("afterContextAttributeReplaced", servletContextAttributeListener);
                    continue;
                }
                this.context.fireContainerEvent("beforeContextAttributeAdded", servletContextAttributeListener);
                servletContextAttributeListener.attributeAdded(servletContextAttributeEvent);
                this.context.fireContainerEvent("afterContextAttributeAdded", servletContextAttributeListener);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                if (bl) {
                    this.context.fireContainerEvent("afterContextAttributeReplaced", servletContextAttributeListener);
                } else {
                    this.context.fireContainerEvent("afterContextAttributeAdded", servletContextAttributeListener);
                }
                this.log(sm.getString("applicationContext.attributeEvent"), throwable);
            }
        }
    }

    public FilterRegistration.Dynamic addFilter(String string, String string2) {
        return this.addFilter(string, string2, null);
    }

    public FilterRegistration.Dynamic addFilter(String string, Filter filter) {
        return this.addFilter(string, null, filter);
    }

    public FilterRegistration.Dynamic addFilter(String string, Class<? extends Filter> clazz) {
        return this.addFilter(string, clazz.getName(), null);
    }

    private FilterRegistration.Dynamic addFilter(String string, String string2, Filter filter) throws IllegalStateException {
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.invalidFilterName", new Object[]{string}));
        }
        this.checkState("applicationContext.addFilter.ise");
        FilterDef filterDef = this.context.findFilterDef(string);
        if (filterDef == null) {
            filterDef = new FilterDef();
            filterDef.setFilterName(string);
            this.context.addFilterDef(filterDef);
        } else if (filterDef.getFilterName() != null && filterDef.getFilterClass() != null) {
            return null;
        }
        if (filter == null) {
            filterDef.setFilterClass(string2);
        } else {
            filterDef.setFilterClass(filter.getClass().getName());
            filterDef.setFilter(filter);
        }
        return new ApplicationFilterRegistration(filterDef, this.context);
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        try {
            Filter filter = (Filter)this.context.getInstanceManager().newInstance(clazz.getName());
            return (T)filter;
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtils.handleThrowable((Throwable)invocationTargetException.getCause());
            throw new ServletException((Throwable)invocationTargetException);
        }
        catch (ReflectiveOperationException | NamingException exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    public FilterRegistration getFilterRegistration(String string) {
        FilterDef filterDef = this.context.findFilterDef(string);
        if (filterDef == null) {
            return null;
        }
        return new ApplicationFilterRegistration(filterDef, this.context);
    }

    public ServletRegistration.Dynamic addServlet(String string, String string2) {
        return this.addServlet(string, string2, null, null);
    }

    public ServletRegistration.Dynamic addServlet(String string, Servlet servlet) {
        return this.addServlet(string, null, servlet, null);
    }

    public ServletRegistration.Dynamic addServlet(String string, Class<? extends Servlet> clazz) {
        return this.addServlet(string, clazz.getName(), null, null);
    }

    public ServletRegistration.Dynamic addJspFile(String string, String string2) {
        if (string2 == null || !string2.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.addJspFile.iae", new Object[]{string2}));
        }
        String string3 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Wrapper wrapper = (Wrapper)this.context.findChild("jsp");
        if (wrapper == null) {
            string3 = "org.apache.jasper.servlet.JspServlet";
        } else {
            String[] stringArray;
            string3 = wrapper.getServletClass();
            for (String string4 : stringArray = wrapper.findInitParameters()) {
                hashMap.put(string4, wrapper.findInitParameter(string4));
            }
        }
        hashMap.put("jspFile", string2);
        return this.addServlet(string, string3, null, hashMap);
    }

    private ServletRegistration.Dynamic addServlet(String string, String string2, Servlet servlet, Map<String, String> map) throws IllegalStateException {
        Object object;
        if (string == null || string.equals("")) {
            throw new IllegalArgumentException(sm.getString("applicationContext.invalidServletName", new Object[]{string}));
        }
        this.checkState("applicationContext.addServlet.ise");
        Wrapper wrapper = (Wrapper)this.context.findChild(string);
        if (wrapper == null) {
            wrapper = this.context.createWrapper();
            wrapper.setName(string);
            this.context.addChild(wrapper);
        } else if (wrapper.getName() != null && wrapper.getServletClass() != null) {
            if (wrapper.isOverridable()) {
                wrapper.setOverridable(false);
            } else {
                return null;
            }
        }
        ServletSecurity servletSecurity = null;
        if (servlet == null) {
            wrapper.setServletClass(string2);
            object = Introspection.loadClass(this.context, string2);
            if (object != null) {
                servletSecurity = ((Class)object).getAnnotation(ServletSecurity.class);
            }
        } else {
            wrapper.setServletClass(servlet.getClass().getName());
            wrapper.setServlet(servlet);
            if (this.context.wasCreatedDynamicServlet(servlet)) {
                servletSecurity = servlet.getClass().getAnnotation(ServletSecurity.class);
            }
        }
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                wrapper.addInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
        }
        object = new ApplicationServletRegistration(wrapper, this.context);
        if (servletSecurity != null) {
            object.setServletSecurity(new ServletSecurityElement(servletSecurity));
        }
        return object;
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            Servlet servlet = (Servlet)this.context.getInstanceManager().newInstance(clazz.getName());
            this.context.dynamicServletCreated(servlet);
            return (T)servlet;
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtils.handleThrowable((Throwable)invocationTargetException.getCause());
            throw new ServletException((Throwable)invocationTargetException);
        }
        catch (ReflectiveOperationException | NamingException exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    public ServletRegistration getServletRegistration(String string) {
        Wrapper wrapper = (Wrapper)this.context.findChild(string);
        if (wrapper == null) {
            return null;
        }
        return new ApplicationServletRegistration(wrapper, this.context);
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.defaultSessionTrackingModes;
    }

    private void populateSessionTrackingModes() {
        Connector[] connectorArray;
        this.defaultSessionTrackingModes = EnumSet.of(SessionTrackingMode.URL);
        this.supportedSessionTrackingModes = EnumSet.of(SessionTrackingMode.URL);
        if (this.context.getCookies()) {
            this.defaultSessionTrackingModes.add(SessionTrackingMode.COOKIE);
            this.supportedSessionTrackingModes.add(SessionTrackingMode.COOKIE);
        }
        for (Connector connector : connectorArray = this.service.findConnectors()) {
            if (!Boolean.TRUE.equals(connector.getProperty("SSLEnabled"))) continue;
            this.supportedSessionTrackingModes.add(SessionTrackingMode.SSL);
            break;
        }
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        if (this.sessionTrackingModes != null) {
            return this.sessionTrackingModes;
        }
        return this.defaultSessionTrackingModes;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> set) {
        this.checkState("applicationContext.setSessionTracking.ise");
        for (SessionTrackingMode sessionTrackingMode : set) {
            if (this.supportedSessionTrackingModes.contains(sessionTrackingMode)) continue;
            throw new IllegalArgumentException(sm.getString("applicationContext.setSessionTracking.iae.invalid", new Object[]{sessionTrackingMode.toString(), this.getContextPath()}));
        }
        if (set.contains(SessionTrackingMode.SSL) && set.size() > 1) {
            throw new IllegalArgumentException(sm.getString("applicationContext.setSessionTracking.iae.ssl", new Object[]{this.getContextPath()}));
        }
        this.sessionTrackingModes = set;
    }

    public boolean setInitParameter(String string, String string2) {
        if (string == null) {
            throw new NullPointerException(sm.getString("applicationContext.setAttribute.namenull"));
        }
        this.checkState("applicationContext.setInitParam.ise");
        return this.parameters.putIfAbsent(string, string2) == null;
    }

    public void addListener(Class<? extends EventListener> clazz) {
        EventListener eventListener;
        try {
            eventListener = this.createListener(clazz);
        }
        catch (ServletException servletException) {
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.init", new Object[]{clazz.getName()}), servletException);
        }
        this.addListener(eventListener);
    }

    public void addListener(String string) {
        try {
            if (this.context.getInstanceManager() != null) {
                Object object = this.context.getInstanceManager().newInstance(string);
                if (!(object instanceof EventListener)) {
                    throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.wrongType", new Object[]{string}));
                }
                EventListener eventListener = (EventListener)object;
                this.addListener(eventListener);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtils.handleThrowable((Throwable)invocationTargetException.getCause());
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.cnfe", new Object[]{string}), invocationTargetException);
        }
        catch (ReflectiveOperationException | NamingException exception) {
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.cnfe", new Object[]{string}), exception);
        }
    }

    public <T extends EventListener> void addListener(T t) {
        this.checkState("applicationContext.addListener.ise");
        boolean bl = false;
        if (t instanceof ServletContextAttributeListener || t instanceof ServletRequestListener || t instanceof ServletRequestAttributeListener || t instanceof HttpSessionIdListener || t instanceof HttpSessionAttributeListener) {
            this.context.addApplicationEventListener(t);
            bl = true;
        }
        if (t instanceof HttpSessionListener || t instanceof ServletContextListener && this.newServletContextListenerAllowed) {
            this.context.addApplicationLifecycleListener(t);
            bl = true;
        }
        if (bl) {
            return;
        }
        if (t instanceof ServletContextListener) {
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.sclNotAllowed", new Object[]{t.getClass().getName()}));
        }
        throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.wrongType", new Object[]{t.getClass().getName()}));
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            EventListener eventListener = (EventListener)this.context.getInstanceManager().newInstance(clazz);
            if (eventListener instanceof ServletContextListener || eventListener instanceof ServletContextAttributeListener || eventListener instanceof ServletRequestListener || eventListener instanceof ServletRequestAttributeListener || eventListener instanceof HttpSessionListener || eventListener instanceof HttpSessionIdListener || eventListener instanceof HttpSessionAttributeListener) {
                return (T)eventListener;
            }
            throw new IllegalArgumentException(sm.getString("applicationContext.addListener.iae.wrongType", new Object[]{eventListener.getClass().getName()}));
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionUtils.handleThrowable((Throwable)invocationTargetException.getCause());
            throw new ServletException((Throwable)invocationTargetException);
        }
        catch (ReflectiveOperationException | NamingException exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    public void declareRoles(String ... stringArray) {
        this.checkState("applicationContext.addRole.ise");
        if (stringArray == null) {
            throw new IllegalArgumentException(sm.getString("applicationContext.roles.iae", new Object[]{this.getContextPath()}));
        }
        for (String string : stringArray) {
            if (string == null || string.isEmpty()) {
                throw new IllegalArgumentException(sm.getString("applicationContext.role.iae", new Object[]{this.getContextPath()}));
            }
            this.context.addSecurityRole(string);
        }
    }

    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.context.getLoader().getClassLoader();
        if (Globals.IS_SECURITY_ENABLED) {
            ClassLoader classLoader2;
            ClassLoader classLoader3 = Thread.currentThread().getContextClassLoader();
            for (classLoader2 = classLoader; classLoader2 != null && classLoader2 != classLoader3; classLoader2 = classLoader2.getParent()) {
            }
            if (classLoader2 == null) {
                System.getSecurityManager().checkPermission(new RuntimePermission("getClassLoader"));
            }
        }
        return classLoader;
    }

    public int getEffectiveMajorVersion() {
        return this.context.getEffectiveMajorVersion();
    }

    public int getEffectiveMinorVersion() {
        return this.context.getEffectiveMinorVersion();
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        FilterDef[] filterDefArray;
        HashMap<String, ApplicationFilterRegistration> hashMap = new HashMap<String, ApplicationFilterRegistration>();
        for (FilterDef filterDef : filterDefArray = this.context.findFilterDefs()) {
            hashMap.put(filterDef.getFilterName(), new ApplicationFilterRegistration(filterDef, this.context));
        }
        return hashMap;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return this.context.getJspConfigDescriptor();
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        Container[] containerArray;
        HashMap<String, ApplicationServletRegistration> hashMap = new HashMap<String, ApplicationServletRegistration>();
        for (Container container : containerArray = this.context.findChildren()) {
            hashMap.put(container.getName(), new ApplicationServletRegistration((Wrapper)container, this.context));
        }
        return hashMap;
    }

    public String getVirtualServerName() {
        Container container = this.context.getParent();
        Container container2 = container.getParent();
        return container2.getName() + "/" + container.getName();
    }

    public int getSessionTimeout() {
        return this.context.getSessionTimeout();
    }

    public void setSessionTimeout(int n) {
        this.checkState("applicationContext.setSessionTimeout.ise");
        this.context.setSessionTimeout(n);
    }

    public String getRequestCharacterEncoding() {
        return this.context.getRequestCharacterEncoding();
    }

    public void setRequestCharacterEncoding(String string) {
        this.checkState("applicationContext.setRequestEncoding.ise");
        this.context.setRequestCharacterEncoding(string);
    }

    public String getResponseCharacterEncoding() {
        return this.context.getResponseCharacterEncoding();
    }

    public void setResponseCharacterEncoding(String string) {
        this.checkState("applicationContext.setResponseEncoding.ise");
        this.context.setResponseCharacterEncoding(string);
    }

    private void checkState(String string) {
        if (!this.context.getState().equals((Object)LifecycleState.STARTING_PREP)) {
            throw new IllegalStateException(sm.getString(string, new Object[]{this.getContextPath()}));
        }
    }

    protected StandardContext getContext() {
        return this.context;
    }

    protected void clearAttributes() {
        ArrayList<String> arrayList = new ArrayList<String>(this.attributes.keySet());
        for (String string : arrayList) {
            this.removeAttribute(string);
        }
    }

    protected ServletContext getFacade() {
        return this.facade;
    }

    void setAttributeReadOnly(String string) {
        if (this.attributes.containsKey(string)) {
            this.readOnlyAttributes.put(string, string);
        }
    }

    protected void setNewServletContextListenerAllowed(boolean bl) {
        this.newServletContextListenerAllowed = bl;
    }

    private static final class DispatchData {
        public MessageBytes uriMB = MessageBytes.newInstance();
        public MappingData mappingData;

        DispatchData() {
            CharChunk charChunk = this.uriMB.getCharChunk();
            charChunk.setLimit(-1);
            this.mappingData = new MappingData();
        }
    }
}

