/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.PrintWriter;
import org.apache.catalina.Loader;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFactoryBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class LoaderSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog(LoaderSF.class);

    @Override
    public void store(PrintWriter printWriter, int n, Object object) throws Exception {
        StoreDescription storeDescription = this.getRegistry().findDescription(object.getClass());
        if (storeDescription != null) {
            Loader loader = (Loader)object;
            if (!this.isDefaultLoader(loader)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("store " + storeDescription.getTag() + "( " + String.valueOf(object) + " )"));
                }
                this.getStoreAppender().printIndent(printWriter, n + 2);
                this.getStoreAppender().printTag(printWriter, n + 2, loader, storeDescription);
            }
        } else if (log.isWarnEnabled() && log.isWarnEnabled()) {
            log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{object.getClass()}));
        }
    }

    protected boolean isDefaultLoader(Loader loader) {
        if (!(loader instanceof WebappLoader)) {
            return false;
        }
        WebappLoader webappLoader = (WebappLoader)loader;
        return !webappLoader.getDelegate() && webappLoader.getLoaderClass().equals("org.apache.catalina.loader.WebappClassLoader");
    }
}

