/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.immutable;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.iface.MultiDexContainer;
import org.jf.dexlib2.immutable.ImmutableDexFile;

public class ImmutableMultiDexContainer
implements MultiDexContainer<ImmutableDexFile> {
    private final ImmutableMap<String, ImmutableDexEntry> entries;

    public ImmutableMultiDexContainer(Map<String, ImmutableDexFile> entries) {
        ImmutableMap.Builder<String, ImmutableDexEntry> builder = ImmutableMap.builder();
        for (Map.Entry<String, ImmutableDexFile> entry : entries.entrySet()) {
            ImmutableDexEntry dexEntry = new ImmutableDexEntry(entry.getKey(), entry.getValue());
            builder.put(dexEntry.getEntryName(), dexEntry);
        }
        this.entries = builder.build();
    }

    @Override
    @Nonnull
    public List<String> getDexEntryNames() {
        return ImmutableList.copyOf(this.entries.keySet());
    }

    @Nullable
    public ImmutableDexEntry getEntry(@Nonnull String entryName) {
        return this.entries.get(entryName);
    }

    public class ImmutableDexEntry
    implements MultiDexContainer.DexEntry<ImmutableDexFile> {
        private final String entryName;
        private final ImmutableDexFile dexFile;

        protected ImmutableDexEntry(String entryName, ImmutableDexFile dexFile) {
            this.entryName = entryName;
            this.dexFile = dexFile;
        }

        @Override
        @Nonnull
        public String getEntryName() {
            return this.entryName;
        }

        @Override
        @Nonnull
        public ImmutableDexFile getDexFile() {
            return this.dexFile;
        }

        @Override
        @Nonnull
        public MultiDexContainer<? extends ImmutableDexFile> getContainer() {
            return ImmutableMultiDexContainer.this;
        }
    }
}

