/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.deque;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.deque.DequeIterCommonBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.deque.DequeIterCommonBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.deque.PDequeIter;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.NoSuchElementException;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PDequeIter, PythonBuiltinClassType.PDequeRevIter})
public final class DequeIterCommonBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = DequeIterCommonBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DequeIterCommonBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeIterReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PTuple doGeneric(PDequeIter self, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Bind PythonLanguage language) {
            Object clazz = getClassNode.execute(inliningTarget, self);
            return PFactory.createTuple(language, new Object[]{clazz, PFactory.createTuple(language, new Object[]{self.deque, self.deque.getSize() - self.lengthHint()})});
        }
    }

    @Builtin(name="__length_hint__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DequeIterLengthHintNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static int doGeneric(PDequeIter self) {
            return self.lengthHint();
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DequeIterNextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        public abstract Object execute(PDequeIter var1);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doGeneric(PDequeIter self) {
            try {
                if (self.startState == self.deque.getState()) {
                    if (!self.hasNext()) {
                        assert (self.lengthHint() == 0);
                        throw DequeIterNextNode.iteratorExhausted();
                    }
                    return self.next();
                }
            }
            catch (NoSuchElementException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            self.reset();
            throw PRaiseNode.raiseStatic((Node)this, PythonBuiltinClassType.RuntimeError, ErrorMessages.DEQUE_MUTATED_DURING_ITERATION);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class DequeIterIterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static PDequeIter doGeneric(PDequeIter self) {
            return self;
        }
    }
}

