/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.SchemaRetriever;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.SchemaReference;
import us.fatehi.utility.Utility;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

public class SchemaSetter
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(SchemaRetriever.class.getName());
    private final Connection connection;
    private final Schema oldSchema;
    private final boolean isSupportsCatalogs;
    private final boolean isSupportsSchemas;

    public SchemaSetter(Connection connection, Schema schema) {
        boolean isSupportsSchemas;
        boolean isSupportsCatalogs;
        boolean errored = false;
        errored = schema == null;
        try {
            DatabaseUtility.checkConnection((Connection)connection);
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            errored = true;
        }
        if (errored) {
            this.oldSchema = null;
            this.connection = null;
            this.isSupportsCatalogs = false;
            this.isSupportsSchemas = false;
            return;
        }
        this.connection = connection;
        try {
            DatabaseMetaData dbMetadata = connection.getMetaData();
            isSupportsCatalogs = dbMetadata.supportsCatalogsInTableDefinitions();
            isSupportsSchemas = dbMetadata.supportsSchemasInTableDefinitions();
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, e.getMessage(), e);
            isSupportsCatalogs = true;
            isSupportsSchemas = true;
        }
        this.isSupportsCatalogs = isSupportsCatalogs;
        this.isSupportsSchemas = isSupportsSchemas;
        this.oldSchema = this.setSchema(schema);
    }

    @Override
    public void close() {
        this.setSchema(this.oldSchema);
    }

    private Schema setSchema(Schema schema) {
        SchemaReference oldSchema = null;
        if (schema == null) {
            return oldSchema;
        }
        try {
            oldSchema = new SchemaReference(this.connection.getCatalog(), this.connection.getSchema());
        }
        catch (Exception e) {
            oldSchema = null;
        }
        String catalogName = schema.getCatalogName();
        try {
            if (this.isSupportsCatalogs && !Utility.isBlank((String)catalogName)) {
                this.connection.setCatalog(catalogName);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not set catalog <%s> on connection", new Object[]{catalogName}));
        }
        String schemaName = schema.getName();
        try {
            if (this.isSupportsSchemas && !Utility.isBlank((String)schemaName)) {
                this.connection.setSchema(schemaName);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, e, (Supplier<String>)new StringFormat("Could not set schema <%s> on connection", new Object[]{schemaName}));
        }
        return oldSchema;
    }
}

