/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.script;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.schemacrawler.exceptions.SchemaCrawlerException;
import schemacrawler.tools.command.script.ScriptCommand;
import schemacrawler.tools.command.script.options.ScriptOptions;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.tools.scripting.options.LanguageOptions;
import us.fatehi.utility.property.PropertyName;

public final class CommandChain
extends BaseSchemaCrawlerCommand<LanguageOptions> {
    private static final PropertyName COMMAND = new PropertyName("chain", "Runs SchemaCrawler commands sequentially, each relying on the previous one");
    private static final Logger LOGGER = Logger.getLogger(CommandChain.class.getName());
    private final CommandRegistry commandRegistry;
    private final List<SchemaCrawlerCommand<?>> scCommands;
    private final Config additionalConfig;

    public CommandChain(ScriptCommand scCommand) {
        super(COMMAND);
        Objects.requireNonNull(scCommand, "No command provided, for settings");
        this.commandRegistry = CommandRegistry.getCommandRegistry();
        this.scCommands = new ArrayList();
        this.additionalConfig = new Config(((ScriptOptions)scCommand.getCommandOptions()).getConfig());
        this.setSchemaCrawlerOptions(scCommand.getSchemaCrawlerOptions());
        this.setOutputOptions(scCommand.getOutputOptions());
        this.setCatalog(scCommand.getCatalog());
        if (this.usesConnection()) {
            this.setConnection(scCommand.getConnection());
        }
        this.setIdentifiers(scCommand.getIdentifiers());
        this.setInformationSchemaViews(scCommand.getInformationSchemaViews());
    }

    public SchemaCrawlerCommand<?> addNext(String command, String outputFormat, String outputFileName) {
        Objects.requireNonNull(command, "No command provided");
        Objects.requireNonNull(outputFormat, "No output format provided");
        Objects.requireNonNull(outputFileName, "No output file name provided");
        Path outputFile = Path.of(outputFileName, new String[0]);
        OutputOptions outputOptions = OutputOptionsBuilder.builder((OutputOptions)this.getOutputOptions()).withOutputFormatValue(outputFormat).withOutputFile(outputFile).toOptions();
        return this.addNextAndConfigureForExecution(command, outputOptions);
    }

    public void checkAvailability() {
        this.checkAvailabilityChain();
    }

    public void execute() {
        this.checkCatalog();
        this.initializeChain();
        this.checkAvailabilityChain();
        this.executeChain();
    }

    public boolean usesConnection() {
        return false;
    }

    private SchemaCrawlerCommand<?> addNextAndConfigureForExecution(String command, OutputOptions outputOptions) {
        try {
            SchemaCrawlerCommand scCommand = this.commandRegistry.configureNewCommand(command, this.schemaCrawlerOptions, this.additionalConfig, outputOptions);
            if (scCommand == null) {
                return null;
            }
            scCommand.setCatalog(this.catalog);
            if (scCommand.usesConnection()) {
                scCommand.setConnection(this.connection);
            }
            scCommand.setIdentifiers(this.identifiers);
            scCommand.setInformationSchemaViews(this.informationSchemaViews);
            this.scCommands.add(scCommand);
            return scCommand;
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException("Cannot chain command, unknown command <%s>".formatted(command), (Throwable)e);
        }
    }

    private void checkAvailabilityChain() {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No command to execute");
            return;
        }
        for (SchemaCrawlerCommand<?> scCommand : this.scCommands) {
            try {
                scCommand.checkAvailability();
            }
            catch (Exception e) {
                throw new InternalRuntimeException("Command <%s> is not available".formatted(scCommand));
            }
        }
    }

    private void executeChain() {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No command to execute");
            return;
        }
        for (SchemaCrawlerCommand<?> scCommand : this.scCommands) {
            try {
                scCommand.call();
            }
            catch (SchemaCrawlerException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ExecutionRuntimeException((Throwable)e);
            }
        }
    }

    private void initializeChain() {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No command to initialize");
            return;
        }
        for (SchemaCrawlerCommand<?> scCommand : this.scCommands) {
            scCommand.initialize();
        }
    }
}

