"""
Exceptions raised by the CLI.

Copyright (c) 2025 Proton AG

This file is part of Proton VPN.

Proton VPN is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Proton VPN is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with ProtonVPN.  If not, see <https://www.gnu.org/licenses/>.
"""


class CountryCodeError(Exception):
    """
    Error identifying a country by code
    """


class CountryNameError(Exception):
    """
    Error identifying a country by name
    """


class AuthenticationRequiredError(Exception):
    """
    Error performing operation that requires user authentication
    """


class RequiresHigherTierError(Exception):
    """
    Requested feature that requires a higher tier
    """
