/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexOr;
import net.sourceforge.plantuml.text.StringLocated;

public enum TLineType {
    PLAIN,
    AFFECTATION_DEFINE,
    AFFECTATION,
    ASSERT,
    IF,
    IFDEF,
    UNDEF,
    IFNDEF,
    ELSE,
    ELSEIF,
    ENDIF,
    WHILE,
    ENDWHILE,
    FOREACH,
    ENDFOREACH,
    DECLARE_RETURN_FUNCTION,
    DECLARE_PROCEDURE,
    END_FUNCTION,
    RETURN,
    LEGACY_DEFINE,
    LEGACY_DEFINELONG,
    THEME,
    INCLUDE,
    INCLUDE_SPRITES,
    INCLUDE_DEF,
    IMPORT,
    STARTSUB,
    ENDSUB,
    INCLUDESUB,
    LOG,
    DUMP_MEMORY,
    COMMENT_SIMPLE,
    COMMENT_LONG_START,
    OPTION;

    private static final RegexLeaf IDENTIFIER_WITH_UNICODE_SURROGATES_SUPPORT;
    private static final IRegex PATTERN_LEGACY_DEFINE;
    private static final IRegex PATTERN_LEGACY_DEFINELONG;
    private static final IRegex PATTERN_AFFECTATION_DEFINE;
    private static final IRegex PATTERN_AFFECTATION;
    private static final IRegex PATTERN_COMMENT_SIMPLE1;
    private static final IRegex PATTERN_COMMENT_SIMPLE2;
    private static final IRegex PATTERN_COMMENT_LONG_START;
    private static final IRegex PATTERN_IFDEF;
    private static final IRegex PATTERN_UNDEF;
    private static final IRegex PATTERN_IFNDEF;
    private static final IRegex PATTERN_ASSERT;
    private static final IRegex PATTERN_IF;
    private static final IRegex PATTERN_DECLARE_RETURN_FUNCTION;
    private static final IRegex PATTERN_DECLARE_PROCEDURE;
    private static final IRegex PATTERN_ELSE;
    private static final IRegex PATTERN_ELSEIF;
    private static final IRegex PATTERN_ENDIF;
    private static final IRegex PATTERN_WHILE;
    private static final IRegex PATTERN_ENDWHILE;
    private static final IRegex PATTERN_FOREACH;
    private static final IRegex PATTERN_ENDFOREACH;
    private static final IRegex PATTERN_END_FUNCTION;
    private static final IRegex PATTERN_RETURN;
    private static final IRegex PATTERN_THEME;
    private static final IRegex PATTERN_INCLUDE;
    private static final IRegex PATTERN_INCLUDE_SPRITES;
    private static final IRegex PATTERN_INCLUDE_DEF;
    private static final IRegex PATTERN_IMPORT;
    private static final IRegex PATTERN_STARTSUB;
    private static final IRegex PATTERN_ENDSUB;
    private static final IRegex PATTERN_INCLUDESUB;
    private static final IRegex PATTERN_LOG;
    private static final IRegex PATTERN_DUMP_MEMORY;
    private static final IRegex PATTERN_OPTION;

    private static RegexConcat simpleKeyword(String word) {
        return new RegexConcat(RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(word), new RegexLeaf("\\b"));
    }

    public static TLineType getFromLineInternal(StringLocated sl) {
        String s = sl.getString();
        if (PATTERN_COMMENT_SIMPLE1.match(sl)) {
            return COMMENT_SIMPLE;
        }
        if (PATTERN_COMMENT_SIMPLE2.match(sl)) {
            return COMMENT_SIMPLE;
        }
        if (PATTERN_COMMENT_LONG_START.match(sl) && !s.contains("'/")) {
            return COMMENT_LONG_START;
        }
        if (!sl.containsExclamationMark()) {
            return PLAIN;
        }
        if (PATTERN_LEGACY_DEFINE.match(sl)) {
            return LEGACY_DEFINE;
        }
        if (PATTERN_LEGACY_DEFINELONG.match(sl)) {
            return LEGACY_DEFINELONG;
        }
        if (PATTERN_AFFECTATION_DEFINE.match(sl)) {
            return AFFECTATION_DEFINE;
        }
        if (PATTERN_AFFECTATION.match(sl)) {
            return AFFECTATION;
        }
        if (PATTERN_IFDEF.match(sl)) {
            return IFDEF;
        }
        if (PATTERN_UNDEF.match(sl)) {
            return UNDEF;
        }
        if (PATTERN_IFNDEF.match(sl)) {
            return IFNDEF;
        }
        if (PATTERN_ASSERT.match(sl)) {
            return ASSERT;
        }
        if (PATTERN_IF.match(sl)) {
            return IF;
        }
        if (PATTERN_DECLARE_RETURN_FUNCTION.match(sl)) {
            return DECLARE_RETURN_FUNCTION;
        }
        if (PATTERN_DECLARE_PROCEDURE.match(sl)) {
            return DECLARE_PROCEDURE;
        }
        if (PATTERN_ELSE.match(sl)) {
            return ELSE;
        }
        if (PATTERN_ELSEIF.match(sl)) {
            return ELSEIF;
        }
        if (PATTERN_ENDIF.match(sl)) {
            return ENDIF;
        }
        if (PATTERN_WHILE.match(sl)) {
            return WHILE;
        }
        if (PATTERN_ENDWHILE.match(sl)) {
            return ENDWHILE;
        }
        if (PATTERN_FOREACH.match(sl)) {
            return FOREACH;
        }
        if (PATTERN_ENDFOREACH.match(sl)) {
            return ENDFOREACH;
        }
        if (PATTERN_END_FUNCTION.match(sl)) {
            return END_FUNCTION;
        }
        if (PATTERN_RETURN.match(sl)) {
            return RETURN;
        }
        if (PATTERN_THEME.match(sl)) {
            return THEME;
        }
        if (PATTERN_INCLUDE.match(sl)) {
            return INCLUDE;
        }
        if (PATTERN_INCLUDE_SPRITES.match(sl)) {
            return INCLUDE_SPRITES;
        }
        if (PATTERN_INCLUDE_DEF.match(sl)) {
            return INCLUDE_DEF;
        }
        if (PATTERN_IMPORT.match(sl)) {
            return IMPORT;
        }
        if (PATTERN_STARTSUB.match(sl)) {
            return STARTSUB;
        }
        if (PATTERN_ENDSUB.match(sl)) {
            return ENDSUB;
        }
        if (PATTERN_INCLUDESUB.match(sl)) {
            return INCLUDESUB;
        }
        if (PATTERN_LOG.match(sl)) {
            return LOG;
        }
        if (PATTERN_DUMP_MEMORY.match(sl)) {
            return DUMP_MEMORY;
        }
        if (PATTERN_OPTION.match(sl)) {
            return OPTION;
        }
        return PLAIN;
    }

    public static boolean isQuote(char ch) {
        return ch == '\"' || ch == '\'';
    }

    public static boolean isSpaceChar(char ch) {
        return Character.isSpaceChar(ch);
    }

    public static boolean isLatinDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isLetterOrEmojiOrUnderscoreOrDigit(char ch) {
        return TLineType.isLetterOrUnderscore(ch) || TLineType.isLatinDigit(ch) || TLineType.isEmoji(ch);
    }

    public static boolean isLetterOrEmojiOrUnderscoreOrDollar(char ch) {
        return TLineType.isLetterOrUnderscore(ch) || ch == '$' || TLineType.isEmoji(ch);
    }

    private static boolean isLetterOrUnderscore(char ch) {
        return TLineType.isLetter(ch) || ch == '_';
    }

    private static boolean isLetter(char ch) {
        return Character.isLetter(ch);
    }

    private static boolean isEmoji(char ch) {
        return Character.isLowSurrogate(ch) || Character.isHighSurrogate(ch);
    }

    static {
        IDENTIFIER_WITH_UNICODE_SURROGATES_SUPPORT = new RegexLeaf("[\\p{L}\\uD800-\\uDBFF\\uDC00-\\uDFFF_][\\p{L}\\uD800-\\uDBFF\\uDC00-\\uDFFF_0-9]*");
        PATTERN_LEGACY_DEFINE = new RegexConcat(RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("!define"), RegexLeaf.spaceOneOrMore(), IDENTIFIER_WITH_UNICODE_SURROGATES_SUPPORT, new RegexLeaf("\\("));
        PATTERN_LEGACY_DEFINELONG = new RegexConcat(RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("!definelong"), RegexLeaf.spaceOneOrMore(), IDENTIFIER_WITH_UNICODE_SURROGATES_SUPPORT, new RegexLeaf("\\b"));
        PATTERN_AFFECTATION_DEFINE = new RegexConcat(RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("!define"), RegexLeaf.spaceOneOrMore(), IDENTIFIER_WITH_UNICODE_SURROGATES_SUPPORT, new RegexLeaf("\\b"));
        PATTERN_AFFECTATION = new RegexConcat(RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("!"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "(local|global)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\$?"), IDENTIFIER_WITH_UNICODE_SURROGATES_SUPPORT, RegexLeaf.spaceZeroOrMore(), new RegexLeaf("\\??="));
        PATTERN_COMMENT_SIMPLE1 = new RegexConcat(RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("'"));
        PATTERN_COMMENT_SIMPLE2 = new RegexConcat(RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("/'"), new RegexLeaf(".*"), new RegexLeaf("'/"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
        PATTERN_COMMENT_LONG_START = new RegexConcat(RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("/'"));
        PATTERN_IFDEF = TLineType.simpleKeyword("!ifdef");
        PATTERN_UNDEF = TLineType.simpleKeyword("!undef");
        PATTERN_IFNDEF = TLineType.simpleKeyword("!ifndef");
        PATTERN_ASSERT = TLineType.simpleKeyword("!assert");
        PATTERN_IF = TLineType.simpleKeyword("!if");
        PATTERN_DECLARE_RETURN_FUNCTION = new RegexConcat(RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("!"), new RegexLeaf(1, "(unquoted\\s|final\\s)*"), new RegexLeaf("function"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\$?"), IDENTIFIER_WITH_UNICODE_SURROGATES_SUPPORT);
        PATTERN_DECLARE_PROCEDURE = new RegexConcat(RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("!"), new RegexLeaf(1, "(unquoted\\s|final\\s)*"), new RegexLeaf("procedure"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("\\$?"), IDENTIFIER_WITH_UNICODE_SURROGATES_SUPPORT);
        PATTERN_ELSE = TLineType.simpleKeyword("!else");
        PATTERN_ELSEIF = TLineType.simpleKeyword("!elseif");
        PATTERN_ENDIF = TLineType.simpleKeyword("!endif");
        PATTERN_WHILE = TLineType.simpleKeyword("!while");
        PATTERN_ENDWHILE = TLineType.simpleKeyword("!endwhile");
        PATTERN_FOREACH = TLineType.simpleKeyword("!foreach");
        PATTERN_ENDFOREACH = TLineType.simpleKeyword("!endfor");
        PATTERN_END_FUNCTION = new RegexConcat(RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("!end"), RegexLeaf.spaceZeroOrMore(), new RegexOr(new RegexLeaf("function"), new RegexLeaf("definelong"), new RegexLeaf("procedure")), new RegexLeaf("\\b"));
        PATTERN_RETURN = TLineType.simpleKeyword("!return");
        PATTERN_THEME = TLineType.simpleKeyword("!theme");
        PATTERN_INCLUDE = new RegexConcat(RegexLeaf.start(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("!include"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexOr(new RegexLeaf("url"), new RegexLeaf("_many"), new RegexLeaf("_once"))), new RegexLeaf("\\b"));
        PATTERN_INCLUDE_SPRITES = TLineType.simpleKeyword("!include_sprites");
        PATTERN_INCLUDE_DEF = TLineType.simpleKeyword("!includedef");
        PATTERN_IMPORT = TLineType.simpleKeyword("!import");
        PATTERN_STARTSUB = TLineType.simpleKeyword("!startsub");
        PATTERN_ENDSUB = TLineType.simpleKeyword("!endsub");
        PATTERN_INCLUDESUB = TLineType.simpleKeyword("!includesub");
        PATTERN_LOG = TLineType.simpleKeyword("!log");
        PATTERN_DUMP_MEMORY = TLineType.simpleKeyword("!dump_memory");
        PATTERN_OPTION = TLineType.simpleKeyword("!option");
    }
}

