/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.DatabaseFunction;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NetException;
import oracle.net.ns.SessionAtts;

class T4CMAREngineNIO
extends T4CMAREngine {
    private static final String CLASS_NAME = T4CMAREngineNIO.class.getName();
    private NIONSDataChannel dataChannel;
    SessionAtts sAtts;
    private boolean bytesReadyToGo = false;
    private boolean isPipelineResponse = false;
    private T4CConnection conn;

    T4CMAREngineNIO(Communication net, T4CConnection conn) throws SQLException, IOException {
        if (net == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433).fillInStackTrace();
        }
        this.net = net;
        this.sAtts = net.getSessionAttributes();
        this.conn = conn;
        this.dataChannel = this.sAtts.dataChannel;
        this.types = new T4CTypeRep(this, true);
        this.types.setRep((byte)1, (byte)0);
        this.sAtts.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        this.sAtts.payloadDataBufferForRead.order(ByteOrder.LITTLE_ENDIAN);
        this.sAtts.payloadDataBufferForWrite.order(ByteOrder.LITTLE_ENDIAN);
    }

    private static void valueToUNV(long value, byte[] buffer) {
        buffer[0] = 0;
        if (value == 0L) {
            return;
        }
        int indexInBuffer = 0;
        boolean zeros = true;
        boolean negative = value < 0L;
        long absoluteValue = negative ? -value : value;
        for (int i = 0; i < 8; ++i) {
            byte b = (byte)(absoluteValue >>> 8 * (7 - i) & 0xFFL);
            if (zeros && b == 0) continue;
            zeros = false;
            buffer[++indexInBuffer] = b;
        }
        buffer[0] = (byte)indexInBuffer;
        if (negative) {
            buffer[0] = (byte)(buffer[0] | 0xFFFFFF80);
        }
    }

    @Override
    final void marshalSB1(byte value) throws IOException {
        this.prepareForMarshall(1);
        this.sAtts.payloadDataBufferForWrite.put(value);
        this.bytesReadyToGo = true;
    }

    @Override
    final void marshalUB1(short value) throws IOException {
        this.marshalSB1((byte)value);
    }

    @Override
    final void marshalSB2(short value) throws IOException {
        this.prepareForMarshall(3);
        if (this.types.rep[1] != 1) {
            this.sAtts.payloadDataBufferForWrite.putShort(value);
        } else if (value == 0) {
            this.sAtts.payloadDataBufferForWrite.put((byte)0);
        } else {
            boolean negative = value < 0;
            short absoluteValue = negative ? -value : value;
            if (absoluteValue <= 255) {
                if (negative) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)-127);
                } else {
                    this.sAtts.payloadDataBufferForWrite.put((byte)1);
                }
                this.sAtts.payloadDataBufferForWrite.put((byte)absoluteValue);
            } else {
                if (negative) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)-126);
                } else {
                    this.sAtts.payloadDataBufferForWrite.put((byte)2);
                }
                this.sAtts.payloadDataBufferForWrite.putShort(absoluteValue);
            }
        }
    }

    @Override
    final void marshalUB2(int value) throws IOException {
        this.prepareForMarshall(3);
        if (this.types.rep[1] != 1) {
            this.sAtts.payloadDataBufferForWrite.putShort((short)value);
        } else if (value == 0) {
            this.sAtts.payloadDataBufferForWrite.put((byte)0);
        } else if (value <= 255) {
            this.sAtts.payloadDataBufferForWrite.put((byte)1);
            this.sAtts.payloadDataBufferForWrite.put((byte)value);
        } else {
            this.sAtts.payloadDataBufferForWrite.put((byte)2);
            this.sAtts.payloadDataBufferForWrite.putShort((short)value);
        }
        this.bytesReadyToGo = true;
    }

    @Override
    void marshalNativeUB2(short value, boolean isLSB) throws IOException {
        try {
            byte rep = this.types.getRep((byte)1);
            byte newRep = (byte)(0 | (isLSB ? 2 : 0));
            this.types.setRep((byte)1, newRep);
            this.marshalUB2(value);
            this.types.setRep((byte)1, rep);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    final void marshalSB4(int value) throws IOException {
        this.prepareForMarshall(5);
        if (this.types.rep[2] != 1) {
            this.sAtts.payloadDataBufferForWrite.putInt(value);
        } else if (value == 0) {
            this.sAtts.payloadDataBufferForWrite.put((byte)0);
        } else {
            int absoluteValue;
            boolean negative = value < 0;
            int n = absoluteValue = negative ? -value : value;
            if (absoluteValue <= 255) {
                if (!negative) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)1);
                } else {
                    this.sAtts.payloadDataBufferForWrite.put((byte)-127);
                }
                this.sAtts.payloadDataBufferForWrite.put((byte)absoluteValue);
            } else if (absoluteValue <= 65535) {
                if (!negative) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)2);
                } else {
                    this.sAtts.payloadDataBufferForWrite.put((byte)-126);
                }
                this.sAtts.payloadDataBufferForWrite.putShort((short)absoluteValue);
            } else if (absoluteValue < 26) {
                T4CMAREngineNIO.valueToUNV(value, this.tmpBuffer10);
                this.sAtts.payloadDataBufferForWrite.put(this.tmpBuffer10, 0, (this.tmpBuffer10[0] & 0x7F) + 1);
            } else {
                if (!negative) {
                    this.sAtts.payloadDataBufferForWrite.put((byte)4);
                } else {
                    this.sAtts.payloadDataBufferForWrite.put((byte)-124);
                }
                this.sAtts.payloadDataBufferForWrite.putInt(absoluteValue);
            }
        }
        this.bytesReadyToGo = true;
    }

    @Override
    final void marshalUB4(long value) throws IOException {
        this.prepareForMarshall(5);
        if (this.types.rep[2] != 1) {
            this.sAtts.payloadDataBufferForWrite.putInt((int)value);
        } else {
            long absoluteValue;
            boolean negative = value < 0L;
            long l = absoluteValue = negative ? -value : value;
            if (absoluteValue == 0L) {
                this.sAtts.payloadDataBufferForWrite.put((byte)0);
            } else if (absoluteValue <= 255L) {
                this.sAtts.payloadDataBufferForWrite.put((byte)1);
                this.sAtts.payloadDataBufferForWrite.put((byte)absoluteValue);
            } else if (absoluteValue <= 65535L) {
                this.sAtts.payloadDataBufferForWrite.put((byte)2);
                this.sAtts.payloadDataBufferForWrite.putShort((short)absoluteValue);
            } else if (absoluteValue <= 0xFFFFFFL) {
                T4CMAREngineNIO.valueToUNV(absoluteValue, this.tmpBuffer10);
                this.sAtts.payloadDataBufferForWrite.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
            } else {
                this.sAtts.payloadDataBufferForWrite.put((byte)4);
                this.sAtts.payloadDataBufferForWrite.putInt((int)absoluteValue);
            }
        }
        this.bytesReadyToGo = true;
    }

    @Override
    final void marshalSB8(long value) throws IOException {
        this.prepareForMarshall(9);
        if (this.types.rep[3] != 1) {
            throw new IOException("TODO: SB8 in UNV representation only");
        }
        T4CMAREngineNIO.valueToUNV(value, this.tmpBuffer10);
        this.sAtts.payloadDataBufferForWrite.put(this.tmpBuffer10, 0, (this.tmpBuffer10[0] & 0x7F) + 1);
    }

    @Override
    final void marshalUB8(long value) throws IOException {
        this.prepareForMarshall(9);
        if (this.types.rep[3] != 1) {
            this.sAtts.payloadDataBufferForWrite.putLong(value);
        } else if (value == 0L) {
            this.sAtts.payloadDataBufferForWrite.put((byte)0);
        } else {
            boolean zeros = true;
            int indexInBuffer = 0;
            for (int i = 0; i < 8; ++i) {
                byte b = (byte)(value >>> 8 * (7 - i) & 0xFFL);
                if (zeros && b == 0) continue;
                zeros = false;
                this.tmpBuffer10[++indexInBuffer] = b;
            }
            this.tmpBuffer10[0] = (byte)indexInBuffer;
            this.sAtts.payloadDataBufferForWrite.put(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
        }
        this.bytesReadyToGo = true;
    }

    @Override
    final void marshalB1Array(byte[] value) throws IOException {
        this.marshalB1Array(value, 0, value.length);
    }

    @Override
    final void marshalB1Array(byte[] value, int off, int len) throws IOException {
        this.prepareForMarshall(1);
        int bytesToWriteInNextCall = 0;
        for (int bytesWrittenSoFar = 0; bytesWrittenSoFar < len; bytesWrittenSoFar += bytesToWriteInNextCall) {
            this.prepareForMarshall(len - bytesWrittenSoFar);
            bytesToWriteInNextCall = Math.min(this.sAtts.payloadDataBufferForWrite.remaining(), len - bytesWrittenSoFar);
            this.sAtts.payloadDataBufferForWrite.put(value, off + bytesWrittenSoFar, bytesToWriteInNextCall);
            this.bytesReadyToGo = true;
        }
    }

    @Override
    final byte unmarshalSB1() throws SQLException, IOException {
        byte result = (byte)this.unmarshalSB2();
        return result;
    }

    @Override
    final short unmarshalUB1() throws SQLException, IOException {
        this.prepareForUnmarshall();
        short value = (short)(this.sAtts.payloadDataBufferForRead.get() & 0xFF);
        return value;
    }

    @Override
    final short unmarshalSB2() throws SQLException, IOException {
        this.prepareForUnmarshall();
        if (this.types.rep[1] != 1 && this.sAtts.payloadDataBufferForRead.remaining() >= 2) {
            return this.sAtts.payloadDataBufferForRead.getShort();
        }
        short result = (short)this.unmarshalUB2();
        return result;
    }

    @Override
    final int unmarshalUB2() throws SQLException, IOException {
        this.prepareForUnmarshall();
        int value = (int)this.buffer2Value((byte)1);
        return value & 0xFFFF;
    }

    @Override
    final int unmarshalSB4() throws SQLException, IOException {
        this.prepareForUnmarshall();
        if (this.types.rep[2] != 1 && this.sAtts.payloadDataBufferForRead.remaining() >= 4) {
            return this.sAtts.payloadDataBufferForRead.getInt();
        }
        return (int)this.buffer2Value((byte)2);
    }

    @Override
    final int unmarshalSB4(byte[] buffer) throws SQLException, IOException {
        this.prepareForUnmarshall();
        long value = this.buffer2Value((byte)2, new ByteArrayInputStream(buffer));
        return (int)value;
    }

    @Override
    final long unmarshalSB8() throws SQLException, IOException {
        this.prepareForUnmarshall();
        long value = this.buffer2Value((byte)3);
        return value;
    }

    @Override
    final long unmarshalUB4() throws SQLException, IOException {
        return (long)this.unmarshalSB4() & 0xFFFFFFFFL;
    }

    @Override
    byte[] unmarshalNBytes(int n) throws SQLException, IOException {
        byte[] tmpBuffer = new byte[n];
        this.getNBytes(tmpBuffer, 0, n);
        return tmpBuffer;
    }

    @Override
    int unmarshalNBytes(byte[] buf, int off, int n) throws SQLException, IOException {
        return this.getNBytes(buf, off, n);
    }

    @Override
    int getNBytes(byte[] buf, int off, int len) throws SQLException, IOException {
        int bytesReadSoFar;
        int pos;
        if (off + len > buf.length) {
            len = buf.length - off;
        }
        boolean cnt = false;
        for (bytesReadSoFar = 0; bytesReadSoFar < len; bytesReadSoFar += this.sAtts.payloadDataBufferForRead.position() - pos) {
            if (!this.sAtts.payloadDataBufferForRead.hasRemaining()) {
                this.prepareForUnmarshall();
            }
            pos = this.sAtts.payloadDataBufferForRead.position();
            this.sAtts.payloadDataBufferForRead.get(buf, off + bytesReadSoFar, Math.min(len - bytesReadSoFar, this.sAtts.payloadDataBufferForRead.remaining()));
        }
        return bytesReadSoFar;
    }

    @Override
    byte[] getNBytes(int n) throws SQLException, IOException {
        return this.unmarshalNBytes(n);
    }

    @Override
    void skipNBytes(int n) throws SQLException, IOException {
        int bytesReadSoFar = 0;
        int pos = this.sAtts.payloadDataBufferForRead.position();
        while (bytesReadSoFar < n) {
            if (this.sAtts.payloadDataBufferForRead.remaining() >= n - bytesReadSoFar) {
                this.sAtts.payloadDataBufferForRead.position(this.sAtts.payloadDataBufferForRead.position() + (n - bytesReadSoFar));
                bytesReadSoFar = n;
                continue;
            }
            if (this.sAtts.payloadDataBufferForRead.remaining() > 0) {
                bytesReadSoFar += this.sAtts.payloadDataBufferForRead.remaining();
                this.sAtts.payloadDataBufferForRead.position(this.sAtts.payloadDataBufferForRead.position() + this.sAtts.payloadDataBufferForRead.remaining());
            }
            this.prepareForUnmarshall();
        }
    }

    @Override
    byte[] unmarshalTEXT(int bytes) throws SQLException, IOException {
        byte[] buffer;
        int offset = 0;
        byte[] tmpBuffer = new byte[bytes];
        while (offset < bytes) {
            this.prepareForUnmarshall();
            tmpBuffer[offset] = this.sAtts.payloadDataBufferForRead.get();
            if (tmpBuffer[offset++] != 0) continue;
        }
        if (tmpBuffer.length == --offset) {
            buffer = tmpBuffer;
        } else {
            buffer = new byte[offset];
            System.arraycopy(tmpBuffer, 0, buffer, 0, offset);
        }
        return buffer;
    }

    @Override
    final long buffer2Value(byte repOffset) throws SQLException, IOException {
        long returnValue = 0L;
        byte rep = this.types.rep[repOffset];
        int numberOfBytes = 0;
        boolean negativeUNV = false;
        if (rep == 1) {
            numberOfBytes = this.sAtts.payloadDataBufferForRead.get();
            if (numberOfBytes == 0) {
                return 0L;
            }
            if ((numberOfBytes & 0x80) > 0) {
                numberOfBytes &= 0x7F;
                negativeUNV = true;
            }
        } else {
            switch (repOffset) {
                case 1: {
                    numberOfBytes = 2;
                    break;
                }
                case 2: {
                    numberOfBytes = 4;
                    break;
                }
                case 3: {
                    numberOfBytes = 8;
                }
            }
        }
        if (this.sAtts.payloadDataBufferForRead.remaining() >= numberOfBytes && (numberOfBytes == 1 || numberOfBytes == 2 || numberOfBytes == 4 || numberOfBytes == 8)) {
            returnValue = numberOfBytes == 1 ? (long)this.sAtts.payloadDataBufferForRead.get() & 0xFFL : (numberOfBytes == 2 ? (long)this.sAtts.payloadDataBufferForRead.getShort() & 0xFFFFL : (numberOfBytes == 4 ? (long)this.sAtts.payloadDataBufferForRead.getInt() & 0xFFFFFFFFL : this.sAtts.payloadDataBufferForRead.getLong()));
        } else {
            this.unmarshalNBytes(this.tmpBuffer8, 0, numberOfBytes);
            for (int byteOffset = 0; byteOffset < numberOfBytes; ++byteOffset) {
                if (rep == 1 || rep != 2) {
                    returnValue |= ((long)this.tmpBuffer8[byteOffset] & 0xFFL) << 8 * (numberOfBytes - byteOffset - 1);
                    continue;
                }
                returnValue |= ((long)this.tmpBuffer8[byteOffset] & 0xFFL) << 8 * byteOffset;
            }
        }
        if (negativeUNV) {
            returnValue *= -1L;
        }
        return returnValue;
    }

    @Override
    void setByteOrder(byte rep) {
        if (rep == 2) {
            this.sAtts.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        } else {
            this.sAtts.setByteOrder(ByteOrder.BIG_ENDIAN);
        }
        if (this.sAtts.payloadDataBufferForRead != null) {
            this.sAtts.payloadDataBufferForRead.order(this.sAtts.getByteOrder());
        }
        if (this.sAtts.payloadDataBufferForWrite != null) {
            this.sAtts.payloadDataBufferForWrite.order(this.sAtts.getByteOrder());
        }
    }

    @Override
    boolean sentCancel() {
        return this.conn.sentCancel;
    }

    @Override
    protected void flush() throws IOException {
        this.flush(0);
    }

    @Override
    protected void beginPipelineRequest() throws IOException {
        this.net.enqueueBlockedWrites(true);
    }

    @Override
    protected boolean endPipelineRequest() throws IOException {
        this.flush(2048);
        if (!this.net.completeBlockedWrites()) {
            return false;
        }
        this.net.enqueueBlockedWrites(false);
        return true;
    }

    @Override
    protected void beginPipelineResponse() {
        this.isPipelineResponse = true;
    }

    @Override
    protected void endPipelineResponse() throws IOException {
        this.isPipelineResponse = false;
    }

    private void flush(int nsDataFlags) throws IOException {
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "flush", "flush flag={0}", (String)null, (Throwable)null, (Object)nsDataFlags);
        try {
            if (!this.sAtts.isConnected()) {
                throw new NetException(17900);
            }
            if (this.bytesReadyToGo) {
                this.dataChannel.writeDataToSocketChannel(nsDataFlags);
                this.bytesReadyToGo = false;
            }
        }
        catch (NetException ne) {
            ne.setNetConnectionId(this.sAtts.getNetConnectionId());
            throw ne;
        }
    }

    private void prepareForUnmarshall() throws IOException, SQLException {
        if (this.bytesReadyToGo) {
            this.flush(2048);
        }
        if (this.sAtts.payloadDataBufferForRead.hasRemaining()) {
            return;
        }
        if (!this.sAtts.isConnected()) {
            throw new NetException(17900);
        }
        try {
            while (!this.sAtts.payloadDataBufferForRead.hasRemaining()) {
                this.dataChannel.readDataFromSocketChannel();
            }
        }
        catch (BreakNetException e) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareForUnmarshall", "Break received from server. Responding with reset...", null, null, new Object[0]);
            if (!this.isPipelineResponse) {
                this.net.sendReset();
            }
            throw e;
        }
        catch (NetException ne) {
            ne.setNetConnectionId(this.sAtts.getNetConnectionId());
            if (ne.isNSControlCommandError()) {
                this.clearWriteBuffer();
            }
            if ((ne.getErrorNumber() == 17902 || ne.getErrorNumber() == 17800 || ne.getErrorNumber() == 17909) && this.net.getSessionAttributes().getcOption() != null) {
                int localPort;
                NVPair nvp = null;
                String serverType = "unknown";
                try {
                    nvp = new NVFactory().createNVPair(this.net.getSessionAttributes().getcOption().conn_data.toString());
                    NVNavigator nav = new NVNavigator();
                    NVPair connDataNVP = nav.findNVPair(nvp, "CONNECT_DATA");
                    NVPair servernvp = nav.findNVPair(connDataNVP, "SERVER");
                    if (servernvp != null) {
                        serverType = servernvp.getAtom();
                    }
                }
                catch (NLException nav) {
                    // empty catch block
                }
                InetAddress localAddr = null;
                try {
                    localAddr = this.net.getSessionAttributes().getNTAdapter().getSocketChannel().socket().getLocalAddress();
                    localPort = this.net.getSessionAttributes().getNTAdapter().getSocketChannel().socket().getLocalPort();
                }
                catch (UnsupportedOperationException e) {
                    localAddr = InetAddress.getLoopbackAddress();
                    localPort = 0;
                }
                throw (NetException)new NetException(3113, null, false, "client", localAddr, String.valueOf(localPort), this.net.getSessionAttributes().getcOption().host, String.valueOf(this.net.getSessionAttributes().getcOption().port), this.net.getSessionAttributes().getcOption().protocol, this.net.getSessionAttributes().getcOption().service_name, "client", serverType, this.conn.thinVsessionProgram, this.conn.sessionProperties != null ? this.conn.getServerSessionInfo("AUTH_SERVER_PID") : null, this.conn.sessionProperties != null ? this.conn.getServerSessionInfo("AUTH_SESSION_ID") : null, this.conn.sessionProperties != null ? this.conn.getServerSessionInfo("AUTH_SERIAL_NUM") : null, this.conn.getUserName() != null ? this.conn.getUserName() : null, this.conn.lastExecutedFunCode != 0 ? DatabaseFunction.valueOfFunctionCode(this.conn.lastExecutedFunCode).getDescription() : null, this.conn.getNetConnectionId(), this.conn.getSecurityInformation() != null ? ", nne_encryption=" + this.conn.getSecurityInformation().getEncryptionAlgorithm() + ", nne_checksumming=" + this.conn.getSecurityInformation().getChecksummingAlgorithm() + ", authentication=" + this.conn.getSecurityInformation().getAuthenticationAdaptor() : null).initCause(ne).fillInStackTrace();
            }
            throw ne;
        }
    }

    private void prepareForMarshall(int numberBytesToBeWritten) throws IOException {
        if (this.sAtts.payloadDataBufferForWrite.remaining() >= numberBytesToBeWritten) {
            return;
        }
        if (this.bytesReadyToGo) {
            this.flush();
        }
        this.sAtts.prepareWriteBuffer();
    }

    @Override
    void writeZeroCopyIO(byte[] userBuffer, int offset, int length) throws IOException, NetException {
        try {
            this.flush();
            this.net.writeZeroCopyIO(userBuffer, offset, length);
        }
        catch (NetException ne) {
            ne.setNetConnectionId(this.sAtts.getNetConnectionId());
        }
    }

    @Override
    void writeZeroCopyIOHeader(boolean flushBuffer, int lengthInDD, boolean isLastDD) throws IOException {
        try {
            if (flushBuffer) {
                this.flush();
            }
            this.net.writeZeroCopyIOHeader(flushBuffer, lengthInDD, isLastDD);
        }
        catch (NetException ne) {
            ne.setNetConnectionId(this.sAtts.getNetConnectionId());
        }
    }

    @Override
    void writeZeroCopyIOData(byte[] userBuffer, int offset, int length) throws IOException {
        try {
            this.net.writeZeroCopyIOData(userBuffer, offset, length);
        }
        catch (NetException ne) {
            ne.setNetConnectionId(this.sAtts.getNetConnectionId());
        }
    }

    @Override
    void clearWriteBuffer() {
        this.sAtts.prepareWriteBuffer();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.sAtts.getDiagnosable();
    }
}

