/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class RingBuffer<T> {
    public static final int DEFAULT_CAPACITY = 64;
    private final T[] ring;
    private int pointer = 0;
    private int nUpdates = 0;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();

    public RingBuffer() {
        this(64);
    }

    public RingBuffer(int capacity) {
        Object[] t = new Object[capacity];
        this.ring = t;
    }

    private int next(int i) {
        return (i + 1) % this.getCapacity();
    }

    private int previous(int i) {
        int j = i - 1;
        return j < 0 ? this.getCapacity() - 1 : j;
    }

    public final void addItem(T item) {
        this.wLock.lock();
        try {
            this.pointer = this.next(this.pointer);
            this.ring[this.pointer] = item;
            if (++this.nUpdates < 0) {
                this.nUpdates = Integer.MAX_VALUE;
            }
        }
        finally {
            this.wLock.unlock();
        }
    }

    public final int getCapacity() {
        return this.ring.length;
    }

    public final int getNumberOfUpdates() {
        this.rLock.lock();
        try {
            int n = this.nUpdates;
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<T> getAsList() {
        this.rLock.lock();
        try {
            ArrayList<T> listHistory = new ArrayList<T>();
            int index = this.pointer;
            for (int i = 0; i < Math.min(this.getCapacity(), this.getNumberOfUpdates()); ++i) {
                listHistory.add(this.ring[index]);
                index = this.previous(index);
            }
            ArrayList<T> arrayList = listHistory;
            return arrayList;
        }
        finally {
            this.rLock.unlock();
        }
    }

    public String toString() {
        this.rLock.lock();
        try {
            String string = this.toString(Math.min(this.getCapacity(), this.getNumberOfUpdates()));
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(int nItems) {
        StringBuilder sb = new StringBuilder();
        this.rLock.lock();
        try {
            int i = this.pointer;
            int n = nItems;
            if (n < 1) {
                String string = "";
                return string;
            }
            do {
                T item;
                if (null == (item = this.ring[i])) continue;
                sb.append(item.toString());
            } while ((i = this.previous(i)) != this.pointer && --n > 0);
        }
        finally {
            this.rLock.unlock();
        }
        return sb.toString();
    }

    public final void clear() {
        this.wLock.lock();
        try {
            this.pointer = 0;
            this.nUpdates = 0;
        }
        finally {
            this.wLock.unlock();
        }
    }
}

