/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron.utility;

import com.hankcs.hanlp.corpus.document.CorpusLoader;
import com.hankcs.hanlp.corpus.document.Document;
import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.corpus.document.sentence.word.CompoundWord;
import com.hankcs.hanlp.corpus.document.sentence.word.IWord;
import com.hankcs.hanlp.corpus.document.sentence.word.Word;
import com.hankcs.hanlp.corpus.io.IOUtil;
import com.hankcs.hanlp.dictionary.other.CharTable;
import com.hankcs.hanlp.model.perceptron.PerceptronSegmenter;
import com.hankcs.hanlp.model.perceptron.instance.InstanceHandler;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.model.perceptron.utility.IOUtility;
import com.hankcs.hanlp.tokenizer.lexical.NERecognizer;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;

public class Utility {
    public static double[] prf(int[] stat) {
        return Utility.prf(stat[0], stat[1], stat[2]);
    }

    public static double[] prf(int goldTotal, int predTotal, int correct) {
        double precision = (double)correct * 100.0 / (double)predTotal;
        double recall = (double)correct * 100.0 / (double)goldTotal;
        double[] performance = new double[]{precision, recall, 2.0 * precision * recall / (precision + recall)};
        return performance;
    }

    public static void shuffleArray(int[] ar) {
        Random rnd = new Random();
        for (int i = ar.length - 1; i > 0; --i) {
            int index = rnd.nextInt(i + 1);
            int a = ar[index];
            ar[index] = ar[i];
            ar[i] = a;
        }
    }

    public static <T> void shuffleArray(T[] ar) {
        Random rnd = new Random();
        for (int i = ar.length - 1; i > 0; --i) {
            int index = rnd.nextInt(i + 1);
            T a = ar[index];
            ar[index] = ar[i];
            ar[i] = a;
        }
    }

    public static String normalize(String text) {
        return CharTable.convert(text);
    }

    public static void convertPKUtoCWS(String inputFolder, String outputFile, final int begin, final int end) throws IOException {
        final BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
        CorpusLoader.walk(inputFolder, new CorpusLoader.Handler(){
            int doc = 0;

            @Override
            public void handle(Document document) {
                ++this.doc;
                if (this.doc < begin || this.doc > end) {
                    return;
                }
                try {
                    List sentenceList = Utility.convertComplexWordToSimpleWord(document.getComplexSentenceList());
                    if (sentenceList.size() == 0) {
                        return;
                    }
                    for (List sentence : sentenceList) {
                        if (sentence.size() == 0) continue;
                        int index = 0;
                        for (IWord iWord : sentence) {
                            bw.write(iWord.getValue());
                            if (++index == sentence.size()) continue;
                            bw.write(32);
                        }
                        bw.newLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        bw.close();
    }

    public static void convertPKUtoPOS(String inputFolder, String outputFile, final int begin, final int end) throws IOException {
        final BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8"));
        CorpusLoader.walk(inputFolder, new CorpusLoader.Handler(){
            int doc = 0;

            @Override
            public void handle(Document document) {
                ++this.doc;
                if (this.doc < begin || this.doc > end) {
                    return;
                }
                try {
                    List<List<Word>> sentenceList = document.getSimpleSentenceList();
                    if (sentenceList.size() == 0) {
                        return;
                    }
                    for (List<Word> sentence : sentenceList) {
                        if (sentence.size() == 0) continue;
                        int index = 0;
                        for (IWord iWord : sentence) {
                            bw.write(iWord.toString());
                            if (++index == sentence.size()) continue;
                            bw.write(32);
                        }
                        bw.newLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        bw.close();
    }

    private static List<List<Word>> convertComplexWordToSimpleWord(List<List<IWord>> document) {
        String[] nerTag = new String[]{"nr", "ns", "nt"};
        ArrayList<List<Word>> output = new ArrayList<List<Word>>(document.size());
        for (List<IWord> sentence : document) {
            ArrayList<Word> s = new ArrayList<Word>(sentence.size());
            for (IWord iWord : sentence) {
                if (iWord instanceof Word) {
                    s.add((Word)iWord);
                    continue;
                }
                if (Utility.isNer(iWord, nerTag)) {
                    s.add(new Word(iWord.getValue(), iWord.getLabel()));
                    continue;
                }
                for (Word word : ((CompoundWord)iWord).innerList) {
                    Utility.isNer(word, nerTag);
                    s.add(word);
                }
            }
            output.add(s);
        }
        return output;
    }

    private static boolean isNer(IWord word, String[] nerTag) {
        for (String tag : nerTag) {
            if (!word.getLabel().startsWith(tag)) continue;
            word.setLabel(tag);
            return true;
        }
        return false;
    }

    public static String[] toWordArray(List<Word> wordList) {
        String[] wordArray = new String[wordList.size()];
        int i = -1;
        for (Word word : wordList) {
            wordArray[++i] = word.getValue();
        }
        return wordArray;
    }

    public static int[] evaluateCWS(String developFile, final PerceptronSegmenter segmenter) throws IOException {
        final int[] stat = new int[3];
        Arrays.fill(stat, 0);
        IOUtility.loadInstance(developFile, new InstanceHandler(){

            @Override
            public boolean process(Sentence sentence) {
                List<Word> wordList = sentence.toSimpleWordList();
                String[] wordArray = Utility.toWordArray(wordList);
                stat[0] = stat[0] + wordArray.length;
                String text = TextUtility.combine(wordArray);
                String[] predArray = segmenter.segment(text).toArray(new String[0]);
                stat[1] = stat[1] + predArray.length;
                int goldIndex = 0;
                int predIndex = 0;
                int goldLen = 0;
                int predLen = 0;
                while (goldIndex < wordArray.length && predIndex < predArray.length) {
                    if (goldLen == predLen) {
                        if (wordArray[goldIndex].equals(predArray[predIndex])) {
                            stat[2] = stat[2] + 1;
                            goldLen += wordArray[goldIndex].length();
                            predLen += wordArray[goldIndex].length();
                            ++goldIndex;
                            ++predIndex;
                            continue;
                        }
                        goldLen += wordArray[goldIndex].length();
                        predLen += predArray[predIndex].length();
                        ++goldIndex;
                        ++predIndex;
                        continue;
                    }
                    if (goldLen < predLen) {
                        goldLen += wordArray[goldIndex].length();
                        ++goldIndex;
                        continue;
                    }
                    predLen += predArray[predIndex].length();
                    ++predIndex;
                }
                return false;
            }
        });
        return stat;
    }

    public static List<String[]> convertSentenceToNER(Sentence sentence, NERTagSet tagSet) {
        LinkedList<String[]> collector = new LinkedList<String[]>();
        Set<String> nerLabels = tagSet.nerLabels;
        for (IWord word : sentence.wordList) {
            if (word instanceof CompoundWord) {
                List<Word> wordList = ((CompoundWord)word).innerList;
                Word[] words = wordList.toArray(new Word[0]);
                if (nerLabels.contains(word.getLabel())) {
                    collector.add(new String[]{words[0].value, words[0].label, tagSet.B_TAG_PREFIX + word.getLabel()});
                    for (int i = 1; i < words.length - 1; ++i) {
                        collector.add(new String[]{words[i].value, words[i].label, tagSet.M_TAG_PREFIX + word.getLabel()});
                    }
                    collector.add(new String[]{words[words.length - 1].value, words[words.length - 1].label, tagSet.E_TAG_PREFIX + word.getLabel()});
                    continue;
                }
                for (Word w : words) {
                    collector.add(new String[]{w.value, w.label, tagSet.O_TAG});
                }
                continue;
            }
            if (nerLabels.contains(word.getLabel())) {
                collector.add(new String[]{word.getValue(), word.getLabel(), tagSet.S_TAG});
                continue;
            }
            collector.add(new String[]{word.getValue(), word.getLabel(), tagSet.O_TAG});
        }
        return collector;
    }

    public static void normalize(Sentence sentence) {
        for (IWord word : sentence.wordList) {
            if (word instanceof CompoundWord) {
                for (Word child : ((CompoundWord)word).innerList) {
                    child.setValue(CharTable.convert(child.getValue()));
                }
                continue;
            }
            word.setValue(CharTable.convert(word.getValue()));
        }
    }

    public static Map<String, double[]> evaluateNER(NERecognizer recognizer, String goldFile) {
        TreeMap<String, double[]> scores = new TreeMap<String, double[]>();
        double[] avg = new double[]{0.0, 0.0, 0.0};
        scores.put("avg.", avg);
        NERTagSet tagSet = recognizer.getNERTagSet();
        IOUtil.LineIterator lineIterator = new IOUtil.LineIterator(goldFile);
        for (String line : lineIterator) {
            double[] s;
            String type;
            Sentence sentence;
            if ((line = line.trim()).isEmpty() || (sentence = Sentence.create(line)) == null) continue;
            String[][] table = Utility.reshapeNER(Utility.convertSentenceToNER(sentence, tagSet));
            Set<String> pred = Utility.combineNER(recognizer.recognize(table[0], table[1]), tagSet);
            Set<String> gold = Utility.combineNER(table[2], tagSet);
            for (String p : pred) {
                type = p.split("\t")[2];
                s = (double[])scores.get(type);
                if (s == null) {
                    s = new double[]{0.0, 0.0, 0.0};
                    scores.put(type, s);
                }
                if (gold.contains(p)) {
                    s[2] = s[2] + 1.0;
                    avg[2] = avg[2] + 1.0;
                }
                s[0] = s[0] + 1.0;
                avg[0] = avg[0] + 1.0;
            }
            for (String g : gold) {
                type = g.split("\t")[2];
                s = (double[])scores.get(type);
                if (s == null) {
                    s = new double[]{0.0, 0.0, 0.0};
                    scores.put(type, s);
                }
                s[1] = s[1] + 1.0;
                avg[1] = avg[1] + 1.0;
            }
        }
        for (double[] s : scores.values()) {
            if (s[2] == 0.0) {
                s[0] = 0.0;
                s[1] = 0.0;
                continue;
            }
            s[1] = s[2] / s[1] * 100.0;
            s[0] = s[2] / s[0] * 100.0;
            s[2] = 2.0 * s[0] * s[1] / (s[0] + s[1]);
        }
        return scores;
    }

    public static Set<String> combineNER(String[] nerArray, NERTagSet tagSet) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        int begin = 0;
        String prePos = NERTagSet.posOf(nerArray[0]);
        for (int i = 1; i < nerArray.length; ++i) {
            if (nerArray[i].charAt(0) == tagSet.B_TAG_CHAR || nerArray[i].charAt(0) == tagSet.S_TAG_CHAR || nerArray[i].charAt(0) == tagSet.O_TAG_CHAR) {
                if (i - begin > 1) {
                    result.add(String.format("%d\t%d\t%s", begin, i, prePos));
                }
                begin = i;
            }
            prePos = NERTagSet.posOf(nerArray[i]);
        }
        if (nerArray.length - 1 - begin >= 1) {
            result.add(String.format("%d\t%d\t%s", begin, nerArray.length, prePos));
        }
        return result;
    }

    public static String[][] reshapeNER(List<String[]> ner) {
        String[] wordArray = new String[ner.size()];
        String[] posArray = new String[ner.size()];
        String[] nerArray = new String[ner.size()];
        Utility.reshapeNER(ner, wordArray, posArray, nerArray);
        return new String[][]{wordArray, posArray, nerArray};
    }

    public static void reshapeNER(List<String[]> collector, String[] wordArray, String[] posArray, String[] tagArray) {
        int i = 0;
        for (String[] tuple : collector) {
            wordArray[i] = tuple[0];
            posArray[i] = tuple[1];
            tagArray[i] = tuple[2];
            ++i;
        }
    }

    public static void printNERScore(Map<String, double[]> scores) {
        System.out.printf("%4s\t%6s\t%6s\t%6s\n", "NER", "P", "R", "F1");
        for (Map.Entry<String, double[]> entry : scores.entrySet()) {
            String type = entry.getKey();
            double[] s = entry.getValue();
            System.out.printf("%4s\t%6.2f\t%6.2f\t%6.2f\n", type, s[0], s[1], s[2]);
        }
    }
}

