/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.models.KeyManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oid4vc.issuance.signing.CredentialSigner;
import org.keycloak.protocol.oid4vc.issuance.signing.CredentialSignerException;
import org.keycloak.protocol.oid4vc.model.CredentialBuildConfig;

public abstract class AbstractCredentialSigner<T>
implements CredentialSigner<T> {
    protected final KeycloakSession keycloakSession;

    protected AbstractCredentialSigner(KeycloakSession keycloakSession) {
        this.keycloakSession = keycloakSession;
    }

    protected SignatureSignerContext getSigner(CredentialBuildConfig credentialBuildConfig) {
        if (credentialBuildConfig.getSigningAlgorithm() == null) {
            throw new CredentialSignerException(String.format("A signing algorithm must be configured for credential %s", credentialBuildConfig.getCredentialId()));
        }
        KeyWrapper signingKey = this.getKeyWithKidSubstitute(credentialBuildConfig.getSigningKeyId(), credentialBuildConfig.getSigningAlgorithm(), credentialBuildConfig.getOverrideKeyId());
        SignatureProvider signatureProvider = (SignatureProvider)this.keycloakSession.getProvider(SignatureProvider.class, credentialBuildConfig.getSigningAlgorithm());
        return signatureProvider.signer(signingKey);
    }

    protected KeyWrapper getKeyWithKidSubstitute(String keyId, String algorithm, String keyIdSubstitute) {
        KeyWrapper signingKey = this.getKey(keyId, algorithm);
        if (signingKey == null) {
            throw new CredentialSignerException(String.format("No key for id %s and algorithm %s available.", keyId, algorithm));
        }
        if (keyIdSubstitute != null) {
            signingKey = signingKey.cloneKey();
            signingKey.setKid(keyIdSubstitute);
        }
        return signingKey;
    }

    protected KeyWrapper getKey(String keyId, String algorithm) {
        RealmModel realm = this.keycloakSession.getContext().getRealm();
        KeyManager keys = this.keycloakSession.keys();
        if (keyId == null) {
            return keys.getActiveKey(realm, KeyUse.SIG, algorithm);
        }
        return keys.getKey(realm, keyId, KeyUse.SIG, algorithm);
    }
}

