/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.List;
import java.util.function.Function;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.SelectStatement;

public class QueryPartTableReference
extends DerivedTableReference {
    private final SelectStatement selectStatement;

    public QueryPartTableReference(SelectStatement selectStatement, String identificationVariable, List<String> columnNames, boolean lateral, SessionFactoryImplementor sessionFactory) {
        super(identificationVariable, columnNames, lateral, sessionFactory);
        this.selectStatement = selectStatement;
    }

    public QueryPart getQueryPart() {
        return this.selectStatement.getQueryPart();
    }

    public SelectStatement getStatement() {
        return this.selectStatement;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitQueryPartTableReference(this);
    }

    @Override
    public Boolean visitAffectedTableNames(Function<String, Boolean> nameCollector) {
        Function<TableReference, Boolean> tableReferenceBooleanFunction = tableReference -> tableReference.visitAffectedTableNames(nameCollector);
        return this.selectStatement.getQueryPart().queryQuerySpecs(querySpec -> (Boolean)querySpec.getFromClause().queryTableReferences(tableReferenceBooleanFunction));
    }
}

