/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.LockModeType;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.keycloak.authorization.AdminPermissionsSchema;
import org.keycloak.authorization.policy.provider.PartialEvaluationStorageProvider;
import org.keycloak.common.util.CollectionUtil;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.jpa.JpaModel;
import org.keycloak.models.jpa.PaginationUtils;
import org.keycloak.models.jpa.entities.GroupAttributeEntity;
import org.keycloak.models.jpa.entities.GroupEntity;
import org.keycloak.models.jpa.entities.GroupRoleMappingEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.utils.StreamsUtil;

public class GroupAdapter
implements GroupModel,
JpaModel<GroupEntity> {
    protected final KeycloakSession session;
    protected GroupEntity group;
    protected EntityManager em;
    protected RealmModel realm;

    public GroupAdapter(KeycloakSession session, RealmModel realm, EntityManager em, GroupEntity group) {
        this.session = session;
        this.em = em;
        this.group = group;
        this.realm = realm;
    }

    public GroupEntity getEntity() {
        return this.group;
    }

    public String getId() {
        return this.group.getId();
    }

    public String getName() {
        return this.group.getName();
    }

    public void setName(String name) {
        this.group.setName(name);
        this.fireGroupUpdatedEvent();
    }

    public GroupModel getParent() {
        String parentId = this.getParentId();
        return parentId == null ? null : this.realm.getGroupById(parentId);
    }

    public String getParentId() {
        return GroupEntity.TOP_PARENT_ID.equals(this.group.getParentId()) ? null : this.group.getParentId();
    }

    public static GroupEntity toEntity(GroupModel model, EntityManager em) {
        if (model instanceof GroupAdapter) {
            return ((GroupAdapter)model).getEntity();
        }
        return (GroupEntity)em.getReference(GroupEntity.class, (Object)model.getId());
    }

    public void setParent(GroupModel parent) {
        if (parent == null) {
            this.group.setParentId(GroupEntity.TOP_PARENT_ID);
        } else if (!parent.getId().equals(this.getId())) {
            GroupEntity parentEntity = GroupAdapter.toEntity(parent, this.em);
            this.group.setParentId(parentEntity.getId());
        }
        this.fireGroupUpdatedEvent();
    }

    public void addChild(GroupModel subGroup) {
        if (subGroup.getId().equals(this.getId())) {
            return;
        }
        subGroup.setParent((GroupModel)this);
        this.fireGroupUpdatedEvent();
    }

    public void removeChild(GroupModel subGroup) {
        if (subGroup.getId().equals(this.getId())) {
            return;
        }
        subGroup.setParent(null);
        this.fireGroupUpdatedEvent();
    }

    public Stream<GroupModel> getSubGroupsStream() {
        return this.getSubGroupsStream("", false, -1, -1);
    }

    public Stream<GroupModel> getSubGroupsStream(String search, Boolean exact, Integer firstResult, Integer maxResults) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(String.class);
        Root root = queryBuilder.from(GroupEntity.class);
        queryBuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realm"), (Object)this.realm.getId()));
        predicates.add(builder.equal((Expression)root.get("type"), (Object)GroupModel.Type.REALM.intValue()));
        predicates.add(builder.equal((Expression)root.get("parentId"), (Object)this.group.getId()));
        String string = search = search == null ? "" : search;
        if (Boolean.TRUE.equals(exact)) {
            predicates.add(builder.like((Expression)root.get("name"), search));
        } else {
            predicates.add(builder.like(builder.lower((Expression)root.get("name")), builder.lower(builder.literal((Object)("%" + search + "%")))));
        }
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.GROUPS, (PartialEvaluationStorageProvider)UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session), this.realm, builder, queryBuilder, (Path)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        queryBuilder.orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        return StreamsUtil.closing(PaginationUtils.paginateQuery((TypedQuery)this.em.createQuery(queryBuilder), (Integer)firstResult, (Integer)maxResults).getResultStream().map(arg_0 -> ((RealmModel)this.realm).getGroupById(arg_0)).filter(Objects::nonNull));
    }

    public Long getSubGroupsCount() {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery queryBuilder = builder.createQuery(Long.class);
        Root root = queryBuilder.from(GroupEntity.class);
        queryBuilder.select((Selection)builder.count((Expression)root.get("id")));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("realm"), (Object)this.realm.getId()));
        predicates.add(builder.equal((Expression)root.get("type"), (Object)GroupModel.Type.REALM.intValue()));
        predicates.add(builder.equal((Expression)root.get("parentId"), (Object)this.group.getId()));
        predicates.addAll(AdminPermissionsSchema.SCHEMA.applyAuthorizationFilters(this.session, AdminPermissionsSchema.GROUPS, (PartialEvaluationStorageProvider)UserStoragePrivateUtil.userLocalStorage((KeycloakSession)this.session), this.realm, builder, queryBuilder, (Path)root));
        queryBuilder.where(predicates.toArray(new Predicate[0]));
        return (Long)this.em.createQuery(queryBuilder).getSingleResult();
    }

    public void setSingleAttribute(String name, String value) {
        boolean found = false;
        ArrayList<GroupAttributeEntity> toRemove = new ArrayList<GroupAttributeEntity>();
        for (GroupAttributeEntity attr : this.group.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            if (!found) {
                attr.setValue(value);
                found = true;
                continue;
            }
            toRemove.add(attr);
        }
        for (GroupAttributeEntity attr : toRemove) {
            this.em.remove((Object)attr);
            this.group.getAttributes().remove(attr);
        }
        if (found) {
            this.fireGroupUpdatedEvent();
            return;
        }
        this.persistAttributeValue(name, value);
        this.fireGroupUpdatedEvent();
    }

    public void setAttribute(String name, List<String> values) {
        List current = this.getAttributes().getOrDefault(name, List.of());
        if (CollectionUtil.collectionEquals(current, (Collection)Optional.ofNullable(values).orElse(List.of()))) {
            return;
        }
        this.removeAttribute(name);
        for (String value : values) {
            this.persistAttributeValue(name, value);
        }
    }

    private void persistAttributeValue(String name, String value) {
        GroupAttributeEntity attr = new GroupAttributeEntity();
        attr.setId(KeycloakModelUtils.generateId());
        attr.setName(name);
        attr.setValue(value);
        attr.setGroup(this.group);
        this.em.persist((Object)attr);
        this.group.getAttributes().add(attr);
    }

    public void removeAttribute(String name) {
        Iterator<GroupAttributeEntity> it = this.group.getAttributes().iterator();
        while (it.hasNext()) {
            GroupAttributeEntity attr = it.next();
            if (!attr.getName().equals(name)) continue;
            it.remove();
            this.em.remove((Object)attr);
        }
        this.fireGroupUpdatedEvent();
    }

    public String getFirstAttribute(String name) {
        for (GroupAttributeEntity attr : this.group.getAttributes()) {
            if (!attr.getName().equals(name)) continue;
            return attr.getValue();
        }
        return null;
    }

    public Stream<String> getAttributeStream(String name) {
        return this.group.getAttributes().stream().filter(attr -> Objects.equals(attr.getName(), name)).map(GroupAttributeEntity::getValue);
    }

    public Map<String, List<String>> getAttributes() {
        MultivaluedHashMap result = new MultivaluedHashMap();
        for (GroupAttributeEntity attr : this.group.getAttributes()) {
            result.add((Object)attr.getName(), (Object)attr.getValue());
        }
        return result;
    }

    public boolean hasRole(RoleModel role) {
        if (RoleUtils.hasRole(this.getRoleMappingsStream(), (RoleModel)role)) {
            return true;
        }
        GroupModel parent = this.getParent();
        return parent != null && parent.hasRole(role);
    }

    protected TypedQuery<GroupRoleMappingEntity> getGroupRoleMappingEntityTypedQuery(RoleModel role) {
        TypedQuery query = this.em.createNamedQuery("groupHasRole", GroupRoleMappingEntity.class);
        query.setParameter("group", (Object)this.getEntity());
        query.setParameter("roleId", (Object)role.getId());
        return query;
    }

    public void grantRole(RoleModel role) {
        if (this.hasDirectRole(role)) {
            return;
        }
        GroupRoleMappingEntity entity = new GroupRoleMappingEntity();
        entity.setGroup(this.getEntity());
        entity.setRoleId(role.getId());
        this.em.persist((Object)entity);
        this.em.flush();
        this.em.detach((Object)entity);
        this.fireGroupUpdatedEvent();
    }

    public Stream<RoleModel> getRealmRoleMappingsStream() {
        return this.getRoleMappingsStream().filter(RoleUtils::isRealmRole);
    }

    public Stream<RoleModel> getRoleMappingsStream() {
        TypedQuery query = this.em.createNamedQuery("groupRoleMappingIds", String.class);
        query.setParameter("group", (Object)this.getEntity());
        return StreamsUtil.closing(query.getResultStream().map(arg_0 -> ((RealmModel)this.realm).getRoleById(arg_0)).filter(Objects::nonNull));
    }

    public void deleteRoleMapping(RoleModel role) {
        if (this.group == null || role == null) {
            return;
        }
        TypedQuery<GroupRoleMappingEntity> query = this.getGroupRoleMappingEntityTypedQuery(role);
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (GroupRoleMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
        this.fireGroupUpdatedEvent();
    }

    public Stream<RoleModel> getClientRoleMappingsStream(ClientModel app) {
        return this.getRoleMappingsStream().filter(r -> RoleUtils.isClientRole((RoleModel)r, (ClientModel)app));
    }

    public GroupModel.Type getType() {
        return GroupModel.Type.valueOf((int)this.group.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof GroupModel)) {
            return false;
        }
        GroupModel that = (GroupModel)o;
        return that.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean escapeSlashesInGroupPath() {
        return KeycloakModelUtils.escapeSlashesInGroupPath((KeycloakSession)this.session);
    }

    private void fireGroupUpdatedEvent() {
        GroupModel.GroupUpdatedEvent.fire((GroupModel)this, (KeycloakSession)this.session);
    }
}

