/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin.permissions;

import jakarta.ws.rs.ForbiddenException;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.models.AdminRoles;
import org.keycloak.services.resources.admin.permissions.MgmtPermissions;
import org.keycloak.services.resources.admin.permissions.RealmPermissionEvaluator;

class RealmPermissions
implements RealmPermissionEvaluator {
    protected final MgmtPermissions root;

    public RealmPermissions(MgmtPermissions root) {
        this.root = root;
    }

    public boolean canManageRealmDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_REALM);
    }

    public boolean canViewRealmDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_REALM, AdminRoles.VIEW_REALM);
    }

    public boolean canManageIdentityProvidersDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_IDENTITY_PROVIDERS);
    }

    public boolean canViewIdentityProvidersDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_IDENTITY_PROVIDERS, AdminRoles.VIEW_IDENTITY_PROVIDERS);
    }

    public boolean canManageAuthorizationDefault(ResourceServer resourceServer) {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_AUTHORIZATION, AdminRoles.MANAGE_CLIENTS);
    }

    public boolean canViewAuthorizationDefault(ResourceServer resourceServer) {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_AUTHORIZATION, AdminRoles.VIEW_AUTHORIZATION);
    }

    public boolean canManageEventsDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_EVENTS);
    }

    public boolean canViewEventsDefault() {
        return this.root.hasOneAdminRole(AdminRoles.MANAGE_EVENTS, AdminRoles.VIEW_EVENTS);
    }

    @Override
    public boolean canListRealms() {
        return this.root.isAdmin();
    }

    @Override
    public void requireViewRealmNameList() {
        if (!this.canListRealms()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManageRealm() {
        return this.canManageRealmDefault();
    }

    @Override
    public void requireManageRealm() {
        if (!this.canManageRealm()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canViewRealm() {
        return this.canViewRealmDefault();
    }

    @Override
    public void requireViewRealm() {
        if (!this.canViewRealm()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManageIdentityProviders() {
        return this.canManageIdentityProvidersDefault();
    }

    @Override
    public boolean canViewIdentityProviders() {
        return this.canViewIdentityProvidersDefault();
    }

    @Override
    public void requireViewIdentityProviders() {
        if (!this.canViewIdentityProviders()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireManageIdentityProviders() {
        if (!this.canManageIdentityProviders()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManageAuthorization(ResourceServer resourceServer) {
        return this.canManageAuthorizationDefault(resourceServer);
    }

    @Override
    public boolean canViewAuthorization(ResourceServer resourceServer) {
        return this.canViewAuthorizationDefault(resourceServer);
    }

    @Override
    public void requireManageAuthorization(ResourceServer resourceServer) {
        if (!this.canManageAuthorization(resourceServer)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireViewAuthorization(ResourceServer resourceServer) {
        if (!this.canViewAuthorization(resourceServer)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canManageEvents() {
        return this.canManageEventsDefault();
    }

    @Override
    public void requireManageEvents() {
        if (!this.canManageEvents()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public boolean canViewEvents() {
        return this.canViewEventsDefault();
    }

    @Override
    public void requireViewEvents() {
        if (!this.canViewEvents()) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireViewRequiredActions() {
        if (!this.canViewRealm() && !this.root.hasOneAdminRole(AdminRoles.QUERY_USERS)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireViewAuthenticationFlows() {
        if (!this.canViewRealm() && !this.root.hasOneAdminRole(AdminRoles.QUERY_CLIENTS)) {
            throw new ForbiddenException();
        }
    }

    @Override
    public void requireViewClientAuthenticatorProviders() {
        if (!this.canViewRealm() && !this.root.hasOneAdminRole(AdminRoles.QUERY_CLIENTS, AdminRoles.VIEW_CLIENTS, AdminRoles.MANAGE_CLIENTS)) {
            throw new ForbiddenException();
        }
    }
}

