/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.infinispan.module.certificates;

import java.lang.invoke.MethodHandles;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.net.ssl.X509ExtendedKeyManager;
import org.jboss.logging.Logger;

class ReloadingX509ExtendedKeyManager
extends X509ExtendedKeyManager {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private volatile X509ExtendedKeyManager delegate;

    public ReloadingX509ExtendedKeyManager(X509ExtendedKeyManager delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        Object[] r = this.delegate.getClientAliases(keyType, issuers);
        if (logger.isDebugEnabled() && r != null) {
            logger.debugf("getClientAliases - %s", (Object)Arrays.toString(r));
        }
        return r;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        String r = this.delegate.chooseClientAlias(keyType, issuers, socket);
        logger.debugf("chooseClientAlias - %s", (Object)r);
        return r;
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        Object[] r = this.delegate.getServerAliases(keyType, issuers);
        if (logger.isDebugEnabled()) {
            logger.debugf("getServerAliases - %s", (Object)Arrays.toString(r));
        }
        return r;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String r = this.delegate.chooseServerAlias(keyType, issuers, socket);
        logger.debugf("chooseServerAlias - %s", (Object)r);
        return r;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] r = this.delegate.getCertificateChain(alias);
        if (logger.isDebugEnabled() && r != null) {
            logger.debugf("getCertificateChain - serial numbers: %s", (Object)Arrays.stream(r).map(X509Certificate::getSerialNumber).map(String::valueOf).collect(Collectors.joining(", ")));
        }
        return r;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.delegate.getPrivateKey(alias);
    }

    public void reload(X509ExtendedKeyManager keyManager) {
        this.delegate = Objects.requireNonNull(keyManager);
    }
}

