/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.email;

import com.fasterxml.jackson.databind.JsonNode;
import jakarta.mail.AuthenticationFailedException;
import jakarta.mail.MessagingException;
import jakarta.mail.Transport;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.broker.provider.util.SimpleHttp;
import org.keycloak.email.EmailAuthenticator;
import org.keycloak.email.EmailException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.utils.KeycloakSessionUtil;
import org.keycloak.vault.VaultStringSecret;

public class TokenAuthEmailAuthenticator
implements EmailAuthenticator {
    private static final Logger logger = Logger.getLogger(TokenAuthEmailAuthenticator.class);
    public static final int FALLBACK_EXPIRES_AT_IN_SECONDS = 60;
    private final Map<String, TokenStoreEntry> tokenStore = new ConcurrentHashMap<String, TokenStoreEntry>();

    @Override
    public void connect(KeycloakSession session, Map<String, String> config, Transport transport) throws EmailException {
        try {
            String token = this.gatherValidToken(session, config);
            transport.connect(config.get("user"), token);
        }
        catch (AuthenticationFailedException e) {
            this.tokenStore.remove(session.getContext().getRealm().getId());
            logger.debugf("AuthenticationFailed-Exception for SMTP in realm %s failed response was %s, will try again", (Object)KeycloakSessionUtil.getRealmNameFromContext((KeycloakSession)session), (Object)e.getMessage());
            String token = this.gatherValidToken(session, config);
            try {
                transport.connect(config.get("user"), token);
            }
            catch (MessagingException ex) {
                logger.warnf("Retry after AuthenticationFailed-Exception for SMTP in realm %s failed response was %s", (Object)KeycloakSessionUtil.getRealmNameFromContext((KeycloakSession)session), (Object)ex);
                throw new EmailException("Retry after AuthenticationFailed-Exception for SMTP failed.", (Throwable)ex);
            }
        }
        catch (MessagingException e) {
            throw new EmailException("Connect failed for SMTP " + KeycloakSessionUtil.getRealmNameFromContext((KeycloakSession)session), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String gatherValidToken(KeycloakSession session, Map<String, String> config) throws EmailException {
        try (VaultStringSecret vaultStringSecret = session.vault().getStringSecret(config.get("authTokenClientSecret"));){
            String authTokenClientSecret = vaultStringSecret.get().orElse(config.get("authTokenClientSecret"));
            String authTokenUrl = config.get("authTokenUrl");
            String authTokenClientId = config.get("authTokenClientId");
            String authTokenScope = config.get("authTokenScope");
            int authTokenClientSecretHash = authTokenClientSecret.hashCode();
            TokenStoreEntry tokenStoreEntry = this.tokenStore.get(session.getContext().getRealm().getId());
            if (TokenAuthEmailAuthenticator.isValidAuthToken(authTokenUrl, authTokenScope, authTokenClientId, authTokenClientSecretHash, tokenStoreEntry)) {
                String string = tokenStoreEntry.token;
                return string;
            }
            Map<String, TokenStoreEntry> map = this.tokenStore;
            synchronized (map) {
                if (TokenAuthEmailAuthenticator.isValidAuthToken(authTokenUrl, authTokenScope, authTokenClientId, authTokenClientSecretHash, tokenStoreEntry)) {
                    String string = tokenStoreEntry.token;
                    return string;
                }
                JsonNode response = this.fetchTokenViaHTTP(session, authTokenUrl, authTokenScope, authTokenClientId, authTokenClientSecret);
                Optional<String> maybeToken = this.getAccessToken(session, response);
                Optional<LocalDateTime> maybeExpiresAt = this.getExpiresIn(session, response);
                if (!maybeToken.isPresent()) throw new EmailException("No access token found in token-response for SMTP");
                String token = maybeToken.get();
                this.tokenStore.put(session.getContext().getRealm().getId(), new TokenStoreEntry(maybeExpiresAt.orElse(LocalDateTime.now().plusSeconds(60L)), authTokenUrl, authTokenScope, authTokenClientId, authTokenClientSecretHash, token));
                String string = token;
                return string;
            }
        }
        catch (IOException e) {
            throw new EmailException("Failed to gather valid token for SMTP", (Throwable)e);
        }
    }

    private static boolean isValidAuthToken(String authTokenUrl, String authTokenScope, String authTokenClientId, int authTokenHash, TokenStoreEntry tokenStoreEntry) {
        return tokenStoreEntry != null && authTokenUrl != null && authTokenUrl.equals(tokenStoreEntry.url) && authTokenScope != null && authTokenScope.equals(tokenStoreEntry.scope) && authTokenClientId != null && authTokenClientId.equals(tokenStoreEntry.clientId) && authTokenHash == tokenStoreEntry.clientSecretHash && tokenStoreEntry.expiration_at.plusSeconds(30L).isAfter(LocalDateTime.now());
    }

    private Optional<String> getAccessToken(KeycloakSession session, JsonNode response) {
        if (response.has("access_token")) {
            return Optional.of(response.get("access_token").asText());
        }
        logger.warnf("Got no access_token from response for SMTP auth in realm %s, response was %s", (Object)KeycloakSessionUtil.getRealmNameFromContext((KeycloakSession)session), (Object)response);
        return Optional.empty();
    }

    private Optional<LocalDateTime> getExpiresIn(KeycloakSession session, JsonNode response) {
        if (response.has("expires_in")) {
            String expiresIn = response.get("expires_in").asText();
            return Optional.of(LocalDateTime.now().plusSeconds(Long.parseLong(expiresIn)));
        }
        logger.warnf("Got no expires_in from response for SMTP auth in realm %s, response was %s", (Object)KeycloakSessionUtil.getRealmNameFromContext((KeycloakSession)session), (Object)response.asText());
        return Optional.of(LocalDateTime.now().plusSeconds(60L));
    }

    private JsonNode fetchTokenViaHTTP(KeycloakSession session, String authTokenUrl, String authTokenScope, String authTokenClientId, String authTokenClientSecret) throws IOException {
        return SimpleHttp.doPost((String)authTokenUrl, (KeycloakSession)session).param("client_id", authTokenClientId).param("client_secret", authTokenClientSecret).param("scope", authTokenScope).param("grant_type", "client_credentials").asJson();
    }

    record TokenStoreEntry(LocalDateTime expiration_at, String url, String scope, String clientId, int clientSecretHash, String token) {
    }
}

