/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Nationalized;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.keycloak.models.jpa.entities.RoleAttributeEntity;

@Entity
@Table(name="KEYCLOAK_ROLE", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "CLIENT_REALM_CONSTRAINT"})})
@NamedQueries(value={@NamedQuery(name="getClientRoles", query="select role from RoleEntity role where role.clientId = :client order by role.name"), @NamedQuery(name="getClientRoleIds", query="select role.id from RoleEntity role where role.clientId = :client"), @NamedQuery(name="getClientRoleByName", query="select role from RoleEntity role where role.name = :name and role.clientId = :client"), @NamedQuery(name="getClientRoleIdByName", query="select role.id from RoleEntity role where role.name = :name and role.clientId = :client"), @NamedQuery(name="searchForClientRoles", query="select role from RoleEntity role where role.clientId = :client and ( lower(role.name) like :search or lower(role.description) like :search ) order by role.name"), @NamedQuery(name="getRealmRoles", query="select role from RoleEntity role where role.clientRole = false and role.realmId = :realm order by role.name"), @NamedQuery(name="getRealmRoleIds", query="select role.id from RoleEntity role where role.clientRole = false and role.realmId = :realm"), @NamedQuery(name="getRealmRoleByName", query="select role from RoleEntity role where role.clientRole = false and role.name = :name and role.realmId = :realm"), @NamedQuery(name="getRealmRoleIdByName", query="select role.id from RoleEntity role where role.clientRole = false and role.name = :name and role.realmId = :realm"), @NamedQuery(name="searchForRealmRoles", query="select role from RoleEntity role where role.clientRole = false and role.realmId = :realm and ( lower(role.name) like :search or lower(role.description) like :search ) order by role.name"), @NamedQuery(name="getRoleIdsFromIdList", query="select role.id from RoleEntity role where role.realmId = :realm and role.id in :ids order by role.name ASC"), @NamedQuery(name="getRoleIdsByNameContainingFromIdList", query="select role.id from RoleEntity role where role.realmId = :realm and lower(role.name) like lower(concat('%',:search,'%')) and role.id in :ids order by role.name ASC")})
@EnhancementInfo(version="6.6.11.Final")
public class RoleEntity
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    String id;
    @Nationalized
    @Column(name="NAME")
    String name;
    @Nationalized
    @Column(name="DESCRIPTION")
    String description;
    @Column(name="REALM_ID")
    String realmId;
    @Column(name="CLIENT_ROLE")
    boolean clientRole;
    @Column(name="CLIENT")
    String clientId;
    @Column(name="CLIENT_REALM_CONSTRAINT", length=36)
    String clientRealmConstraint;
    @ManyToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="COMPOSITE_ROLE", joinColumns={@JoinColumn(name="COMPOSITE")}, inverseJoinColumns={@JoinColumn(name="CHILD_ROLE")})
    Set<RoleEntity> compositeRoles;
    @ManyToMany(mappedBy="compositeRoles", fetch=FetchType.LAZY, cascade={})
    Set<RoleEntity> parentRoles;
    @OneToMany(cascade={CascadeType.REMOVE}, orphanRemoval=false, mappedBy="role")
    @Fetch(value=FetchMode.SELECT)
    @BatchSize(size=20)
    protected List<RoleAttributeEntity> attributes;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public RoleEntity() {
        this.$$_hibernate_write_attributes(new LinkedList());
    }

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getRealmId() {
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_write_realmId(realmId);
        this.$$_hibernate_write_clientRealmConstraint(realmId);
    }

    public List<RoleAttributeEntity> getAttributes() {
        if (this.$$_hibernate_read_attributes() == null) {
            this.$$_hibernate_write_attributes(new LinkedList());
        }
        return this.$$_hibernate_read_attributes();
    }

    public void setAttributes(List<RoleAttributeEntity> attributes) {
        this.$$_hibernate_write_attributes(attributes);
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_write_name(name);
    }

    public String getDescription() {
        return this.$$_hibernate_read_description();
    }

    public void setDescription(String description) {
        this.$$_hibernate_write_description(description);
    }

    public Set<RoleEntity> getCompositeRoles() {
        if (this.$$_hibernate_read_compositeRoles() == null) {
            this.$$_hibernate_write_compositeRoles(new HashSet());
        }
        return this.$$_hibernate_read_compositeRoles();
    }

    public Set<RoleEntity> getParentRoles() {
        if (this.$$_hibernate_read_parentRoles() == null) {
            this.$$_hibernate_write_parentRoles(new HashSet());
        }
        return this.$$_hibernate_read_parentRoles();
    }

    public void setParentRoles(Set<RoleEntity> parentRoles) {
        this.$$_hibernate_write_parentRoles(parentRoles);
    }

    public void setCompositeRoles(Set<RoleEntity> compositeRoles) {
        this.$$_hibernate_write_compositeRoles(compositeRoles);
    }

    public boolean isClientRole() {
        return this.$$_hibernate_read_clientRole();
    }

    public void setClientRole(boolean clientRole) {
        this.$$_hibernate_write_clientRole(clientRole);
    }

    public String getClientId() {
        return this.$$_hibernate_read_clientId();
    }

    public void setClientId(String clientId) {
        this.$$_hibernate_write_clientId(clientId);
        this.$$_hibernate_write_clientRealmConstraint(clientId);
    }

    public String getClientRealmConstraint() {
        return this.$$_hibernate_read_clientRealmConstraint();
    }

    public void setClientRealmConstraint(String clientRealmConstraint) {
        this.$$_hibernate_write_clientRealmConstraint(clientRealmConstraint);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof RoleEntity)) {
            return false;
        }
        RoleEntity that = (RoleEntity)o;
        return this.$$_hibernate_read_id().equals(that.getId());
    }

    public int hashCode() {
        return this.$$_hibernate_read_id().hashCode();
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        RoleEntity roleEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        int n;
        block8: {
            int n2;
            block9: {
                RoleEntity roleEntity = this;
                RoleEntity roleEntity2 = roleEntity;
                RoleEntity roleEntity3 = roleEntity2;
                int n3 = 0;
                if (n3 == 0 && roleEntity2.$$_hibernate_collectionTracker != null) {
                    int n4 = roleEntity2.$$_hibernate_collectionTracker.getSize("compositeRoles");
                    if (roleEntity2.compositeRoles == null && n4 != -1) {
                        n3 = 1;
                    } else if (roleEntity2.compositeRoles != null && (!(roleEntity2.compositeRoles instanceof PersistentCollection) || ((PersistentCollection)roleEntity2.compositeRoles).wasInitialized()) && n4 != roleEntity2.compositeRoles.size()) {
                        n3 = 1;
                    }
                }
                if ((n2 = n3) == 0 && roleEntity.$$_hibernate_collectionTracker != null) {
                    n3 = roleEntity.$$_hibernate_collectionTracker.getSize("parentRoles");
                    if (roleEntity.parentRoles == null && n3 != -1) {
                        n2 = 1;
                    } else if (roleEntity.parentRoles != null && (!(roleEntity.parentRoles instanceof PersistentCollection) || ((PersistentCollection)roleEntity.parentRoles).wasInitialized()) && n3 != roleEntity.parentRoles.size()) {
                        n2 = 1;
                    }
                }
                if ((n = n2) != 0 || this.$$_hibernate_collectionTracker == null) break block8;
                n2 = this.$$_hibernate_collectionTracker.getSize("attributes");
                if (this.attributes != null || n2 == -1) break block9;
                n = 1;
                break block8;
            }
            if (this.attributes == null || this.attributes instanceof PersistentCollection && !((PersistentCollection)this.attributes).wasInitialized() || n2 == this.attributes.size()) break block8;
            n = 1;
        }
        return n != 0;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block8: {
            int n;
            block9: {
                RoleEntity roleEntity = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                RoleEntity roleEntity2 = roleEntity;
                DirtyTracker dirtyTracker3 = dirtyTracker2;
                RoleEntity roleEntity3 = roleEntity2;
                DirtyTracker dirtyTracker4 = dirtyTracker3;
                if (roleEntity2.$$_hibernate_collectionTracker != null) {
                    int n2 = roleEntity2.$$_hibernate_collectionTracker.getSize("compositeRoles");
                    if (roleEntity2.compositeRoles == null && n2 != -1) {
                        dirtyTracker3.add("compositeRoles");
                    } else if (roleEntity2.compositeRoles != null && (!(roleEntity2.compositeRoles instanceof PersistentCollection) || ((PersistentCollection)roleEntity2.compositeRoles).wasInitialized()) && n2 != roleEntity2.compositeRoles.size()) {
                        dirtyTracker3.add("compositeRoles");
                    }
                }
                if (roleEntity.$$_hibernate_collectionTracker != null) {
                    int n3 = roleEntity.$$_hibernate_collectionTracker.getSize("parentRoles");
                    if (roleEntity.parentRoles == null && n3 != -1) {
                        dirtyTracker2.add("parentRoles");
                    } else if (roleEntity.parentRoles != null && (!(roleEntity.parentRoles instanceof PersistentCollection) || ((PersistentCollection)roleEntity.parentRoles).wasInitialized()) && n3 != roleEntity.parentRoles.size()) {
                        dirtyTracker2.add("parentRoles");
                    }
                }
                if (this.$$_hibernate_collectionTracker == null) break block8;
                n = this.$$_hibernate_collectionTracker.getSize("attributes");
                if (this.attributes != null || n == -1) break block9;
                dirtyTracker.add("attributes");
                break block8;
            }
            if (this.attributes == null || this.attributes instanceof PersistentCollection && !((PersistentCollection)this.attributes).wasInitialized() || n == this.attributes.size()) break block8;
            dirtyTracker.add("attributes");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block9: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            RoleEntity roleEntity = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            RoleEntity roleEntity2 = roleEntity;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor3 = lazyAttributeLoadingInterceptor2;
            RoleEntity roleEntity3 = roleEntity2;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor4 = lazyAttributeLoadingInterceptor3;
            if (lazyAttributeLoadingInterceptor3 == null || lazyAttributeLoadingInterceptor3.isAttributeLoaded("compositeRoles")) {
                if (roleEntity2.compositeRoles == null || roleEntity2.compositeRoles instanceof PersistentCollection && !((PersistentCollection)roleEntity2.compositeRoles).wasInitialized()) {
                    roleEntity2.$$_hibernate_collectionTracker.add("compositeRoles", -1);
                } else {
                    roleEntity2.$$_hibernate_collectionTracker.add("compositeRoles", roleEntity2.compositeRoles.size());
                }
            }
            if (lazyAttributeLoadingInterceptor2 == null || lazyAttributeLoadingInterceptor2.isAttributeLoaded("parentRoles")) {
                if (roleEntity.parentRoles == null || roleEntity.parentRoles instanceof PersistentCollection && !((PersistentCollection)roleEntity.parentRoles).wasInitialized()) {
                    roleEntity.$$_hibernate_collectionTracker.add("parentRoles", -1);
                } else {
                    roleEntity.$$_hibernate_collectionTracker.add("parentRoles", roleEntity.parentRoles.size());
                }
            }
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("attributes")) break block9;
            if (this.attributes == null || this.attributes instanceof PersistentCollection && !((PersistentCollection)this.attributes).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("attributes", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("attributes", this.attributes.size());
            }
        }
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"name", (Object)string, (Object)this.name)) {
            this.$$_hibernate_trackChange("name");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public String $$_hibernate_read_description() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "description", (Object)this.description);
        }
        return this.description;
    }

    public void $$_hibernate_write_description(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"description", (Object)string, (Object)this.description)) {
            this.$$_hibernate_trackChange("description");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "description", (Object)this.description, (Object)string);
            return;
        }
        this.description = string;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"realmId", (Object)string, (Object)this.realmId)) {
            this.$$_hibernate_trackChange("realmId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public boolean $$_hibernate_read_clientRole() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientRole = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "clientRole", this.clientRole);
        }
        return this.clientRole;
    }

    public void $$_hibernate_write_clientRole(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"clientRole", (boolean)bl, (boolean)this.clientRole)) {
            this.$$_hibernate_trackChange("clientRole");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientRole = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "clientRole", this.clientRole, bl);
            return;
        }
        this.clientRole = bl;
    }

    public String $$_hibernate_read_clientId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientId", (Object)this.clientId);
        }
        return this.clientId;
    }

    public void $$_hibernate_write_clientId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"clientId", (Object)string, (Object)this.clientId)) {
            this.$$_hibernate_trackChange("clientId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientId", (Object)this.clientId, (Object)string);
            return;
        }
        this.clientId = string;
    }

    public String $$_hibernate_read_clientRealmConstraint() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientRealmConstraint = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientRealmConstraint", (Object)this.clientRealmConstraint);
        }
        return this.clientRealmConstraint;
    }

    public void $$_hibernate_write_clientRealmConstraint(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"clientRealmConstraint", (Object)string, (Object)this.clientRealmConstraint)) {
            this.$$_hibernate_trackChange("clientRealmConstraint");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientRealmConstraint = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientRealmConstraint", (Object)this.clientRealmConstraint, (Object)string);
            return;
        }
        this.clientRealmConstraint = string;
    }

    public Set $$_hibernate_read_compositeRoles() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.compositeRoles = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "compositeRoles", this.compositeRoles);
        }
        return this.compositeRoles;
    }

    public void $$_hibernate_write_compositeRoles(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.compositeRoles = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "compositeRoles", this.compositeRoles, (Object)set);
            return;
        }
        this.compositeRoles = set;
    }

    public Set $$_hibernate_read_parentRoles() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.parentRoles = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "parentRoles", this.parentRoles);
        }
        return this.parentRoles;
    }

    public void $$_hibernate_write_parentRoles(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.parentRoles = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "parentRoles", this.parentRoles, (Object)set);
            return;
        }
        this.parentRoles = set;
    }

    public List $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }

    public void $$_hibernate_write_attributes(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "attributes", this.attributes, (Object)list);
            return;
        }
        this.attributes = list;
    }
}

