/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import kafka.cluster.Partition;
import kafka.server.AbstractFetcherThread;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.network.BrokerEndPoint;
import org.apache.kafka.server.storage.log.FetchIsolation;
import org.apache.kafka.server.storage.log.FetchParams;
import org.apache.kafka.server.storage.log.FetchPartitionData;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005}h\u0001\u0002\u0010 \u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\"Aa\t\u0001B\u0001B\u0003%q\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u001d)\u0006A1A\u0005\nYCaA\u0017\u0001!\u0002\u00139\u0006bB.\u0001\u0005\u0004%I\u0001\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B/\t\u000f\u0019\u0004!\u0019!C\u00059\"1q\r\u0001Q\u0001\nuCq\u0001\u001b\u0001A\u0002\u0013%\u0011\u000eC\u0004t\u0001\u0001\u0007I\u0011\u0002;\t\ri\u0004\u0001\u0015)\u0003k\u0011\u001dY\bA1A\u0005BqDq!!\u0001\u0001A\u0003%Q\u0010C\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\u0006!9\u0011\u0011\u0002\u0001\u0005B\u0005-\u0001bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\t\u0019\u0006\u0001C!\u0003+Bq!a\u0017\u0001\t\u0003\ni\u0006C\u0004\u0002d\u0001!\t%!\u001a\t\u000f\u0005\u0005\u0006\u0001\"\u0011\u0002$\"9\u0011Q\u001a\u0001\u0005\n\u0005=\u0007bBAn\u0001\u0011%\u0011Q\u001c\u0005\b\u0003K\u0004A\u0011BAt\u0011\u001d\tY\u000f\u0001C!\u0003[\u00141\u0003T8dC2dU-\u00193fe\u0016sG\rU8j]RT!\u0001I\u0011\u0002\rM,'O^3s\u0015\u0005\u0011\u0013!B6bM.\f7\u0001A\n\u0005\u0001\u0015Zs\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003Y5j\u0011aH\u0005\u0003]}\u0011a\u0002T3bI\u0016\u0014XI\u001c3Q_&tG\u000f\u0005\u00021g5\t\u0011G\u0003\u00023C\u0005)Q\u000f^5mg&\u0011A'\r\u0002\b\u0019><w-\u001b8h\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\t9\u0004)D\u00019\u0015\tI$(A\u0004oKR<xN]6\u000b\u0005\u0001Z$B\u0001\u0012=\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\n\u0005\u0005C$A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003Y\u0011K!!R\u0010\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s!\ta\u0003*\u0003\u0002J?\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018!B9v_R\f\u0007C\u0001\u0017M\u0013\tiuD\u0001\u0007SKBd\u0017nY1Rk>$\u0018-\u0001\u0004=S:LGO\u0010\u000b\u0006!F\u00136\u000b\u0016\t\u0003Y\u0001AQ!N\u0003A\u0002YBQAQ\u0003A\u0002\rCQAR\u0003A\u0002\u001dCQAS\u0003A\u0002-\u000b\u0011B]3qY&\u001c\u0017-\u00133\u0016\u0003]\u0003\"A\n-\n\u0005e;#aA%oi\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u00115\f\u0007PQ=uKN,\u0012!\u0018\t\u0003=\u000el\u0011a\u0018\u0006\u0003A\u0006\fA\u0001\\1oO*\t!-\u0001\u0003kCZ\f\u0017B\u00013`\u0005\u001dIe\u000e^3hKJ\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u0013\u0019,Go\u00195TSj,\u0017A\u00034fi\u000eD7+\u001b>fA\u0005\u0019\u0012N\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]V\t!\u000eE\u0002'W6L!\u0001\\\u0014\u0003\r=\u0003H/[8o!\tq\u0017/D\u0001p\u0015\t\u00018(\u0001\u0004d_6lwN\\\u0005\u0003e>\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\fj]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn\u0018\u0013fcR\u0011Q\u000f\u001f\t\u0003MYL!a^\u0014\u0003\tUs\u0017\u000e\u001e\u0005\bs6\t\t\u00111\u0001k\u0003\rAH%M\u0001\u0015S:\u0004&o\\4sKN\u001c\b+\u0019:uSRLwN\u001c\u0011\u00029%\u001cHK];oG\u0006$\u0018n\u001c8P]\u001a+Go\u00195TkB\u0004xN\u001d;fIV\tQ\u0010\u0005\u0002'}&\u0011qp\n\u0002\b\u0005>|G.Z1o\u0003uI7\u000f\u0016:v]\u000e\fG/[8o\u001f:4U\r^2i'V\u0004\bo\u001c:uK\u0012\u0004\u0013!D5oSRL\u0017\r^3DY>\u001cX\rF\u0001v\u0003\u0015\u0019Gn\\:f\u00039\u0011'o\\6fe\u0016sG\rU8j]R$\u0012AN\u0001\u0006M\u0016$8\r\u001b\u000b\u0005\u0003#\t)\u0003E\u0004\u0002\u0014\u0005eQ.!\b\u000e\u0005\u0005U!bAA\fO\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0011Q\u0003\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0010\u0003Ci\u0011\u0001A\u0005\u0004\u0003Gi#!\u0003$fi\u000eDG)\u0019;b\u0011\u001d\t9\u0003\u0006a\u0001\u0003S\tABZ3uG\"\u0014V-];fgR\u0004B!a\u000b\u000289!\u0011QFA\u001a\u001b\t\tyCC\u0002\u00022=\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003k\ty#\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0002:\u0005m\"a\u0002\"vS2$WM\u001d\u0006\u0005\u0003k\ty#A\ngKR\u001c\u0007.R1sY&,7\u000f^(gMN,G\u000f\u0006\u0004\u0002B\u0005-\u0013q\n\t\u0005\u0003\u0007\n9%\u0004\u0002\u0002F)\u0011\u0001OO\u0005\u0005\u0003\u0013\n)E\u0001\bPM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\t\r\u00055S\u00031\u0001n\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Da!!\u0015\u0016\u0001\u00049\u0016AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\f\u0011CZ3uG\"d\u0015\r^3ti>3gm]3u)\u0019\t\t%a\u0016\u0002Z!1\u0011Q\n\fA\u00025Da!!\u0015\u0017\u0001\u00049\u0016\u0001\u00074fi\u000eDW)\u0019:mS\u0016\u001cH\u000fT8dC2|eMZ:fiR1\u0011\u0011IA0\u0003CBa!!\u0014\u0018\u0001\u0004i\u0007BBA)/\u0001\u0007q+\u0001\u000bgKR\u001c\u0007.\u00129pG\",e\u000eZ(gMN,Go\u001d\u000b\u0005\u0003O\n)\nE\u0004\u0002\u0014\u0005eQ.!\u001b\u0011\t\u0005-\u0014q\u0012\b\u0005\u0003[\nII\u0004\u0003\u0002p\u0005\u0015e\u0002BA9\u0003\u0007sA!a\u001d\u0002\u0002:!\u0011QOA@\u001d\u0011\t9(! \u000e\u0005\u0005e$bAA>G\u00051AH]8pizJ\u0011aP\u0005\u0003{yJ!A\t\u001f\n\u0005A\\\u0014bAAD_\u00069Q.Z:tC\u001e,\u0017\u0002BAF\u0003\u001b\u000b\u0001e\u00144gg\u0016$hi\u001c:MK\u0006$WM]#q_\u000eD'+Z:q_:\u001cX\rR1uC*\u0019\u0011qQ8\n\t\u0005E\u00151\u0013\u0002\u000f\u000bB|7\r[#oI>3gm]3u\u0015\u0011\tY)!$\t\u000f\u0005]\u0005\u00041\u0001\u0002\u001a\u0006Q\u0001/\u0019:uSRLwN\\:\u0011\u000f\u0005M\u0011\u0011D7\u0002\u001cB!\u0011qDAO\u0013\r\ty*\f\u0002\n\u000bB|7\r\u001b#bi\u0006\f!BY;jY\u00124U\r^2i)\u0011\t)+a1\u0011\r\u0005\u001d\u0016QWA^\u001d\u0011\tI+!-\u000f\t\u0005-\u0016q\u0016\b\u0005\u0003o\ni+C\u0001#\u0013\t\u0001\u0013%C\u0002\u00024~\tQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0003\u0003\u00028\u0006e&\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7OC\u0002\u00024~\u0001BAJ6\u0002>B!\u0011qUA`\u0013\u0011\t\t-!/\u0003\u0019I+\u0007\u000f\\5dC\u001a+Go\u00195\t\u000f\u0005]\u0015\u00041\u0001\u0002FB9\u00111CA\r[\u0006\u001d\u0007c\u0001\u0017\u0002J&\u0019\u00111Z\u0010\u0003'A\u000b'\u000f^5uS>tg)\u001a;dQN#\u0018\r^3\u0002-M,G.Z2u!\u0006\u0014H/\u001b;j_:$vNR3uG\"$B!!5\u0002ZB!ae[Aj!\u00191\u0013Q[7\u0002H&\u0019\u0011q[\u0014\u0003\rQ+\b\u000f\\33\u0011\u001d\t9J\u0007a\u0001\u0003\u000b\faCY;jY\u00124U\r^2i\r>\u0014\b+\u0019:uSRLwN\u001c\u000b\u0007\u0003K\u000by.!9\t\r\u000553\u00041\u0001n\u0011\u001d\t\u0019o\u0007a\u0001\u0003\u000f\f!BZ3uG\"\u001cF/\u0019;f\u0003IqW\r\u001f;SK\u0006$\u0017\u0010U1si&$\u0018n\u001c8\u0015\t\u0005E\u0017\u0011\u001e\u0005\b\u0003/c\u0002\u0019AAc\u0003!!xn\u0015;sS:<GCAAx!\u0011\t\t0!?\u000f\t\u0005M\u0018Q\u001f\t\u0004\u0003o:\u0013bAA|O\u00051\u0001K]3eK\u001aLA!a?\u0002~\n11\u000b\u001e:j]\u001eT1!a>(\u0001")
public class LocalLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BrokerEndPoint sourceBroker;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;
    private final boolean isTruncationOnFetchSupported;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return this.isTruncationOnFetchSupported;
    }

    @Override
    public void initiateClose() {
    }

    @Override
    public void close() {
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.sourceBroker;
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        HashMap topicNames = new HashMap();
        request.data().topics().forEach(topic -> topicNames.put((Object)topic.topicId(), (Object)topic.topic()));
        java.util.Map fetchData = request.fetchData(CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)topicNames).asJava());
        FetchParams fetchParams = new FetchParams(request.version(), -3, -1L, 0L, request.minBytes(), request.maxBytes(), FetchIsolation.LOG_END, Optional.empty());
        this.replicaManager.fetchMessages(fetchParams, (Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>>)CollectionConverters$.MODULE$.MapHasAsScala(fetchData).asScala().toSeq(), QuotaFactory.UNBOUNDED_QUOTA, (Function1<Seq<Tuple2<TopicIdPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable)responsePartitionData -> {
            LocalLeaderEndPoint.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        });
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException("Failed to fetch data for partitions " + Predef$.MODULE$.wrapRefArray(fetchData.keySet().toArray()).mkString(","));
        }
        return ((Seq)partitionData.elem).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    @Override
    public OffsetAndEpoch fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long logStartOffset = partition.localLogOrException().logStartOffset();
        OptionalInt epoch = partition.localLogOrException().leaderEpochCache().epochForOffset(logStartOffset);
        return new OffsetAndEpoch(logStartOffset, epoch.orElse(0));
    }

    @Override
    public OffsetAndEpoch fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long logEndOffset = partition.localLogOrException().logEndOffset();
        OptionalInt epoch = partition.localLogOrException().leaderEpochCache().epochForOffset(logEndOffset);
        return new OffsetAndEpoch(logEndOffset, epoch.orElse(0));
    }

    @Override
    public OffsetAndEpoch fetchEarliestLocalOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        Partition partition = this.replicaManager.getPartitionOrException(topicPartition);
        long localLogStartOffset = partition.localLogOrException().localLogStartOffset();
        OptionalInt epoch = partition.localLogOrException().leaderEpochCache().epochForOffset(localLogStartOffset);
        return new OffsetAndEpoch(localLogStartOffset, epoch.orElse(0));
    }

    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        return (Map)partitions.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition tp = (TopicPartition)x0$1._1();
                OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData = (OffsetForLeaderEpochRequestData.OffsetForLeaderPartition)x0$1._2();
                try {
                    OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = epochData.leaderEpoch() == -1 ? new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.NONE.code()) : $this.replicaManager.getPartitionOrException(tp).lastOffsetForLeaderEpoch(RequestUtils.getLeaderEpoch((int)epochData.currentLeaderEpoch()), epochData.leaderEpoch(), false);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> "Error when getting EpochEndOffset for " + tp, (Function0<Throwable>)(Function0 & Serializable)() -> t);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(Errors.forException((Throwable)t).code()));
                }
            }
            throw new MatchError(null);
        });
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        Tuple2 tuple2;
        if (this.quota.isQuotaExceeded()) {
            return new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)((Set)Set$.MODULE$.empty()));
        }
        Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitions);
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            TopicPartition tp = (TopicPartition)tuple2._1();
            PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
            return this.buildFetchForPartition(tp, fetchState);
        }
        if (None$.MODULE$.equals(option)) {
            return new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)((Set)Set$.MODULE$.empty()));
        }
        throw new MatchError(option);
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1 & Serializable)tp -> {
                LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$1(partitions, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitions);
            nextPartitionOpt.foreach((Function1 & Serializable)x0$1 -> {
                LocalLeaderEndPoint.$anonfun$selectPartitionToFetch$4(this, partitions, x0$1);
                return BoxedUnit.UNIT;
            });
            return var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    /*
     * WARNING - void declaration
     */
    private AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetchForPartition(TopicPartition topicPartition, PartitionFetchState fetchState) {
        None$ none$;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaManager.futureLocalLogOrException(topicPartition).logStartOffset();
            Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOption$.MODULE$.toJava$extension(OptionConverters$.MODULE$.RichOption(fetchState.lastFetchedEpoch().map((Function1 & Serializable)x$2 -> LocalLeaderEndPoint.$anonfun$buildFetchForPartition$1(BoxesRunTime.unboxToInt((Object)x$2))))) : Optional.empty();
            Uuid topicId = (Uuid)fetchState.topicId().getOrElse((Function0 & Serializable)() -> Uuid.ZERO_UUID);
            requestMap.put(topicPartition, new FetchRequest.PartitionData(topicId, fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Failed to build fetch for " + topicPartition, (Function0<Throwable>)(Function0 & Serializable)() -> e);
            partitionsWithError.$plus$eq((Object)topicPartition);
        }
        if (requestMap.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            void forReplica_minBytes;
            void forReplica_maxWait;
            void forReplica_replicaEpoch;
            short version = fetchState.topicId().isEmpty() ? (short)12 : (short)ApiKeys.FETCH.latestVersion();
            boolean bl = false;
            boolean bl2 = false;
            long l = -1L;
            int forReplica_replicaId = this.replicaId();
            FetchRequest.Builder requestBuilder = new FetchRequest.Builder(version, version, forReplica_replicaId, (long)forReplica_replicaEpoch, (int)forReplica_maxWait, (int)forReplica_minBytes, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(requestMap, requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitions) {
        return ((IterableOnceOps)partitions.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LocalLeaderEndPoint.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable)(left, right) -> {
            block3: {
                block2: {
                    if (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic()), ((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                return left;
            }
            return right;
        });
    }

    public String toString() {
        return "LocalLeaderEndPoint";
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicIdPartition tp = (TopicIdPartition)x0$1._1();
                FetchPartitionData data = (FetchPartitionData)x0$1._2();
                List abortedTransactions = data.abortedTransactions.orElse(null);
                long lastStableOffset = data.lastStableOffset.orElse(-1L);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp.topicPartition()), (Object)new FetchResponseData.PartitionData().setPartitionIndex(tp.topicPartition().partition()).setErrorCode(data.error.code()).setHighWatermark(data.highWatermark).setLastStableOffset(lastStableOffset).setLogStartOffset(data.logStartOffset).setAbortedTransactions(abortedTransactions).setRecords((BaseRecords)data.records));
            }
            throw new MatchError(null);
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitions$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        partitions$1.get((Object)tp).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isReadyForFetch())).foreach((Function1 & Serializable)fetchState -> {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)tp, fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(LocalLeaderEndPoint $this, Map partitions$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
            $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
            $this.info((Function0<String>)(Function0 & Serializable)() -> "Beginning/resuming copy of partition " + tp + " from offset " + fetchState.fetchOffset() + ". Including this partition, there are " + partitions$1.size() + " remaining partitions to copy by this thread.");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetchForPartition$1(int x$2) {
        return BoxesRunTime.boxToInteger((int)x$2);
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            return ((PartitionFetchState)x0$1._2()).isReadyForFetch();
        }
        throw new MatchError(null);
    }

    public LocalLeaderEndPoint(BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota) {
        this.sourceBroker = sourceBroker;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
        this.isTruncationOnFetchSupported = false;
    }
}

