/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Objects;
import java.util.Optional;

public interface LogHistory<T> {
    public void addAt(long var1, T var3);

    public Optional<T> valueAtOrBefore(long var1);

    public Optional<Entry<T>> lastEntry();

    public void truncateNewEntries(long var1);

    public void truncateOldEntries(long var1);

    public void clear();

    public static final class Entry<T> {
        private final long offset;
        private final T value;

        public Entry(long offset, T value) {
            this.offset = offset;
            this.value = value;
        }

        public long offset() {
            return this.offset;
        }

        public T value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry that = (Entry)o;
            if (this.offset != that.offset) {
                return false;
            }
            return Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.offset, this.value);
        }

        public String toString() {
            return String.format("Entry(offset=%d, value=%s)", this.offset, this.value);
        }
    }
}

