Clazz.declarePackage("J.adapter.smarter");
Clazz.load(["J.api.JmolAdapter"], "J.adapter.smarter.SmarterJmolAdapter", ["java.io.BufferedReader", "$.StringReader", "java.util.Hashtable", "JU.PT", "$.Rdr", "J.adapter.smarter.AtomIterator", "$.AtomSetCollection", "$.BondIterator", "$.Resolver", "$.StructureIterator", "J.api.Interface", "JS.SV", "JU.BSUtil", "$.Logger"], function(){
var c$ = Clazz.declareType(J.adapter.smarter, "SmarterJmolAdapter", J.api.JmolAdapter);
Clazz.makeConstructor(c$, 
function(){
Clazz.superConstructor (this, J.adapter.smarter.SmarterJmolAdapter, []);
});
Clazz.overrideMethod(c$, "getFileTypeName", 
function(ascOrReader){
if ((typeof(ascOrReader)=='string')) return J.adapter.smarter.Resolver.getFileTypefromFilter(ascOrReader);
if (Clazz.instanceOf(ascOrReader,"J.adapter.smarter.AtomSetCollection")) {
return (ascOrReader).fileTypeName;
}if (Clazz.instanceOf(ascOrReader,"java.io.BufferedReader")) return J.adapter.smarter.Resolver.getFileType(ascOrReader);
if (Clazz.instanceOf(ascOrReader,"java.io.BufferedInputStream")) {
var type = J.adapter.smarter.Resolver.getBinaryType(ascOrReader);
if (type == null) try {
type = J.adapter.smarter.Resolver.getFileType(JU.Rdr.getBufferedReader(ascOrReader, null));
} catch (e) {
if (Clazz.exceptionOf(e, Exception)){
} else {
throw e;
}
}
return type;
}return null;
}, "~O");
Clazz.overrideMethod(c$, "getAtomSetCollectionReader", 
function(name, type, bufferedReader, htParams){
return J.adapter.smarter.SmarterJmolAdapter.staticGetAtomSetCollectionReader(name, type, bufferedReader, htParams);
}, "~S,~S,~O,java.util.Map");
c$.staticGetAtomSetCollectionReader = Clazz.defineMethod(c$, "staticGetAtomSetCollectionReader", 
function(name, type, bufferedReader, htParams){
if (htParams == null) htParams =  new java.util.Hashtable();
try {
var ret = J.adapter.smarter.Resolver.getAtomCollectionReader(name, type, bufferedReader, htParams, -1);
if ((typeof(ret)=='string')) {
try {
J.adapter.smarter.SmarterJmolAdapter.close(bufferedReader);
} catch (e) {
if (Clazz.exceptionOf(e, Exception)){
} else {
throw e;
}
}
} else {
(ret).setup(name, htParams, bufferedReader);
}return ret;
} catch (e) {
try {
J.adapter.smarter.SmarterJmolAdapter.close(bufferedReader);
} catch (ex) {
if (Clazz.exceptionOf(ex, Exception)){
} else {
throw ex;
}
}
bufferedReader = null;
JU.Logger.error("" + e);
return "" + e;
}
}, "~S,~S,~O,java.util.Map");
Clazz.overrideMethod(c$, "getAtomSetCollectionFromReader", 
function(fname, readerOrDocument, htParams){
var ret = J.adapter.smarter.Resolver.getAtomCollectionReader(fname, null, readerOrDocument, htParams, -1);
if (Clazz.instanceOf(ret,"J.adapter.smarter.AtomSetCollectionReader")) {
if (Clazz.instanceOf(readerOrDocument,"java.io.BufferedInputStream")) {
var bis = readerOrDocument;
if (J.adapter.smarter.Resolver.getBinaryType(bis) != null) {
readerOrDocument = (J.api.Interface.getInterface("JU.BinaryDocument", null, "JmolAdapter")).setStream(bis, false);
} else {
readerOrDocument = JU.Rdr.getBufferedReader(bis, null);
}}(ret).setup(fname, htParams, readerOrDocument);
return (ret).readData();
}return "" + ret;
}, "~S,~O,java.util.Map");
Clazz.overrideMethod(c$, "getAtomSetCollection", 
function(ascReader){
return J.adapter.smarter.SmarterJmolAdapter.staticGetAtomSetCollection(ascReader);
}, "~O");
c$.staticGetAtomSetCollection = Clazz.defineMethod(c$, "staticGetAtomSetCollection", 
function(a){
var br = null;
try {
br = a.reader;
var ret = a.readData();
if (!(Clazz.instanceOf(ret,"J.adapter.smarter.AtomSetCollection"))) return ret;
var asc = ret;
if (asc.errorMessage != null) return asc.errorMessage;
return asc;
} catch (e) {
try {
JU.Logger.info(e.toString());
} catch (ee) {
if (Clazz.exceptionOf(ee, Exception)){
JU.Logger.error(e.toString());
} else {
throw ee;
}
}
try {
br.close();
} catch (ex) {
if (Clazz.exceptionOf(ex, Exception)){
} else {
throw ex;
}
}
br = null;
JU.Logger.error("" + e);
return "" + e;
}
}, "J.adapter.smarter.AtomSetCollectionReader");
Clazz.overrideMethod(c$, "getAtomSetCollectionReaders", 
function(filesReader, names, types, htParams, getReadersOnly){
var vwr = htParams.get("vwr");
var size = names.length;
var reader = null;
if (htParams.containsKey("concatenate")) {
var s = "";
for (var i = 0; i < size; i++) {
var name = names[i];
var f = vwr.getFileAsString3(name, false, null);
if (i > 0 && size <= 3 && f.startsWith("{")) {
var type = (f.contains("version\":\"DSSR") ? "dssr" : f.contains("/outliers/") ? "validation" : "domains");
var x = vwr.parseJSONMap(f);
if (x != null) htParams.put(type, (type.equals("dssr") ? x : JS.SV.getVariableMap(x)));
continue;
}if (name.indexOf("|") >= 0) name = JU.PT.rep(name, "_", "/");
if (i == 1) {
if (name.indexOf("/rna3dhub/") >= 0) {
s += "\n_rna3d \n;" + f + "\n;\n";
continue;
}if (name.indexOf("/dssr/") >= 0) {
s += "\n_dssr \n;" + f + "\n;\n";
continue;
}}s += f;
if (!s.endsWith("\n")) s += "\n";
}
size = 1;
reader = JU.Rdr.getBR(s);
}var readers = (getReadersOnly ?  new Array(size) : null);
var atomsets = (getReadersOnly ? null :  new Array(size));
var r = null;
for (var i = 0; i < size; i++) {
try {
htParams.put("vwr", vwr);
if (reader == null) reader = filesReader.getBufferedReaderOrBinaryDocument(i, false);
if (!(Clazz.instanceOf(reader,"java.io.BufferedReader") || Clazz.instanceOf(reader,"javajs.api.GenericBinaryDocument"))) return reader;
var fullPathName = names[i];
htParams.put("fullPathName", fullPathName);
var ret = J.adapter.smarter.Resolver.getAtomCollectionReader(names[i], (types == null ? null : types[i]), reader, htParams, i);
if (!(Clazz.instanceOf(ret,"J.adapter.smarter.AtomSetCollectionReader"))) return ret;
r = ret;
r.setup(null, null, null);
if (r.isBinary) {
r.setup(names[i], htParams, filesReader.getBufferedReaderOrBinaryDocument(i, true));
} else {
r.setup(names[i], htParams, reader);
}reader = null;
if (getReadersOnly) {
readers[i] = r;
} else {
ret = r.readData();
if (!(Clazz.instanceOf(ret,"J.adapter.smarter.AtomSetCollection"))) return ret;
atomsets[i] = ret;
if (atomsets[i].errorMessage != null) return atomsets[i].errorMessage;
}} catch (e) {
JU.Logger.error("" + e);
e.printStackTrace();
return "" + e;
}
}
if (getReadersOnly) return readers;
return this.getAtomSetCollectionFromSet(readers, atomsets, htParams);
}, "J.api.JmolFilesReaderInterface,~A,~A,java.util.Map,~B");
Clazz.overrideMethod(c$, "getAtomSetCollectionFromSet", 
function(readerSet, atomsets, htParams){
var readers = readerSet;
var asc = (atomsets == null ?  new Array(readers.length) : atomsets);
if (atomsets == null) {
for (var i = 0; i < readers.length; i++) {
if (readers[i] != null) try {
var ret = readers[i].readData();
if (!(Clazz.instanceOf(ret,"J.adapter.smarter.AtomSetCollection"))) return ret;
asc[i] = ret;
if (asc[i].errorMessage != null) return asc[i].errorMessage;
} catch (e) {
JU.Logger.error("" + e);
return "" + e;
}
}
}var result;
if (htParams.containsKey("trajectorySteps")) {
result = asc[0];
try {
if (asc.length > 1) asc[0].setInfo("ignoreUnitCell", asc[1].atomSetInfo.get("ignoreUnitCell"));
result.finalizeTrajectoryAs(htParams.get("trajectorySteps"), htParams.get("vibrationSteps"));
} catch (e) {
if (Clazz.exceptionOf(e, Exception)){
if (result.errorMessage == null) result.errorMessage = "" + e;
} else {
throw e;
}
}
} else if (asc[0].isTrajectory) {
result = asc[0];
for (var i = 1; i < asc.length; i++) asc[0].mergeTrajectories(asc[i]);

} else {
result = (asc.length == 1 ? asc[0] :  new J.adapter.smarter.AtomSetCollection("Array", null, asc, null));
}return (result.errorMessage == null ? result : result.errorMessage);
}, "~O,~O,java.util.Map");
Clazz.overrideMethod(c$, "getAtomSetCollectionFromDOM", 
function(DOMNode, htParams){
throw  new UnsupportedOperationException();
}, "~O,java.util.Map");
Clazz.overrideMethod(c$, "finish", 
function(asc){
(asc).finish();
}, "~O");
Clazz.overrideMethod(c$, "getAtomSetCollectionName", 
function(asc){
return (asc).collectionName;
}, "~O");
Clazz.overrideMethod(c$, "getAtomSetCollectionAuxiliaryInfo", 
function(asc){
return (asc).atomSetInfo;
}, "~O");
Clazz.overrideMethod(c$, "getAtomSetCount", 
function(asc){
return (asc).atomSetCount;
}, "~O");
Clazz.overrideMethod(c$, "getAtomSetNumber", 
function(asc, atomSetIndex){
return (asc).getAtomSetNumber(atomSetIndex);
}, "~O,~N");
Clazz.overrideMethod(c$, "getAtomSetName", 
function(asc, atomSetIndex){
return (asc).getAtomSetName(atomSetIndex);
}, "~O,~N");
Clazz.overrideMethod(c$, "getAtomSetAuxiliaryInfo", 
function(asc, atomSetIndex){
return (asc).getAtomSetAuxiliaryInfo(atomSetIndex);
}, "~O,~N");
Clazz.overrideMethod(c$, "getHydrogenAtomCount", 
function(asc){
return (asc).getHydrogenAtomCount();
}, "~O");
Clazz.overrideMethod(c$, "getBondList", 
function(asc){
return (asc).getBondList();
}, "~O");
Clazz.overrideMethod(c$, "getAtomCount", 
function(asc, atomSetIndex){
var a = asc;
if (atomSetIndex < 0) return (a.bsAtoms == null ? a.ac : a.bsAtoms.cardinality());
if (a.bsAtoms == null) return a.getAtomSetAtomCount(atomSetIndex);
var b = JU.BSUtil.copy(a.bsAtoms);
var i0 = a.getAtomSetAtomIndex(atomSetIndex);
b.and(JU.BSUtil.newBitSet2(i0, i0 + a.getAtomSetAtomCount(atomSetIndex)));
return b.cardinality();
}, "~O,~N");
Clazz.overrideMethod(c$, "coordinatesAreFractional", 
function(asc){
return (asc).coordinatesAreFractional;
}, "~O");
Clazz.overrideMethod(c$, "getAtomIterator", 
function(asc){
return  new J.adapter.smarter.AtomIterator(asc);
}, "~O");
Clazz.overrideMethod(c$, "getBondIterator", 
function(asc){
return ((asc).bondCount == 0 ? null :  new J.adapter.smarter.BondIterator(asc));
}, "~O");
Clazz.overrideMethod(c$, "getStructureIterator", 
function(asc){
return (asc).structureCount == 0 ? null :  new J.adapter.smarter.StructureIterator(asc);
}, "~O");
c$.close = Clazz.defineMethod(c$, "close", 
function(bufferedReader){
if (Clazz.instanceOf(bufferedReader,"java.io.BufferedReader")) (bufferedReader).close();
 else (bufferedReader).close();
}, "~O");
Clazz.overrideMethod(c$, "getAtomSetCollectionInline", 
function(molData, htParams){
var r = null;
try {
if ((typeof(molData)=='string')) {
r =  new java.io.BufferedReader( new java.io.StringReader(molData));
} else if (Clazz.instanceOf(molData,"java.io.InputStream")) {
r = molData;
} else {
return null;
}var atomSetReader = this.getAtomSetCollectionReader("String", null, r, null);
if ((typeof(atomSetReader)=='string')) {
return atomSetReader;
}return this.getAtomSetCollection(atomSetReader);
} finally {
try {
if (Clazz.instanceOf(r,"java.io.BufferedReader")) {
(r).close();
} else {
(r).close();
}} catch (e) {
if (Clazz.exceptionOf(e,"java.io.IOException")){
} else {
throw e;
}
}
}
}, "~O,java.util.Map");
c$.PATH_SEPARATOR = System.getProperty("path.separator", "/");
});
;//5.0.1-v7 Sat Jan 10 12:35:15 CST 2026
