/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.pathname;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.FrameField;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Pathname"})
public class RubyPathname
extends RubyObject {
    private static final ReturnValueMapper IDENTITY_MAPPER = (context, klazz, value2) -> value2;
    private static final ReturnValueMapper SINGLE_PATH_MAPPER = (context, klazz, value2) -> RubyPathname.newInstance(context, klazz, value2);
    private static final ReturnValueMapper ARRAY_OF_PATHS_MAPPER = (context, klazz, value2) -> RubyPathname.mapToPathnames(context, klazz, value2);
    private static final AddArg UNSHIFT_PATH = (args2, path2) -> RubyPathname.insert(args2, 0, path2);
    private static final AddArg APPEND_PATH = (args2, path2) -> RubyPathname.insert(args2, args2.length, path2);

    private RubyString getPath() {
        return this.getInstanceVariable("@path").convertToString();
    }

    private void setPath(RubyString path2) {
        this.setInstanceVariable("@path", path2);
    }

    static void createPathnameClass(ThreadContext context) {
        RubyClass Dir2 = Access.dirClass(context);
        RubyClass File2 = Access.fileClass(context);
        RubyModule FileTest = Access.fileTestModule(context);
        RubyClass IO = Access.ioClass(context);
        RubyClass Pathname = (RubyClass)Define.defineClass(context, "Pathname", Access.objectClass(context), RubyPathname::new).defineMethods(context, RubyPathname.class);
        Access.kernelModule(context).defineMethods(context, PathnameKernelMethods.class);
        RubyPathname.defineDelegateMethods(context, Pathname, File2, "atime", "ctime", "birthtime", "mtime", "ftype", "rename", "stat", "lstat", "truncate", "extname", "open");
        RubyPathname.defineDelegateMethodsAppendPath(context, Pathname, File2, "chmod", "lchmod", "chown", "lchown", "utime");
        RubyPathname.defineDelegateMethodsSinglePath(context, Pathname, File2, "realpath", "realdirpath", "basename", "dirname", "expand_path", "readlink");
        RubyPathname.defineDelegateMethodsArrayOfPaths(context, Pathname, File2, "split");
        RubyPathname.defineDelegateMethods(context, Pathname, IO, "read", "binread", "write", "binwrite", "readlines", "sysopen");
        RubyPathname.defineDelegateMethods(context, Pathname, FileTest, "blockdev?", "chardev?", "executable?", "executable_real?", "exist?", "grpowned?", "directory?", "file?", "pipe?", "socket?", "owned?", "readable?", "world_readable?", "readable_real?", "setuid?", "setgid?", "size", "size?", "sticky?", "symlink?", "writable?", "world_writable?", "writable_real?", "zero?");
        RubyPathname.defineDelegateMethods(context, Pathname, Dir2, "mkdir", "rmdir");
        RubyPathname.defineDelegateMethodsArrayOfPaths(context, Pathname, Dir2, "entries");
        Pathname.undefMethods(context, "=~");
    }

    private static void defineDelegateMethodsGeneric(ThreadContext context, RubyClass cPathname, final RubyModule klass, final ReturnValueMapper mapper, final AddArg addArg, String ... methods2) {
        for (String method2 : methods2) {
            cPathname.addMethod(context, method2, new JavaMethod.JavaMethodNBlock(cPathname, Visibility.PUBLIC, method2){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject _self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    RubyPathname self2 = (RubyPathname)_self;
                    args2 = addArg.addArg(args2, self2.getPath());
                    return mapper.map(context, (RubyClass)clazz, klass.callMethod(context, name2, args2, block));
                }
            });
        }
    }

    private static void defineDelegateMethods(ThreadContext context, RubyClass cPathname, RubyModule klass, String ... methods2) {
        RubyPathname.defineDelegateMethodsGeneric(context, cPathname, klass, IDENTITY_MAPPER, UNSHIFT_PATH, methods2);
    }

    private static void defineDelegateMethodsAppendPath(ThreadContext context, RubyClass cPathname, RubyModule klass, String ... methods2) {
        RubyPathname.defineDelegateMethodsGeneric(context, cPathname, klass, IDENTITY_MAPPER, APPEND_PATH, methods2);
    }

    private static void defineDelegateMethodsSinglePath(ThreadContext context, RubyClass cPathname, RubyModule klass, String ... methods2) {
        RubyPathname.defineDelegateMethodsGeneric(context, cPathname, klass, SINGLE_PATH_MAPPER, UNSHIFT_PATH, methods2);
    }

    private static void defineDelegateMethodsArrayOfPaths(ThreadContext context, RubyClass cPathname, RubyModule klass, String ... methods2) {
        RubyPathname.defineDelegateMethodsGeneric(context, cPathname, klass, ARRAY_OF_PATHS_MAPPER, UNSHIFT_PATH, methods2);
    }

    public RubyPathname(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    public static RubyPathname newInstance(ThreadContext context, RubyClass klass, IRubyObject path2) {
        RubyPathname pathname2 = new RubyPathname(context.runtime, klass);
        return (RubyPathname)pathname2.initialize(context, path2);
    }

    public static RubyPathname newInstance(ThreadContext context, IRubyObject path2) {
        return RubyPathname.newInstance(context, Access.getClass(context, "Pathname"), path2);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject path2) {
        RubyString str;
        if (path2.respondsTo("to_path")) {
            path2 = path2.callMethod(context, "to_path");
        }
        if ((str = path2.convertToString()).getByteList().indexOf(0) != -1) {
            throw Error.argumentError(context, "pathname contains null byte");
        }
        this.setPath((RubyString)str.dup());
        return this;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject pathname2) {
        super.initialize_copy(context, pathname2);
        this.initialize(context, pathname2);
        return this;
    }

    @JRubyMethod
    public IRubyObject to_path(ThreadContext context) {
        return this.getPath();
    }

    @Override
    @JRubyMethod
    public IRubyObject freeze(ThreadContext context) {
        this.getPath().freeze(context);
        return super.freeze(context);
    }

    @Override
    @JRubyMethod(name={"==", "eql?"})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyPathname) {
            return Helpers.rbEqual(context, this.getPath(), ((RubyPathname)other).getPath());
        }
        return context.fals;
    }

    private int cmp(RubyPathname other) {
        int i2;
        byte[] a = this.getPath().getByteList().bytes();
        byte[] b2 = other.getPath().getByteList().bytes();
        for (i2 = 0; i2 < a.length && i2 < b2.length; ++i2) {
            byte ca = a[i2];
            byte cb = b2[i2];
            if (ca == 47) {
                ca = 0;
            }
            if (cb == 47) {
                cb = 0;
            }
            if (ca == cb) continue;
            return ca < cb ? -1 : 1;
        }
        if (i2 < a.length) {
            return 1;
        }
        if (i2 < b2.length) {
            return -1;
        }
        return 0;
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        IRubyObject iRubyObject;
        if (other instanceof RubyPathname) {
            RubyPathname path2 = (RubyPathname)other;
            iRubyObject = Convert.asFixnum(context, this.cmp(path2));
        } else {
            iRubyObject = context.nil;
        }
        return iRubyObject;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return this.getPath().hash(context);
    }

    @Override
    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        return this.getPath().dup();
    }

    @Override
    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        return Create.newString(context, "#<Pathname:" + String.valueOf(this.getPath()) + ">");
    }

    @JRubyMethod(required=1, optional=1, checkArity=false, writes={FrameField.BACKREF})
    public IRubyObject sub(ThreadContext context, IRubyObject[] args2, Block block) {
        IRubyObject result2 = RubyPathname.sites((ThreadContext)context).sub.call(context, (IRubyObject)this, (IRubyObject)this.getPath(), args2, block);
        return RubyPathname.newInstance(context, result2);
    }

    @JRubyMethod
    public IRubyObject sub_ext(ThreadContext context, IRubyObject newExt) {
        IRubyObject ext2 = Access.fileClass(context).callMethod(context, "extname", (IRubyObject)this.getPath());
        IRubyObject newPath = this.getPath().chomp(context, ext2).callMethod(context, "+", newExt);
        return RubyPathname.newInstance(context, newPath);
    }

    @JRubyMethod(name={"fnmatch", "fnmatch?"})
    public IRubyObject fnmatch_p(ThreadContext context, IRubyObject arg0) {
        RubyClass File2 = Access.fileClass(context);
        return RubyPathname.sites((ThreadContext)context).fnmatch_p.call(context, (IRubyObject)File2, (IRubyObject)File2, arg0, (IRubyObject)this.getPath());
    }

    @JRubyMethod(name={"fnmatch", "fnmatch?"})
    public IRubyObject fnmatch_p(ThreadContext context, IRubyObject arg0, IRubyObject arg1) {
        RubyClass File2 = Access.fileClass(context);
        return RubyPathname.sites((ThreadContext)context).fnmatch_p.call(context, (IRubyObject)File2, (IRubyObject)File2, arg0, (IRubyObject)this.getPath(), arg1);
    }

    @JRubyMethod
    public IRubyObject make_link(ThreadContext context, IRubyObject old) {
        return Access.fileClass(context).callMethod(context, "link", new IRubyObject[]{old, this.getPath()});
    }

    @JRubyMethod
    public IRubyObject make_symlink(ThreadContext context, IRubyObject old) {
        return Access.fileClass(context).callMethod(context, "symlink", new IRubyObject[]{old, this.getPath()});
    }

    @JRubyMethod(optional=3, checkArity=false, keywords=true)
    public IRubyObject each_line(ThreadContext context, IRubyObject[] args2, Block block) {
        return Access.fileClass(context).callMethod(context, "foreach", this.unshiftPath(args2), block);
    }

    @JRubyMethod(alias={"pwd"}, meta=true)
    public static IRubyObject getwd(ThreadContext context, IRubyObject recv2) {
        return RubyPathname.newInstance(context, Access.dirClass(context).callMethod("getwd"));
    }

    @JRubyMethod(required=1, optional=2, checkArity=false, meta=true)
    public static IRubyObject glob(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        RubyArray files = RubyPathname.mapToPathnames(context, (RubyClass)recv2, Access.dirClass(context).callMethod(context, "glob", args2));
        if (!block.isGiven()) {
            return files;
        }
        files.each(context, block);
        return context.nil;
    }

    @JRubyMethod(required=1, optional=1, checkArity=false)
    public IRubyObject glob(ThreadContext context, IRubyObject[] _args, Block block) {
        int argc = Arity.checkArgumentCount(context, _args, 1, 2);
        IRubyObject[] args2 = new IRubyObject[3];
        boolean blockGiven = block.isGiven();
        args2[0] = _args[0];
        args2[1] = argc == 1 ? Convert.asFixnum(context, 0) : _args[1];
        args2[2] = Create.newSmallHash(context);
        ((RubyHash)args2[2]).fastASetSmall(Convert.asSymbol(context, "base"), this.getPath());
        JavaSites.PathnameSites sites = RubyPathname.sites(context);
        CallSite glob2 = sites.glob;
        RubyArray ary = glob2.call(context, (IRubyObject)this, (IRubyObject)Access.dirClass(context), args2).convertToArray();
        CallSite op_plus2 = sites.op_plus;
        for (long i2 = 0L; i2 < (long)ary.size(); ++i2) {
            IRubyObject elt = op_plus2.call(context, (IRubyObject)this, (IRubyObject)this, (IRubyObject)ary.eltOk(i2));
            ary.eltSetOk(i2, elt);
            if (!blockGiven) continue;
            block.yield(context, elt);
        }
        return blockGiven ? context.nil : ary;
    }

    @JRubyMethod
    public IRubyObject opendir(ThreadContext context, Block block) {
        return Access.dirClass(context).callMethod(context, "open", new IRubyObject[]{this.getPath()}, block);
    }

    @JRubyMethod
    public IRubyObject each_entry(ThreadContext context, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, this, "each_entry");
        }
        RubyArray entries2 = this.callMethod(context, "entries").convertToArray();
        entries2.each(context, block);
        return context.nil;
    }

    @JRubyMethod(name={"unlink", "delete"})
    public IRubyObject unlink(ThreadContext context) {
        GlobalVariables globalVariables = Access.globalVariables(context);
        IRubyObject oldExc = globalVariables.get("$!");
        try {
            return Access.dirClass(context).callMethod(context, "unlink", (IRubyObject)this.getPath());
        }
        catch (RaiseException ex) {
            if (!Access.errnoModule(context).getClass(context, "ENOTDIR").isInstance(ex.getException())) {
                throw ex;
            }
            globalVariables.set("$!", oldExc);
            return Access.fileClass(context).callMethod(context, "unlink", (IRubyObject)this.getPath());
        }
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject empty_p(ThreadContext context) {
        RubyModule fileTest = Access.fileTestModule(context);
        return fileTest.callMethod(context, "directory?", (IRubyObject)this.getPath()).isTrue() ? Access.dirClass(context).callMethod(context, "empty?", (IRubyObject)this.getPath()) : fileTest.callMethod(context, "empty?", (IRubyObject)this.getPath());
    }

    private IRubyObject[] insertPath(IRubyObject[] args2, int i2) {
        return RubyPathname.insert(args2, i2, this.getPath());
    }

    private IRubyObject[] unshiftPath(IRubyObject[] args2) {
        return RubyPathname.insert(args2, 0, this.getPath());
    }

    private static IRubyObject[] insert(IRubyObject[] old, int i2, IRubyObject obj) {
        IRubyObject[] ary = new IRubyObject[old.length + 1];
        if (i2 > 0) {
            System.arraycopy(old, 0, ary, 0, i2);
        }
        ary[i2] = obj;
        if (old.length > i2) {
            System.arraycopy(old, i2, ary, i2 + 1, old.length - i2);
        }
        return ary;
    }

    private static RubyArray mapToPathnames(ThreadContext context, RubyClass clazz, IRubyObject ary) {
        RubyArray paths = ary.convertToArray();
        for (int i2 = 0; i2 < paths.size(); ++i2) {
            RubyString path2 = paths.eltOk(i2).convertToString();
            paths.store(i2, RubyPathname.newInstance(context, clazz, path2));
        }
        return paths;
    }

    private static JavaSites.PathnameSites sites(ThreadContext context) {
        return context.sites.Pathname;
    }

    @Override
    @Deprecated
    @JRubyMethod
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    @Override
    @Deprecated
    @JRubyMethod
    public IRubyObject untaint(ThreadContext context) {
        return this;
    }

    @Deprecated
    public IRubyObject fnmatch(ThreadContext context, IRubyObject[] args2) {
        return switch (args2.length) {
            case 1 -> this.fnmatch_p(context, args2[0]);
            case 2 -> this.fnmatch_p(context, args2[0], args2[1]);
            default -> throw Error.argumentError(context, args2.length, 1, 2);
        };
    }

    public static class PathnameKernelMethods {
        @JRubyMethod(name={"Pathname"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newPathname(ThreadContext context, IRubyObject recv2, IRubyObject path2) {
            return path2 instanceof RubyPathname ? path2 : RubyPathname.newInstance(context, path2);
        }
    }

    static interface AddArg {
        public IRubyObject[] addArg(IRubyObject[] var1, RubyString var2);
    }

    static interface ReturnValueMapper {
        public IRubyObject map(ThreadContext var1, RubyClass var2, IRubyObject var3);
    }
}

