/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericColor;
import javajs.util.BS;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.PT;
import jspecview.api.AnnotationData;
import jspecview.api.JSVPanel;
import jspecview.api.VisibleInterface;
import jspecview.common.Annotation;
import jspecview.common.ColorParameters;
import jspecview.common.ColoredAnnotation;
import jspecview.common.Coordinate;
import jspecview.common.ImageView;
import jspecview.common.Integral;
import jspecview.common.IntegralData;
import jspecview.common.Measurement;
import jspecview.common.MeasurementData;
import jspecview.common.PanelData;
import jspecview.common.Parameters;
import jspecview.common.PeakData;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.PlotWidget;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.common.ViewData;
import jspecview.common.XYScaleConverter;
import jspecview.dialog.JSVDialog;
import jspecview.source.JDXDataObject;
import org.jmol.api.GenericGraphics;
import org.jmol.util.Font;
import org.jmol.util.Logger;

class GraphSet
implements XYScaleConverter {
    private static final int ARROW_RESET = -1;
    private static final int ARROW_HOME = 0;
    private static final int ARROW_LEFT = 1;
    private static final int ARROW_RIGHT = 2;
    private static final int ARROW_UP = 3;
    private static final int ARROW_DOWN = 4;
    private GraphSet gs2dLinkedX;
    private GraphSet gs2dLinkedY;
    private boolean cur1D2Locked;
    private Lst<Highlight> highlights = new Lst();
    Lst<Spectrum> spectra = new Lst();
    private boolean isSplittable = true;
    private boolean allowStacking = true;
    private Lst<Annotation> annotations;
    private MeasurementData selectedSpectrumMeasurements;
    private MeasurementData selectedSpectrumIntegrals;
    private Annotation lastAnnotation;
    Measurement pendingMeasurement;
    private Integral pendingIntegral;
    private Lst<Spectrum> graphsTemp = new Lst();
    private PlotWidget[] widgets;
    private boolean isLinked;
    private boolean haveSingleYScale;
    static final double RT2 = Math.sqrt(2.0);
    private static GenericColor veryLightGrey;
    private int iSpectrumMovedTo;
    private int iSpectrumClicked;
    private int iSpectrumSelected = -1;
    private boolean stackSelected = false;
    private BS bsSelected = new BS();
    ViewData viewData;
    boolean reversePlot;
    int nSplit = 1;
    int yStackOffsetPercent = 0;
    boolean showAllStacked = true;
    Lst<ViewData> viewList;
    ImageView imageView;
    private PanelData pd;
    private boolean sticky2Dcursor;
    int nSpectra;
    private double fracX = 1.0;
    private double fracY = 1.0;
    private double fX0 = 0.0;
    private double fY0 = 0.0;
    private PlotWidget zoomBox1D;
    private PlotWidget zoomBox2D;
    private PlotWidget pin1Dx0;
    private PlotWidget pin1Dx1;
    private PlotWidget pin1Dy0;
    private PlotWidget pin1Dy1;
    private PlotWidget pin1Dx01;
    private PlotWidget pin1Dy01;
    private PlotWidget pin2Dx0;
    private PlotWidget pin2Dx1;
    private PlotWidget pin2Dy0;
    private PlotWidget pin2Dy1;
    private PlotWidget pin2Dx01;
    private PlotWidget pin2Dy01;
    private PlotWidget cur2Dx0;
    private PlotWidget cur2Dx1;
    private PlotWidget cur1D2x1;
    private PlotWidget cur1D2x2;
    private PlotWidget cur2Dy;
    private int xPixel0;
    private int yPixel0;
    private int xPixel1;
    private int yPixel1;
    private int xVArrows;
    private int xHArrows;
    private int yHArrows;
    private int xPixel00;
    private int yPixel00;
    private int xPixel11;
    private int yPixel11;
    private int yPixel000;
    private int xPixels;
    private int yPixels;
    private int xPixel10;
    private int xPixels0;
    private boolean allowStackedYScale = true;
    private boolean drawXAxisLeftToRight;
    private boolean xAxisLeftToRight = true;
    private int iPreviousSpectrumClicked = -1;
    private boolean haveSelectedSpectrum;
    private boolean zoomEnabled;
    private int currentZoomIndex;
    private double lastClickX = Double.NaN;
    private int lastPixelX = Integer.MAX_VALUE;
    private int height;
    private int width;
    private int right;
    private int top;
    private int left;
    private int bottom;
    private PeakInfo piMouseOver;
    private final Coordinate coordTemp = new Coordinate();
    private static final int minNumOfPointsForZoom = 3;
    private final int FONT_PLAIN = 0;
    private final int FONT_BOLD = 1;
    private final int FONT_ITALIC = 2;
    private boolean is2DSpectrum;
    private Measurement selectedMeasurement;
    private Integral selectedIntegral;
    private double lastXMax = Double.NaN;
    private int lastSpecClicked = -1;
    private static final int MIN_DRAG_PIXELS = 5;
    private boolean inPlotMove;
    private int xPixelMovedTo = -1;
    private int xPixelMovedTo2 = -1;
    private double yValueMovedTo;
    private double xValueMovedTo;
    private boolean haveLeftRightArrows;
    private int xPixelPlot1;
    private int xPixelPlot0;
    private int yPixelPlot0;
    private int yPixelPlot1;
    private Double nextClickForSetPeak;
    private int closerX;
    private int closerY;
    private int splitterX;
    private int splitterY;
    Map<Double, String> mapX = new Hashtable<Double, String>();
    private static final int ONLINE_CUTOFF = 2;
    private boolean widgetsAreSet = true;
    private int lastIntDragX;
    private int nextClickMode;
    static final int SHIFT_PEAK = 1;
    static final int SHIFT_SETX = 2;
    static final int SHIFT_X = 3;
    static final int SHIFT_CLICKED = 4;
    private Map<String, AnnotationData> dialogs;
    private Object[] aIntegrationRatios;
    private JSVPanel jsvp;
    private Object image2D;
    private GenericColor[] plotColors;
    private GenericGraphics g2d;
    private Object gMain;
    private final int COLOR_GREY = -3;
    private final int COLOR_BLACK = -2;
    private final int COLOR_INTEGRAL = -1;

    GraphSet(PanelData panelData) {
        this.pd = panelData;
        this.jsvp = panelData.jsvp;
        this.g2d = panelData.g2d;
    }

    private int setSpectrumMovedTo(int n) {
        this.iSpectrumMovedTo = n;
        return this.iSpectrumMovedTo;
    }

    private void setSpectrumClicked(int n) {
        this.stackSelected = this.showAllStacked;
        if (n < 0 || this.iSpectrumClicked != n) {
            this.lastClickX = Double.NaN;
            this.lastPixelX = Integer.MAX_VALUE;
        }
        this.iSpectrumClicked = this.setSpectrumSelected(this.setSpectrumMovedTo(n));
    }

    private int setSpectrumSelected(int n) {
        boolean bl = n != this.iSpectrumSelected;
        this.iSpectrumSelected = n;
        if (bl) {
            this.getCurrentView();
        }
        return this.iSpectrumSelected;
    }

    void closeDialogsExcept(Annotation.AType aType) {
        if (this.dialogs != null) {
            for (Map.Entry<String, AnnotationData> entry : this.dialogs.entrySet()) {
                AnnotationData annotationData = entry.getValue();
                if (!annotationData.isDialog() || aType != Annotation.AType.NONE && annotationData.getAType() == aType) continue;
                ((JSVDialog)annotationData).setVisible(false);
            }
        }
    }

    void dispose() {
        this.spectra = null;
        this.viewData = null;
        this.viewList = null;
        this.annotations = null;
        this.lastAnnotation = null;
        this.pendingMeasurement = null;
        this.imageView = null;
        this.graphsTemp = null;
        this.widgets = null;
        this.disposeImage();
        if (this.dialogs != null) {
            for (Map.Entry<String, AnnotationData> entry : this.dialogs.entrySet()) {
                AnnotationData annotationData = entry.getValue();
                if (!annotationData.isDialog()) continue;
                ((JSVDialog)annotationData).dispose();
            }
        }
        this.dialogs = null;
    }

    private boolean isDrawNoSpectra() {
        return this.iSpectrumSelected == Integer.MIN_VALUE;
    }

    private int getFixedSelectedSpectrumIndex() {
        return Math.max(this.iSpectrumSelected, 0);
    }

    Spectrum getSpectrum() {
        return this.getSpectrumAt(this.getFixedSelectedSpectrumIndex()).getCurrentSubSpectrum();
    }

    Spectrum getSpectrumAt(int n) {
        return (Spectrum)this.spectra.get(n);
    }

    int getSpectrumIndex(Spectrum spectrum) {
        int n = this.spectra.size();
        while (--n >= 0) {
            if (this.spectra.get(n) != spectrum) continue;
            return n;
        }
        return -1;
    }

    private void addSpec(Spectrum spectrum) {
        this.spectra.addLast(spectrum);
        ++this.nSpectra;
    }

    void splitStack(boolean bl) {
        if (bl && this.isSplittable) {
            this.nSplit = this.nSpectra;
            this.showAllStacked = false;
            this.setSpectrumClicked(this.iSpectrumSelected);
            this.pd.currentSplitPoint = this.iSpectrumSelected;
        } else {
            this.nSplit = 1;
            this.showAllStacked = this.allowStacking && !bl;
            this.setSpectrumClicked(this.iSpectrumSelected);
        }
        this.stackSelected = false;
        GraphSet.setFractionalPositions(this.pd, this.pd.graphSets, PanelData.LinkMode.NONE);
        this.pd.setTaintedAll();
    }

    private void setPositionForFrame(int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.height - 50;
        this.xPixel00 = (int)((double)this.width * this.fX0);
        this.xPixel11 = (int)((double)this.xPixel00 + (double)this.width * this.fracX - 1.0);
        this.xHArrows = this.xPixel00 + 25;
        this.xVArrows = this.xPixel11 - this.right / 2;
        this.xPixel0 = this.xPixel00 + (int)((double)this.left * (1.0 - this.fX0));
        this.xPixel10 = this.xPixel1 = this.xPixel11 - this.right;
        this.xPixels0 = this.xPixels = this.xPixel1 - this.xPixel0 + 1;
        this.yPixel000 = (this.fY0 == 0.0 ? 25 : 0) + (int)((double)this.height * this.fY0);
        this.yPixel00 = this.yPixel000 + (int)((double)n2 * this.fracY * (double)n);
        this.yPixel11 = this.yPixel00 + (int)((double)n2 * this.fracY) - 1;
        this.yHArrows = this.yPixel11 - 12;
        this.yPixel0 = this.yPixel00 + this.top / 2;
        this.yPixel1 = this.yPixel11 - this.bottom / 2;
        this.yPixels = this.yPixel1 - this.yPixel0 + 1;
        if (this.imageView != null && this.is2DSpectrum) {
            this.setImageWindow();
            if (this.pd.display1D) {
                double d = this.pd.display1D ? 1.0 * (double)(this.xPixels0 - this.imageView.xPixels) / (double)this.xPixels0 : 1.0;
                this.xPixels = (int)Math.floor(d * (double)this.xPixels0 * 0.8);
                this.xPixel1 = this.xPixel0 + this.xPixels - 1;
            } else {
                this.xPixels = 0;
                this.xPixel1 = this.imageView.xPixel0 - 30;
            }
        }
    }

    private boolean hasPoint(int n, int n2) {
        return n >= this.xPixel00 && n <= this.xPixel11 && n2 >= this.yPixel000 && n2 <= this.yPixel11 * this.nSplit;
    }

    private boolean isInPlotRegion(int n, int n2) {
        return n >= this.xPixel0 && n <= this.xPixel1 && n2 >= this.yPixel0 && n2 <= this.yPixel1;
    }

    int getSplitPoint(int n) {
        return Math.max(0, Math.min((n - this.yPixel000) / (this.yPixel11 - this.yPixel00), this.nSplit - 1));
    }

    private boolean isSplitWidget(int n, int n2) {
        return this.isFrameBox(n, n2, this.splitterX, this.splitterY);
    }

    private boolean isCloserWidget(int n, int n2) {
        return this.isFrameBox(n, n2, this.closerX, this.closerY);
    }

    private void initGraphSet(int n, int n2) {
        if (veryLightGrey == null) {
            veryLightGrey = this.g2d.getColor3(200, 200, 200);
        }
        this.setPlotColors(ColorParameters.defaultPlotColors);
        this.xAxisLeftToRight = this.getSpectrumAt(0).shouldDisplayXAxisIncreasing();
        this.setDrawXAxis();
        int[] nArray = new int[this.nSpectra];
        int[] nArray2 = new int[this.nSpectra];
        this.bsSelected.setBits(0, this.nSpectra);
        this.allowStackedYScale = true;
        if (n2 <= 0) {
            n2 = Integer.MAX_VALUE;
        }
        this.isSplittable = this.nSpectra > 1;
        this.allowStacking = ((Spectrum)this.spectra.get(0)).isStackable();
        this.showAllStacked = this.allowStacking && this.nSpectra > 1;
        int n3 = 0;
        while (n3 < this.nSpectra) {
            int n4 = ((Spectrum)this.spectra.get(n3)).getXYCoords().length - 1;
            nArray[n3] = Coordinate.intoRange(n, 0, n4);
            nArray2[n3] = Coordinate.intoRange(n2, 0, n4);
            this.allowStackedYScale &= ((Spectrum)this.spectra.get(n3)).getYUnits().equals(((Spectrum)this.spectra.get(0)).getYUnits()) && ((Spectrum)this.spectra.get(n3)).getUserYFactor() == ((Spectrum)this.spectra.get(0)).getUserYFactor();
            ++n3;
        }
        this.getView(0.0, 0.0, 0.0, 0.0, nArray, nArray2, null, null);
        this.viewList = new Lst();
        this.viewList.addLast(this.viewData);
    }

    private synchronized void getView(double d, double d2, double d3, double d4, int[] nArray, int[] nArray2, ScaleData[] scaleDataArray, ScaleData[] scaleDataArray2) {
        Lst<Spectrum> lst = this.graphsTemp.size() == 0 ? this.spectra : this.graphsTemp;
        Lst<Spectrum> lst2 = this.getSpectrumAt(0).getSubSpectra();
        boolean bl = lst2 == null || lst2.size() == 2 && ((Spectrum)lst2.get(1)).isImaginary();
        boolean bl2 = !this.getSpectrumAt(0).is1D();
        boolean bl3 = false;
        if (bl2 && bl3 || bl && d3 == d4) {
            lst = this.spectra;
        } else if (d3 == d4) {
            this.viewData = new ViewData(lst2, d3, d4, this.getSpectrum().isContinuous());
            lst = null;
        }
        if (lst != null) {
            this.viewData = new ViewData(lst, d3, d4, nArray, nArray2, this.getSpectrumAt(0).isContinuous(), bl2);
            if (d != d2) {
                this.getScale().setXRange(d, d2);
            }
        }
        if (scaleDataArray != null) {
            ScaleData.copyScaleFactors(scaleDataArray, this.viewData.getScaleData());
            if (scaleDataArray2 != null) {
                ScaleData.copyYScales(scaleDataArray2, this.viewData.getScaleData());
            }
            this.getCurrentView();
        }
    }

    private boolean isNearby(Coordinate coordinate, Coordinate coordinate2, XYScaleConverter xYScaleConverter, int n) {
        double d = coordinate.getXVal();
        int n2 = xYScaleConverter.toPixelX(d);
        int n3 = this.toPixelY(coordinate.getYVal());
        d = coordinate2.getXVal();
        int n4 = xYScaleConverter.toPixelX(d);
        int n5 = this.toPixelY(coordinate2.getYVal());
        return Math.abs(n2 - n4) + Math.abs(n3 - n5) < n;
    }

    void setReversePlot(boolean bl) {
        this.reversePlot = bl;
        if (this.reversePlot) {
            this.closeDialogsExcept(Annotation.AType.NONE);
        }
        this.setDrawXAxis();
    }

    private void setDrawXAxis() {
        this.drawXAxisLeftToRight = this.xAxisLeftToRight ^ this.reversePlot;
        int n = 0;
        while (n < this.spectra.size()) {
            ((Spectrum)this.spectra.get(n)).setExportXAxisDirection(this.drawXAxisLeftToRight);
            ++n;
        }
    }

    private boolean isInTopBar(int n, int n2) {
        return n == this.fixX(n) && n2 > this.pin1Dx0.yPixel0 - 2 && n2 < this.pin1Dx0.yPixel1;
    }

    private boolean isInTopBar2D(int n, int n2) {
        return this.imageView != null && n == this.imageView.fixX(n) && n2 > this.pin2Dx0.yPixel0 - 2 && n2 < this.pin2Dx0.yPixel1;
    }

    private boolean isInRightBar(int n, int n2) {
        return n2 == this.fixY(n2) && n > this.pin1Dy0.xPixel1 && n < this.pin1Dy0.xPixel0 + 2;
    }

    private boolean isInRightBar2D(int n, int n2) {
        return this.imageView != null && n2 == this.fixY(n2) && n > this.pin2Dy0.xPixel1 && n < this.pin2Dy0.xPixel0 + 2;
    }

    private double toX0(int n) {
        return ((ViewData)this.viewList.get(0)).getScale().toX0(this.fixX(n), this.xPixel0, this.xPixel1, this.drawXAxisLeftToRight);
    }

    private double toY0(int n) {
        return ((ViewData)this.viewList.get(0)).getScale().toY0(this.fixY(n), this.yPixel0, this.yPixel1);
    }

    @Override
    public double toX(int n) {
        if (this.imageView != null && this.imageView.isXWithinRange(n)) {
            return this.imageView.toX(n);
        }
        return this.getScale().toX(this.fixX(n), this.xPixel1, this.drawXAxisLeftToRight);
    }

    @Override
    public double toY(int n) {
        return this.getScale().toY(n, this.yPixel0);
    }

    @Override
    public int toPixelX(double d) {
        return this.getScale().toPixelX(d, this.xPixel0, this.xPixel1, this.drawXAxisLeftToRight);
    }

    @Override
    public int toPixelY(double d) {
        return this.getScale().toPixelY(d, this.yPixel1);
    }

    private int toPixelX0(double d) {
        return ((ViewData)this.viewList.get(0)).getScale().toPixelX0(d, this.xPixel0, this.xPixel1, this.drawXAxisLeftToRight);
    }

    private int toPixelY0(double d) {
        return this.fixY(((ViewData)this.viewList.get(0)).getScale().toPixelY0(d, this.yPixel0, this.yPixel1));
    }

    @Override
    public int fixX(int n) {
        return Coordinate.intoRange(n, this.xPixel0, this.xPixel1);
    }

    @Override
    public int fixY(int n) {
        return Coordinate.intoRange(n, this.yPixel0, this.yPixel1);
    }

    @Override
    public int getXPixel0() {
        return this.xPixel0;
    }

    @Override
    public int getXPixels() {
        return this.xPixels;
    }

    @Override
    public int getYPixels() {
        return this.yPixels;
    }

    @Override
    public ScaleData getScale() {
        return this.viewData.getScale();
    }

    private int toPixelYint(double d) {
        return this.yPixel1 - (int)(Double.isNaN(d) ? -2.147483648E9 : (double)this.yPixels * d);
    }

    private Annotation findAnnotation2D(Coordinate coordinate) {
        int n = this.annotations.size();
        while (--n >= 0) {
            Annotation annotation = (Annotation)this.annotations.get(n);
            if (!this.isNearby(annotation, coordinate, this.imageView, 10)) continue;
            return annotation;
        }
        return null;
    }

    private void addAnnotation(Annotation annotation, boolean bl) {
        if (this.annotations == null) {
            this.annotations = new Lst();
        }
        boolean bl2 = false;
        int n = this.annotations.size();
        while (--n >= 0) {
            if (!(annotation.is2D ? this.isNearby((Coordinate)this.annotations.get(n), annotation, this.imageView, 10) : annotation.equals((Coordinate)this.annotations.get(n)))) continue;
            bl2 = true;
            this.annotations.removeItemAt(n);
        }
        if (!(annotation.text.length() <= 0 || bl2 && bl)) {
            this.annotations.addLast(annotation);
        }
    }

    private void setImageWindow() {
        this.imageView.setPixelWidthHeight((int)((this.pd.display1D ? 0.6 : 1.0) * (double)this.xPixels0), this.yPixels);
        this.imageView.setXY0(this.getSpectrumAt(0), (int)Math.floor(this.xPixel10 - this.imageView.xPixels), this.yPixel0);
    }

    private boolean findNearestMaxMin() {
        if (this.nSpectra > 1 && this.iSpectrumClicked < 0) {
            return false;
        }
        this.xValueMovedTo = this.getSpectrum().findXForPeakNearest(this.xValueMovedTo);
        this.setXPixelMovedTo(this.xValueMovedTo, Double.MAX_VALUE, 0, 0);
        return !Double.isNaN(this.xValueMovedTo);
    }

    void setXPixelMovedTo(double d, double d2, int n, int n2) {
        if (d == Double.MAX_VALUE && d2 == Double.MAX_VALUE) {
            this.xPixelMovedTo = n;
            this.xPixelMovedTo2 = n2;
            if (this.isLinked && this.sticky2Dcursor) {
                this.pd.setlinkedXMove(this, this.toX(this.xPixelMovedTo), false);
            }
            return;
        }
        if (d != Double.MAX_VALUE) {
            this.xPixelMovedTo = this.toPixelX(d);
            if (this.fixX(this.xPixelMovedTo) != this.xPixelMovedTo) {
                this.xPixelMovedTo = -1;
            }
            this.xPixelMovedTo2 = -1;
            if (d != 1.0E10) {
                this.setSpectrumClicked(this.getFixedSelectedSpectrumIndex());
            }
        }
        if (d2 != Double.MAX_VALUE) {
            this.xPixelMovedTo2 = this.toPixelX(d2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processPendingMeasurement(int var1_1, int var2_2, int var3_3) {
        if (!this.isInPlotRegion(var1_1, var2_2) || this.is2dClick(var1_1, var2_2)) {
            this.pendingMeasurement = null;
            return;
        }
        var4_4 = this.toX(var1_1);
        var6_5 = this.toY(var2_2);
        var8_6 = var4_4;
        switch (var3_3) {
            case 0: {
                this.pendingMeasurement.setPt2(this.toX(var1_1), this.toY(var2_2));
                break;
            }
            case 2: 
            case 3: {
                if (this.iSpectrumClicked < 0) {
                    return;
                }
                var11_7 = (Spectrum)this.spectra.get(this.iSpectrumClicked);
                this.setScale(this.iSpectrumClicked);
                if (var3_3 != 3) {
                    var10_8 = this.findMeasurement(this.selectedSpectrumMeasurements, var1_1, var2_2, 1);
                    if (var10_8 != null) {
                        var4_4 = var10_8.getXVal();
                        var6_5 = var10_8.getYVal();
                    } else {
                        var10_8 = this.findMeasurement(this.selectedSpectrumMeasurements, var1_1, var2_2, 2);
                        if (var10_8 != null) {
                            var4_4 = var10_8.getXVal2();
                            var6_5 = var10_8.getYVal2();
                        } else {
                            var4_4 = this.getNearestPeak(var11_7, var4_4, var6_5);
                        }
                    }
                }
                this.pendingMeasurement = new Measurement().setM1(var4_4, var6_5, var11_7);
                this.pendingMeasurement.setPt2(var8_6, var6_5);
                this.pd.setTaintedAll();
                this.pd.repaint();
                break;
            }
            case -3: 
            case -2: 
            case 1: {
                v0 = var12_9 = this.pendingMeasurement != null && this.isVisible(this.getDialog(Annotation.AType.Measurements, -1)) != false;
                if (!var12_9) ** GOTO lbl54
                this.setScale(this.getSpectrumIndex(this.pendingMeasurement.spec));
                if (var3_3 == 3) ** GOTO lbl42
                if (!this.findNearestMaxMin()) {
                    var12_9 = false;
                } else {
                    var1_1 = this.xPixelMovedTo;
lbl42:
                    // 2 sources

                    var4_4 = this.toX(var1_1);
                    var6_5 = this.toY(var2_2);
                    this.pendingMeasurement.setPt2(var4_4, var6_5);
                    if (this.pendingMeasurement.text.length() == 0) {
                        var12_9 = false;
                    } else {
                        this.setMeasurement(this.pendingMeasurement);
                        if (var3_3 != 1) {
                            var12_9 = false;
                        } else {
                            this.setSpectrumClicked(this.getSpectrumIndex(this.pendingMeasurement.spec));
                            this.pendingMeasurement = new Measurement().setM1(var4_4, var6_5, this.pendingMeasurement.spec);
                        }
                    }
                }
lbl54:
                // 5 sources

                if (!var12_9) {
                    this.pendingMeasurement = null;
                }
                this.pd.setTaintedAll();
                this.pd.repaint();
                break;
            }
            case 5: {
                if (this.findNearestMaxMin()) {
                    var13_10 = this.getFixedSelectedSpectrumIndex();
                    if (Double.isNaN(this.lastXMax) || this.lastSpecClicked != var13_10 || this.pendingMeasurement == null) {
                        this.lastXMax = this.xValueMovedTo;
                        this.lastSpecClicked = var13_10;
                        this.pendingMeasurement = new Measurement().setM1(this.xValueMovedTo, this.yValueMovedTo, (Spectrum)this.spectra.get(var13_10));
                        break;
                    }
                    this.pendingMeasurement.setPt2(this.xValueMovedTo, this.yValueMovedTo);
                    if (this.pendingMeasurement.text.length() > 0) {
                        this.setMeasurement(this.pendingMeasurement);
                    }
                    this.pendingMeasurement = null;
                    this.lastXMax = NaN;
                    break;
                }
                this.lastXMax = NaN;
            }
        }
    }

    private boolean checkIntegralNormalizationClick(int n, int n2) {
        if (this.selectedSpectrumIntegrals == null) {
            return false;
        }
        Integral integral = (Integral)this.findMeasurement(this.selectedSpectrumIntegrals, n, n2, -5);
        if (integral == null) {
            return false;
        }
        this.selectedIntegral = integral;
        this.pd.normalizeIntegral();
        this.updateDialog(Annotation.AType.Integration, -1);
        this.setSpectrumClicked(this.getSpectrumIndex(integral.spec));
        return true;
    }

    private double getNearestPeak(Spectrum spectrum, double d, double d2) {
        double d3 = Coordinate.getNearestXWithYAbove(spectrum.getXYCoords(), d, d2, spectrum.isInverted(), false);
        double d4 = Coordinate.getNearestXWithYAbove(spectrum.getXYCoords(), d, d2, spectrum.isInverted(), true);
        return Double.isNaN(d3) ? d4 : (Double.isNaN(d4) ? d3 : (Math.abs(d3 - d) < Math.abs(d4 - d) ? d3 : d4));
    }

    private Measurement findMeasurement(MeasurementData measurementData, int n, int n2, int n3) {
        if (measurementData == null || measurementData.size() == 0) {
            return null;
        }
        if (n3 == 0) {
            Measurement measurement = this.findMeasurement(measurementData, n, n2, -1);
            if (measurement != null || measurementData.get(0) instanceof Integral) {
                return measurement;
            }
            return this.findMeasurement(measurementData, n, n2, -2);
        }
        int n4 = measurementData.size();
        block5: while (--n4 >= 0) {
            int n5;
            int n6;
            int n7;
            int n8;
            Measurement measurement = (Measurement)measurementData.get(n4);
            if (measurement instanceof Integral) {
                n7 = n8 = this.toPixelX(measurement.getXVal2());
                n6 = this.toPixelYint(measurement.getYVal());
                n5 = this.toPixelYint(measurement.getYVal2());
            } else {
                n7 = this.toPixelX(measurement.getXVal());
                n8 = this.toPixelX(measurement.getXVal2());
                n5 = n3 == -2 ? this.yPixel1 - 2 : this.toPixelY(measurement.getYVal());
                n6 = n5;
            }
            switch (n3) {
                case 1: {
                    if (Math.abs(n - n7) + Math.abs(n2 - n6) >= 4) continue block5;
                    return measurement;
                }
                case 2: {
                    if (Math.abs(n - n8) + Math.abs(n2 - n5) >= 4) continue block5;
                    return measurement;
                }
                case -5: {
                    n6 = n5 = (n6 + n5) / 2;
                    n8 = n7 + 20;
                }
                default: {
                    if (!GraphSet.isOnLine(n, n2, n7, n6, n8, n5)) continue block5;
                    return measurement;
                }
            }
        }
        return null;
    }

    private void setMeasurement(Measurement measurement) {
        int n = this.getSpectrumIndex(measurement.spec);
        AnnotationData annotationData = this.getDialog(Annotation.AType.Measurements, n);
        if (annotationData == null) {
            annotationData = new MeasurementData(Annotation.AType.Measurements, measurement.spec);
            this.addDialog(n, Annotation.AType.Measurements, annotationData);
        }
        annotationData.getData().addLast(measurement.copyM());
        this.updateDialog(Annotation.AType.Measurements, -1);
    }

    private boolean checkArrowUpDownClick(int n, int n2) {
        double d;
        boolean bl = false;
        double d2 = this.isArrowClick(n, n2, 3) ? RT2 : (d = this.isArrowClick(n, n2, 4) ? 1.0 / RT2 : 0.0);
        if (d != 0.0) {
            if (this.nSplit > 1) {
                this.setSpectrumSelected(this.iSpectrumMovedTo);
            }
            if ((this.nSpectra == 1 || this.iSpectrumSelected >= 0) && ((Spectrum)this.spectra.get(this.getFixedSelectedSpectrumIndex())).isTransmittance()) {
                d = 1.0 / d;
            }
            this.viewData.scaleSpectrum(this.imageView == null ? this.iSpectrumSelected : -2, d);
            bl = true;
        } else if (this.isArrowClick(n, n2, -1)) {
            this.resetViewCompletely();
            bl = true;
        }
        if (bl) {
            if (this.imageView != null) {
                this.update2dImage(false);
                this.resetPinsFromView();
            }
            this.pd.setTaintedAll();
        }
        return bl;
    }

    void resetViewCompletely() {
        this.clearViews();
        if (this.showAllStacked && !this.stackSelected) {
            this.closeDialogsExcept(Annotation.AType.NONE);
        }
        this.viewData.resetScaleFactors();
        this.updateDialogs();
    }

    private boolean checkArrowLeftRightClick(int n, int n2) {
        if (this.haveLeftRightArrows) {
            int n3;
            int n4 = this.isArrowClick(n, n2, 1) ? -1 : (n3 = this.isArrowClick(n, n2, 2) ? 1 : 0);
            if (n3 != 0) {
                int n5 = this.iSpectrumSelected + n3;
                if (n5 < 0) {
                    n5 = this.nSpectra - 1;
                }
                this.setSpectrumClicked(n5 % this.nSpectra);
                return true;
            }
            if (this.isArrowClick(n, n2, 0)) {
                if (this.showAllStacked) {
                    this.showAllStacked = false;
                    this.setSpectrumClicked(this.getFixedSelectedSpectrumIndex());
                    return true;
                }
                this.showAllStacked = this.allowStacking;
                this.setSpectrumSelected(-1);
                this.stackSelected = false;
            }
        }
        return false;
    }

    private boolean isArrowClick(int n, int n2, int n3) {
        switch (n3) {
            case -1: 
            case 3: 
            case 4: {
                int n4 = (this.yPixel00 + this.yPixel11) / 2 + (n3 == 3 ? -1 : (n3 == 4 ? 1 : 0)) * 15;
                return Math.abs(this.xVArrows - n) < 10 && Math.abs(n4 - n2) < 10;
            }
            case 0: 
            case 1: 
            case 2: {
                int n5 = this.xHArrows + (n3 == 1 ? -1 : (n3 == 2 ? 1 : 0)) * 15;
                return Math.abs(n5 - n) < 10 && Math.abs(this.yHArrows - n2) < 10;
            }
        }
        return false;
    }

    private void setWidgetValueByUser(PlotWidget plotWidget) {
        String string = plotWidget == this.cur2Dy ? "" + this.imageView.toSubspectrumIndex(plotWidget.yPixel0) : (plotWidget == this.pin1Dx01 ? Math.min(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()) + " - " + Math.max(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()) : (plotWidget == this.pin1Dy01 ? Math.min(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()) + " - " + Math.max(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()) : (plotWidget == this.pin2Dx01 ? Math.min(this.pin2Dx0.getXVal(), this.pin2Dx1.getXVal()) + " - " + Math.max(this.pin2Dx0.getXVal(), this.pin2Dx1.getXVal()) : (plotWidget == this.pin2Dy01 ? (int)Math.min(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) + " - " + (int)Math.max(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) : "" + plotWidget.getValue()))));
        if ((string = this.pd.getInput("New value?", "Set Slider", string)) == null) {
            return;
        }
        string = string.trim();
        try {
            if (plotWidget == this.pin1Dx01 || plotWidget == this.pin1Dy01 || plotWidget == this.pin2Dx01 || plotWidget == this.pin2Dy01) {
                int n = string.indexOf("-", 1);
                if (n < 0) {
                    return;
                }
                double d = Double.valueOf(string.substring(0, n));
                double d2 = Double.valueOf(string.substring(n + 1));
                if (plotWidget == this.pin1Dx01) {
                    this.doZoom(d, this.pin1Dy0.getYVal(), d2, this.pin1Dy1.getYVal(), true, false, false, true, true);
                } else if (plotWidget == this.pin1Dy01) {
                    this.doZoom(this.pin1Dx0.getXVal(), d, this.pin1Dx1.getXVal(), d2, this.imageView == null, this.imageView == null, false, false, true);
                } else if (plotWidget == this.pin2Dx01) {
                    this.imageView.setView0(this.imageView.toPixelX0(d), this.pin2Dy0.yPixel0, this.imageView.toPixelX0(d2), this.pin2Dy1.yPixel0);
                    this.doZoom(d, this.pin1Dy0.getYVal(), d2, this.pin1Dy1.getYVal(), false, false, false, true, true);
                } else if (plotWidget == this.pin2Dy01) {
                    this.imageView.setView0(this.pin2Dx0.xPixel0, this.imageView.toPixelY0(d), this.pin2Dx1.xPixel0, this.imageView.toPixelY0(d2));
                    this.doZoom(this.imageView.toX(this.imageView.xPixel0), this.getScale().minY, this.imageView.toX(this.imageView.xPixel0 + this.imageView.xPixels - 1), this.getScale().maxY, false, false, false, false, true);
                }
            } else {
                double d = Double.valueOf(string);
                if (plotWidget.isXtype) {
                    double d3 = plotWidget == this.pin1Dx0 || plotWidget == this.cur2Dx0 || plotWidget == this.pin2Dx0 ? this.pin1Dx1.getXVal() : this.pin1Dx0.getXVal();
                    this.doZoom(d, 0.0, d3, 0.0, !plotWidget.is2D, false, false, true, true);
                } else if (plotWidget == this.cur2Dy) {
                    this.setCurrentSubSpectrum((int)d);
                } else if (plotWidget == this.pin2Dy0 || plotWidget == this.pin2Dy1) {
                    int n = plotWidget == this.pin2Dy0 ? this.pin2Dy1.yPixel0 : this.pin2Dy0.yPixel0;
                    this.imageView.setView0(this.pin2Dx0.xPixel0, this.imageView.subIndexToPixelY((int)d), this.pin2Dx1.xPixel0, n);
                } else {
                    double d4 = plotWidget == this.pin1Dy0 ? this.pin1Dy1.getYVal() : this.pin1Dy0.getYVal();
                    this.doZoom(this.pin1Dx0.getXVal(), d, this.pin1Dx1.getXVal(), d4, this.imageView == null, this.imageView == null, false, false, true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeAllHighlights(Spectrum spectrum) {
        if (spectrum == null) {
            this.highlights.clear();
        } else {
            int n = this.highlights.size();
            while (--n >= 0) {
                if (((Highlight)this.highlights.get((int)n)).spectrum != spectrum) continue;
                this.highlights.removeItemAt(n);
            }
        }
    }

    private Coordinate setCoordClicked(int n, double d, double d2) {
        if (d2 == 0.0) {
            this.nextClickForSetPeak = null;
        }
        if (Double.isNaN(d)) {
            this.pd.coordClicked = null;
            this.pd.coordsClicked = null;
            return null;
        }
        this.lastClickX = d;
        this.pd.coordClicked = new Coordinate().set(this.lastClickX, d2);
        this.pd.coordsClicked = this.getSpectrum().getXYCoords();
        this.pd.xPixelClicked = this.lastPixelX = n;
        return this.pd.coordClicked;
    }

    private void setWidgets(boolean bl, int n, boolean bl2) {
        if (bl || this.pin1Dx0 == null) {
            if (this.zoomBox1D == null) {
                this.newPins();
            } else {
                this.resetPinPositions();
            }
        }
        this.setDerivedPins(n);
        this.setPinSliderPositions(bl2);
    }

    private void newPins() {
        this.zoomBox1D = new PlotWidget("zoomBox1D");
        this.pin1Dx0 = new PlotWidget("pin1Dx0");
        this.pin1Dx1 = new PlotWidget("pin1Dx1");
        this.pin1Dy0 = new PlotWidget("pin1Dy0");
        this.pin1Dy1 = new PlotWidget("pin1Dy1");
        this.pin1Dx01 = new PlotWidget("pin1Dx01");
        this.pin1Dy01 = new PlotWidget("pin1Dy01");
        this.cur1D2x1 = new PlotWidget("cur1D2x1");
        this.cur1D2x1.color = ScriptToken.PEAKTABCOLOR;
        this.cur1D2x2 = new PlotWidget("cur1D2x2");
        this.cur1D2x2.color = ScriptToken.PEAKTABCOLOR;
        if (this.imageView != null) {
            this.zoomBox2D = new PlotWidget("zoomBox2D");
            this.pin2Dx0 = new PlotWidget("pin2Dx0");
            this.pin2Dx1 = new PlotWidget("pin2Dx1");
            this.pin2Dy0 = new PlotWidget("pin2Dy0");
            this.pin2Dy1 = new PlotWidget("pin2Dy1");
            this.pin2Dx01 = new PlotWidget("pin2Dx01");
            this.pin2Dy01 = new PlotWidget("pin2Dy01");
            this.cur2Dx0 = new PlotWidget("cur2Dx0");
            this.cur2Dx1 = new PlotWidget("cur2Dx1");
            this.cur2Dy = new PlotWidget("cur2Dy");
            this.pin2Dy0.setY(0.0, this.imageView.toPixelY0(0.0));
            int n = this.getSpectrumAt(0).getSubSpectra().size();
            this.pin2Dy1.setY(n, this.imageView.toPixelY0(n));
        }
        this.setWidgetX(this.pin1Dx0, this.getScale().minX);
        this.setWidgetX(this.pin1Dx1, this.getScale().maxX);
        this.setWidgetY(this.pin1Dy0, this.getScale().minY);
        this.setWidgetY(this.pin1Dy1, this.getScale().maxY);
        this.widgets = new PlotWidget[]{this.zoomBox1D, this.zoomBox2D, this.pin1Dx0, this.pin1Dx01, this.pin1Dx1, this.pin1Dy0, this.pin1Dy01, this.pin1Dy1, this.pin2Dx0, this.pin2Dx01, this.pin2Dx1, this.pin2Dy0, this.pin2Dy01, this.pin2Dy1, this.cur2Dx0, this.cur2Dx1, this.cur2Dy, this.cur1D2x1, this.cur1D2x2};
    }

    private void setWidgetX(PlotWidget plotWidget, double d) {
        plotWidget.setX(d, this.toPixelX0(d));
    }

    private void setWidgetY(PlotWidget plotWidget, double d) {
        plotWidget.setY(d, this.toPixelY0(d));
    }

    private void resetPinsFromView() {
        if (this.pin1Dx0 == null) {
            return;
        }
        this.setWidgetX(this.pin1Dx0, this.getScale().minXOnScale);
        this.setWidgetX(this.pin1Dx1, this.getScale().maxXOnScale);
        this.setWidgetY(this.pin1Dy0, this.getScale().minYOnScale);
        this.setWidgetY(this.pin1Dy1, this.getScale().maxYOnScale);
    }

    private void resetPinPositions() {
        this.resetX(this.pin1Dx0);
        this.resetY(this.pin1Dy0);
        this.resetY(this.pin1Dy1);
        if (this.imageView == null) {
            if (this.gs2dLinkedX != null) {
                this.resetX(this.cur1D2x1);
            }
            if (this.gs2dLinkedY != null) {
                this.resetX(this.cur1D2x2);
            }
        } else {
            this.pin2Dy0.setY(this.pin2Dy0.getYVal(), this.imageView.toPixelY0(this.pin2Dy0.getYVal()));
            this.pin2Dy1.setY(this.pin2Dy1.getYVal(), this.imageView.toPixelY0(this.pin2Dy1.getYVal()));
        }
    }

    private void resetX(PlotWidget plotWidget) {
        this.setWidgetX(plotWidget, plotWidget.getXVal());
    }

    private void resetY(PlotWidget plotWidget) {
        this.setWidgetY(plotWidget, plotWidget.getYVal());
    }

    private void setPinSliderPositions(boolean bl) {
        this.pin1Dx1.yPixel0 = this.pin1Dx01.yPixel0 = this.yPixel0 - 5;
        this.pin1Dx0.yPixel0 = this.pin1Dx01.yPixel0;
        this.pin1Dx1.yPixel1 = this.pin1Dx01.yPixel1 = this.yPixel0;
        this.pin1Dx0.yPixel1 = this.pin1Dx01.yPixel1;
        this.cur1D2x1.yPixel1 = this.cur1D2x2.yPixel1 = this.yPixel0 - 5;
        this.cur1D2x1.yPixel0 = this.cur1D2x2.yPixel0 = this.yPixel1 + 6;
        if (this.imageView == null) {
            this.pin1Dy1.xPixel0 = this.pin1Dy01.xPixel0 = this.xPixel1 + 5;
            this.pin1Dy0.xPixel0 = this.pin1Dy01.xPixel0;
            this.pin1Dy1.xPixel1 = this.pin1Dy01.xPixel1 = this.xPixel1;
            this.pin1Dy0.xPixel1 = this.pin1Dy01.xPixel1;
        } else {
            this.pin1Dy1.xPixel0 = this.pin1Dy01.xPixel0 = this.imageView.xPixel1 + 15;
            this.pin1Dy0.xPixel0 = this.pin1Dy01.xPixel0;
            this.pin1Dy1.xPixel1 = this.pin1Dy01.xPixel1 = this.imageView.xPixel1 + 10;
            this.pin1Dy0.xPixel1 = this.pin1Dy01.xPixel1;
            this.pin2Dx1.yPixel0 = this.pin2Dx01.yPixel0 = this.yPixel0 - 5;
            this.pin2Dx0.yPixel0 = this.pin2Dx01.yPixel0;
            this.pin2Dx1.yPixel1 = this.pin2Dx01.yPixel1 = this.yPixel0;
            this.pin2Dx0.yPixel1 = this.pin2Dx01.yPixel1;
            this.pin2Dy1.xPixel0 = this.pin2Dy01.xPixel0 = this.imageView.xPixel1 + 5;
            this.pin2Dy0.xPixel0 = this.pin2Dy01.xPixel0;
            this.pin2Dy1.xPixel1 = this.pin2Dy01.xPixel1 = this.imageView.xPixel1;
            this.pin2Dy0.xPixel1 = this.pin2Dy01.xPixel1;
            this.cur2Dx0.yPixel0 = this.cur2Dx1.yPixel0 = this.yPixel1 + 6;
            this.cur2Dx0.yPixel1 = this.cur2Dx1.yPixel1 = this.yPixel0 - 5;
            this.cur2Dx0.yPixel0 = this.cur2Dx1.yPixel0 = this.yPixel1 + 6;
            this.cur2Dx1.yPixel1 = this.cur2Dx1.yPixel1 = this.yPixel0 - 5;
            this.cur2Dy.xPixel0 = bl ? (this.xPixel1 + this.imageView.xPixel0) / 2 : this.imageView.xPixel0 - 6;
            this.cur2Dy.xPixel1 = this.imageView.xPixel1 + 5;
        }
    }

    private void setDerivedPins(int n) {
        this.widgetsAreSet = true;
        if (this.gs2dLinkedX != null) {
            this.cur1D2x1.setX(this.cur1D2x1.getXVal(), this.toPixelX(this.cur1D2x1.getXVal()));
        }
        if (this.gs2dLinkedY != null) {
            this.cur1D2x2.setX(this.cur1D2x2.getXVal(), this.toPixelX(this.cur1D2x2.getXVal()));
        }
        this.pin1Dx01.setX(0.0, (this.pin1Dx0.xPixel0 + this.pin1Dx1.xPixel0) / 2);
        this.pin1Dy01.setY(0.0, (this.pin1Dy0.yPixel0 + this.pin1Dy1.yPixel0) / 2);
        this.pin1Dx01.setEnabled(Math.min(this.pin1Dx0.xPixel0, this.pin1Dx1.xPixel0) > this.xPixel0 || Math.max(this.pin1Dx0.xPixel0, this.pin1Dx1.xPixel0) < this.xPixel1);
        this.pin1Dy01.setEnabled(Math.min(this.pin1Dy0.yPixel0, this.pin1Dy1.yPixel0) > Math.min(this.toPixelY(this.getScale().minY), this.toPixelY(this.getScale().maxY)) || Math.max(this.pin1Dy0.yPixel0, this.pin1Dy1.yPixel0) < Math.max(this.toPixelY(this.getScale().minY), this.toPixelY(this.getScale().maxY)));
        if (this.imageView == null) {
            return;
        }
        double d = this.pin1Dx0.getXVal();
        this.cur2Dx0.setX(d, this.imageView.toPixelX(d));
        d = this.pin1Dx1.getXVal();
        this.cur2Dx1.setX(d, this.imageView.toPixelX(d));
        d = this.imageView.toX(this.imageView.xPixel0);
        this.pin2Dx0.setX(d, this.imageView.toPixelX0(d));
        d = this.imageView.toX(this.imageView.xPixel1);
        this.pin2Dx1.setX(d, this.imageView.toPixelX0(d));
        this.pin2Dx01.setX(0.0, (this.pin2Dx0.xPixel0 + this.pin2Dx1.xPixel0) / 2);
        double d2 = this.imageView.imageHeight - 1 - this.imageView.yView1;
        this.pin2Dy0.setY(d2, this.imageView.toPixelY0(d2));
        d2 = this.imageView.imageHeight - 1 - this.imageView.yView2;
        this.pin2Dy1.setY(d2, this.imageView.toPixelY0(d2));
        this.pin2Dy01.setY(0.0, (this.pin2Dy0.yPixel0 + this.pin2Dy1.yPixel0) / 2);
        this.cur2Dy.yPixel0 = this.cur2Dy.yPixel1 = this.imageView.subIndexToPixelY(n);
        this.pin2Dx01.setEnabled(Math.min(this.pin2Dx0.xPixel0, this.pin2Dx1.xPixel0) != this.imageView.xPixel0 || Math.max(this.pin2Dx0.xPixel0, this.pin2Dx1.xPixel1) != this.imageView.xPixel1);
        this.pin2Dy01.setEnabled(Math.min(this.pin2Dy0.yPixel0, this.pin2Dy1.yPixel0) != this.yPixel0 || Math.max(this.pin2Dy0.yPixel0, this.pin2Dy1.yPixel1) != this.yPixel1);
    }

    synchronized void doZoom(double d, double d2, double d3, double d4, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        double d5;
        double d6;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        double d7;
        if (d == d3) {
            d = this.getScale().minXOnScale;
            d3 = this.getScale().maxXOnScale;
        } else if (this.isLinked && bl4) {
            this.pd.doZoomLinked(this, d, d3, bl5, bl3, bl);
        }
        if (d > d3) {
            d7 = d;
            d = d3;
            d3 = d7;
        }
        if (d2 > d4) {
            d7 = d2;
            d2 = d4;
            d4 = d7;
        }
        boolean bl9 = bl8 = !bl && this.imageView != null && (this.imageView.minZ != d2 || this.imageView.maxZ != d4);
        if (!this.zoomEnabled && !bl8) {
            return;
        }
        if (bl3) {
            if (!this.getScale().isInRangeX(d) && !this.getScale().isInRangeX(d3)) {
                return;
            }
            if (!this.getScale().isInRangeX(d)) {
                d = this.getScale().minX;
            } else if (!this.getScale().isInRangeX(d3)) {
                d3 = this.getScale().maxX;
            }
        }
        this.pd.setTaintedAll();
        ScaleData[] scaleDataArray = this.viewData.getScaleData();
        int[] nArray = new int[this.nSpectra];
        int[] nArray2 = new int[this.nSpectra];
        this.graphsTemp.clear();
        Lst<Spectrum> lst = this.getSpectrumAt(0).getSubSpectra();
        boolean bl10 = lst == null || lst.size() == 2;
        boolean bl11 = bl7 = !this.getSpectrumAt(0).is1D();
        if (!bl7 && !bl10) {
            this.graphsTemp.addLast(this.getSpectrum());
            if (!ScaleData.setDataPointIndices(this.graphsTemp, d, d3, 3, nArray, nArray2)) {
                return;
            }
        } else if (!ScaleData.setDataPointIndices(this.spectra, d, d3, 3, nArray, nArray2)) {
            return;
        }
        boolean bl12 = bl6 = (d6 = d2) == (d5 = d4);
        if (bl6) {
            double d8;
            double d9 = d8 = !bl8 && bl ? (d8 = this.getScale().spectrumScaleFactor) : 1.0;
            if (Math.abs(d8 - 1.0) < 1.0E-4) {
                d6 = this.getScale().minYOnScale;
                d5 = this.getScale().maxYOnScale;
            }
        }
        ScaleData[] scaleDataArray2 = null;
        if (bl6 || bl2) {
            this.getCurrentView();
            scaleDataArray2 = this.viewData.getNewScales(this.iSpectrumSelected, bl6, d6, d5);
        }
        this.getView(d, d3, d6, d5, nArray, nArray2, scaleDataArray, scaleDataArray2);
        this.setXPixelMovedTo(1.0E10, Double.MAX_VALUE, 0, 0);
        this.setWidgetX(this.pin1Dx0, d);
        this.setWidgetX(this.pin1Dx1, d3);
        this.setWidgetY(this.pin1Dy0, d6);
        this.setWidgetY(this.pin1Dy1, d5);
        if (this.imageView == null) {
            this.updateDialogs();
        } else {
            int n = this.getSpectrumAt(0).getSubIndex();
            int n2 = this.imageView.fixSubIndex(n);
            if (n2 != n) {
                this.setCurrentSubSpectrum(n2);
            }
            if (bl8) {
                this.update2dImage(false);
            }
        }
        if (bl5) {
            this.addCurrentZoom();
        }
    }

    private void updateDialogs() {
        this.updateDialog(Annotation.AType.PeakList, -1);
        this.updateDialog(Annotation.AType.Measurements, -1);
    }

    private void setCurrentSubSpectrum(int n) {
        Spectrum spectrum = this.getSpectrumAt(0);
        n = spectrum.setCurrentSubSpectrum(n);
        if (spectrum.isForcedSubset()) {
            this.viewData.setXRangeForSubSpectrum(this.getSpectrum().getXYCoords());
        }
        this.pd.notifySubSpectrumChange(n, this.getSpectrum());
    }

    private void addCurrentZoom() {
        if (this.viewList.size() > this.currentZoomIndex + 1) {
            int n = this.viewList.size() - 1;
            while (n > this.currentZoomIndex) {
                this.viewList.removeItemAt(n);
                --n;
            }
        }
        this.viewList.addLast(this.viewData);
        ++this.currentZoomIndex;
    }

    private void setZoomTo(int n) {
        this.currentZoomIndex = n;
        this.viewData = (ViewData)this.viewList.get(n);
        this.resetPinsFromView();
    }

    void clearViews() {
        if (this.isLinked) {
            this.pd.clearLinkViews(this);
        }
        this.setZoom(0.0, 0.0, 0.0, 0.0);
        int n = this.viewList.size();
        while (--n >= 1) {
            this.viewList.removeItemAt(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void drawAll(Object object, Object object2, Object object3, int n, boolean bl, boolean bl2, boolean bl3) {
        int n3;
        int n4;
        Object object4;
        int n5;
        this.g2d = this.pd.g2d;
        this.gMain = object;
        Spectrum spectrum = this.getSpectrumAt(0);
        int n6 = spectrum.getSubIndex();
        boolean bl4 = this.is2DSpectrum = !(spectrum.is1D() || !this.isLinked && !this.pd.getBoolean(ScriptToken.DISPLAY2D) || this.imageView == null && !this.get2DImage(spectrum));
        if (this.imageView != null && bl2) {
            if (this.pd.isPrinting && this.g2d != this.pd.g2d0) {
                this.g2d.newGrayScaleImage(object, this.image2D, this.imageView.imageWidth, this.imageView.imageHeight, this.imageView.getBuffer());
            }
            if (this.is2DSpectrum) {
                this.setPositionForFrame(n);
            }
            this.draw2DImage();
        }
        int n7 = this.stackSelected || !this.showAllStacked ? this.iSpectrumSelected : -1;
        boolean bl5 = !this.showAllStacked || this.nSpectra == 1 || n7 >= 0;
        boolean bl6 = this.imageView == null || this.pd.display1D;
        int n8 = n7 >= 0 ? 1 : 0;
        int n9 = this.getFixedSelectedSpectrumIndex();
        if (bl6 && bl2) {
            this.fillBox(object, this.xPixel0, this.yPixel0, this.xPixel1, this.yPixel1, ScriptToken.PLOTAREACOLOR);
            if (n7 < 0) {
                bl5 = true;
                n5 = 0;
                while (n5 < this.nSpectra) {
                    if (this.doPlot(n5, n) && n8++ != 0) {
                        bl5 &= this.viewData.areYScalesSame(n5 - 1, n5);
                    }
                    ++n5;
                }
            }
        }
        n5 = this.nSpectra == 1 ? 0 : (!this.showAllStacked ? this.iSpectrumMovedTo : this.iSpectrumSelected);
        Object object5 = object4 = object3 == object ? object2 : object3;
        if (bl2) {
            n4 = this.pd.getCurrentGraphSet() == this && !this.isLinked && (!this.isSplittable || this.nSplit == 1 || this.pd.currentSplitPoint == n) ? 1 : 0;
            n3 = !(!this.zoomEnabled || this.isDrawNoSpectra() || !this.pd.isCurrentGraphSet(this) || !((Spectrum)this.spectra.get(0)).isScalable() || n4 == 0 && this.nSpectra != 1 || this.nSplit != 1 && this.pd.currentSplitPoint != this.iSpectrumMovedTo) ? 1 : 0;
            boolean n2 = this.isSplittable;
            this.drawFrame(object, n5, n4 != 0, n2, n3 != 0);
        }
        if (this.pd.isCurrentGraphSet(this) && n == this.pd.currentSplitPoint && (n8 < 2 || this.iSpectrumSelected >= 0)) {
            this.haveSelectedSpectrum = true;
        }
        boolean bl7 = this.showAllStacked && this.nSpectra > 1 ? this.allowStackedYScale && bl5 : (this.haveSingleYScale = true);
        if (bl6) {
            n4 = (int)((float)this.yPixels * ((float)this.yStackOffsetPercent / 100.0f));
            this.haveLeftRightArrows = false;
            n3 = 0;
            boolean bl8 = false;
            while (n3 < this.nSpectra) {
                if (this.doPlot(n3, n)) {
                    void var19_21;
                    boolean bl9;
                    boolean bl10;
                    boolean bl11 = this.stackSelected && this.iSpectrumSelected >= 0 && this.iSpectrumSelected != n3;
                    IntegralData integralData = !this.reversePlot && this.getShowAnnotation(Annotation.AType.Integration, n3) && (!this.showAllStacked || this.iSpectrumSelected == n3) ? (IntegralData)this.getDialog(Annotation.AType.Integration, n3).getData() : null;
                    this.setScale(n3);
                    Spectrum spectrum2 = (Spectrum)this.spectra.get(n3);
                    if (this.nSplit > 1) {
                        n9 = n3;
                    }
                    boolean bl12 = !bl11 && (this.nSplit == 1 || this.showAllStacked || this.iSpectrumSelected == n);
                    boolean bl13 = bl10 = bl12 && this.haveSelectedSpectrum && n3 == n9;
                    if (bl12) {
                        this.resetPinsFromView();
                        this.drawWidgets(object2, object4, n6, bl, bl6, bl10, false);
                    }
                    if (this.haveSingleYScale && n3 == n9 && bl2) {
                        this.drawGrid(object);
                        if (this.pd.isPrinting && this.nSplit > 1) {
                            this.drawSpectrumSource(object, n3);
                        }
                    }
                    if (bl12) {
                        this.drawWidgets(object2, object4, n6, false, bl6, bl10, true);
                    }
                    if (!this.isDrawNoSpectra() && (this.nSpectra == 1 || this.iSpectrumSelected >= 0) && (this.haveSingleYScale && n3 == n9 || this.showAllStacked && this.stackSelected && n3 == this.iSpectrumSelected)) {
                        this.drawHighlightsAndPeakTabs(object2, object4, n3);
                    }
                    if (bl2) {
                        if ((n8 == 1 && this.iSpectrumSelected < 0 || this.iSpectrumSelected == n3 && this.pd.isCurrentGraphSet(this)) && this.pd.titleOn && !this.pd.titleDrawn) {
                            this.pd.drawTitle(object, this.height, this.width, this.pd.getDrawTitle(this.pd.isPrinting));
                            this.pd.titleDrawn = true;
                        }
                        if (this.haveSingleYScale && n3 == n9) {
                            if (this.pd.getBoolean(ScriptToken.YSCALEON)) {
                                this.drawYScale(object, this);
                            }
                            if (this.pd.getBoolean(ScriptToken.YUNITSON)) {
                                this.drawYUnits(object);
                            }
                        }
                    }
                    boolean bl14 = spectrum2.isContinuous();
                    boolean bl15 = (this.nSplit > 1 ? n3 == this.iSpectrumMovedTo : this.isLinked || n3 == n9) && !this.pd.isPrinting && bl14;
                    boolean bl16 = bl9 = !bl11 && this.pendingIntegral != null && spectrum2 == this.pendingIntegral.spec;
                    if (bl2 || bl9) {
                        this.drawPlot(bl9 && !bl2 ? object2 : object, n3, spectrum2, bl14, (int)var19_21, bl11, null, bl15, bl9, bl3);
                    }
                    this.drawIntegration(object2, n3, (int)var19_21, bl11, integralData, bl14, bl15);
                    this.drawMeasurements(object2, n3);
                    if (this.pendingMeasurement != null && this.pendingMeasurement.spec == spectrum2) {
                        this.drawMeasurement(object2, this.pendingMeasurement);
                    }
                    if (bl15 && this.xPixelMovedTo >= 0) {
                        this.drawSpectrumPointer(object2, spectrum2, (int)var19_21, integralData);
                    }
                    if (this.nSpectra > 1 && this.nSplit == 1 && this.pd.isCurrentGraphSet(this) && bl2) {
                        this.haveLeftRightArrows = true;
                        if (!this.pd.isPrinting) {
                            this.setScale(0);
                            n5 = this.iSpectrumSelected;
                            if (this.nSpectra != 2) {
                                this.setPlotColor(object, (n5 + this.nSpectra - 1) % this.nSpectra);
                                this.fillArrow(object, 1, this.yHArrows, this.xHArrows - 9, true);
                                this.setCurrentBoxColor(object);
                                this.fillArrow(object, 1, this.yHArrows, this.xHArrows - 9, false);
                            }
                            if (n5 >= 0) {
                                this.setPlotColor(object, n5);
                                this.fillCircle(object, this.xHArrows, this.yHArrows, true);
                            }
                            this.setCurrentBoxColor(object);
                            this.fillCircle(object, this.xHArrows, this.yHArrows, false);
                            this.setPlotColor(object, (n5 + 1) % this.nSpectra);
                            this.fillArrow(object, 2, this.yHArrows, this.xHArrows + 9, true);
                            this.setCurrentBoxColor(object);
                            this.fillArrow(object, 2, this.yHArrows, this.xHArrows + 9, false);
                        }
                    }
                    var19_21 -= n4;
                }
                ++n3;
            }
            if (bl2) {
                if (this.pd.getBoolean(ScriptToken.XSCALEON)) {
                    this.drawXScale(object, this);
                }
                if (this.pd.getBoolean(ScriptToken.XUNITSON)) {
                    this.drawXUnits(object);
                }
            }
        } else {
            if (bl2) {
                if (this.pd.getBoolean(ScriptToken.XSCALEON)) {
                    this.drawXScale(object, this.imageView);
                }
                if (this.pd.getBoolean(ScriptToken.YSCALEON)) {
                    this.drawYScale(object, this.imageView);
                }
                if (n6 >= 0) {
                    this.draw2DUnits(object);
                }
            }
            this.drawWidgets(object2, object4, n6, bl, bl6, true, false);
            this.drawWidgets(object2, object4, n6, bl, bl6, true, true);
            this.widgetsAreSet = true;
        }
        if (this.annotations != null) {
            this.drawAnnotations(object2, this.annotations, null);
        }
    }

    private void drawSpectrumSource(Object object, int n) {
        this.pd.printFilePath(object, this.pd.thisWidth - this.pd.right, this.yPixel0, ((Spectrum)this.spectra.get(n)).getFilePath());
    }

    private boolean doPlot(int n, int n2) {
        boolean bl;
        boolean bl2 = this.stackSelected && this.iSpectrumSelected >= 0 && this.iSpectrumSelected != n;
        boolean bl3 = bl = this.showAllStacked || this.iSpectrumSelected == -1 || this.iSpectrumSelected == n;
        return this.nSplit > 1 ? n == n2 : bl && (!this.pd.isPrinting || !bl2);
    }

    private void drawSpectrumPointer(Object object, Spectrum spectrum, int n, IntegralData integralData) {
        this.setColorFromToken(object, ScriptToken.PEAKTABCOLOR);
        int n2 = this.pd.integralShiftMode;
        if (integralData != null) {
            if (!(this.pd.ctrlPressed && !this.pd.isIntegralDrag || this.isOnSpectrum(this.pd.mouseX, this.pd.mouseY, -1))) {
                integralData = null;
            } else if (n2 == 0 && (n2 = this.getShiftMode(this.pd.mouseX, this.pd.mouseY)) == 0) {
                n2 = Integer.MAX_VALUE;
            }
        }
        double d = this.yValueMovedTo;
        this.yValueMovedTo = integralData == null ? spectrum.getYValueAt(this.xValueMovedTo) : integralData.getPercentYValueAt(this.xValueMovedTo);
        this.setCoordStr(this.xValueMovedTo, this.yValueMovedTo);
        if (n2 != 0) {
            this.setPlotColor(object, n2 == Integer.MAX_VALUE ? -1 : 0);
            if (n2 < 0 || n2 == Integer.MAX_VALUE) {
                this.drawHandle(object, this.xPixelPlot1, this.yPixelPlot0, 3, false);
            }
            if (n2 > 0) {
                this.drawHandle(object, this.xPixelPlot0, this.yPixelPlot1, 3, false);
            }
            if (n2 != Integer.MAX_VALUE) {
                return;
            }
        }
        if (integralData != null) {
            this.g2d.setStrokeBold(object, true);
        }
        if (Double.isNaN(d) || this.pendingMeasurement != null) {
            this.g2d.drawLine(object, this.xPixelMovedTo, this.yPixel0, this.xPixelMovedTo, this.yPixel1);
            if (this.xPixelMovedTo2 >= 0) {
                this.g2d.drawLine(object, this.xPixelMovedTo2, this.yPixel0, this.xPixelMovedTo2, this.yPixel1);
            }
            this.yValueMovedTo = Double.NaN;
        } else {
            int n3;
            int n4 = n3 = integralData == null ? n + this.toPixelY(this.yValueMovedTo) : this.toPixelYint(this.yValueMovedTo / 100.0);
            if (n3 == this.fixY(n3)) {
                this.g2d.drawLine(object, this.xPixelMovedTo, n3 - 10, this.xPixelMovedTo, n3 + 10);
            }
        }
        if (integralData != null) {
            this.g2d.setStrokeBold(object, false);
        }
    }

    void setScale(int n) {
        this.viewData.setScale(n, this.xPixels, this.yPixels, ((Spectrum)this.spectra.get(n)).isInverted());
    }

    private void draw2DUnits(Object object) {
        String string = this.getSpectrumAt((int)0).nucleusX;
        String string2 = this.getSpectrumAt((int)0).nucleusY;
        this.setColorFromToken(object, ScriptToken.PLOTCOLOR);
        this.drawUnits(object, string, this.imageView.xPixel1 + 5 * this.pd.scalingFactor, this.yPixel1, 1.0, 1.0);
        this.drawUnits(object, string2, this.imageView.xPixel0 - 5 * this.pd.scalingFactor, this.yPixel0, 1.0, 0.0);
    }

    private void drawPeakTabs(Object object, Object object2, Spectrum spectrum) {
        Lst<PeakInfo> lst;
        Lst<PeakInfo> lst2 = lst = this.nSpectra == 1 || this.iSpectrumSelected >= 0 ? spectrum.getPeakList() : null;
        if (lst != null && lst.size() > 0) {
            if (this.piMouseOver != null && this.piMouseOver.spectrum == spectrum && this.pd.isMouseUp()) {
                this.g2d.setGraphicsColor(object2, this.g2d.getColor4(240, 240, 240, 140));
                this.drawPeak(object2, this.piMouseOver, 0);
                spectrum.setHighlightedPeak(this.piMouseOver);
            } else {
                spectrum.setHighlightedPeak(null);
            }
            this.setColorFromToken(object, ScriptToken.PEAKTABCOLOR);
            int n = lst.size();
            while (--n >= 0) {
                PeakInfo peakInfo;
                this.drawPeak(object, peakInfo, (peakInfo = (PeakInfo)lst.get(n)) == spectrum.getSelectedPeak() ? 14 : 7);
            }
        }
    }

    private void drawPeak(Object object, PeakInfo peakInfo, int n) {
        double d;
        if (this.pd.isPrinting) {
            return;
        }
        double d2 = peakInfo.getXMin();
        if (d2 == (d = peakInfo.getXMax())) {
            return;
        }
        this.drawBar(object, peakInfo, d2, d, null, n);
    }

    private void drawWidgets(Object object, Object object2, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setWidgets(bl, n, bl2);
        if (this.pd.isPrinting && (this.imageView == null ? !this.cur1D2Locked : this.sticky2Dcursor)) {
            return;
        }
        if (!this.pd.isPrinting && !bl4) {
            if (bl2) {
                this.fillBox(object, this.xPixel0, this.pin1Dx0.yPixel1, this.xPixel1, this.pin1Dx1.yPixel1 + 2, ScriptToken.GRIDCOLOR);
                this.fillBox(object, this.pin1Dx0.xPixel0, this.pin1Dx0.yPixel1, this.pin1Dx1.xPixel0, this.pin1Dx1.yPixel1 + 2, ScriptToken.PLOTCOLOR);
            } else {
                this.fillBox(object, this.imageView.xPixel0, this.pin2Dx0.yPixel1, this.imageView.xPixel1, this.pin2Dx0.yPixel1 + 2, ScriptToken.GRIDCOLOR);
                this.fillBox(object, this.pin2Dx0.xPixel0, this.pin2Dx0.yPixel1, this.pin2Dx1.xPixel0, this.pin2Dx1.yPixel1 + 2, ScriptToken.PLOTCOLOR);
                this.fillBox(object, this.pin2Dy0.xPixel1, this.yPixel1, this.pin2Dy1.xPixel1 + 2, this.yPixel0, ScriptToken.GRIDCOLOR);
                this.fillBox(object, this.pin2Dy0.xPixel1, this.pin2Dy0.yPixel1, this.pin2Dy1.xPixel1 + 2, this.pin2Dy1.yPixel0, ScriptToken.PLOTCOLOR);
            }
            this.fillBox(object, this.pin1Dy0.xPixel1, this.yPixel1, this.pin1Dy1.xPixel1 + 2, this.yPixel0, ScriptToken.GRIDCOLOR);
            if (bl3) {
                this.fillBox(object, this.pin1Dy0.xPixel1, this.pin1Dy0.yPixel1, this.pin1Dy1.xPixel1 + 2, this.pin1Dy1.yPixel0, ScriptToken.PLOTCOLOR);
            }
        }
        int n2 = 0;
        while (n2 < this.widgets.length) {
            block14: {
                boolean bl5;
                PlotWidget plotWidget;
                block16: {
                    boolean bl6;
                    block15: {
                        plotWidget = this.widgets[n2];
                        if (plotWidget == null || !plotWidget.isPinOrCursor && !this.zoomEnabled) break block14;
                        bl5 = plotWidget == this.cur1D2x1 || plotWidget == this.cur1D2x2 || plotWidget == this.cur2Dx0 || plotWidget == this.cur2Dx1 || plotWidget == this.cur2Dy;
                        if ((plotWidget.isPin || !plotWidget.isPinOrCursor) == bl4) break block14;
                        if (!plotWidget.is2D) break block15;
                        if (plotWidget != this.cur2Dx0 || bl2) break block16;
                        break block14;
                    }
                    boolean bl7 = bl6 = plotWidget == this.pin1Dy0 || plotWidget == this.pin1Dy1 || plotWidget == this.pin1Dy01;
                    if ((this.imageView != null && bl2 == bl6 || bl6 && !bl3 || plotWidget == this.cur1D2x1 && this.gs2dLinkedX == null || plotWidget == this.cur1D2x2 && this.gs2dLinkedY == null || plotWidget == this.zoomBox1D && (this.pd.isIntegralDrag || this.pd.integralShiftMode != 0)) && (!this.isLinked || this.imageView != null)) break block14;
                }
                if (!this.pd.isPrinting || bl5) {
                    if (plotWidget.isPinOrCursor) {
                        this.setColorFromToken(object, plotWidget.color);
                        this.g2d.drawLine(object, plotWidget.xPixel0, plotWidget.yPixel0, plotWidget.xPixel1, plotWidget.yPixel1);
                        plotWidget.isVisible = true;
                        if (plotWidget.isPin) {
                            this.drawHandle(object, plotWidget.xPixel0, plotWidget.yPixel0, 2, !plotWidget.isEnabled);
                        }
                    } else if (plotWidget.xPixel1 != plotWidget.xPixel0) {
                        this.fillBox(object2, plotWidget.xPixel0, plotWidget.yPixel0, plotWidget.xPixel1, plotWidget.yPixel1, plotWidget == this.zoomBox1D && this.pd.shiftPressed ? ScriptToken.ZOOMBOXCOLOR2 : ScriptToken.ZOOMBOXCOLOR);
                    }
                }
            }
            ++n2;
        }
    }

    private void drawBar(Object object, PeakInfo peakInfo, double d, double d2, ScriptToken scriptToken, int n) {
        int n2;
        double d3 = d2 + d;
        double d4 = Math.abs(d2 - d);
        double d5 = Math.abs(this.toX(this.xPixel1) - this.toX(this.xPixel0));
        int n3 = this.toPixelX(d);
        if (n3 > (n2 = this.toPixelX(d2))) {
            int n4 = n3;
            n3 = n2;
            n2 = n4;
        }
        n3 = this.fixX(n3);
        if ((n2 = this.fixX(n2)) - n3 < 3) {
            n3 -= 2;
            n2 += 2;
        }
        if (peakInfo != null) {
            peakInfo.setPixelRange(n3, n2);
        }
        if (n == 0) {
            this.fillBox(object, n3, this.yPixel0, n2, this.yPixel0 + this.yPixels, scriptToken);
        } else {
            this.fillBox(object, n3, this.yPixel0 + 2, n2, this.yPixel0 + 5, scriptToken);
            if (peakInfo != null) {
                n3 = (n3 + n2) / 2;
                this.fillBox(object, n3 - 1, this.yPixel0 + 2, n3 + 1, this.yPixel0 + 2 + n, scriptToken);
            }
        }
    }

    private void drawIntegration(Object object, int n, int n2, boolean bl, IntegralData integralData, boolean bl2, boolean bl3) {
        Lst<Annotation> lst;
        if (integralData != null) {
            if (this.haveIntegralDisplayed(n)) {
                this.drawPlot(object, n, (Spectrum)this.spectra.get(n), true, n2, false, integralData, true, false, false);
            }
            this.drawIntegralValues(object, n, n2);
        }
        if ((lst = this.getIntegrationRatios(n)) != null) {
            this.drawAnnotations(object, lst, ScriptToken.INTEGRALPLOTCOLOR);
        }
    }

    private MeasurementData getMeasurements(Annotation.AType aType, int n) {
        AnnotationData annotationData = this.getDialog(aType, n);
        return annotationData == null || annotationData.getData().size() == 0 || !annotationData.getState() ? null : annotationData.getData();
    }

    private void drawPlot(Object object, int n, Spectrum spectrum, boolean bl, int n2, boolean bl2, IntegralData integralData, boolean bl3, boolean bl4, boolean bl5) {
        boolean bl6;
        Coordinate[] coordinateArray = integralData == null ? spectrum.getXYCoords() : this.getIntegrationGraph(n).getXYCoords();
        boolean bl7 = integralData != null;
        BS bS = bl7 ? integralData.getBitSet() : null;
        boolean bl8 = bl6 = bl4 || spectrum.fillColor != null && bl3;
        int n3 = bl2 ? -2 : (bl7 ? -1 : (!this.allowStacking ? 0 : n));
        this.setPlotColor(object, n3);
        boolean bl9 = true;
        int n4 = this.toPixelY(0.0);
        if (bl7) {
            bl6 &= n4 == this.fixY(n4);
        } else {
            n4 = this.fixY(n4);
        }
        GenericColor genericColor = bl7 || bl6 ? this.pd.getColor(ScriptToken.INTEGRALPLOTCOLOR) : null;
        GenericColor genericColor2 = genericColor == null || spectrum.fillColor == null ? genericColor : spectrum.fillColor;
        int n5 = this.viewData.getStartingPointIndex(n);
        int n6 = this.viewData.getEndingPointIndex(n);
        if (bl && !bl5) {
            boolean bl10;
            --n6;
            boolean bl11 = bl10 = (bl7 || this.pendingIntegral != null) && this.g2d.canDoLineTo();
            if (bl10) {
                this.g2d.doStroke(object, true);
            }
            boolean bl12 = false;
            int n7 = n5;
            while (n7 <= n6) {
                int n8;
                Coordinate coordinate = coordinateArray[n7];
                Coordinate coordinate2 = coordinateArray[n7 + 1];
                int n9 = n8 = bl7 ? this.toPixelYint(coordinate.getYVal()) : this.toPixelY(coordinate.getYVal());
                if (n8 != Integer.MIN_VALUE) {
                    int n10;
                    int n11 = n10 = bl7 ? this.toPixelYint(coordinate2.getYVal()) : this.toPixelY(coordinate2.getYVal());
                    if (n10 != Integer.MIN_VALUE) {
                        double d = coordinate.getXVal();
                        double d2 = coordinate2.getXVal();
                        int n12 = this.toPixelX(d);
                        int n13 = this.toPixelX(d2);
                        n8 = this.fixY(n2 + n8);
                        n10 = this.fixY(n2 + n10);
                        if (bl7) {
                            if (n7 == n5) {
                                this.xPixelPlot1 = n12;
                                this.yPixelPlot0 = n8;
                            }
                            this.xPixelPlot0 = n13;
                            this.yPixelPlot1 = n10;
                        }
                        if (n13 != n12 || n8 != n10) {
                            if (bl6 && bl4 && this.pendingIntegral.overlaps(d, d2)) {
                                if (genericColor2 != null) {
                                    this.g2d.doStroke(object, false);
                                    this.g2d.setGraphicsColor(object, genericColor2);
                                }
                                this.g2d.fillRect(object, Math.min(n12, n13), Math.min(n4, n8), Math.max(1, Math.abs(n13 - n12)), Math.abs(n4 - n8));
                                if (genericColor2 != null) {
                                    this.g2d.doStroke(object, false);
                                    this.g2d.doStroke(object, true);
                                    bl12 = false;
                                    this.setPlotColor(object, n3);
                                }
                            } else if (n8 != n10 || n8 != this.yPixel0) {
                                if (bS != null && bS.get(n7) != bl9) {
                                    bl9 = bS.get(n7);
                                    if (bl10 && bl12) {
                                        this.g2d.doStroke(object, false);
                                        this.g2d.doStroke(object, true);
                                        bl12 = false;
                                    }
                                    if (!this.pd.isPrinting && this.pd.integralShiftMode != 0) {
                                        this.setPlotColor(object, 0);
                                    } else if (bl9) {
                                        this.setColorFromToken(object, ScriptToken.INTEGRALPLOTCOLOR);
                                    } else {
                                        this.setPlotColor(object, -3);
                                    }
                                }
                                if (!this.pd.isPrinting || bl9) {
                                    if (bl12) {
                                        this.g2d.lineTo(object, n13, n10);
                                    } else {
                                        this.g2d.drawLine(object, n12, n8, n13, n10);
                                        bl12 = bl10;
                                    }
                                }
                            }
                        }
                    }
                }
                ++n7;
            }
            if (bl10) {
                this.g2d.doStroke(object, false);
            }
        } else {
            int n14 = n5;
            while (n14 <= n6) {
                Coordinate coordinate = coordinateArray[n14];
                int n15 = this.toPixelY(coordinate.getYVal());
                if (n15 != Integer.MIN_VALUE) {
                    int n16 = this.toPixelX(coordinate.getXVal());
                    int n17 = this.toPixelY(Math.max(this.getScale().minYOnScale, 0.0));
                    if ((n17 = this.fixY(n2 + n17)) != (n15 = this.fixY(n2 + n15)) || n17 != this.yPixel0 && n17 != this.yPixel1) {
                        if (bl5) {
                            this.g2d.fillRect(object, n16 - 1, n15 - 1, 3, 3);
                        } else {
                            this.g2d.drawLine(object, n16, n17, n16, n15);
                        }
                    }
                }
                ++n14;
            }
            if (!bl5 && this.getScale().isYZeroOnScale() && (n14 = n2 + this.toPixelY(this.getScale().spectrumYRef)) == this.fixY(n14)) {
                this.g2d.drawLine(object, this.xPixel1, n14, this.xPixel0, n14);
            }
        }
    }

    private void drawFrame(Object object, int n, boolean bl, boolean bl2, boolean bl3) {
        if (!this.pd.gridOn || this.pd.isPrinting) {
            this.setColorFromToken(object, ScriptToken.GRIDCOLOR);
            this.g2d.drawRect(object, this.xPixel0, this.yPixel0, this.xPixels, this.yPixels);
            if (this.pd.isPrinting) {
                return;
            }
        }
        this.setCurrentBoxColor(object);
        if (bl3) {
            if (n >= 0) {
                this.setPlotColor(object, n);
                this.fillArrow(object, 3, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2 - 9, true);
                this.fillArrow(object, 4, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2 + 9, true);
                this.setCurrentBoxColor(object);
            }
            this.fillArrow(object, 3, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2 - 9, false);
            this.fillCircle(object, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2, false);
            this.fillArrow(object, 4, this.xVArrows, (this.yPixel00 + this.yPixel11) / 2 + 9, false);
        }
        if (this.imageView != null) {
            return;
        }
        if (bl) {
            int n2 = this.xPixel00 + 10;
            int n3 = this.xPixel11 - 10;
            int n4 = this.yPixel00 + 1;
            int n5 = this.yPixel11 - 2;
            this.g2d.drawLine(object, n2, n4, n3, n4);
            this.g2d.drawLine(object, n3, n4, n3, n5);
            this.g2d.drawLine(object, n2, n5, n3, n5);
            this.closerX = Integer.MIN_VALUE;
            this.splitterX = Integer.MIN_VALUE;
            this.drawBox(object, n3 - 10, n4, n3, n4 + 10, null);
            this.g2d.drawLine(object, n3 - 10, n4 + 10, n3, n4);
            this.g2d.drawLine(object, n3, n4 + 10, n3 - 10, n4);
            this.closerX = n3 - 10;
            this.closerY = n4;
            if (bl2) {
                this.fillBox(object, (n3 -= 10) - 10, n4, n3, n4 + 10, null);
                this.splitterX = n3 - 10;
                this.splitterY = n4;
            }
        }
    }

    private void drawGrid(Object object) {
        int n;
        double d;
        double d2;
        if (!this.pd.gridOn || this.imageView != null) {
            return;
        }
        this.setColorFromToken(object, ScriptToken.GRIDCOLOR);
        if (Double.isNaN(this.getScale().firstX)) {
            d2 = this.getScale().maxXOnScale + this.getScale().steps[0] / 2.0;
            d = this.getScale().minXOnScale;
            while (d < d2) {
                n = this.toPixelX(d);
                this.g2d.drawLine(object, n, this.yPixel0, n, this.yPixel1);
                d += this.getScale().steps[0];
            }
        } else {
            d2 = this.getScale().maxXOnScale * 1.0001;
            d = this.getScale().firstX;
            while (d <= d2) {
                n = this.toPixelX(d);
                this.g2d.drawLine(object, n, this.yPixel0, n, this.yPixel1);
                d += this.getScale().steps[0];
            }
        }
        d = this.getScale().firstY;
        while (d < this.getScale().maxYOnScale + this.getScale().steps[1] / 2.0) {
            n = this.toPixelY(d);
            if (n == this.fixY(n)) {
                this.g2d.drawLine(object, this.xPixel0, n, this.xPixel1, n);
            }
            d += this.getScale().steps[1];
        }
    }

    private void drawXScale(Object object, XYScaleConverter xYScaleConverter) {
        this.setColorFromToken(object, ScriptToken.SCALECOLOR);
        if (this.pd.isPrinting) {
            this.g2d.drawLine(object, xYScaleConverter.getXPixel0(), this.yPixel1, xYScaleConverter.getXPixel0() + xYScaleConverter.getXPixels() - 1, this.yPixel1);
        }
        int n = this.getScale().precision[0];
        Font font = this.pd.setFont(object, xYScaleConverter.getXPixels(), 0, this.pd.isPrinting ? 10 : 12, false);
        int n2 = this.yPixel1;
        int n3 = this.yPixel1 + 4 * this.pd.scalingFactor;
        int n4 = this.yPixel1 + 2 * this.pd.scalingFactor;
        int n5 = font.getHeight();
        double d = xYScaleConverter.toPixelX(this.getScale().steps[0]) - xYScaleConverter.toPixelX(0.0);
        double d2 = Math.abs(d * 0.95);
        double d3 = this.getScale().firstX - this.getScale().steps[0];
        double d4 = (this.getScale().maxXOnScale + this.getScale().steps[0]) * 1.0001;
        int n6 = 0;
        while (n6 < 2) {
            if (n6 == 1) {
                ScaleData.fixScale(this.mapX);
            }
            double d5 = 1.0E10;
            double d6 = d3;
            while (d6 <= d4) {
                int n7 = xYScaleConverter.toPixelX(d6);
                Double d7 = d6;
                switch (n6) {
                    case 0: {
                        String string = DF.formatDecimalDbl(d6, n);
                        this.mapX.put(d7, string);
                        this.drawTick(object, n7, n2, n3, xYScaleConverter);
                        d = Math.abs(d5 - d6);
                        int n8 = this.getScale().minorTickCounts[0];
                        if (n8 != 0) {
                            double d8 = d / (double)n8;
                            int n9 = 1;
                            while (n9 < n8) {
                                double d9 = d6 - (double)n9 * d8;
                                this.drawTick(object, xYScaleConverter.toPixelX(d9), n2, n4, xYScaleConverter);
                                ++n9;
                            }
                        }
                        d5 = d6;
                        break;
                    }
                    case 1: {
                        int n10;
                        String string = this.mapX.get(d7);
                        if (string == null || n7 != xYScaleConverter.fixX(n7)) break;
                        int n11 = this.pd.getStringWidth(string);
                        int n12 = n10 = n7 + n11 / 2 == xYScaleConverter.fixX(n7 + n11 / 2) ? 2 : 0;
                        if (n10 > 0) {
                            this.g2d.drawString(object, string, n7 - n11 / n10, n3 + n5);
                        }
                        d6 += Math.floor((double)n11 / d2) * this.getScale().steps[0];
                    }
                }
                d6 += this.getScale().steps[0];
            }
            ++n6;
        }
        this.mapX.clear();
    }

    private void drawTick(Object object, int n, int n2, int n3, XYScaleConverter xYScaleConverter) {
        if (n == xYScaleConverter.fixX(n)) {
            this.g2d.drawLine(object, n, n2, n, n3);
        }
    }

    private void drawYScale(Object object, XYScaleConverter xYScaleConverter) {
        ScaleData scaleData = xYScaleConverter.getScale();
        int n = scaleData.precision[1];
        Font font = this.pd.setFont(object, xYScaleConverter.getXPixels(), 0, this.pd.isPrinting ? 10 : 12, false);
        int n2 = font.getHeight();
        double d = scaleData.maxYOnScale + scaleData.steps[1] / 2.0;
        int n3 = Integer.MIN_VALUE;
        this.setColorFromToken(object, ScriptToken.SCALECOLOR);
        int n4 = 0;
        while (n4 < 2) {
            if (n4 == 1) {
                ScaleData.fixScale(this.mapX);
            }
            double d2 = scaleData.firstY;
            while (d2 < d) {
                Double d3 = d2;
                int n5 = xYScaleConverter.getXPixel0();
                int n6 = xYScaleConverter.toPixelY(d2);
                if (n6 == xYScaleConverter.fixY(n6)) {
                    if (n4 == 0) {
                        this.g2d.drawLine(object, n5, n6, n5 - 3 * this.pd.scalingFactor, n6);
                    }
                    if (Math.abs(n6 - n3) > n2) {
                        n3 = n6;
                        switch (n4) {
                            case 0: {
                                String string = DF.formatDecimalDbl(d2, n);
                                this.mapX.put(d3, string);
                                break;
                            }
                            case 1: {
                                String string = this.mapX.get(d3);
                                if (string == null) break;
                                if (string.startsWith("0") && string.contains("E")) {
                                    string = "0";
                                }
                                this.g2d.drawString(object, string, n5 - 4 * this.pd.scalingFactor - this.pd.getStringWidth(string), n6 + n2 / 3);
                            }
                        }
                    }
                }
                d2 += scaleData.steps[1];
            }
            ++n4;
        }
        this.mapX.clear();
    }

    private void drawXUnits(Object object) {
        String string = ((Spectrum)this.spectra.get(0)).getAxisLabel(true);
        if (string != null) {
            this.drawUnits(object, string, this.xPixel1 + 25 * this.pd.scalingFactor, this.yPixel1 + 5 * this.pd.scalingFactor, 1.0, 1.0);
        }
    }

    private void drawUnits(Object object, String string, int n, int n2, double d, double d2) {
        this.setColorFromToken(object, ScriptToken.UNITSCOLOR);
        this.pd.setFont(object, (this.imageView == null ? this : this.imageView).getXPixels(), 3, 10.0f, false);
        this.g2d.drawString(object, string, (int)((double)n - (double)this.pd.getStringWidth(string) * d), (int)((double)n2 + (double)this.pd.getFontHeight() * d2));
    }

    private void drawYUnits(Object object) {
        String string = ((Spectrum)this.spectra.get(0)).getAxisLabel(false);
        if (string != null) {
            this.drawUnits(object, string, (this.pd.isPrinting ? 30 : 5) * this.pd.scalingFactor, this.yPixel0 + (this.pd.isPrinting ? 0 : 5) * this.pd.scalingFactor, 0.0, -1.0);
        }
    }

    private void drawHighlightsAndPeakTabs(Object object, Object object2, int n) {
        int n2;
        MeasurementData measurementData = this.getMeasurements(Annotation.AType.PeakList, n);
        Spectrum spectrum = (Spectrum)this.spectra.get(n);
        if (this.pd.isPrinting) {
            if (measurementData != null) {
                this.setColorFromToken(object, ScriptToken.PEAKTABCOLOR);
                this.printPeakList(object, spectrum, (PeakData)measurementData);
            }
            return;
        }
        if (measurementData == null) {
            n2 = 0;
            while (n2 < this.highlights.size()) {
                Highlight highlight = (Highlight)this.highlights.get(n2);
                if (highlight.spectrum == spectrum) {
                    this.pd.setHighlightColor(highlight.color);
                    this.drawBar(object2, null, highlight.x1, highlight.x2, ScriptToken.HIGHLIGHTCOLOR, 0);
                }
                ++n2;
            }
            if (this.pd.peakTabsOn) {
                this.drawPeakTabs(object, object2, spectrum);
            }
        }
        if (measurementData != null) {
            n2 = spectrum.isInverted() ? this.yPixel1 - 10 * this.pd.scalingFactor : this.yPixel0;
            this.setColorFromToken(object, ScriptToken.PEAKTABCOLOR);
            int n3 = measurementData.size();
            while (--n3 >= 0) {
                Measurement measurement = (Measurement)measurementData.get(n3);
                int n4 = this.toPixelX(measurement.getXVal());
                this.g2d.drawLine(object, n4, n2, n4, n2 + 10 * this.pd.scalingFactor);
            }
            if (this.isVisible(this.getDialog(Annotation.AType.PeakList, n)) && (n2 = this.toPixelY(((PeakData)measurementData).getThresh())) == this.fixY(n2) && !this.pd.isPrinting) {
                this.g2d.drawLine(object, this.xPixel0, n2, this.xPixel1, n2);
            }
        }
    }

    private void printPeakList(Object object, Spectrum spectrum, PeakData peakData) {
        String[][] stringArray = peakData.getMeasurementListArray(null);
        if (stringArray.length == 0) {
            return;
        }
        this.pd.setFont(object, this.xPixels, 0, 8.0f, false);
        int n = this.pd.getFontHeight();
        int[] nArray = new int[peakData.size()];
        int[] nArray2 = new int[peakData.size()];
        int n2 = 0;
        int n3 = 5 * this.pd.scalingFactor;
        int n4 = 10 * this.pd.scalingFactor;
        int n5 = 15 * this.pd.scalingFactor;
        int n6 = 25 * this.pd.scalingFactor;
        int n7 = 0;
        while (n7 < stringArray.length) {
            nArray2[n7] = this.toPixelX(Double.parseDouble(stringArray[n7][1]));
            if (n7 == 0) {
                nArray[n7] = nArray2[n7];
            } else {
                nArray[n7] = Math.max(nArray[n7 - 1] + n, nArray2[n7] + n);
                n2 += nArray[n7] - nArray2[n7];
            }
            ++n7;
        }
        if (nArray[0] - (n2 /= 2 * stringArray.length) < this.xPixel0 + n6) {
            n2 = nArray[0] - (this.xPixel0 + n6);
        }
        n7 = 0;
        while (n7 < stringArray.length) {
            int n8 = n7++;
            nArray[n8] = nArray[n8] - n2;
        }
        n7 = spectrum.isInverted() ? 1 : 0;
        int n9 = this.pd.getStringWidth("99.9999");
        int n10 = stringArray[0].length >= 6 ? this.pd.getStringWidth("99.99") : 0;
        int n11 = n7 != 0 ? -1 : 1;
        int n12 = (n7 != 0 ? this.yPixel1 : this.yPixel0) + n11 * (n10 + n9 + n5);
        int n13 = 0;
        while (n13 < stringArray.length) {
            this.g2d.drawLine(object, nArray[n13], n12, nArray[n13], n12 + n3 * n11);
            this.g2d.drawLine(object, nArray[n13], n12 + n3 * n11, nArray2[n13], n12 + n4 * n11);
            this.g2d.drawLine(object, nArray2[n13], n12 + n4 * n11, nArray2[n13], n12 + n5 * n11);
            if (n10 > 0 && stringArray[n13][4].length() > 0) {
                this.g2d.drawLine(object, (nArray[n13] + nArray[n13 - 1]) / 2, n12 - n9 + n3, (nArray[n13] + nArray[n13 - 1]) / 2, n12 - n9 - n3);
            }
            ++n13;
        }
        n12 -= n11 * 2 * this.pd.scalingFactor;
        if (n10 > 0) {
            this.drawStringRotated(object, -90, nArray[0] - n5, n12, "  ppm");
            this.drawStringRotated(object, -90, nArray[0] - n5, n12 - n9 - n3, " Hz");
        }
        n13 = peakData.size();
        while (--n13 >= 0) {
            this.drawStringRotated(object, -90 * n11, nArray[n13] + n11 * n / 3, n12, stringArray[n13][1]);
            if (n10 <= 0 || stringArray[n13][4].length() <= 0) continue;
            int n14 = (nArray[n13] + nArray[n13 - 1]) / 2 + n / 3;
            this.drawStringRotated(object, -90, n14, n12 - n9 - n3, stringArray[n13][4]);
        }
    }

    private void drawStringRotated(Object object, int n, int n2, int n3, String string) {
        this.g2d.drawStringRotated(object, string, n2, n3, n);
    }

    private void drawAnnotations(Object object, Lst<Annotation> lst, ScriptToken scriptToken) {
        this.pd.setFont(object, this.xPixels, 1, 18.0f, false);
        int n = lst.size();
        while (--n >= 0) {
            Annotation annotation = (Annotation)lst.get(n);
            this.setAnnotationColor(object, annotation, scriptToken);
            XYScaleConverter xYScaleConverter = annotation.is2D ? this.imageView : this;
            int n2 = xYScaleConverter.toPixelX(annotation.getXVal());
            int n3 = annotation.isPixels() ? (int)((double)(this.yPixel0 + 10 + 10 * this.pd.scalingFactor) - annotation.getYVal()) : (annotation.is2D ? this.imageView.subIndexToPixelY((int)annotation.getYVal()) : this.toPixelY(annotation.getYVal()));
            this.g2d.drawString(object, annotation.text, n2 + annotation.offsetX * this.pd.scalingFactor, n3 - annotation.offsetY * this.pd.scalingFactor);
        }
    }

    private void drawIntegralValues(Object object, int n, int n2) {
        MeasurementData measurementData = this.getMeasurements(Annotation.AType.Integration, n);
        if (measurementData != null) {
            if (this.pd.isPrinting) {
                this.pd.setFont(object, this.xPixels, 0, 8.0f, false);
            } else {
                this.pd.setFont(object, this.xPixels, 1, 12.0f, false);
            }
            this.setColorFromToken(object, ScriptToken.INTEGRALPLOTCOLOR);
            int n3 = this.pd.getFontHeight();
            this.g2d.setStrokeBold(object, true);
            int n4 = measurementData.size();
            while (--n4 >= 0) {
                Measurement measurement = (Measurement)measurementData.get(n4);
                if (measurement.getValue() == 0.0) continue;
                int n5 = this.toPixelX(measurement.getXVal2());
                int n6 = n2 * this.pd.scalingFactor + this.toPixelYint(measurement.getYVal());
                int n7 = n2 * this.pd.scalingFactor + this.toPixelYint(measurement.getYVal2());
                if (n5 != this.fixX(n5) || n6 != this.fixY(n6) || n7 != this.fixY(n7)) continue;
                if (!this.pd.isPrinting) {
                    this.g2d.drawLine(object, n5, n6, n5, n7);
                }
                String string = "  " + measurement.text;
                this.g2d.drawString(object, string, n5, (n6 + n7) / 2 + n3 / 3);
            }
            this.g2d.setStrokeBold(object, false);
        }
        if (n == this.getFixedSelectedSpectrumIndex()) {
            this.selectedSpectrumIntegrals = measurementData;
        }
    }

    private void drawMeasurements(Object object, int n) {
        MeasurementData measurementData = this.getMeasurements(Annotation.AType.Measurements, n);
        if (measurementData != null) {
            int n2 = measurementData.size();
            while (--n2 >= 0) {
                this.drawMeasurement(object, (Measurement)measurementData.get(n2));
            }
        }
        if (n == this.getFixedSelectedSpectrumIndex()) {
            this.selectedSpectrumMeasurements = measurementData;
        }
    }

    private void drawMeasurement(Object object, Measurement measurement) {
        if (measurement.text.length() == 0 && measurement != this.pendingMeasurement) {
            return;
        }
        this.pd.setFont(object, this.xPixels, 1, 12.0f, false);
        this.g2d.setGraphicsColor(object, measurement == this.pendingMeasurement ? this.pd.getColor(ScriptToken.PEAKTABCOLOR) : this.pd.BLACK);
        int n = this.toPixelX(measurement.getXVal());
        int n2 = this.toPixelY(measurement.getYVal());
        int n3 = this.toPixelX(measurement.getXVal2());
        if (Double.isNaN(measurement.getXVal()) || n != this.fixX(n) || n3 != this.fixX(n3)) {
            return;
        }
        boolean bl = Math.abs(n - n3) >= 2;
        boolean bl2 = this.getScale().isYZeroOnScale() && measurement.spec.isHNMR();
        int n4 = (n + n3) / 2;
        this.g2d.setStrokeBold(object, true);
        if (bl) {
            this.g2d.drawLine(object, n, n2, n3, n2);
        }
        if (bl2) {
            this.g2d.drawLine(object, n + 1, this.yPixel1 - 1, n3, this.yPixel1 - 1);
        }
        this.g2d.setStrokeBold(object, false);
        if (bl) {
            this.g2d.drawString(object, measurement.text, n4 + measurement.offsetX, n2 - measurement.offsetY);
        }
        if (bl2) {
            this.g2d.drawLine(object, n, this.yPixel1, n, this.yPixel1 - 6 * this.pd.scalingFactor);
            this.g2d.drawLine(object, n3, this.yPixel1, n3, this.yPixel1 - 6 * this.pd.scalingFactor);
        }
    }

    private PlotWidget getPinSelected(int n, int n2) {
        if (this.widgets != null) {
            int n3 = 0;
            while (n3 < this.widgets.length) {
                if (this.widgets[n3] != null && this.widgets[n3].isPinOrCursor && this.widgets[n3].selected(n, n2)) {
                    return this.widgets[n3];
                }
                ++n3;
            }
        }
        return null;
    }

    void set2DCrossHairs(int n, int n2) {
        if (n == this.imageView.fixX(n) && n2 == this.fixY(n2)) {
            double d = this.imageView.toX(n);
            this.pin1Dx1.setX(d, this.toPixelX(d));
            this.cur2Dx1.setX(d, n);
            this.setCurrentSubSpectrum(this.imageView.toSubspectrumIndex(n2));
            if (this.isLinked) {
                double d2 = this.imageView.toY(n2);
                this.pd.set2DCrossHairsLinked(this, d, d2, !this.sticky2Dcursor);
            }
        }
    }

    private void reset2D(boolean bl) {
        if (bl) {
            this.imageView.setView0(this.imageView.xPixel0, this.pin2Dy0.yPixel0, this.imageView.xPixel1, this.pin2Dy1.yPixel0);
            this.doZoom(0.0, this.getScale().minY, 0.0, this.getScale().maxY, true, false, false, false, true);
        } else {
            this.imageView.setView0(this.pin2Dx0.xPixel0, this.imageView.yPixel0, this.pin2Dx1.xPixel0, this.imageView.yPixel1);
        }
    }

    private boolean setAnnotationText(Annotation annotation) {
        String string = this.pd.getInput("New text?", "Set Label", annotation.text);
        if (string == null) {
            return false;
        }
        if (string.length() == 0) {
            this.annotations.removeObj(annotation);
        } else {
            annotation.text = string;
        }
        return true;
    }

    private boolean checkIntegral(double d, double d2, boolean bl) {
        AnnotationData annotationData = this.getDialog(Annotation.AType.Integration, -1);
        if (annotationData == null) {
            return false;
        }
        Integral integral = ((IntegralData)annotationData.getData()).addIntegralRegion(d, d2);
        if (bl && annotationData.isDialog()) {
            ((JSVDialog)annotationData).update(null, 0.0, 0);
        }
        if (Double.isNaN(d2)) {
            return false;
        }
        this.pendingIntegral = bl ? null : integral;
        this.pd.isIntegralDrag = !bl;
        this.selectedSpectrumIntegrals = null;
        return true;
    }

    private void setToolTipForPixels(int n, int n2) {
        if (this.iSpectrumMovedTo != this.iSpectrumClicked || this.pd.getCurrentGraphSet() != this) {
            this.pd.setToolTipText("click spectrum to activate");
            return;
        }
        if (this.isSplitWidget(n, n2)) {
            this.pd.setToolTipText("click to " + (this.nSplit > 1 ? "combine" : "split"));
            return;
        }
        if (this.isCloserWidget(n, n2)) {
            this.pd.setToolTipText("click to close");
            return;
        }
        PlotWidget plotWidget = this.getPinSelected(n, n2);
        int n3 = this.getScale().precision[0];
        int n4 = this.getScale().precision[1];
        if (plotWidget != null) {
            String string;
            if (this.setStartupPinTip()) {
                return;
            }
            if (plotWidget == this.pin1Dx01 || plotWidget == this.pin2Dx01) {
                string = String.valueOf(DF.formatDecimalDbl(Math.min(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()), n3)) + " - " + DF.formatDecimalDbl(Math.max(this.pin1Dx0.getXVal(), this.pin1Dx1.getXVal()), n3);
            } else if (plotWidget == this.pin1Dy01) {
                string = String.valueOf(DF.formatDecimalDbl(Math.min(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()), n4)) + " - " + DF.formatDecimalDbl(Math.max(this.pin1Dy0.getYVal(), this.pin1Dy1.getYVal()), n4);
            } else if (plotWidget == this.cur2Dy) {
                int n5 = this.imageView.toSubspectrumIndex(plotWidget.yPixel0);
                string = this.get2DYLabel(n5, n3);
            } else {
                string = plotWidget == this.pin2Dy01 ? (int)Math.min(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) + " - " + (int)Math.max(this.pin2Dy0.getYVal(), this.pin2Dy1.getYVal()) : (plotWidget.isXtype ? DF.formatDecimalDbl(plotWidget.getXVal(), n3) : (plotWidget.is2D ? "" + (int)plotWidget.getYVal() : DF.formatDecimalDbl(plotWidget.getYVal(), n4)));
            }
            this.pd.setToolTipText(string);
            return;
        }
        if (this.imageView != null) {
            if (this.imageView.fixX(n) == n && this.fixY(n2) == n2) {
                int n6 = this.imageView.toSubspectrumIndex(n2);
                String string = "y=" + this.get2DYLabel(n6, n3) + " / x=" + DF.formatDecimalDbl(this.imageView.toX(n), n3) + " " + this.getSpectrum().getAxisLabel(true);
                this.pd.setToolTipText(string);
                this.pd.coordStr = string;
                return;
            }
            if (!this.pd.display1D) {
                this.pd.setToolTipText("");
                this.pd.coordStr = "";
                return;
            }
        }
        double d = this.toX(this.fixX(n));
        double d2 = this.imageView != null && this.imageView.isXWithinRange(n) ? (double)this.imageView.toSubspectrumIndex(this.fixY(n2)) : this.toY(this.fixY(n2));
        String string = this.setCoordStr(d, d2);
        int n7 = this.getFixedSelectedSpectrumIndex();
        if (!this.isInPlotRegion(n, n2)) {
            d2 = Double.NaN;
        } else if (this.nSpectra != 1 && this.haveIntegralDisplayed(n7)) {
            d2 = this.getIntegrationGraph(n7).getPercentYValueAt(d);
            string = String.valueOf(string) + ", " + DF.formatDecimalDbl(d2, 1);
        }
        this.pd.setToolTipText((String)(this.selectedIntegral != null ? "click to set value" : (this.pendingMeasurement != null || this.selectedMeasurement != null ? (this.pd.hasFocus() ? "Press ESC to delete " + (this.selectedIntegral != null ? "integral, DEL to delete all visible, or N to normalize" : (this.pendingMeasurement == null ? "\"" + this.selectedMeasurement.text + "\" or DEL to delete all visible" : "measurement")) : "") : (Double.isNaN(d2) ? null : string))));
    }

    private boolean isFrameBox(int n, int n2, int n3, int n4) {
        return Math.abs(n - (n3 + 5)) < 5 && Math.abs(n2 - (n4 + 5)) < 5;
    }

    private String setCoordStr(double d, double d2) {
        String string = DF.formatDecimalDbl(d, this.getScale().precision[0]);
        this.pd.coordStr = "(" + string + (this.haveSingleYScale || this.iSpectrumSelected >= 0 ? ", " + DF.formatDecimalDbl(d2, this.getScale().precision[1]) : "") + ")";
        return string;
    }

    private boolean setStartupPinTip() {
        if (this.pd.startupPinTip == null) {
            return false;
        }
        this.pd.setToolTipText(this.pd.startupPinTip);
        this.pd.startupPinTip = null;
        return true;
    }

    private String get2DYLabel(int n, int n2) {
        Spectrum spectrum = (Spectrum)this.getSpectrumAt(0).getSubSpectra().get(n);
        return String.valueOf(DF.formatDecimalDbl(spectrum.getY2DPPM(), n2)) + " PPM" + (spectrum.y2DUnits.equals("HZ") ? " (" + DF.formatDecimalDbl(spectrum.getY2D(), n2) + " HZ) " : "");
    }

    private boolean isOnSpectrum(int n, int n2, int n3) {
        Object object;
        boolean bl;
        Coordinate[] coordinateArray = null;
        boolean bl2 = true;
        boolean bl3 = bl = n3 < 0;
        if (bl) {
            object = this.getDialog(Annotation.AType.Integration, -1);
            if (object == null) {
                return false;
            }
            coordinateArray = ((IntegralData)object.getData()).getXYCoords();
            n3 = this.getFixedSelectedSpectrumIndex();
        } else {
            this.setScale(n3);
            object = (Spectrum)this.spectra.get(n3);
            coordinateArray = ((Spectrum)object).xyCoords;
            bl2 = ((JDXDataObject)object).isContinuous();
        }
        int n4 = n3 * (int)((float)this.yPixels * ((float)this.yStackOffsetPercent / 100.0f));
        int n5 = this.viewData.getStartingPointIndex(n3);
        int n6 = this.viewData.getEndingPointIndex(n3);
        if (bl2) {
            int n7 = n5;
            while (n7 < n6) {
                int n8;
                Coordinate coordinate = coordinateArray[n7];
                Coordinate coordinate2 = coordinateArray[n7 + 1];
                int n9 = this.toPixelX(coordinate.getXVal());
                int n10 = this.toPixelX(coordinate2.getXVal());
                int n11 = bl ? this.toPixelYint(coordinate.getYVal()) : this.toPixelY(coordinate.getYVal());
                int n12 = n8 = bl ? this.toPixelYint(coordinate2.getYVal()) : this.toPixelY(coordinate2.getYVal());
                if (n11 != Integer.MIN_VALUE && n8 != Integer.MIN_VALUE && GraphSet.isOnLine(n, n2, n9, n11 = this.fixY(n11) - n4, n10, n8 = this.fixY(n8) - n4)) {
                    return true;
                }
                ++n7;
            }
        } else {
            int n13 = n5;
            while (n13 <= n6) {
                Coordinate coordinate = coordinateArray[n13];
                int n14 = this.toPixelY(coordinate.getYVal());
                if (n14 != Integer.MIN_VALUE) {
                    int n15 = this.toPixelX(coordinate.getXVal());
                    int n16 = this.toPixelY(Math.max(this.getScale().minYOnScale, 0.0));
                    if (((n16 = this.fixY(n16)) != (n14 = this.fixY(n14)) || n16 != this.yPixel0 && n16 != this.yPixel1) && GraphSet.isOnLine(n, n2, n15, n16, n15, n14)) {
                        return true;
                    }
                }
                ++n13;
            }
        }
        return false;
    }

    private static double distance(int n, int n2) {
        return Math.sqrt(n * n + n2 * n2);
    }

    private static GraphSet findCompatibleGraphSet(Lst<GraphSet> lst, Spectrum spectrum) {
        int n = 0;
        while (n < lst.size()) {
            if (Spectrum.areXScalesCompatible(spectrum, ((GraphSet)lst.get(n)).getSpectrum(), false, false)) {
                return (GraphSet)lst.get(n);
            }
            ++n;
        }
        return null;
    }

    private static boolean isGoodEvent(PlotWidget plotWidget, PlotWidget plotWidget2, boolean bl) {
        return plotWidget2 == null ? Math.abs(plotWidget.xPixel1 - plotWidget.xPixel0) > 5 && Math.abs(plotWidget.yPixel1 - plotWidget.yPixel0) > 5 : (bl ? Math.abs(plotWidget.xPixel0 - plotWidget2.xPixel0) > 5 : Math.abs(plotWidget.yPixel0 - plotWidget2.yPixel0) > 5);
    }

    private static boolean isOnLine(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Math.abs(n3 - n);
        if (n7 < 2 && Math.abs(n4 - n2) < 2) {
            return true;
        }
        int n8 = n5 - n;
        if (Math.abs(n8) < 2 && Math.abs(n6 - n2) < 2) {
            return true;
        }
        int n9 = n4 - n6;
        if (Math.abs(n9) > 2 && n4 < n2 == n6 < n2) {
            return false;
        }
        int n10 = n3 - n5;
        if (Math.abs(n10) > 2 && n3 < n == n5 < n) {
            return false;
        }
        return GraphSet.distance(n7, n4 - n2) + GraphSet.distance(n8, n2 - n6) < GraphSet.distance(n10, n9) + 2.0;
    }

    private static void setFractionalPositions(PanelData panelData, Lst<GraphSet> lst, PanelData.LinkMode linkMode) {
        int n = lst.size();
        double d = 0.0;
        int n2 = 1;
        double d2 = 0.0;
        boolean bl = panelData.isLinked = linkMode != PanelData.LinkMode.NONE;
        if (linkMode == PanelData.LinkMode.NONE) {
            GraphSet graphSet;
            int n3 = 0;
            while (n3 < n) {
                graphSet = (GraphSet)lst.get(n3);
                d += (double)((graphSet.getSpectrumAt(0).is1D() ? 1 : n2) * graphSet.nSplit);
                ++n3;
            }
            d = 1.0 / d;
            n3 = 0;
            while (n3 < n) {
                graphSet = (GraphSet)lst.get(n3);
                graphSet.isLinked = false;
                double d3 = graphSet.getSpectrumAt(0).is1D() ? d : (double)n2 * d;
                graphSet.fX0 = 0.0;
                graphSet.fY0 = d2;
                graphSet.fracX = 1.0;
                graphSet.fracY = d3;
                d2 += d3 * (double)graphSet.nSplit;
                ++n3;
            }
        } else {
            GraphSet graphSet;
            int n4;
            GraphSet graphSet2 = null;
            int n5 = -1;
            if (n == 2 || n == 3) {
                n4 = 0;
                while (n4 < n) {
                    graphSet = (GraphSet)lst.get(n4);
                    if (!graphSet.getSpectrum().is1D()) {
                        graphSet2 = graphSet;
                        if (n5 >= 0) {
                            n4 = -2;
                        }
                        n5 = n4;
                        break;
                    }
                    ++n4;
                }
            }
            if (n5 == -2 || n5 == -1 && n != 2) {
                GraphSet.setFractionalPositions(panelData, lst, PanelData.LinkMode.NONE);
                return;
            }
            n4 = 0;
            while (n4 < n) {
                graphSet = (GraphSet)lst.get(n4);
                graphSet.isLinked = true;
                Spectrum spectrum = graphSet.getSpectrumAt(0);
                boolean bl2 = spectrum.is1D();
                if (bl2) {
                    if (graphSet2 != null) {
                        Spectrum spectrum2 = graphSet2.getSpectrumAt(0);
                        if (Spectrum.areLinkableX(spectrum, spectrum2)) {
                            graphSet.gs2dLinkedX = graphSet2;
                        }
                        if (Spectrum.areLinkableY(spectrum, spectrum2)) {
                            graphSet.gs2dLinkedY = graphSet2;
                        }
                    }
                    graphSet.fX0 = 0.0;
                    graphSet.fY0 = d2;
                    graphSet.fracX = graphSet2 == null ? 1.0 : 0.5;
                    graphSet.fracY = n == 3 || graphSet2 == null ? 0.5 : 1.0;
                    d2 += 0.5;
                } else {
                    graphSet.fX0 = 0.5;
                    graphSet.fY0 = 0.0;
                    graphSet.fracX = 0.5;
                    graphSet.fracY = 1.0;
                }
                ++n4;
            }
        }
    }

    String addAnnotation(Lst<String> lst, String string) {
        Annotation annotation;
        if (lst.size() == 0 || lst.size() == 1 && ((String)lst.get(0)).equalsIgnoreCase("none")) {
            this.annotations = null;
            this.lastAnnotation = null;
            return null;
        }
        if (lst.size() < 4 && this.lastAnnotation == null) {
            this.lastAnnotation = this.getAnnotation((this.getScale().maxXOnScale + this.getScale().minXOnScale) / 2.0, (this.getScale().maxYOnScale + this.getScale().minYOnScale) / 2.0, string, false, false, 0, 0);
        }
        if ((annotation = this.getAnnotation(lst, this.lastAnnotation)) == null) {
            return null;
        }
        if (this.annotations == null && lst.size() == 1 && ((String)lst.get(0)).charAt(0) == '\"') {
            String string2 = annotation.text;
            this.getSpectrum().setTitle(string2);
            return string2;
        }
        this.lastAnnotation = annotation;
        this.addAnnotation(annotation, false);
        return null;
    }

    void addHighlight(double d, double d2, Spectrum spectrum, GenericColor genericColor) {
        Highlight highlight;
        if (spectrum == null) {
            spectrum = this.getSpectrumAt(0);
        }
        if (!this.highlights.contains(highlight = new Highlight(d, d2, spectrum, genericColor == null ? this.pd.getColor(ScriptToken.HIGHLIGHTCOLOR) : genericColor))) {
            this.highlights.addLast(highlight);
        }
    }

    void addPeakHighlight(PeakInfo peakInfo) {
        int n = this.spectra.size();
        while (--n >= 0) {
            String string;
            Spectrum spectrum = (Spectrum)this.spectra.get(n);
            this.removeAllHighlights(spectrum);
            if (peakInfo == null || peakInfo.isClearAll() || spectrum != peakInfo.spectrum || (string = peakInfo.toString()) == null) continue;
            String string2 = PT.getQuotedAttribute(string, "xMin");
            String string3 = PT.getQuotedAttribute(string, "xMax");
            if (string2 == null || string3 == null) {
                return;
            }
            float f = PT.parseFloat(string2);
            float f2 = PT.parseFloat(string3);
            if (Float.isNaN(f) || Float.isNaN(f2)) {
                return;
            }
            this.pd.addHighlight(this, f, f2, spectrum, 200, 140, 140, 100);
            spectrum.setSelectedPeak(peakInfo);
            if (this.getScale().isInRangeX(f) || this.getScale().isInRangeX(f2) || (double)f < this.getScale().minX && this.getScale().maxX < (double)f2) continue;
            this.setZoomTo(0);
        }
    }

    void advanceSubSpectrum(int n) {
        Spectrum spectrum = this.getSpectrumAt(0);
        int n2 = spectrum.advanceSubSpectrum(n);
        if (spectrum.isForcedSubset()) {
            this.viewData.setXRangeForSubSpectrum(this.getSpectrum().getXYCoords());
        }
        this.pd.notifySubSpectrumChange(n2, this.getSpectrum());
    }

    synchronized boolean checkSpectrumClickedEvent(int n, int n2, int n3) {
        int n4;
        if (this.nextClickForSetPeak != null) {
            return false;
        }
        if (n3 > 1 || this.pendingMeasurement != null || !this.isInPlotRegion(n, n2)) {
            return false;
        }
        if (n3 == 0) {
            n4 = this.isOnSpectrum(n, n2, -1);
            this.pd.integralShiftMode = n4 != 0 ? this.getShiftMode(n, n2) : 0;
            boolean bl = this.pd.isIntegralDrag = this.pd.integralShiftMode == 0 && (n4 != 0 || this.haveIntegralDisplayed(-1) && this.findMeasurement(this.getIntegrationGraph(-1), n, n2, 0) != null);
            if (this.pd.integralShiftMode != 0) {
                return false;
            }
        }
        if (!this.showAllStacked) {
            return false;
        }
        this.stackSelected = false;
        n4 = 0;
        while (n4 < this.nSpectra) {
            if (this.isOnSpectrum(n, n2, n4)) {
                this.iPreviousSpectrumClicked = n4;
                this.setSpectrumClicked(this.iPreviousSpectrumClicked);
                return false;
            }
            ++n4;
        }
        if (this.isDialogOpen()) {
            return false;
        }
        this.setSpectrumClicked(-1);
        this.stackSelected = false;
        return false;
    }

    private int getShiftMode(int n, int n2) {
        return this.isStartEndIntegral(n, false) ? n2 : (this.isStartEndIntegral(n, true) ? -n2 : 0);
    }

    private boolean isDialogOpen() {
        return this.isVisible(this.getDialog(Annotation.AType.Integration, -1)) || this.isVisible(this.getDialog(Annotation.AType.Measurements, -1)) || this.isVisible(this.getDialog(Annotation.AType.PeakList, -1));
    }

    private boolean isStartEndIntegral(int n, boolean bl) {
        return bl ? this.xPixelPlot1 - n < 20 : n - this.xPixelPlot0 < 20;
    }

    synchronized boolean checkWidgetEvent(int n, int n2, boolean bl) {
        if (!this.widgetsAreSet) {
            return false;
        }
        this.widgetsAreSet = false;
        if (bl) {
            if (this.pd.clickCount == 2 && this.lastIntDragX != n && !this.is2dClick(n, n2)) {
                if (this.pendingMeasurement == null) {
                    if (this.iSpectrumClicked == -1 && this.iPreviousSpectrumClicked >= 0) {
                        this.setSpectrumClicked(this.iPreviousSpectrumClicked);
                    }
                    this.processPendingMeasurement(n, n2, 2);
                    return true;
                }
            } else if (!this.is2dClick(n, n2)) {
                if (this.isOnSpectrum(n, n2, -1)) {
                    this.checkIntegral(this.toX(n), Double.NaN, false);
                }
                if (this.lastIntDragX == n) {
                    this.pd.isIntegralDrag = true;
                    if (!this.checkIntegral(this.toX(n), this.toX(n), false)) {
                        return false;
                    }
                }
            }
            if (this.pendingMeasurement != null) {
                return true;
            }
            PlotWidget plotWidget = this.getPinSelected(n, n2);
            if (plotWidget == null) {
                n2 = this.fixY(n2);
                if (n < this.xPixel1) {
                    if (this.pd.shiftPressed) {
                        this.setSpectrumClicked(this.iPreviousSpectrumClicked);
                    }
                    n = this.fixX(n);
                    if (this.zoomBox1D == null) {
                        this.newPins();
                    }
                    this.zoomBox1D.setX(this.toX(n), n);
                    this.zoomBox1D.yPixel0 = n2;
                    plotWidget = this.zoomBox1D;
                } else if (this.imageView != null && n < this.imageView.xPixel1) {
                    this.zoomBox2D.setX(this.imageView.toX(n), this.imageView.fixX(n));
                    this.zoomBox2D.yPixel0 = n2;
                    plotWidget = this.zoomBox2D;
                }
            }
            this.pd.thisWidget = plotWidget;
            return false;
        }
        this.nextClickForSetPeak = null;
        PlotWidget plotWidget = this.pd.thisWidget;
        if (plotWidget == null) {
            return false;
        }
        if (plotWidget == this.zoomBox1D) {
            this.zoomBox1D.xPixel1 = this.fixX(n);
            this.zoomBox1D.yPixel1 = this.fixY(n2);
            if (this.pd.isIntegralDrag && this.zoomBox1D.xPixel0 != this.zoomBox1D.xPixel1) {
                if (this.lastIntDragX <= n != this.zoomBox1D.xPixel0 <= n) {
                    this.zoomBox1D.xPixel0 = this.lastIntDragX;
                    this.zoomBox1D.xPixel1 = n;
                    this.zoomBox1D.setXVal(this.toX(this.zoomBox1D.xPixel0));
                }
                this.lastIntDragX = n;
                this.checkIntegral(this.zoomBox1D.getXVal(), this.toX(this.zoomBox1D.xPixel1), false);
            }
            return false;
        }
        if (!this.zoomEnabled) {
            return false;
        }
        if (plotWidget == this.zoomBox2D) {
            this.zoomBox2D.xPixel1 = this.imageView.fixX(n);
            this.zoomBox2D.yPixel1 = this.fixY(n2);
            return true;
        }
        if (plotWidget == this.cur2Dy) {
            this.cur2Dy.yPixel0 = this.cur2Dy.yPixel1 = (n2 = this.fixY(n2));
            this.setCurrentSubSpectrum(this.imageView.toSubspectrumIndex(n2));
            return true;
        }
        if (plotWidget == this.cur2Dx0 || plotWidget == this.cur2Dx1) {
            return false;
        }
        if (plotWidget == this.pin1Dx0 || plotWidget == this.pin1Dx1 || plotWidget == this.pin1Dx01) {
            n = this.fixX(n);
            plotWidget.setX(this.toX0(n), n);
            if (plotWidget == this.pin1Dx01) {
                int n3 = n - (this.pin1Dx0.xPixel0 + this.pin1Dx1.xPixel0) / 2;
                int n4 = n3 < 0 ? n3 : n3;
                int n5 = n3 < 0 ? n3 : n3;
                n = this.pin1Dx0.xPixel0 + n5;
                int n6 = this.pin1Dx1.xPixel0 + n4;
                if (n3 == 0 || this.fixX(n) != n || this.fixX(n6) != n6) {
                    return true;
                }
                this.pin1Dx0.setX(this.toX0(n), n);
                this.pin1Dx1.setX(this.toX0(n6), n6);
            }
            this.doZoom(this.pin1Dx0.getXVal(), 0.0, this.pin1Dx1.getXVal(), 0.0, true, false, false, true, false);
            return true;
        }
        if (plotWidget == this.pin1Dy0 || plotWidget == this.pin1Dy1 || plotWidget == this.pin1Dy01) {
            n2 = this.fixY(n2);
            plotWidget.setY(this.toY0(n2), n2);
            if (plotWidget == this.pin1Dy01) {
                double d;
                int n7 = n2 - (this.pin1Dy0.yPixel0 + this.pin1Dy1.yPixel0) / 2 + 1;
                n2 = this.pin1Dy0.yPixel0 + n7;
                int n8 = this.pin1Dy1.yPixel0 + n7;
                double d2 = this.toY0(n2);
                if (Math.min(d2, d = this.toY0(n8)) == this.getScale().minY || Math.max(d2, d) == this.getScale().maxY) {
                    return true;
                }
                this.pin1Dy0.setY(d2, n2);
                this.pin1Dy1.setY(d, n8);
            }
            this.doZoom(0.0, this.pin1Dy0.getYVal(), 0.0, this.pin1Dy1.getYVal(), this.imageView == null, this.imageView == null, false, false, false);
            return true;
        }
        if (plotWidget == this.pin2Dx0 || plotWidget == this.pin2Dx1 || plotWidget == this.pin2Dx01) {
            n = this.imageView.fixX(n);
            plotWidget.setX(this.imageView.toX0(n), n);
            if (plotWidget == this.pin2Dx01) {
                int n9 = n - (this.pin2Dx0.xPixel0 + this.pin2Dx1.xPixel0) / 2 + 1;
                n = this.pin2Dx0.xPixel0 + n9;
                int n10 = this.pin2Dx1.xPixel0 + n9;
                if (this.imageView.fixX(n) != n || this.imageView.fixX(n10) != n10) {
                    return true;
                }
                this.pin2Dx0.setX(this.imageView.toX0(n), n);
                this.pin2Dx1.setX(this.imageView.toX0(n10), n10);
            }
            if (!GraphSet.isGoodEvent(this.pin2Dx0, this.pin2Dx1, true)) {
                this.reset2D(true);
                return true;
            }
            this.imageView.setView0(this.pin2Dx0.xPixel0, this.pin2Dy0.yPixel0, this.pin2Dx1.xPixel0, this.pin2Dy1.yPixel0);
            this.doZoom(this.pin2Dx0.getXVal(), this.getScale().minY, this.pin2Dx1.getXVal(), this.getScale().maxY, false, false, false, true, false);
            return true;
        }
        if (plotWidget == this.pin2Dy0 || plotWidget == this.pin2Dy1 || plotWidget == this.pin2Dy01) {
            n2 = this.fixY(n2);
            plotWidget.setY(this.imageView.toSubspectrumIndex(n2), n2);
            if (plotWidget == this.pin2Dy01) {
                int n11 = n2 - (this.pin2Dy0.yPixel0 + this.pin2Dy1.yPixel0) / 2 + 1;
                n2 = this.pin2Dy0.yPixel0 + n11;
                int n12 = this.pin2Dy1.yPixel0 + n11;
                if (n2 != this.fixY(n2) || n12 != this.fixY(n12)) {
                    return true;
                }
                this.pin2Dy0.setY(this.imageView.toSubspectrumIndex(n2), n2);
                this.pin2Dy1.setY(this.imageView.toSubspectrumIndex(n12), n12);
            }
            if (!GraphSet.isGoodEvent(this.pin2Dy0, this.pin2Dy1, false)) {
                this.reset2D(false);
                return true;
            }
            this.imageView.setView0(this.pin2Dx0.xPixel0, this.pin2Dy0.yPixel0, this.pin2Dx1.xPixel1, this.pin2Dy1.yPixel1);
            return true;
        }
        return false;
    }

    void clearIntegrals() {
        this.checkIntegral(Double.NaN, 0.0, false);
    }

    void clearMeasurements() {
        this.removeDialog(this.getFixedSelectedSpectrumIndex(), Annotation.AType.Measurements);
    }

    static Lst<GraphSet> createGraphSetsAndSetLinkMode(PanelData panelData, JSVPanel jSVPanel, Lst<Spectrum> lst, int n, int n2, PanelData.LinkMode linkMode) {
        Lst<GraphSet> lst2 = new Lst<GraphSet>();
        int n3 = 0;
        while (n3 < lst.size()) {
            GraphSet graphSet;
            Spectrum spectrum = (Spectrum)lst.get(n3);
            GraphSet graphSet2 = graphSet = linkMode == PanelData.LinkMode.NONE ? GraphSet.findCompatibleGraphSet(lst2, spectrum) : null;
            if (graphSet == null) {
                graphSet = new GraphSet(jSVPanel.getPanelData());
                lst2.addLast(graphSet);
            }
            graphSet.addSpec(spectrum);
            ++n3;
        }
        GraphSet.setFractionalPositions(panelData, lst2, linkMode);
        n3 = lst2.size();
        while (--n3 >= 0) {
            ((GraphSet)lst2.get(n3)).initGraphSet(n, n2);
            Logger.info("JSVGraphSet " + (n3 + 1) + " nSpectra = " + ((GraphSet)lst2.get((int)n3)).nSpectra);
        }
        return lst2;
    }

    synchronized void drawGraphSet(Object object, Object object2, Object object3, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2, boolean bl3) {
        int n7;
        this.zoomEnabled = this.pd.getBoolean(ScriptToken.ENABLEZOOM);
        this.height = n2 * this.pd.scalingFactor;
        this.width = n * this.pd.scalingFactor;
        this.left = n3 * this.pd.scalingFactor;
        this.right = n4 * this.pd.scalingFactor;
        this.top = n5 * this.pd.scalingFactor;
        this.bottom = n6 * this.pd.scalingFactor;
        this.haveSelectedSpectrum = false;
        this.selectedSpectrumIntegrals = null;
        this.selectedSpectrumMeasurements = null;
        if (!this.pd.isPrinting && this.widgets != null) {
            n7 = 0;
            while (n7 < this.widgets.length) {
                if (this.widgets[n7] != null) {
                    this.widgets[n7].isVisible = false;
                }
                ++n7;
            }
        }
        n7 = 0;
        while (n7 < this.nSplit) {
            this.setPositionForFrame(n7);
            this.drawAll(object, object2, object3, n7, bl || this.nSplit > 1, bl2, bl3);
            ++n7;
        }
        this.setPositionForFrame(this.nSplit > 1 ? this.pd.currentSplitPoint : 0);
        if (this.pd.isPrinting) {
            return;
        }
    }

    synchronized void escapeKeyPressed(boolean bl) {
        if (this.zoomBox1D != null) {
            this.zoomBox1D.xPixel1 = 0;
            this.zoomBox1D.xPixel0 = 0;
        }
        if (this.zoomBox2D != null) {
            this.zoomBox2D.xPixel1 = 0;
            this.zoomBox2D.xPixel0 = 0;
        }
        if (!this.inPlotMove) {
            return;
        }
        if (this.pendingMeasurement != null) {
            this.pendingMeasurement = null;
            return;
        }
        this.pd.thisWidget = null;
        this.pendingMeasurement = null;
        if (this.selectedSpectrumMeasurements != null && this.selectedMeasurement != null) {
            if (bl) {
                this.selectedSpectrumMeasurements.clear(this.getScale().minXOnScale, this.getScale().maxXOnScale);
            } else {
                this.selectedSpectrumMeasurements.removeObj(this.selectedMeasurement);
            }
            this.selectedMeasurement = null;
            this.updateDialog(Annotation.AType.Measurements, -1);
        }
        if (this.selectedSpectrumIntegrals != null && this.selectedIntegral != null) {
            if (bl) {
                this.selectedSpectrumIntegrals.clear(this.getScale().minXOnScale, this.getScale().maxXOnScale);
            } else {
                this.selectedSpectrumIntegrals.removeObj(this.selectedIntegral);
            }
            this.selectedIntegral = null;
            this.updateDialog(Annotation.AType.Integration, -1);
        }
    }

    static GraphSet findGraphSet(Lst<GraphSet> lst, int n, int n2) {
        int n3 = lst.size();
        while (--n3 >= 0) {
            if (!((GraphSet)lst.get(n3)).hasPoint(n, n2)) continue;
            return (GraphSet)lst.get(n3);
        }
        return null;
    }

    PeakInfo findMatchingPeakInfo(PeakInfo peakInfo) {
        PeakInfo peakInfo2 = null;
        int n = 0;
        while (n < this.spectra.size()) {
            peakInfo2 = ((Spectrum)this.spectra.get(n)).findMatchingPeakInfo(peakInfo);
            if (peakInfo2 != null) break;
            ++n;
        }
        return peakInfo2;
    }

    int getCurrentSpectrumIndex() {
        return this.nSpectra == 1 ? 0 : this.iSpectrumSelected;
    }

    Integral getSelectedIntegral() {
        return this.selectedIntegral;
    }

    boolean getShowAnnotation(Annotation.AType aType, int n) {
        AnnotationData annotationData = this.getDialog(aType, n);
        return annotationData != null && annotationData.getState();
    }

    boolean hasFileLoaded(String string) {
        int n = this.spectra.size();
        while (--n >= 0) {
            if (!((Spectrum)this.spectra.get(n)).getFilePathForwardSlash().equals(string)) continue;
            return true;
        }
        return false;
    }

    boolean haveSelectedSpectrum() {
        return this.haveSelectedSpectrum;
    }

    synchronized void mouseClickedEvent(int n, int n2, int n3, boolean bl) {
        this.selectedMeasurement = null;
        this.selectedIntegral = null;
        Double d = this.nextClickForSetPeak;
        this.nextClickForSetPeak = null;
        if (this.checkArrowUpDownClick(n, n2) || this.checkArrowLeftRightClick(n, n2)) {
            return;
        }
        this.lastClickX = Double.NaN;
        this.lastPixelX = Integer.MAX_VALUE;
        if (this.isSplitWidget(n, n2)) {
            this.splitStack(this.nSplit == 1);
            return;
        }
        if (this.isCloserWidget(n, n2)) {
            this.pd.closeSpectrum();
            return;
        }
        PlotWidget plotWidget = this.getPinSelected(n, n2);
        if (plotWidget != null) {
            this.setWidgetValueByUser(plotWidget);
            return;
        }
        boolean bl2 = this.is2dClick(n, n2);
        if (n3 == 2 && this.iSpectrumClicked == -1 && this.iPreviousSpectrumClicked >= 0) {
            this.setSpectrumClicked(this.iPreviousSpectrumClicked);
        }
        if (!bl2 && bl) {
            this.setSpectrumClicked(this.iPreviousSpectrumClicked);
            if (this.pendingMeasurement != null) {
                this.processPendingMeasurement(n, n2, -3);
            } else if (this.iSpectrumClicked >= 0) {
                this.processPendingMeasurement(n, n2, 3);
            }
            return;
        }
        this.lastXMax = Double.NaN;
        if (n3 == 2) {
            if (bl2) {
                if (this.sticky2Dcursor) {
                    this.addAnnotation(this.getAnnotation(this.imageView.toX(n), this.imageView.toSubspectrumIndex(n2), this.pd.coordStr, false, true, 5, 5), true);
                }
                this.sticky2Dcursor = true;
                this.set2DCrossHairs(n, n2);
                return;
            }
            if (this.isInTopBar(n, n2)) {
                this.doZoom(this.toX0(this.xPixel0), 0.0, this.toX0(this.xPixel1), 0.0, true, false, false, true, true);
            } else if (this.isInRightBar(n, n2)) {
                this.doZoom(this.getScale().minXOnScale, ((ViewData)this.viewList.get((int)0)).getScale().minYOnScale, this.getScale().maxXOnScale, ((ViewData)this.viewList.get((int)0)).getScale().maxYOnScale, true, true, false, false, false);
            } else if (this.isInTopBar2D(n, n2)) {
                this.reset2D(true);
            } else if (this.isInRightBar2D(n, n2)) {
                this.reset2D(false);
            } else if (this.pendingMeasurement != null) {
                this.processPendingMeasurement(n, n2, -2);
            } else if (this.iSpectrumClicked >= 0) {
                this.processPendingMeasurement(n, n2, 2);
            }
            return;
        }
        if (bl2) {
            Coordinate coordinate;
            Annotation annotation;
            if (this.annotations != null && (annotation = this.findAnnotation2D(coordinate = new Coordinate().set(this.imageView.toX(n), this.imageView.toSubspectrumIndex(n2)))) != null && this.setAnnotationText(annotation)) {
                return;
            }
            if (n3 == 1) {
                this.sticky2Dcursor = false;
            }
            this.set2DCrossHairs(n, n2);
            return;
        }
        if (this.isInPlotRegion(n, n2)) {
            if (this.selectedSpectrumIntegrals != null && this.checkIntegralNormalizationClick(n, n2)) {
                return;
            }
            if (this.pendingMeasurement != null) {
                this.processPendingMeasurement(n, n2, 1);
                return;
            }
            this.setCoordClicked(n, this.toX(n), this.toY(n2));
            this.updateDialog(Annotation.AType.PeakList, -1);
            if (d != null) {
                this.nextClickForSetPeak = d;
                this.shiftSpectrum(4, Double.NaN, Double.NaN);
                this.nextClickForSetPeak = null;
                return;
            }
        } else {
            this.setCoordClicked(0, Double.NaN, 0.0);
        }
        this.pd.notifyPeakPickedListeners(null);
    }

    private boolean is2dClick(int n, int n2) {
        return this.imageView != null && n == this.imageView.fixX(n) && n2 == this.fixY(n2);
    }

    private void updateDialog(Annotation.AType aType, int n) {
        AnnotationData annotationData = this.getDialog(aType, n);
        if (annotationData == null || !this.isVisible(annotationData)) {
            return;
        }
        double d = this.toX(this.xPixel1) - this.toX(this.xPixel0);
        int n2 = this.getSpectrum().isInverted() ? this.yPixel1 - this.pd.mouseY : this.pd.mouseY - this.yPixel0;
        ((JSVDialog)annotationData).update(this.pd.coordClicked, d, n2);
    }

    private boolean isVisible(AnnotationData annotationData) {
        return annotationData != null && annotationData.isDialog() && annotationData.isVisible();
    }

    public void mousePressedEvent(int n, int n2, int n3) {
        this.checkWidgetEvent(n, n2, true);
    }

    synchronized void mouseReleasedEvent(int n, int n2) {
        if (this.pendingMeasurement != null) {
            if (Math.abs(this.toPixelX(this.pendingMeasurement.getXVal()) - n) < 2) {
                this.pendingMeasurement = null;
            }
            this.processPendingMeasurement(n, n2, -2);
            this.setToolTipForPixels(n, n2);
            return;
        }
        if (this.pd.integralShiftMode != 0) {
            this.pd.integralShiftMode = 0;
            this.zoomBox1D.xPixel1 = this.zoomBox1D.xPixel0;
            return;
        }
        if (this.iSpectrumMovedTo >= 0) {
            this.setScale(this.iSpectrumMovedTo);
        }
        PlotWidget plotWidget = this.pd.thisWidget;
        if (this.pd.isIntegralDrag) {
            if (GraphSet.isGoodEvent(this.zoomBox1D, null, true)) {
                this.checkIntegral(this.toX(this.zoomBox1D.xPixel0), this.toX(this.zoomBox1D.xPixel1), true);
            }
            this.zoomBox1D.xPixel0 = 0;
            this.zoomBox1D.xPixel1 = 0;
            this.pendingIntegral = null;
            this.pd.isIntegralDrag = false;
        } else if (plotWidget == this.zoomBox2D) {
            if (!GraphSet.isGoodEvent(this.zoomBox2D, null, true)) {
                return;
            }
            this.imageView.setZoom(this.zoomBox2D.xPixel0, this.zoomBox2D.yPixel0, this.zoomBox2D.xPixel1, this.zoomBox2D.yPixel1);
            this.zoomBox2D.xPixel1 = this.zoomBox2D.xPixel0;
            this.doZoom(this.imageView.toX(this.imageView.xPixel0), this.getScale().minY, this.imageView.toX(this.imageView.xPixel0 + this.imageView.xPixels - 1), this.getScale().maxY, false, false, false, true, true);
        } else if (plotWidget == this.zoomBox1D) {
            if (!GraphSet.isGoodEvent(this.zoomBox1D, null, true)) {
                return;
            }
            int n3 = this.zoomBox1D.xPixel1;
            boolean bl = this.pd.shiftPressed;
            this.doZoom(this.toX(this.zoomBox1D.xPixel0), bl ? this.toY(this.zoomBox1D.yPixel0) : 0.0, this.toX(n3), bl ? this.toY(this.zoomBox1D.yPixel1) : 0.0, true, bl, true, true, true);
            this.zoomBox1D.xPixel1 = this.zoomBox1D.xPixel0;
        } else if (plotWidget == this.pin1Dx0 || plotWidget == this.pin1Dx1 || plotWidget == this.cur2Dx0 || plotWidget == this.cur2Dx1) {
            this.addCurrentZoom();
        }
    }

    synchronized void mouseMovedEvent(int n, int n2) {
        int n3;
        if (this.nSpectra > 1) {
            n3 = this.getSplitPoint(n2);
            this.setPositionForFrame(n3);
            this.setSpectrumMovedTo(this.nSplit > 1 ? n3 : this.iSpectrumSelected);
            if (this.iSpectrumMovedTo >= 0) {
                this.setScale(this.iSpectrumMovedTo);
            }
        }
        this.inPlotMove = this.isInPlotRegion(n, n2);
        this.setXPixelMovedTo(Double.MAX_VALUE, Double.MAX_VALUE, this.inPlotMove ? n : -1, -1);
        if (this.inPlotMove) {
            this.xValueMovedTo = this.toX(this.xPixelMovedTo);
            this.yValueMovedTo = this.getSpectrum().getYValueAt(this.xValueMovedTo);
        }
        if (this.pd.integralShiftMode != 0) {
            AnnotationData annotationData = this.getDialog(Annotation.AType.Integration, -1);
            Coordinate[] coordinateArray = ((IntegralData)annotationData.getData()).getXYCoords();
            double d = coordinateArray[this.pd.integralShiftMode > 0 ? coordinateArray.length - 1 : 0].getYVal();
            ((IntegralData)annotationData.getData()).shiftY(this.pd.integralShiftMode, this.toPixelYint(d) + n2 - (this.pd.integralShiftMode > 0 ? this.yPixelPlot1 : this.yPixelPlot0), this.yPixel0, this.yPixels);
        } else if (!this.pd.isIntegralDrag) {
            if (this.pendingMeasurement != null) {
                this.processPendingMeasurement(n, n2, 0);
                this.setToolTipForPixels(n, n2);
            } else {
                this.selectedMeasurement = this.inPlotMove && this.selectedSpectrumMeasurements != null ? this.findMeasurement(this.selectedSpectrumMeasurements, n, n2, 0) : null;
                this.selectedIntegral = null;
                if (this.inPlotMove && this.selectedSpectrumIntegrals != null && this.selectedMeasurement == null) {
                    this.selectedIntegral = (Integral)this.findMeasurement(this.selectedSpectrumIntegrals, n, n2, 0);
                    if (this.selectedIntegral == null) {
                        this.selectedIntegral = (Integral)this.findMeasurement(this.selectedSpectrumIntegrals, n, n2, -5);
                    }
                }
                this.setToolTipForPixels(n, n2);
                if (this.imageView == null) {
                    Spectrum spectrum;
                    this.piMouseOver = null;
                    int n4 = n3 = this.nSplit > 1 ? this.iSpectrumMovedTo : this.iSpectrumClicked;
                    if (!this.isDrawNoSpectra() && n3 >= 0 && (spectrum = (Spectrum)this.spectra.get(n3)).getPeakList() != null) {
                        this.coordTemp.setXVal(this.toX(n));
                        this.coordTemp.setYVal(this.toY(n2));
                        this.piMouseOver = spectrum.findPeakByCoord(n, this.coordTemp);
                    }
                } else if (!this.pd.display1D && this.sticky2Dcursor) {
                    this.set2DCrossHairs(n, n2);
                }
            }
        }
    }

    void nextView() {
        if (this.currentZoomIndex + 1 < this.viewList.size()) {
            this.setZoomTo(this.currentZoomIndex + 1);
        }
    }

    void previousView() {
        if (this.currentZoomIndex > 0) {
            this.setZoomTo(this.currentZoomIndex - 1);
        }
    }

    void resetView() {
        this.setZoomTo(0);
    }

    void removeAllHighlights() {
        this.removeAllHighlights(null);
    }

    void removeHighlight(int n) {
        this.highlights.removeItemAt(n);
    }

    void removeHighlight(double d, double d2) {
        int n = this.highlights.size();
        while (--n >= 0) {
            Highlight highlight = (Highlight)this.highlights.get(n);
            if (highlight.x1 != d || highlight.x2 != d2) continue;
            this.highlights.removeItemAt(n);
        }
    }

    void scaleYBy(double d) {
        if (this.imageView == null && !this.zoomEnabled) {
            return;
        }
        this.viewData.scaleSpectrum(this.imageView == null ? this.iSpectrumSelected : -2, d);
        if (this.imageView != null) {
            this.update2dImage(false);
            this.resetPinsFromView();
        }
        this.pd.refresh();
    }

    boolean selectSpectrum(String string, String string2, String string3) {
        boolean bl = false;
        int n = this.spectra.size();
        while (--n >= 0) {
            if (string != null && !this.getSpectrumAt(n).getFilePathForwardSlash().equals(string) || !this.getSpectrumAt(n).matchesPeakTypeModel(string2, string3)) continue;
            this.setSpectrumSelected(n);
            if (this.nSplit > 1) {
                this.splitStack(true);
            }
            bl = true;
        }
        if (this.nSpectra > 1 && !bl && this.iSpectrumSelected >= 0 && !this.pd.isCurrentGraphSet(this)) {
            this.setSpectrumSelected(Integer.MIN_VALUE);
        }
        return bl;
    }

    PeakInfo selectPeakByFileIndex(String string, String string2, String string3) {
        int n = this.spectra.size();
        while (--n >= 0) {
            PeakInfo peakInfo = this.getSpectrumAt(n).selectPeakByFileIndex(string, string2, string3);
            if (peakInfo == null) continue;
            return peakInfo;
        }
        return null;
    }

    void setSelected(int n) {
        if (n < 0) {
            this.bsSelected.clearAll();
            this.setSpectrumClicked(-1);
            return;
        }
        this.bsSelected.set(n);
        this.setSpectrumClicked(this.bsSelected.cardinality() == 1 ? n : -1);
        if (this.nSplit > 1 && n >= 0) {
            this.pd.currentSplitPoint = n;
        }
    }

    void setSelectedIntegral(double d) {
        Spectrum spectrum = this.selectedIntegral.getSpectrum();
        this.getIntegrationGraph(this.getSpectrumIndex(spectrum)).setSelectedIntegral(this.selectedIntegral, d);
    }

    void setShowAnnotation(Annotation.AType aType, Boolean bl) {
        AnnotationData annotationData = this.getDialog(aType, -1);
        if (annotationData == null) {
            if (bl != null && bl != Boolean.TRUE) {
                return;
            }
            if (aType == Annotation.AType.PeakList || aType == Annotation.AType.Integration || aType == Annotation.AType.Measurements) {
                this.pd.showDialog(aType);
            }
            return;
        }
        if (bl == null) {
            if (annotationData.isDialog()) {
                ((JSVDialog)annotationData).setVisible(!((JSVDialog)annotationData).isVisible());
            } else {
                this.pd.showDialog(aType);
            }
            return;
        }
        boolean bl2 = bl;
        if (bl2) {
            annotationData.setState(bl2);
        }
        if (bl2 || annotationData.isDialog()) {
            this.pd.showDialog(aType);
        }
        if (!bl2 && annotationData.isDialog()) {
            ((JSVDialog)annotationData).setVisible(false);
        }
    }

    boolean checkIntegralParams(Parameters parameters, String string) {
        Spectrum spectrum = this.getSpectrum();
        if (!spectrum.canIntegrate() || this.reversePlot) {
            return false;
        }
        int n = this.getFixedSelectedSpectrumIndex();
        AnnotationData annotationData = this.getDialog(Annotation.AType.Integration, -1);
        if (string == null) {
            return true;
        }
        switch (IntegralData.IntMode.getMode(string.toUpperCase())) {
            case NA: {
                return false;
            }
            case CLEAR: {
                this.integrate(n, null);
                this.integrate(n, parameters);
                break;
            }
            case ON: {
                if (annotationData == null) {
                    this.integrate(n, parameters);
                    break;
                }
                annotationData.setState(true);
                break;
            }
            case OFF: {
                if (annotationData == null) break;
                annotationData.setState(false);
                break;
            }
            case TOGGLE: {
                if (annotationData == null) {
                    this.integrate(n, parameters);
                    break;
                }
                annotationData.setState(!annotationData.getState());
                break;
            }
            case AUTO: {
                if (annotationData == null) {
                    this.checkIntegralParams(parameters, "ON");
                    annotationData = this.getDialog(Annotation.AType.Integration, -1);
                }
                if (annotationData == null) break;
                ((IntegralData)annotationData.getData()).autoIntegrate();
                break;
            }
            case LIST: {
                this.pd.showDialog(Annotation.AType.Integration);
                break;
            }
            case MARK: {
                if (annotationData == null) {
                    this.checkIntegralParams(parameters, "ON");
                    annotationData = this.getDialog(Annotation.AType.Integration, -1);
                }
                if (annotationData == null) break;
                ((IntegralData)annotationData.getData()).addMarks(string.substring(4).trim());
                break;
            }
            case MIN: {
                if (annotationData == null) break;
                try {
                    double d = Double.parseDouble((String)ScriptToken.getTokens(string).get(1));
                    ((IntegralData)annotationData.getData()).setMinimumIntegral(d);
                }
                catch (Exception exception) {}
                break;
            }
            case UPDATE: {
                if (annotationData == null) break;
                ((IntegralData)annotationData.getData()).update(parameters);
            }
        }
        this.updateDialog(Annotation.AType.Integration, -1);
        return true;
    }

    void setSpectrum(int n, boolean bl) {
        if (bl && this.nSplit > 1) {
            if (this.nSplit > 1) {
                this.setSpectrumClicked(n);
            }
        } else {
            this.setSpectrumClicked(n);
            this.stackSelected = false;
            this.showAllStacked = false;
        }
        if (n >= 0) {
            this.dialogsToFront(this.getSpectrum());
        }
    }

    void setSpectrumJDX(Spectrum spectrum) {
        int n = this.getFixedSelectedSpectrumIndex();
        this.spectra.removeItemAt(n);
        this.spectra.add(n, spectrum);
        this.pendingMeasurement = null;
        this.clearViews();
        this.viewData.newSpectrum(this.spectra);
    }

    void setZoom(double d, double d2, double d3, double d4) {
        this.setZoomTo(0);
        if (d == 0.0 && d3 == 0.0 && d2 == 0.0 && d4 == 0.0) {
            this.newPins();
            this.imageView = null;
            d = this.getScale().minXOnScale;
            d3 = this.getScale().maxXOnScale;
        } else {
            this.doZoom(d, d2, d3, d4, true, d2 != d4, false, true, true);
        }
    }

    boolean shiftSpectrum(int n, double d, double d2) {
        Spectrum spectrum = this.getSpectrum();
        if (!spectrum.isNMR() || !spectrum.is1D()) {
            return false;
        }
        String string = null;
        double d3 = 0.0;
        if (d2 == Double.MAX_VALUE) {
            d3 = -spectrum.addSpecShift(0.0);
        } else {
            switch (n) {
                case 3: {
                    d3 = d2;
                    break;
                }
                case 1: 
                case 2: {
                    this.nextClickMode = n;
                    if (Double.isNaN(d)) {
                        string = this.pd.getInput("Click on " + (n == 1 ? "or beside a peak to set its chemical shift" : "the spectrum set the chemical shift at that point") + (d2 == -2.147483648E9 ? "" : " to " + d2) + ".", "Set Reference " + (n == 1 ? "for Peak" : "at Point"), "OK");
                        this.nextClickForSetPeak = "OK".equals(string) ? Double.valueOf(d2) : null;
                        return false;
                    }
                    this.nextClickForSetPeak = null;
                }
                case 4: {
                    if (this.nextClickForSetPeak != null) {
                        d2 = this.nextClickForSetPeak;
                        this.nextClickForSetPeak = null;
                    }
                    if (Double.isNaN(d)) {
                        d = this.lastClickX;
                    }
                    if (this.nextClickMode == 1) {
                        d = this.getNearestPeak(spectrum, d, this.toY(this.pd.mouseY));
                    }
                    if (Double.isNaN(d2)) {
                        try {
                            Map.Entry<String, AnnotationData> entry = this.pd.getInput("New chemical shift (set blank to reset)", "Set Reference", DF.formatDecimalDbl(d, this.getScale().precision[0])).trim();
                            d2 = ((String)((Object)entry)).length() == 0 ? d - spectrum.addSpecShift(0.0) : Double.parseDouble((String)((Object)entry));
                        }
                        catch (Exception exception) {
                            return false;
                        }
                    }
                    d3 = d2 - d;
                }
            }
        }
        if (d3 == 0.0) {
            return false;
        }
        spectrum.addSpecShift(d3);
        if (this.annotations != null) {
            int n2 = this.annotations.size();
            while (--n2 >= 0) {
                if (((Annotation)this.annotations.get((int)n2)).spec != spectrum) continue;
                ((Annotation)this.annotations.get(n2)).addSpecShift(d3);
            }
        }
        if (this.dialogs != null) {
            for (Map.Entry<String, AnnotationData> entry : this.dialogs.entrySet()) {
                if (((AnnotationData)entry.getValue()).getSpectrum() != spectrum) continue;
                ((AnnotationData)entry.getValue()).setSpecShift(d3);
            }
        }
        this.getScale().addSpecShift(d3);
        if (!Double.isNaN(this.lastClickX)) {
            this.lastClickX += d3;
        }
        this.updateDialogs();
        this.doZoom(0.0, this.getScale().minYOnScale, 0.0, this.getScale().maxYOnScale, true, true, false, true, false);
        this.pd.setTaintedAll();
        this.pd.repaint();
        return true;
    }

    void toPeak(int n) {
        Coordinate coordinate;
        Spectrum spectrum;
        int n2;
        n *= this.drawXAxisLeftToRight ? 1 : -1;
        if (Double.isNaN(this.lastClickX)) {
            this.lastPixelX = 0;
            this.lastClickX = 0;
        }
        if ((n2 = (spectrum = this.getSpectrum()).setNextPeak(coordinate = this.setCoordClicked(this.lastPixelX, this.lastClickX, 0.0), n)) < 0) {
            return;
        }
        PeakInfo peakInfo = (PeakInfo)spectrum.getPeakList().get(n2);
        spectrum.setSelectedPeak(peakInfo);
        this.setCoordClicked(peakInfo.getXPixel(), peakInfo.getX(), 0.0);
        this.pd.notifyPeakPickedListeners(new PeakPickEvent(this.jsvp, this.pd.coordClicked, peakInfo));
    }

    void scaleSelectedBy(double d) {
        int n = this.bsSelected.nextSetBit(0);
        while (n >= 0) {
            this.viewData.scaleSpectrum(n, d);
            n = this.bsSelected.nextSetBit(n + 1);
        }
    }

    public String toString() {
        return "gs: " + this.nSpectra + " " + this.spectra + " " + ((Spectrum)this.spectra.get(0)).getFilePath();
    }

    void setXPointer(Spectrum spectrum, double d) {
        if (spectrum != null) {
            this.setSpectrumClicked(this.getSpectrumIndex(spectrum));
        }
        this.xValueMovedTo = this.lastClickX = d;
        this.lastPixelX = this.toPixelX(d);
        this.setXPixelMovedTo(d, Double.MAX_VALUE, 0, 0);
        this.yValueMovedTo = Double.NaN;
    }

    void setXPointer2(Spectrum spectrum, double d) {
        if (spectrum != null) {
            this.setSpectrumClicked(this.getSpectrumIndex(spectrum));
        }
        this.setXPixelMovedTo(Double.MAX_VALUE, d, 0, 0);
    }

    boolean hasCurrentMeasurement(Annotation.AType aType) {
        return (aType == Annotation.AType.Integration ? this.selectedSpectrumIntegrals : this.selectedSpectrumMeasurements) != null;
    }

    AnnotationData getDialog(Annotation.AType aType, int n) {
        if (n == -1) {
            n = this.getCurrentSpectrumIndex();
        }
        return this.dialogs == null || n < 0 ? null : this.dialogs.get((Object)((Object)aType) + "_" + n);
    }

    void removeDialog(int n, Annotation.AType aType) {
        if (this.dialogs != null && n >= 0) {
            this.dialogs.remove((Object)((Object)aType) + "_" + n);
        }
    }

    AnnotationData addDialog(int n, Annotation.AType aType, AnnotationData annotationData) {
        if (this.dialogs == null) {
            this.dialogs = new Hashtable<String, AnnotationData>();
        }
        String string = (Object)((Object)aType) + "_" + n;
        annotationData.setGraphSetKey(string);
        this.dialogs.put(string, annotationData);
        return annotationData;
    }

    void removeDialog(JSVDialog jSVDialog) {
        String string = jSVDialog.getGraphSetKey();
        this.dialogs.remove(string);
        MeasurementData measurementData = jSVDialog.getData();
        if (measurementData != null) {
            this.dialogs.put(string, measurementData);
        }
    }

    MeasurementData getPeakListing(int n, Parameters parameters, boolean bl) {
        if (n < 0) {
            n = this.getCurrentSpectrumIndex();
        }
        if (n < 0) {
            return null;
        }
        AnnotationData annotationData = this.getDialog(Annotation.AType.PeakList, -1);
        if (annotationData == null) {
            if (!bl) {
                return null;
            }
            annotationData = new PeakData(Annotation.AType.PeakList, this.getSpectrum());
            this.addDialog(n, Annotation.AType.PeakList, annotationData);
        }
        ((PeakData)annotationData.getData()).setPeakList(parameters, Integer.MIN_VALUE, this.viewData.getScale());
        if (annotationData.isDialog()) {
            ((JSVDialog)annotationData).setFields();
        }
        return annotationData.getData();
    }

    void setPeakListing(Boolean bl) {
        boolean bl2;
        JSVDialog jSVDialog;
        AnnotationData annotationData = this.getDialog(Annotation.AType.PeakList, -1);
        JSVDialog jSVDialog2 = jSVDialog = annotationData != null && annotationData.isDialog() ? (JSVDialog)annotationData : null;
        boolean bl3 = bl == null ? jSVDialog == null || !jSVDialog.isVisible() : (bl2 = bl.booleanValue());
        if (bl2) {
            this.pd.showDialog(Annotation.AType.PeakList);
        } else if (annotationData.isDialog()) {
            ((JSVDialog)annotationData).setVisible(false);
        }
    }

    boolean haveIntegralDisplayed(int n) {
        AnnotationData annotationData = this.getDialog(Annotation.AType.Integration, n);
        return annotationData != null && annotationData.getState();
    }

    IntegralData getIntegrationGraph(int n) {
        AnnotationData annotationData = this.getDialog(Annotation.AType.Integration, n);
        return annotationData == null ? null : (IntegralData)annotationData.getData();
    }

    void setIntegrationRatios(String string) {
        int n = this.getFixedSelectedSpectrumIndex();
        if (this.aIntegrationRatios == null) {
            this.aIntegrationRatios = new Object[this.nSpectra];
        }
        this.aIntegrationRatios[n] = IntegralData.getIntegrationRatiosFromString(this.getSpectrum(), string);
    }

    Lst<Annotation> getIntegrationRatios(int n) {
        return (Lst)(this.aIntegrationRatios == null ? null : this.aIntegrationRatios[n]);
    }

    boolean integrate(int n, Parameters parameters) {
        Spectrum spectrum = this.getSpectrumAt(n);
        if (parameters == null || !spectrum.canIntegrate()) {
            this.removeDialog(n, Annotation.AType.Integration);
            return false;
        }
        this.addDialog(n, Annotation.AType.Integration, new IntegralData(spectrum, parameters));
        return true;
    }

    IntegralData getIntegration(int n, Parameters parameters, boolean bl) {
        if (n < 0) {
            n = this.getCurrentSpectrumIndex();
        }
        if (n < 0) {
            return null;
        }
        AnnotationData annotationData = this.getDialog(Annotation.AType.Integration, -1);
        if (annotationData == null) {
            if (!bl) {
                return null;
            }
            annotationData = this.addDialog(n, Annotation.AType.Integration, new IntegralData(this.getSpectrum(), parameters));
        }
        return (IntegralData)annotationData.getData();
    }

    Map<String, Object> getMeasurementInfo(Annotation.AType aType, int n) {
        MeasurementData measurementData;
        switch (aType) {
            case PeakList: {
                measurementData = this.getPeakListing(n, null, false);
                break;
            }
            case Integration: {
                measurementData = this.getIntegration(n, null, false);
                break;
            }
            default: {
                return null;
            }
        }
        if (measurementData == null) {
            return null;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        measurementData.getInfo(hashtable);
        return hashtable;
    }

    Map<String, Object> getInfo(String string, int n) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if ("".equals(string)) {
            hashtable.put("KEYS", "viewInfo spectra");
        } else if ("viewInfo".equalsIgnoreCase(string)) {
            return this.getScale().getInfo(hashtable);
        }
        Lst<Map<String, Object>> lst = new Lst<Map<String, Object>>();
        hashtable.put("spectra", lst);
        int n2 = 0;
        while (n2 < this.nSpectra) {
            if (n < 0 || n2 == n) {
                Spectrum spectrum = (Spectrum)this.spectra.get(n2);
                Map<String, Object> map = spectrum.getInfo(string);
                if (n >= 0 && string != null && (map.size() == 2 || string.equalsIgnoreCase("id"))) {
                    if (map.size() == 2) {
                        map.remove("id");
                    }
                    return map;
                }
                Parameters.putInfo(string, map, "type", spectrum.getDataType());
                Parameters.putInfo(string, map, "titleLabel", spectrum.getTitleLabel());
                Parameters.putInfo(string, map, "filePath", spectrum.getFilePath().replace('\\', '/'));
                Parameters.putInfo(string, map, "PeakList", Parameters.isMatch(string, "PeakList") ? this.getMeasurementInfo(Annotation.AType.PeakList, n2) : null);
                Parameters.putInfo(string, map, "Integration", Parameters.isMatch(string, "Integration") ? this.getMeasurementInfo(Annotation.AType.Integration, n2) : null);
                if (n >= 0) {
                    return map;
                }
                lst.addLast(map);
            }
            ++n2;
        }
        return hashtable;
    }

    String getTitle(boolean bl) {
        return this.nSpectra == 1 || this.iSpectrumSelected >= 0 && (!bl || this.nSplit == 1) ? this.getSpectrum().getTitle() : null;
    }

    ScaleData getCurrentView() {
        this.setScale(this.getFixedSelectedSpectrumIndex());
        return this.viewData.getScale();
    }

    void set2DXY(double d, double d2, boolean bl) {
        int n;
        if (this.gs2dLinkedX != null) {
            n = this.toPixelX(d);
            if (n != this.fixX(n)) {
                n = Integer.MIN_VALUE;
                d = Double.MAX_VALUE;
            }
            this.cur1D2x1.setX(d, n);
        }
        if (this.gs2dLinkedY != null) {
            n = this.toPixelX(d2);
            if (n != this.fixX(n)) {
                n = Integer.MIN_VALUE;
                d2 = Double.MAX_VALUE;
            }
            this.cur1D2x2.setX(d2, n);
        }
        this.cur1D2Locked = bl;
    }

    void dialogsToFront(Spectrum spectrum) {
        if (this.dialogs == null) {
            return;
        }
        if (spectrum == null) {
            spectrum = this.getSpectrum();
        }
        for (Map.Entry<String, AnnotationData> entry : this.dialogs.entrySet()) {
            AnnotationData annotationData = entry.getValue();
            if (!this.isVisible(annotationData)) continue;
            if (spectrum == null) {
                ((JSVDialog)annotationData).setVisible(true);
                continue;
            }
            ((JSVDialog)annotationData).setFocus(annotationData.getSpectrum() == spectrum);
        }
    }

    void setPlotColors(Object object) {
        GenericColor[] genericColorArray = (GenericColor[])object;
        if (genericColorArray.length > this.nSpectra) {
            GenericColor[] genericColorArray2 = new GenericColor[this.nSpectra];
            System.arraycopy(genericColorArray, 0, genericColorArray2, 0, this.nSpectra);
            genericColorArray = genericColorArray2;
        } else if (this.nSpectra > genericColorArray.length) {
            GenericColor[] genericColorArray3 = new GenericColor[this.nSpectra];
            int n = this.nSpectra - genericColorArray.length;
            System.arraycopy(genericColorArray, 0, genericColorArray3, 0, genericColorArray.length);
            int n2 = 0;
            int n3 = genericColorArray.length;
            while (n2 < n) {
                genericColorArray3[n3] = this.generateRandomColor();
                ++n2;
                ++n3;
            }
            genericColorArray = genericColorArray3;
        }
        this.plotColors = genericColorArray;
    }

    private void disposeImage() {
        this.image2D = null;
        this.jsvp = null;
        this.pd = null;
        this.highlights = null;
        this.plotColors = null;
    }

    private GenericColor generateRandomColor() {
        int n;
        int n2;
        int n3;
        GenericColor genericColor;
        while ((genericColor = this.g2d.getColor3(n3 = (int)(Math.random() * 255.0), n2 = (int)(Math.random() * 255.0), n = (int)(Math.random() * 255.0))).getRGB() == 0) {
        }
        return genericColor;
    }

    void setPlotColor0(Object object) {
        this.plotColors[0] = (GenericColor)object;
    }

    GenericColor getPlotColor(int n) {
        if (n >= this.plotColors.length) {
            return null;
        }
        return this.plotColors[n];
    }

    private void setColorFromToken(Object object, ScriptToken scriptToken) {
        if (scriptToken != null) {
            this.g2d.setGraphicsColor(object, scriptToken == ScriptToken.PLOTCOLOR ? this.plotColors[0] : this.pd.getColor(scriptToken));
        }
    }

    private void setPlotColor(Object object, int n) {
        GenericColor genericColor;
        switch (n) {
            case -3: {
                genericColor = veryLightGrey;
                break;
            }
            case -2: {
                genericColor = this.pd.BLACK;
                break;
            }
            case -1: {
                genericColor = this.pd.getColor(ScriptToken.INTEGRALPLOTCOLOR);
                break;
            }
            default: {
                genericColor = this.plotColors[n];
            }
        }
        this.g2d.setGraphicsColor(object, genericColor);
    }

    private void draw2DImage() {
        if (this.imageView != null) {
            this.g2d.drawGrayScaleImage(this.gMain, this.image2D, this.imageView.xPixel0, this.imageView.yPixel0, this.imageView.xPixel0 + this.imageView.xPixels - 1, this.imageView.yPixel0 + this.imageView.yPixels - 1, this.imageView.xView1, this.imageView.yView1, this.imageView.xView2, this.imageView.yView2);
        }
    }

    private boolean get2DImage(Spectrum spectrum) {
        this.imageView = new ImageView();
        this.imageView.set(((ViewData)this.viewList.get(0)).getScale());
        if (!this.update2dImage(true)) {
            return false;
        }
        this.imageView.resetZoom();
        this.sticky2Dcursor = true;
        return true;
    }

    private boolean update2dImage(boolean bl) {
        this.imageView.set(this.viewData.getScale());
        Spectrum spectrum = this.getSpectrumAt(0);
        int[] nArray = this.imageView.get2dBuffer(spectrum, !bl);
        if (nArray == null) {
            this.image2D = null;
            this.imageView = null;
            return false;
        }
        if (bl) {
            nArray = this.imageView.adjustView(spectrum, this.viewData);
            this.imageView.resetView();
        }
        this.image2D = this.g2d.newGrayScaleImage(this.gMain, this.image2D, this.imageView.imageWidth, this.imageView.imageHeight, nArray);
        this.setImageWindow();
        return true;
    }

    private Annotation getAnnotation(double d, double d2, String string, boolean bl, boolean bl2, int n, int n2) {
        return new ColoredAnnotation().setCA(d, d2, this.getSpectrum(), string, this.pd.BLACK, bl, bl2, n, n2);
    }

    private Annotation getAnnotation(Lst<String> lst, Annotation annotation) {
        return Annotation.getColoredAnnotation(this.g2d, this.getSpectrum(), lst, annotation);
    }

    private void fillBox(Object object, int n, int n2, int n3, int n4, ScriptToken scriptToken) {
        this.setColorFromToken(object, scriptToken);
        this.g2d.fillRect(object, Math.min(n, n3), Math.min(n2, n4), Math.abs(n - n3), Math.abs(n2 - n4));
    }

    private void drawBox(Object object, int n, int n2, int n3, int n4, ScriptToken scriptToken) {
        this.setColorFromToken(object, scriptToken);
        this.g2d.drawRect(object, Math.min(n, n3), Math.min(n2, n4), Math.abs(n - n3) - 1, Math.abs(n2 - n4) - 1);
    }

    private void drawHandle(Object object, int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.g2d.drawRect(object, n - n3, n2 - n3, n3 * 2, n3 * 2);
        } else {
            this.g2d.fillRect(object, n - n3, n2 - n3, n3 * 2 + 1, n3 * 2 + 1);
        }
    }

    private void setCurrentBoxColor(Object object) {
        this.g2d.setGraphicsColor(object, this.pd.BLACK);
    }

    private void fillArrow(Object object, int n, int n2, int n3, boolean bl) {
        int n4 = 1;
        switch (n) {
            case 1: 
            case 3: {
                n4 = -1;
            }
        }
        int[] nArray = new int[]{n2 - 5, n2 - 5, n2 + 5, n2 + 5, n2 + 8, n2, n2 - 8};
        int[] nArray2 = new int[]{n3 + 5 * n4, n3 - n4, n3 - n4, n3 + 5 * n4, n3 + 5 * n4, n3 + 10 * n4, n3 + 5 * n4};
        switch (n) {
            case 1: 
            case 2: {
                if (bl) {
                    this.g2d.fillPolygon(object, nArray2, nArray, 7);
                    break;
                }
                this.g2d.drawPolygon(object, nArray2, nArray, 7);
                break;
            }
            case 3: 
            case 4: {
                if (bl) {
                    this.g2d.fillPolygon(object, nArray, nArray2, 7);
                    break;
                }
                this.g2d.drawPolygon(object, nArray, nArray2, 7);
            }
        }
    }

    private void fillCircle(Object object, int n, int n2, boolean bl) {
        if (bl) {
            this.g2d.fillCircle(object, n - 4, n2 - 4, 8);
        } else {
            this.g2d.drawCircle(object, n - 4, n2 - 4, 8);
        }
    }

    void setAnnotationColor(Object object, Annotation annotation, ScriptToken scriptToken) {
        if (scriptToken != null) {
            this.setColorFromToken(object, scriptToken);
            return;
        }
        GenericColor genericColor = null;
        if (annotation instanceof ColoredAnnotation) {
            genericColor = ((ColoredAnnotation)annotation).getColor();
        }
        if (genericColor == null) {
            genericColor = this.pd.BLACK;
        }
        this.g2d.setGraphicsColor(object, genericColor);
    }

    public void setSolutionColor(VisibleInterface visibleInterface, boolean bl, boolean bl2) {
        int n = 0;
        while (n < this.nSpectra) {
            Spectrum spectrum = (Spectrum)this.spectra.get(n);
            int n2 = bl || !spectrum.canShowSolutionColor() ? -1 : visibleInterface.getColour(spectrum, bl2);
            spectrum.setFillColor(n2 == -1 ? null : this.pd.vwr.parameters.getColor1(n2));
            ++n;
        }
    }

    public void setIRMode(Spectrum.IRMode iRMode, String string) {
        int n = 0;
        while (n < this.nSpectra) {
            Spectrum spectrum;
            Spectrum spectrum2 = (Spectrum)this.spectra.get(n);
            if (spectrum2.dataType.equals(string) && (spectrum = Spectrum.taConvert(spectrum2, iRMode)) != spectrum2) {
                this.pd.setSpecForIRMode(spectrum);
            }
            ++n;
        }
    }

    public int getSpectrumCount() {
        return 0;
    }

    public void invertYAxis() {
        ((ViewData)this.viewList.get(0)).init(null, 0.0, 0.0, this.getSpectrum().invertYAxis().isContinuous());
        this.resetViewCompletely();
    }

    private class Highlight {
        double x1;
        double x2;
        GenericColor color;
        Spectrum spectrum;

        public String toString() {
            return "highlight " + this.x1 + " " + this.x2 + " " + this.spectrum;
        }

        Highlight(double d, double d2, Spectrum spectrum, GenericColor genericColor) {
            this.x1 = d;
            this.x2 = d2;
            this.color = genericColor;
            this.spectrum = spectrum;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Highlight)) {
                return false;
            }
            Highlight highlight = (Highlight)object;
            return highlight.x1 == this.x1 && highlight.x2 == this.x2;
        }
    }
}

