/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.TreeMap;
import javajs.api.GenericColor;
import javajs.util.CU;
import javajs.util.SB;
import jspecview.common.ColorParameters;
import jspecview.common.JSVFileManager;
import jspecview.common.ScriptToken;
import jspecview.java.AwtParameters;
import jspecview.source.XMLParser;

public class DisplaySchemesProcessor {
    private final String newLine = System.getProperty("line.separator");
    private String fileName = "displaySchemes.xml";
    private TreeMap<String, ColorParameters> displaySchemes = new TreeMap();
    private XMLParser parser;

    public ColorParameters loadDefault() {
        AwtParameters dsdef = (AwtParameters)new AwtParameters().setName("Default");
        dsdef.displayFontName = "default";
        dsdef.setColor(ScriptToken.TITLECOLOR, ColorParameters.BLACK);
        dsdef.setColor(ScriptToken.UNITSCOLOR, ColorParameters.BLACK);
        dsdef.setColor(ScriptToken.SCALECOLOR, ColorParameters.BLACK);
        dsdef.setColor(ScriptToken.COORDINATESCOLOR, ColorParameters.BLACK);
        dsdef.setColor(ScriptToken.PEAKTABCOLOR, ColorParameters.RED);
        dsdef.setColor(ScriptToken.HIGHLIGHTCOLOR, ColorParameters.DARK_GRAY);
        dsdef.setColor(ScriptToken.GRIDCOLOR, ColorParameters.BLACK);
        dsdef.setColor(ScriptToken.PLOTCOLOR, ColorParameters.BLACK);
        dsdef.setColor(ScriptToken.PLOTAREACOLOR, ColorParameters.WHITE);
        dsdef.setColor(ScriptToken.BACKGROUNDCOLOR, ColorParameters.WHITE);
        dsdef.setColor(ScriptToken.INTEGRALPLOTCOLOR, ColorParameters.RED);
        this.displaySchemes.put("Default", dsdef);
        return dsdef;
    }

    public ColorParameters getDefaultScheme() {
        ColorParameters ds = this.displaySchemes.get("Default");
        if (ds == null) {
            ds = this.loadDefault();
        }
        return ds;
    }

    public void store() throws Exception {
        this.serializeDisplaySchemes(new BufferedWriter(new FileWriter(this.fileName)));
    }

    public TreeMap<String, ColorParameters> getDisplaySchemes() {
        return this.displaySchemes;
    }

    public boolean load(InputStream stream) {
        try {
            return this.load(JSVFileManager.getBufferedReaderForInputStream(stream));
        }
        catch (Exception e) {
            System.out.println("DisplaySchemeProcessor ignored: " + e.getMessage());
            return false;
        }
    }

    public boolean load(String dispSchemeFileName) {
        this.fileName = dispSchemeFileName;
        try {
            BufferedReader br = JSVFileManager.getBufferedReaderFromName(this.fileName);
            return this.load(br);
        }
        catch (Exception e) {
            System.out.println("DisplaySchemeProcessor ignored: " + e.getMessage());
            return false;
        }
    }

    public boolean load(BufferedReader br) throws Exception {
        this.parser = new XMLParser(br);
        String defaultDS = "Default";
        ColorParameters ds = null;
        try {
            while (this.parser.hasNext()) {
                ScriptToken st;
                if (this.parser.nextEvent() != 1) continue;
                String theTag = this.parser.getTagName();
                if (theTag.equals("displayschemes")) {
                    defaultDS = this.parser.getAttrValue("default");
                }
                if (theTag.equals("displayscheme")) {
                    String name = this.parser.getAttrValue("name");
                    ds = (ColorParameters)new AwtParameters().setName(name);
                    if (name.equals(defaultDS)) {
                        ds.isDefault = true;
                    }
                    this.displaySchemes.put(name, ds);
                }
                if (ds == null) continue;
                if (theTag.equals("font")) {
                    String attr = this.parser.getAttrValue("face");
                    if (attr.length() <= 0) continue;
                    ds.displayFontName = attr;
                    continue;
                }
                if (theTag.equals("coordinateColor")) {
                    theTag = "coordinatesColor";
                }
                if ((st = ScriptToken.getScriptToken(theTag)) == ScriptToken.UNKNOWN) continue;
                GenericColor color = this.getColor(ds);
                if (color == null) {
                    String def;
                    switch (st) {
                        default: {
                            def = null;
                            break;
                        }
                        case TITLECOLOR: {
                            def = "#0000ff";
                            break;
                        }
                        case COORDINATESCOLOR: {
                            def = "#ff0000";
                            break;
                        }
                        case PEAKTABCOLOR: {
                            def = "#ff0000";
                            break;
                        }
                        case HIGHLIGHTCOLOR: {
                            def = "#808080";
                            break;
                        }
                        case SCALECOLOR: {
                            def = "#660000";
                            break;
                        }
                        case UNITSCOLOR: {
                            def = "#ff0000";
                            break;
                        }
                        case GRIDCOLOR: {
                            def = "#4e4c4c";
                            break;
                        }
                        case PLOTCOLOR: {
                            def = "#ff9900";
                            break;
                        }
                        case PLOTAREACOLOR: {
                            def = "#333333";
                            break;
                        }
                        case BACKGROUNDCOLOR: {
                            def = "#c0c0c0";
                        }
                    }
                    if (def != null) {
                        color = ds.getColorFromString(def);
                    }
                }
                if (color == null) continue;
                ds.setColor(st, color);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private GenericColor getColor(ColorParameters p) {
        String value = this.parser.getAttrValueLC("hex");
        return value.length() == 0 || value.equals("default") ? null : p.getColorFromString(value);
    }

    public void serializeDisplaySchemes(Writer writer) throws Exception {
        if (this.displaySchemes.size() == 0) {
            return;
        }
        SB buffer = new SB();
        String defaultDSName = "";
        for (ColorParameters ds : this.displaySchemes.values()) {
            if (ds.isDefault) {
                defaultDSName = ds.name;
            }
            buffer.append("\t<displayScheme name=\"" + ds.name + "\">").append(this.newLine);
            buffer.append("\t\t<font face=\"" + ds.displayFontName + "\"/>").append(this.newLine);
            this.writeColor(buffer, ds, "titleColor", ScriptToken.TITLECOLOR);
            this.writeColor(buffer, ds, "scaleColor", ScriptToken.SCALECOLOR);
            this.writeColor(buffer, ds, "unitsColor", ScriptToken.UNITSCOLOR);
            this.writeColor(buffer, ds, "coordinatesColor", ScriptToken.COORDINATESCOLOR);
            this.writeColor(buffer, ds, "highlightColor", ScriptToken.HIGHLIGHTCOLOR);
            this.writeColor(buffer, ds, "peakTabColor", ScriptToken.PEAKTABCOLOR);
            this.writeColor(buffer, ds, "gridColor", ScriptToken.GRIDCOLOR);
            this.writeColor(buffer, ds, "plotColor", ScriptToken.PLOTCOLOR);
            this.writeColor(buffer, ds, "plotAreaColor", ScriptToken.PLOTAREACOLOR);
            this.writeColor(buffer, ds, "backgroundColor", ScriptToken.BACKGROUNDCOLOR);
            buffer.append("\t</displayScheme>").append(this.newLine);
        }
        buffer.append("</displaySchemes>");
        SB outBuffer = new SB();
        outBuffer.append("<?xml version=\"1.0\"?>" + this.newLine);
        outBuffer.append("<displaySchemes default=\"" + defaultDSName + "\">" + this.newLine);
        outBuffer.append(buffer.toString());
        writer.write(outBuffer.toString());
        writer.flush();
        writer.close();
    }

    private void writeColor(SB buffer, ColorParameters ds, String name, ScriptToken t) {
        buffer.append("\t\t<" + name + " hex=\"" + CU.toRGBHexString(ds.getElementColor(t)) + "\"/>").append(this.newLine);
    }
}

