/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.Measure;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.Symmetry;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.viewer.Viewer;

public class WyckoffFinder {
    private static WyckoffFinder nullHelper;
    private static final Map<String, WyckoffFinder> helpers;
    public static final int WYCKOFF_RET_LABEL = -1;
    public static final int WYCKOFF_RET_COORD = -2;
    public static final int WYCKOFF_RET_COORDS = -3;
    public static final int WYCKOFF_RET_ALL_ARRAY = -4;
    public static final int WYCKOFF_RET_COORDS_ALL = 42;
    public static final int WYCKOFF_RET_GENERAL = 71;
    public static final int WYCKOFF_RET_CENTERING = 67;
    public static final int WYCKOFF_RET_CENTERING_STRING = 83;
    public static final int WYCKOFF_RET_WITH_MULT = 77;
    private Lst<Object> positions;
    private int npos;
    private int ncent;
    protected P3[] centerings;
    protected String[] centeringStr;
    private Lst<Object> gpos;
    private static final String elementList = "AlB C D FeF GaHeI GeK LiMgN OsP CaRhS T U V W XeYbZnAm";

    public WyckoffFinder() {
    }

    WyckoffFinder getWyckoffFinder(Viewer vwr, SpaceGroup sg) {
        String cleg = sg.getClegId();
        WyckoffFinder helper = helpers.get(cleg);
        if (helper != null) {
            return helper;
        }
        helper = WyckoffFinder.createHelper(vwr, cleg, sg.groupType);
        if (helper == null) {
            if (nullHelper == null) {
                nullHelper = new WyckoffFinder(null);
            }
            helpers.put(cleg, nullHelper);
        } else {
            helpers.put(cleg, helper);
        }
        return helper;
    }

    P3 findPositionFor(P3 p, String letter) {
        if (this.positions != null) {
            int i;
            boolean isGeneral = letter.equals("G");
            int n = i = isGeneral ? 1 : this.npos;
            while (--i >= 0) {
                Map map = (Map)this.positions.get(i);
                String l = (String)map.get("label");
                if (!isGeneral && !l.equals(letter)) continue;
                Lst coords = (Lst)map.get("coord");
                if (coords != null) {
                    WyckoffFinder.getWyckoffCoord(coords, 0, l).project(p);
                }
                return p;
            }
        }
        return null;
    }

    Object getInfo(UnitCell uc, P3 p, int returnType, boolean withMult, boolean is2d) {
        Object info = this.createInfo(uc, p, returnType, withMult, is2d);
        return info == null ? "?" : info;
    }

    protected static SB wrap(String xyz, SB sb) {
        return sb.appendC('(').append(xyz).appendC(')');
    }

    private Object createInfo(UnitCell uc, P3 p, int returnType, boolean withMult, boolean is2d) {
        switch (returnType) {
            case 83: {
                return this.getCenteringStr(-1, ' ', null).toString().trim();
            }
            case 67: {
                P3[] ret = new P3[this.centerings.length];
                int i = ret.length;
                while (--i >= 0) {
                    ret[i] = this.centerings[i];
                }
                return ret;
            }
            case 42: {
                SB sb = new SB();
                this.getCenteringStr(-1, '+', sb);
                int i = this.npos;
                while (--i >= 0) {
                    Map map = (Map)this.positions.get(i);
                    String label = (withMult ? "" + map.get("mult") : "") + map.get("label");
                    sb.appendC('\n').append(label);
                    WyckoffFinder.getList(i == 0 ? this.gpos : (Lst)map.get("coord"), label, sb, i == 0 ? this.ncent : 0);
                }
                return sb.toString();
            }
            case -4: {
                P3[] pts = new P3[this.npos];
                for (int i = 0; i < this.npos; ++i) {
                    Map map = (Map)this.positions.get(i);
                    pts[i] = this.findPositionFor(P3.newP(p), (String)map.get("label"));
                    uc.toCartesian(pts[i], false);
                }
                return new Object[]{pts, elementList};
            }
            case -3: 
            case -2: 
            case -1: {
                int i = this.npos;
                while (--i >= 0) {
                    Map map = (Map)this.positions.get(i);
                    String label = (withMult ? "" + map.get("mult") : "") + map.get("label");
                    if (i == 0) {
                        switch (returnType) {
                            case -1: {
                                return label;
                            }
                            case -2: {
                                return "(x,y,z)";
                            }
                            case -3: {
                                SB sbc = new SB();
                                sbc.append(label).appendC(' ');
                                this.getCenteringStr(-1, '+', sbc).appendC(' ');
                                WyckoffFinder.getList(this.gpos, label, sbc, this.ncent);
                                return sbc.toString();
                            }
                        }
                    }
                    Lst coords = (Lst)map.get("coord");
                    int n = coords.size();
                    for (int c = 0; c < n; ++c) {
                        WyckoffCoord coord = WyckoffFinder.getWyckoffCoord(coords, c, label);
                        if (!coord.contains(this, uc, p)) continue;
                        switch (returnType) {
                            case -1: {
                                return label;
                            }
                            case -2: {
                                return coord.asString(null, true).toString();
                            }
                            case -3: {
                                SB sbc = new SB();
                                sbc.append(label).appendC(' ');
                                this.getCenteringStr(-1, '+', sbc).appendC(' ');
                                WyckoffFinder.getList(coords, label, sbc, 0);
                                return sbc.toString();
                            }
                        }
                    }
                }
                break;
            }
            default: {
                int i;
                String letter = "" + (char)returnType;
                boolean isGeneral = returnType == 71;
                P3 tempP = new P3();
                int n = i = isGeneral ? 1 : this.npos;
                while (--i >= 0) {
                    Map map = (Map)this.positions.get(i);
                    String label = (String)map.get("label");
                    if (!isGeneral && !label.equals(letter)) continue;
                    SB sbc = new SB();
                    if (isGeneral) {
                        sbc.append(label).appendC(' ');
                    }
                    Lst coords = i == 0 ? this.gpos : (Lst)map.get("coord");
                    WyckoffFinder.getList(coords, (withMult ? map.get("mult") : "") + letter, sbc, 0);
                    if (i > 0 && this.ncent > 0) {
                        M4 tempOp = new M4();
                        for (int j = 0; j < this.ncent; ++j) {
                            this.addCentering(coords, this.centerings[j], tempOp, tempP, sbc);
                        }
                    }
                    return sbc.toString();
                }
                break block0;
            }
        }
        return null;
    }

    private static WyckoffFinder createHelper(Viewer vwr, String clegId, int groupType) {
        String sgname = groupType > 0 ? clegId.substring(2) : clegId;
        int pt = sgname.indexOf(":");
        int itno = PT.parseInt(pt < 0 ? sgname : sgname.substring(0, pt));
        if (!SpaceGroup.isInRange(itno, groupType, false, false)) {
            return null;
        }
        Map<String, Object> resource = Symmetry.getITJSONResource(vwr, groupType, itno, null);
        if (resource == null) {
            return null;
        }
        Lst its = (Lst)resource.get("its");
        Map<String, Object> map = null;
        boolean haveMap = false;
        int c = its.size();
        for (int i = 0; i < c; ++i) {
            map = (Map<String, Object>)its.get(i);
            if (!clegId.equals(map.get("clegId"))) continue;
            haveMap = true;
            break;
        }
        if (!haveMap || map.containsKey("more")) {
            map = SpaceGroup.fillMoreData(vwr, haveMap ? map : null, clegId, itno, (Map)its.get(0));
        }
        WyckoffFinder helper = new WyckoffFinder(map);
        return helper;
    }

    private WyckoffFinder(Map<String, Object> map) {
        if (map != null) {
            Lst gp = (Lst)map.get("gp");
            this.gpos = new Lst();
            this.gpos.addAll(gp);
            Map wpos = (Map)map.get("wpos");
            this.positions = (Lst)wpos.get("pos");
            this.npos = this.positions.size();
            Lst cent = (Lst)wpos.get("cent");
            if (cent != null) {
                this.ncent = cent.size();
                this.centeringStr = new String[this.ncent];
                this.centerings = new P3[this.ncent];
                int i = this.ncent;
                while (--i >= 0) {
                    String s;
                    this.centeringStr[i] = s = (String)cent.get(i);
                    this.centerings[i] = SymmetryOperation.toPoint(s, null);
                }
            }
        }
    }

    private SB getCenteringStr(int index, char sep, SB sb) {
        if (sb == null) {
            sb = new SB();
        }
        if (this.ncent == 0) {
            return sb;
        }
        if (index >= 0) {
            sb.appendC(sep);
            return WyckoffFinder.wrap(this.centeringStr[index], sb);
        }
        for (int i = 0; i < this.ncent; ++i) {
            sb.appendC(sep);
            WyckoffFinder.wrap(this.centeringStr[i], sb);
        }
        return sb;
    }

    private static SB getList(Lst<Object> coords, String letter, SB sb, int n) {
        if (sb == null) {
            sb = new SB();
        }
        n = n == 0 ? coords.size() : coords.size() / (n + 1);
        for (int c = 0; c < n; ++c) {
            WyckoffCoord coord = WyckoffFinder.getWyckoffCoord(coords, c, letter);
            sb.append(" ");
            coord.asString(sb, false);
        }
        return sb;
    }

    private void addCentering(Lst<Object> coords, P3 centering, M4 tempOp, P3 tempP, SB sb) {
        int n = coords.size();
        for (int c = 0; c < n; ++c) {
            WyckoffCoord coord = (WyckoffCoord)coords.get(c);
            sb.append(" ");
            coord.asStringCentered(centering, tempOp, tempP, sb);
        }
    }

    private static WyckoffCoord getWyckoffCoord(Lst<Object> coords, int c, String label) {
        Object coord = coords.get(c);
        if (coord instanceof String) {
            coord = new WyckoffCoord((String)coord, label);
            coords.set(c, coord);
        }
        return (WyckoffCoord)coord;
    }

    static {
        helpers = new Hashtable<String, WyckoffFinder>();
    }

    static class WyckoffCoord {
        private static final int TYPE_POINT = 1;
        private static final int TYPE_LINE = 2;
        private static final int TYPE_PLANE = 3;
        private int type;
        private String xyz;
        private String label;
        private transient String thisCentering = "";
        private M4 op;
        private P3 point;
        private V3 line;
        private P4 plane;
        private static final P3 p1 = new P3();
        private static final P3 p2 = new P3();
        private static final P3 p3 = new P3();
        private static final P3 pc = new P3();
        private static final V3 vt = new V3();

        WyckoffCoord(String xyz, String label) {
            this.xyz = xyz;
            this.label = label;
            this.create(xyz);
        }

        public void asStringCentered(P3 centering, M4 tempOp, P3 tempP, SB sb) {
            tempOp.setM4(this.op);
            tempOp.add(centering);
            tempOp.getTranslation(tempP);
            tempP.x %= 1.0f;
            tempP.y %= 1.0f;
            tempP.z %= 1.0f;
            tempOp.setTranslation(tempP);
            sb.appendC(' ');
            String s = "," + SymmetryOperation.getXYZFromMatrixFrac(tempOp, false, true, false, true, null) + ",";
            s = PT.rep(s, ",,", ",0,");
            s = PT.rep(s, ",+", ",");
            sb.appendC('(').append(s.substring(1, s.length() - 1)).appendC(')');
        }

        protected boolean contains(WyckoffFinder w, UnitCell uc, P3 p) {
            float slop = uc.getPrecision();
            this.thisCentering = null;
            if (this.checkLatticePt(p, slop)) {
                return true;
            }
            if (w.centerings == null) {
                return false;
            }
            int i = w.centerings.length;
            while (--i >= 0) {
                pc.add2(p, w.centerings[i]);
                uc.unitize(pc);
                if (!this.checkLatticePt(pc, slop)) continue;
                this.thisCentering = w.centeringStr[i];
                return true;
            }
            return false;
        }

        protected void project(P3 p) {
            switch (this.type) {
                case 1: {
                    p.setT(this.point);
                    break;
                }
                case 2: {
                    Measure.projectOntoAxis(p, this.point, this.line, vt);
                    break;
                }
                case 3: {
                    Measure.getPlaneProjection(p, this.plane, vt, vt);
                    p.setT(vt);
                }
            }
        }

        protected SB asString(SB sb, boolean withCentering) {
            if (sb == null) {
                sb = new SB();
            }
            WyckoffFinder.wrap(this.xyz, sb);
            if (withCentering && this.thisCentering != null) {
                sb.appendC('+');
                WyckoffFinder.wrap(this.thisCentering, sb);
            }
            return sb;
        }

        private boolean checkLatticePt(P3 p, float slop) {
            if (this.checkPoint(p, slop)) {
                return true;
            }
            int z = 62;
            for (int i = -2; i < 3; ++i) {
                for (int j = -2; j < 3; ++j) {
                    int k = -2;
                    while (k < 3) {
                        if (z != 0) {
                            p3.set(i, j, k);
                            p3.add(p);
                            if (this.checkPoint(p3, slop)) {
                                System.out.println(this.label + " " + this.xyz + " found for " + i + " " + j + " " + k);
                                return true;
                            }
                        }
                        ++k;
                        --z;
                    }
                }
            }
            return false;
        }

        private boolean checkPoint(P3 p, float slop) {
            float d = 1.0f;
            switch (this.type) {
                case 1: {
                    d = this.point.distance(p);
                    break;
                }
                case 2: {
                    p1.setT(p);
                    Measure.projectOntoAxis(p1, this.point, this.line, vt);
                    d = p1.distance(p);
                    break;
                }
                case 3: {
                    d = Math.abs(Measure.getPlaneProjection(p, this.plane, vt, vt));
                }
            }
            return d < slop;
        }

        private void create(String p) {
            int nxyz = (p.indexOf(120) >= 0 ? 1 : 0) + (p.indexOf(121) >= 0 ? 1 : 0) + (p.indexOf(122) >= 0 ? 1 : 0);
            float[] a = new float[16];
            String[] v = PT.split(this.xyz, ",");
            WyckoffCoord.getRow(v[0], a, 0);
            WyckoffCoord.getRow(v[1], a, 4);
            WyckoffCoord.getRow(v[2], a, 8);
            a[15] = 1.0f;
            this.op = M4.newA16(a);
            switch (nxyz) {
                case 0: {
                    this.type = 1;
                    this.point = SymmetryOperation.toPoint(p, null);
                    break;
                }
                case 1: {
                    this.type = 2;
                    p1.set(0.19f, 0.53f, 0.71f);
                    this.op.rotTrans(p1);
                    p2.set(0.51f, 0.27f, 0.64f);
                    this.op.rotTrans(p2);
                    p2.sub2(p2, p1);
                    p2.normalize();
                    this.point = P3.newP(p1);
                    this.line = V3.newV(p2);
                    break;
                }
                case 2: {
                    this.type = 3;
                    p1.set(0.19f, 0.51f, 0.73f);
                    this.op.rotTrans(p1);
                    p2.set(0.23f, 0.47f, 0.86f);
                    this.op.rotTrans(p2);
                    p3.set(0.1f, 0.2f, 0.3f);
                    this.op.rotTrans(p3);
                    this.plane = Measure.getPlaneThroughPoints(p1, p2, p3, null, null, new P4());
                    break;
                }
            }
        }

        private static void getRow(String s, float[] a, int rowpt) {
            s = PT.rep(s, "-", "+-");
            s = PT.rep(s, "x", "*x");
            s = PT.rep(s, "y", "*y");
            s = PT.rep(s, "z", "*z");
            s = PT.rep(s, "-*", "-");
            s = PT.rep(s, "+*", "+");
            String[] part = PT.split(s, "+");
            int p = part.length;
            while (--p >= 0) {
                s = part[p];
                if (s.length() == 0) continue;
                int pt = 3;
                if (s.indexOf(46) >= 0) {
                    float d;
                    a[rowpt + pt] = d = PT.parseFloat(s);
                    continue;
                }
                int i0 = 0;
                float sgn = 1.0f;
                switch (s.charAt(0)) {
                    case '-': {
                        sgn = -1.0f;
                    }
                    case '*': {
                        ++i0;
                    }
                }
                float v = 0.0f;
                int i = s.length();
                int f2 = 0;
                block12: while (--i >= i0) {
                    char c = s.charAt(i);
                    switch (c) {
                        case 'x': {
                            pt = 0;
                            v = 1.0f;
                            continue block12;
                        }
                        case 'y': {
                            pt = 1;
                            v = 1.0f;
                            continue block12;
                        }
                        case 'z': {
                            pt = 2;
                            v = 1.0f;
                            continue block12;
                        }
                        case '/': {
                            f2 = 1;
                            v = 1.0f / v;
                        }
                        case '*': {
                            sgn *= v;
                            v = 0.0f;
                            continue block12;
                        }
                    }
                    int u = "0123456789".indexOf(c);
                    if (u < 0) {
                        System.err.println("WH ????");
                    }
                    if (v == 0.0f) {
                        v = u;
                        continue;
                    }
                    f2 = f2 == 0 ? 10 : f2 * 10;
                    v += (float)(f2 * u);
                }
                a[rowpt + pt] = sgn * v;
            }
        }

        public String toString() {
            return this.asString(null, false).toString();
        }
    }
}

