/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.dom;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.echosvg.css.engine.value.ColorValue;
import io.sf.carte.echosvg.css.engine.value.RectValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueModificationHandler;
import org.w3c.css.om.typed.CSSCounterValue;
import org.w3c.dom.DOMException;

public class CSSOMValue
implements Value {
    private static final long serialVersionUID = 1L;
    protected ValueProvider valueProvider;
    protected ValueModificationHandler handler;

    public CSSOMValue(ValueProvider vp) {
        this.valueProvider = vp;
    }

    @Override
    public void setModificationHandler(ValueModificationHandler h) {
        this.handler = h;
    }

    public String getCssText() {
        return this.valueProvider.getValue().getCssText();
    }

    public void setCssText(String cssText) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.valueProvider.getValue().setCssText(cssText);
        this.handler.valueChanged(this.valueProvider.getValue());
    }

    public CSSValue.CssType getCssValueType() {
        return this.valueProvider.getValue().getCssValueType();
    }

    public CSSValue.Type getPrimitiveType() {
        return this.valueProvider.getValue().getPrimitiveType();
    }

    @Override
    public void setFloatValue(float floatValue) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.valueChanged(this);
    }

    @Override
    public float getFloatValue() throws DOMException {
        return this.valueProvider.getValue().getFloatValue();
    }

    public static float convertFloatValue(short unitType, Value value) {
        if (value.getUnitType() == unitType) {
            return value.getFloatValue();
        }
        switch (unitType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 20: 
            case 21: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 41: 
            case 43: 
            case 44: 
            case 45: {
                break;
            }
            case 7: {
                return CSSOMValue.toCentimeters(value);
            }
            case 8: {
                return CSSOMValue.toMillimeters(value);
            }
            case 4: {
                return CSSOMValue.toInches(value);
            }
            case 6: {
                return CSSOMValue.toPoints(value);
            }
            case 5: {
                return CSSOMValue.toPicas(value);
            }
            case 80: {
                return CSSOMValue.toDegrees(value);
            }
            case 81: {
                return CSSOMValue.toRadians(value);
            }
            case 82: {
                return CSSOMValue.toGradians(value);
            }
            case 91: {
                return CSSOMValue.toMilliseconds(value);
            }
            case 90: {
                return CSSOMValue.toSeconds(value);
            }
            case 100: {
                return CSSOMValue.toHertz(value);
            }
            case 101: {
                return CSSOMValue.tokHertz(value);
            }
            default: {
                return NumberValue.floatValueConversion((float)value.getFloatValue(), (short)value.getUnitType(), (short)unitType);
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toCentimeters(Value value) {
        switch (value.getUnitType()) {
            case 7: {
                return value.getFloatValue();
            }
            case 8: {
                return value.getFloatValue() / 10.0f;
            }
            case 4: {
                return value.getFloatValue() * 2.54f;
            }
            case 6: {
                return value.getFloatValue() * 2.54f / 72.0f;
            }
            case 5: {
                return value.getFloatValue() * 2.54f / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toInches(Value value) {
        switch (value.getUnitType()) {
            case 7: {
                return value.getFloatValue() / 2.54f;
            }
            case 8: {
                return value.getFloatValue() / 25.4f;
            }
            case 4: {
                return value.getFloatValue();
            }
            case 6: {
                return value.getFloatValue() / 72.0f;
            }
            case 5: {
                return value.getFloatValue() / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toMillimeters(Value value) {
        switch (value.getUnitType()) {
            case 7: {
                return value.getFloatValue() * 10.0f;
            }
            case 8: {
                return value.getFloatValue();
            }
            case 4: {
                return value.getFloatValue() * 25.4f;
            }
            case 6: {
                return value.getFloatValue() * 25.4f / 72.0f;
            }
            case 5: {
                return value.getFloatValue() * 25.4f / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toPoints(Value value) {
        switch (value.getUnitType()) {
            case 7: {
                return value.getFloatValue() * 72.0f / 2.54f;
            }
            case 8: {
                return value.getFloatValue() * 72.0f / 25.4f;
            }
            case 4: {
                return value.getFloatValue() * 72.0f;
            }
            case 6: {
                return value.getFloatValue();
            }
            case 5: {
                return value.getFloatValue() * 12.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toPicas(Value value) {
        switch (value.getUnitType()) {
            case 7: {
                return value.getFloatValue() * 6.0f / 2.54f;
            }
            case 8: {
                return value.getFloatValue() * 6.0f / 25.4f;
            }
            case 4: {
                return value.getFloatValue() * 6.0f;
            }
            case 6: {
                return value.getFloatValue() / 12.0f;
            }
            case 5: {
                return value.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toDegrees(Value value) {
        switch (value.getUnitType()) {
            case 80: {
                return value.getFloatValue();
            }
            case 81: {
                return (float)Math.toDegrees(value.getFloatValue());
            }
            case 82: {
                return value.getFloatValue() * 9.0f / 5.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toRadians(Value value) {
        switch (value.getUnitType()) {
            case 80: {
                return value.getFloatValue() * 5.0f / 9.0f;
            }
            case 81: {
                return value.getFloatValue();
            }
            case 82: {
                return (float)((double)(value.getFloatValue() * 100.0f) / Math.PI);
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toGradians(Value value) {
        switch (value.getUnitType()) {
            case 80: {
                return (float)((double)value.getFloatValue() * Math.PI / 180.0);
            }
            case 81: {
                return (float)((double)value.getFloatValue() * Math.PI / 100.0);
            }
            case 82: {
                return value.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toMilliseconds(Value value) {
        switch (value.getUnitType()) {
            case 91: {
                return value.getFloatValue();
            }
            case 90: {
                return value.getFloatValue() * 1000.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toSeconds(Value value) {
        switch (value.getUnitType()) {
            case 91: {
                return value.getFloatValue() / 1000.0f;
            }
            case 90: {
                return value.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toHertz(Value value) {
        switch (value.getUnitType()) {
            case 100: {
                return value.getFloatValue();
            }
            case 101: {
                return value.getFloatValue() / 1000.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float tokHertz(Value value) {
        switch (value.getUnitType()) {
            case 100: {
                return value.getFloatValue() * 1000.0f;
            }
            case 101: {
                return value.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    @Override
    public String getIdentifierValue() throws DOMException {
        return this.valueProvider.getValue().getIdentifierValue();
    }

    @Override
    public short getUnitType() {
        return this.valueProvider.getValue().getUnitType();
    }

    @Override
    public String getStringValue() throws DOMException {
        return this.valueProvider.getValue().getStringValue();
    }

    @Override
    public ValueModificationHandler getModificationHandler() {
        return this.handler;
    }

    @Override
    public String getURIValue() throws DOMException {
        return this.valueProvider.getValue().getIdentifierValue();
    }

    @Override
    public CSSCounterValue getCounterValue() throws DOMException {
        return this.valueProvider.getValue().getCounterValue();
    }

    @Override
    public RectValue getRectValue() throws DOMException {
        return this.valueProvider.getValue().getRectValue();
    }

    @Override
    public ColorValue getColorValue() throws DOMException {
        return this.valueProvider.getValue().getColorValue();
    }

    @Override
    public int getLength() {
        return this.valueProvider.getValue().getLength();
    }

    @Override
    public Value item(int index) {
        int len = this.valueProvider.getValue().getLength();
        if (index < 0 || index >= len) {
            return null;
        }
        Value result = this.valueProvider.getValue().item(index);
        if (result.getModificationHandler() == null) {
            result.setModificationHandler(this.handler);
        }
        return result;
    }

    @Override
    public String getIdentifier() {
        return this.valueProvider.getValue().getIdentifierValue();
    }

    @Override
    public Value clone() {
        return this.valueProvider.getValue().clone();
    }

    public static interface ValueProvider {
        public Value getValue();
    }
}

